# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from .. import utilities, tables

class Entity(pulumi.CustomResource):
    disabled: pulumi.Output[bool]
    """
    True/false Is this entity currently disabled. Defaults to `false`
    """
    external_policies: pulumi.Output[bool]
    """
    `false` by default. If set to `true`, this resource will ignore any policies return from Vault or specified in the resource. You can use `identity.EntityPolicies` to manage policies for this entity in a decoupled manner.
    """
    metadata: pulumi.Output[dict]
    """
    A Map of additional metadata to associate with the user.
    """
    name: pulumi.Output[str]
    """
    Name of the identity entity to create.
    """
    policies: pulumi.Output[list]
    """
    A list of policies to apply to the entity.
    """
    def __init__(__self__, resource_name, opts=None, disabled=None, external_policies=None, metadata=None, name=None, policies=None, __props__=None, __name__=None, __opts__=None):
        """
        Create a Entity resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] disabled: True/false Is this entity currently disabled. Defaults to `false`
        :param pulumi.Input[bool] external_policies: `false` by default. If set to `true`, this resource will ignore any policies return from Vault or specified in the resource. You can use `identity.EntityPolicies` to manage policies for this entity in a decoupled manner.
        :param pulumi.Input[dict] metadata: A Map of additional metadata to associate with the user.
        :param pulumi.Input[str] name: Name of the identity entity to create.
        :param pulumi.Input[list] policies: A list of policies to apply to the entity.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['disabled'] = disabled
            __props__['external_policies'] = external_policies
            __props__['metadata'] = metadata
            __props__['name'] = name
            __props__['policies'] = policies
        super(Entity, __self__).__init__(
            'vault:identity/entity:Entity',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, disabled=None, external_policies=None, metadata=None, name=None, policies=None):
        """
        Get an existing Entity resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] disabled: True/false Is this entity currently disabled. Defaults to `false`
        :param pulumi.Input[bool] external_policies: `false` by default. If set to `true`, this resource will ignore any policies return from Vault or specified in the resource. You can use `identity.EntityPolicies` to manage policies for this entity in a decoupled manner.
        :param pulumi.Input[dict] metadata: A Map of additional metadata to associate with the user.
        :param pulumi.Input[str] name: Name of the identity entity to create.
        :param pulumi.Input[list] policies: A list of policies to apply to the entity.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["disabled"] = disabled
        __props__["external_policies"] = external_policies
        __props__["metadata"] = metadata
        __props__["name"] = name
        __props__["policies"] = policies
        return Entity(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

