# ---
# jupyter:
#   jupytext:
#     formats: ipynb,py:percent
#     text_representation:
#       extension: .py
#       format_name: percent
#       format_version: '1.3'
#       jupytext_version: 1.4.2
#   kernelspec:
#     display_name: Python 3
#     language: python
#     name: python3
# ---

# %% [markdown]
# # Getting Started
#
# Currently **SpectroChemPy** can be used as a library for python script. 
# Indeed, at this time, there is no particular graphical user interface (GUI) available. This may change in the future
# but for now we prefer to recommend the use of `Jupyter Notebook` document (see https://jupyter.org/).
#
# ## Using `Jupyter Notebook`
#
# Assuming `Jupyter` is installed (*i.e.*, you have followed the [Spectrochempy installation procedure](../../../gettingstarted/install/index.rst)), go to your favorite user document folder (*e.g.,* `$HOME/workspace/) or any other folder you want to use to store your development).
#
#     $ cd ~/workspace
#
# From this location, type the following command:
#
#     $ jupyter notebook
#
# Your default Web explorer is now launched.
#
# <img src="../images/jupyter_home.png" alt="launched" width="690"/>
#
# Here you can create a new notebook and follow our [UserGuide](../index.rst) or [Tutorials](../../tutorials/index.rst).

# %% [markdown]
# ## Using `Jupyter Lab`
#
# Using the new application `jupyter lab` is very similar to the `jupyter notebook`. 
#
# We recommend to use this application as it is quite intuitive to use, and advantageously replace the traditional `jupyter notebook` application.
#
# To get more information on its usage, one can go to: 
# [https://jupyterlab.readthedocs.io](https://jupyterlab.readthedocs.io/en/stable/getting_started/overview.html)
#
# From you worspace folder or any other location on your computer, open a terminal and issue commands as follows:
#
#     $ jupyter lab
#
# The home window should looks similar to this:
#
# <img src="../images/jupyter_lab_home.png" alt="launch" width="690"/>
#
# From there, it is quite easy to create new notebooks or to navigate to already existing ones.
#
# Then follow our [UserGuide](../index.rst) or [Tutorials](../../tutorials/index.rst) to get strated with **SpectroChemPy**

# %%
