# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['sickchill',
 'sickchill.adba',
 'sickchill.helper',
 'sickchill.oldbeard',
 'sickchill.oldbeard.clients',
 'sickchill.oldbeard.databases',
 'sickchill.oldbeard.name_parser',
 'sickchill.oldbeard.notifiers',
 'sickchill.oldbeard.providers',
 'sickchill.oldbeard.trakt_api',
 'sickchill.providers',
 'sickchill.providers.metadata',
 'sickchill.providers.nzb',
 'sickchill.providers.subtitle',
 'sickchill.providers.torrent',
 'sickchill.recompiled',
 'sickchill.show',
 'sickchill.show.indexers',
 'sickchill.show.recommendations',
 'sickchill.system',
 'sickchill.tagger',
 'sickchill.update_manager',
 'sickchill.views',
 'sickchill.views.api',
 'sickchill.views.config',
 'sickchill.views.manage']

package_data = \
{'': ['*'],
 'sickchill': ['gui/slick/css/*',
               'gui/slick/css/fonts/Bold/*',
               'gui/slick/css/fonts/BoldItalic/*',
               'gui/slick/css/fonts/ExtraBold/*',
               'gui/slick/css/fonts/ExtraBoldItalic/*',
               'gui/slick/css/fonts/Italic/*',
               'gui/slick/css/fonts/Light/*',
               'gui/slick/css/fonts/LightItalic/*',
               'gui/slick/css/fonts/Regular/*',
               'gui/slick/css/fonts/Semibold/*',
               'gui/slick/css/fonts/SemiboldItalic/*',
               'gui/slick/css/lib/*',
               'gui/slick/css/lib/images/*',
               'gui/slick/css/lib/images/tablesorter/*',
               'gui/slick/fonts/*',
               'gui/slick/images/*',
               'gui/slick/images/bootstrap-formhelpers/*',
               'gui/slick/images/flags/*',
               'gui/slick/images/ico/*',
               'gui/slick/images/indexers/*',
               'gui/slick/images/menu/*',
               'gui/slick/images/network/*',
               'gui/slick/images/network/canvas/*',
               'gui/slick/images/network/s4/*',
               'gui/slick/images/providers/*',
               'gui/slick/images/subtitles/*',
               'gui/slick/images/subtitles/flags/*',
               'gui/slick/images/tablesorter/*',
               'gui/slick/js/*',
               'gui/slick/js/lib/*',
               'gui/slick/views/*',
               'gui/slick/views/layouts/*',
               'gui/slick/views/movies/*',
               'gui/slick/views/movies/layouts/*',
               'locale/*',
               'locale/af_ZA/LC_MESSAGES/*',
               'locale/ar_SA/LC_MESSAGES/*',
               'locale/bg_BG/LC_MESSAGES/*',
               'locale/ca_ES/LC_MESSAGES/*',
               'locale/cs_CZ/LC_MESSAGES/*',
               'locale/da_DK/LC_MESSAGES/*',
               'locale/de_DE/LC_MESSAGES/*',
               'locale/el_GR/LC_MESSAGES/*',
               'locale/en_GB/LC_MESSAGES/*',
               'locale/en_US/LC_MESSAGES/*',
               'locale/es_ES/LC_MESSAGES/*',
               'locale/et_EE/LC_MESSAGES/*',
               'locale/fa_IR/LC_MESSAGES/*',
               'locale/fi_FI/LC_MESSAGES/*',
               'locale/fr_FR/LC_MESSAGES/*',
               'locale/he_IL/LC_MESSAGES/*',
               'locale/hr_HR/LC_MESSAGES/*',
               'locale/hu_HU/LC_MESSAGES/*',
               'locale/id_ID/LC_MESSAGES/*',
               'locale/is_IS/LC_MESSAGES/*',
               'locale/it_IT/LC_MESSAGES/*',
               'locale/ja_JP/LC_MESSAGES/*',
               'locale/ko_KR/LC_MESSAGES/*',
               'locale/lv_LV/LC_MESSAGES/*',
               'locale/nl_NL/LC_MESSAGES/*',
               'locale/no_NO/LC_MESSAGES/*',
               'locale/pl_PL/LC_MESSAGES/*',
               'locale/pt_BR/LC_MESSAGES/*',
               'locale/pt_PT/LC_MESSAGES/*',
               'locale/ro_RO/LC_MESSAGES/*',
               'locale/ru_RU/LC_MESSAGES/*',
               'locale/sk_SK/LC_MESSAGES/*',
               'locale/sl_SI/LC_MESSAGES/*',
               'locale/sv_SE/LC_MESSAGES/*',
               'locale/tr_TR/LC_MESSAGES/*',
               'locale/uk_UA/LC_MESSAGES/*',
               'locale/vi_VN/LC_MESSAGES/*',
               'locale/zh_CN/LC_MESSAGES/*',
               'locale/zh_TW/LC_MESSAGES/*']}

modules = \
['SickChill']
install_requires = \
['CacheControl>=0.12.6,<0.13.0',
 'IMDbPY>=2020.09.25',
 'Js2Py>=0.70,<0.72',
 'Mako>=1.1.4,<2.0.0',
 'PyGithub>=1.54.1,<2.0.0',
 'PyNMA>=1.0,<2.0',
 'PySocks>=1.7.1,<2.0.0',
 'SQLAlchemy>=1.4.3,<2.0.0',
 'Send2Trash>=1.5.0,<2.0.0',
 'Unidecode>=1.2.0,<2.0.0',
 'beautifulsoup4>=4.9.3,<5.0.0',
 'beekeeper>=0.9.2,<0.10.0',
 'bencode.py>=4.0.0,<5.0.0',
 'chardet>=4.0.0,<5.0.0',
 'cloudscraper>=1.2.56,<2.0.0',
 'configobj>=5.0.6,<6.0.0',
 'deluge-client>=1.9.0,<2.0.0',
 'enzyme>=0.4.1,<0.5.0',
 'feedparser>=6.0.2,<7.0.0',
 'gntp>=1.0.3,<2.0.0',
 'guessit>=3.3.1,<4.0.0',
 'html5lib>=1.1,<2.0',
 'httplib2>=0.19.0,<0.20.0',
 'ifaddr>=0.1.7,<0.2.0',
 'imagesize>=1.2.0,<2.0.0',
 'ipaddress>=1.0.23,<2.0.0',
 'jsonrpclib-pelix>=0.4.2,<0.5.0',
 'kodipydent>=0.3.1,<0.4.0',
 'markdown2>=2.4.0,<3.0.0',
 'new-rtorrent-python>=1.0.1-alpha.0,<2.0.0',
 'packaging>=20.9,<21.0',
 'profilehooks>=1.12.0,<2.0.0',
 'putio.py>=8.7.0,<9.0.0',
 'pyOpenSSL>=20.0.1,<21.0.0',
 'pyaes>=1.6.1,<2.0.0',
 'pymediainfo>=5.0.3,<6.0.0',
 'python-dateutil>=2.8.1,<3.0.0',
 'python-slugify>=4.0.1,<5.0.0',
 'python-twitter>=3.5,<4.0',
 'python3-fanart>=2.0.0,<3.0.0',
 'qbittorrent-api>=2021.3.18,<2022.0.0',
 'rarfile>=4.0,<5.0',
 'requests>=2.25.1,<3.0.0',
 'subliminal>=2.1.0,<3.0.0',
 'timeago>=1.0.15,<2.0.0',
 'tmdbsimple>=2.8.0,<3.0.0',
 'tornado>=6.1,<7.0',
 'tus.py>=1.3.4,<2.0.0',
 'tvdbsimple>=1.0.6,<2.0.0',
 'validators>=0.18.2,<0.19.0',
 'win-inet-pton>=1.1.0,<2.0.0']

entry_points = \
{'poetry.application.plugin': ['plugin = '
                               'poetry_date_version_plugin.plugin:VersionPlugin']}

scripts = \
["SickChill.py"]

setup_kwargs = {
    'name': 'sickchill',
    'version': '2021.5.10',
    'description': 'Automatic Video Library Manager for TV Shows',
    'long_description': 'SickChill [![Build Status](https://travis-ci.org/SickChill/SickChill.svg?branch=master)](https://travis-ci.org/SickChill/SickChill) [![Build status](https://ci.appveyor.com/api/projects/status/s8bb0iqroecnhya2/branch/master?svg=true)](https://ci.appveyor.com/project/miigotu/SickChill/branch/master) [![XO code style](https://img.shields.io/badge/code_style-XO-5ed9c7.svg)](https://github.com/sindresorhus/xo) [![Donate](https://img.shields.io/badge/donations-appreciated-green.svg)](https://github.com/SickChill/SickChill/wiki/Donations)\n====================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================\n\n#### Please do not confuse us with SickRageTV aka Sickrage.ca, which took over the `sickrage/sickrage` repository in Oct 2018\n#### We will never mine bitcoin on your machine, charge for a "service" or to use the software.\n#### We will never store your information, especially site logins to private trackers.\n#### We believe in honesty and loyalty and privacy.\n\nAutomatic Video Library Manager for TV Shows. It watches for new episodes of your favorite shows, and when they are posted it does its magic.\n\n#### Features\n - Kodi/XBMC library updates, poster/banner/fanart downloads, and NFO/TBN generation\n - Configurable automatic episode renaming, sorting, and other processing\n - Easily see what episodes you\'re missing, are airing soon, and more\n - Automatic torrent/nzb searching, downloading, and processing at the qualities you want\n - Largest list of supported torrent and nzb providers, both public and private\n - Can notify Kodi, XBMC, Growl, Trakt, Twitter, and more when new episodes are available\n - Searches TheTVDB.com and AniDB.net for shows, seasons, episodes, and metadata\n - Episode status management allows for mass failing seasons/episodes to force retrying\n - DVD Order numbering for returning the results in DVD order instead of Air-By-Date order\n - Allows you to choose which indexer to have SickChill search its show info from when importing\n - Automatic XEM Scene Numbering/Naming for seasons/episodes\n - Available for any platform, uses a simple HTTP interface\n - Specials and multi-episode torrent/nzb support\n - Automatic subtitles matching and downloading\n - Improved failed download handling\n - DupeKey/DupeScore for NZBGet 12+\n - Real SSL certificate validation\n - Supports Anime shows\n\n#### Installation/Setup\n\nVisit the [Installation & Configuration guides page](https://github.com/SickChill/SickChill/wiki/Installation-&-Configuration-Guides) on our wiki\n\n#### Dependencies\n\nTo run SickChill you will need Python 3.6+\n\n#### More info\n\n* [Wiki](https://github.com/SickChill/SickChill/wiki)\n\n* [FAQ](https://github.com/SickChill/SickChill/wiki/FAQ%27s-and-Fixes)\n\n* [Issue Tracker](https://github.com/SickChill/SickChill/issues)\n\n#### Important notes on switching from other forks\n\nBefore using this with your existing database (`sickbeard.db`) please make a backup copy of it and delete any other database files such as cache.db and failed.db if present.\n\nWe HIGHLY recommend starting out with no database files at all to make this a fresh start but the choice is at your own risk.\n\n#### Supported providers\n\nA full list can be found here: [Link](https://github.com/SickChill/SickChill/wiki/SickChill-Search-Providers)\n\n#### News and Changelog\n[news.md and CHANGES.md have moved to a separate repo, click here](https://github.com/SickChill/SickChill.github.io)\n',
    'author': 'Dustyn Gibson',
    'author_email': 'miigotu@gmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://sickchill.github.io',
    'packages': packages,
    'package_data': package_data,
    'py_modules': modules,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'scripts': scripts,
    'python_requires': '>=3.6,<4',
}


setup(**setup_kwargs)
