# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from . import utilities, tables

class KafkaAcl(pulumi.CustomResource):
    permission: pulumi.Output[str]
    """
    Kafka permission to grant (admin, read, readwrite, write)
    """
    project: pulumi.Output[str]
    """
    Project to link the Kafka ACL to
    """
    service_name: pulumi.Output[str]
    """
    Service to link the Kafka ACL to
    """
    topic: pulumi.Output[str]
    """
    Topic name pattern for the ACL entry
    """
    username: pulumi.Output[str]
    """
    Username pattern for the ACL entry
    """
    def __init__(__self__, resource_name, opts=None, permission=None, project=None, service_name=None, topic=None, username=None, __props__=None, __name__=None, __opts__=None):
        """
        ## Example Usage



        ```python
        import pulumi
        import pulumi_aiven as aiven

        mytestacl = aiven.KafkaAcl("mytestacl",
            permission="admin",
            project=aiven_project["myproject"]["project"],
            service_name=aiven_service["myservice"]["service_name"],
            topic="<TOPIC_NAME_PATTERN>",
            username="<USERNAME_PATTERN>")
        ```


        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] permission: Kafka permission to grant (admin, read, readwrite, write)
        :param pulumi.Input[str] project: Project to link the Kafka ACL to
        :param pulumi.Input[str] service_name: Service to link the Kafka ACL to
        :param pulumi.Input[str] topic: Topic name pattern for the ACL entry
        :param pulumi.Input[str] username: Username pattern for the ACL entry
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if permission is None:
                raise TypeError("Missing required property 'permission'")
            __props__['permission'] = permission
            if project is None:
                raise TypeError("Missing required property 'project'")
            __props__['project'] = project
            if service_name is None:
                raise TypeError("Missing required property 'service_name'")
            __props__['service_name'] = service_name
            if topic is None:
                raise TypeError("Missing required property 'topic'")
            __props__['topic'] = topic
            if username is None:
                raise TypeError("Missing required property 'username'")
            __props__['username'] = username
        super(KafkaAcl, __self__).__init__(
            'aiven:index/kafkaAcl:KafkaAcl',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, permission=None, project=None, service_name=None, topic=None, username=None):
        """
        Get an existing KafkaAcl resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] permission: Kafka permission to grant (admin, read, readwrite, write)
        :param pulumi.Input[str] project: Project to link the Kafka ACL to
        :param pulumi.Input[str] service_name: Service to link the Kafka ACL to
        :param pulumi.Input[str] topic: Topic name pattern for the ACL entry
        :param pulumi.Input[str] username: Username pattern for the ACL entry
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["permission"] = permission
        __props__["project"] = project
        __props__["service_name"] = service_name
        __props__["topic"] = topic
        __props__["username"] = username
        return KafkaAcl(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

