# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from . import utilities, tables

class ServiceIntegrationEndpoint(pulumi.CustomResource):
    datadog_user_config: pulumi.Output[dict]
    """
    Datadog specific user configurable settings

      * `datadogApiKey` (`str`)
      * `disableConsumerStats` (`str`)
      * `maxPartitionContexts` (`float`)
      * `site` (`str`)
    """
    endpoint_config: pulumi.Output[dict]
    """
    Integration endpoint specific backend configuration
    """
    endpoint_name: pulumi.Output[str]
    """
    Name of the service integration endpoint
    """
    endpoint_type: pulumi.Output[str]
    """
    Type of the service integration endpoint
    """
    external_elasticsearch_logs_user_config: pulumi.Output[dict]
    """
    external elasticsearch specific user configurable settings

      * `ca` (`str`)
      * `indexDaysMax` (`float`)
      * `indexPrefix` (`str`)
      * `timeout` (`float`)
      * `url` (`str`)
    """
    project: pulumi.Output[str]
    """
    Project the service integration endpoint belongs to
    """
    prometheus_user_config: pulumi.Output[dict]
    """
    Prometheus specific user configurable settings

      * `basicAuthPassword` (`str`)
      * `basicAuthUsername` (`str`)
    """
    rsyslog_user_config: pulumi.Output[dict]
    """
    rsyslog specific user configurable settings

      * `ca` (`str`)
      * `cert` (`str`)
      * `format` (`str`)
      * `key` (`str`)
      * `logline` (`str`)
      * `port` (`float`)
      * `sd` (`str`)
      * `server` (`str`)
      * `tls` (`bool`)
    """
    def __init__(__self__, resource_name, opts=None, datadog_user_config=None, endpoint_name=None, endpoint_type=None, external_elasticsearch_logs_user_config=None, project=None, prometheus_user_config=None, rsyslog_user_config=None, __props__=None, __name__=None, __opts__=None):
        """
        ## Example Usage



        ```python
        import pulumi
        import pulumi_aiven as aiven

        myendpoint = aiven.ServiceIntegrationEndpoint("myendpoint",
            datadog_user_config={
                "datadogApiKey": "<DATADOG_API_KEY>",
            },
            endpoint_name="<ENDPOINT_NAME>",
            endpoint_type="datadog",
            project=aiven_project["myproject"]["project"])
        ```


        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[dict] datadog_user_config: Datadog specific user configurable settings
        :param pulumi.Input[str] endpoint_name: Name of the service integration endpoint
        :param pulumi.Input[str] endpoint_type: Type of the service integration endpoint
        :param pulumi.Input[dict] external_elasticsearch_logs_user_config: external elasticsearch specific user configurable settings
        :param pulumi.Input[str] project: Project the service integration endpoint belongs to
        :param pulumi.Input[dict] prometheus_user_config: Prometheus specific user configurable settings
        :param pulumi.Input[dict] rsyslog_user_config: rsyslog specific user configurable settings

        The **datadog_user_config** object supports the following:

          * `datadogApiKey` (`pulumi.Input[str]`)
          * `disableConsumerStats` (`pulumi.Input[str]`)
          * `maxPartitionContexts` (`pulumi.Input[float]`)
          * `site` (`pulumi.Input[str]`)

        The **external_elasticsearch_logs_user_config** object supports the following:

          * `ca` (`pulumi.Input[str]`)
          * `indexDaysMax` (`pulumi.Input[float]`)
          * `indexPrefix` (`pulumi.Input[str]`)
          * `timeout` (`pulumi.Input[float]`)
          * `url` (`pulumi.Input[str]`)

        The **prometheus_user_config** object supports the following:

          * `basicAuthPassword` (`pulumi.Input[str]`)
          * `basicAuthUsername` (`pulumi.Input[str]`)

        The **rsyslog_user_config** object supports the following:

          * `ca` (`pulumi.Input[str]`)
          * `cert` (`pulumi.Input[str]`)
          * `format` (`pulumi.Input[str]`)
          * `key` (`pulumi.Input[str]`)
          * `logline` (`pulumi.Input[str]`)
          * `port` (`pulumi.Input[float]`)
          * `sd` (`pulumi.Input[str]`)
          * `server` (`pulumi.Input[str]`)
          * `tls` (`pulumi.Input[bool]`)
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['datadog_user_config'] = datadog_user_config
            if endpoint_name is None:
                raise TypeError("Missing required property 'endpoint_name'")
            __props__['endpoint_name'] = endpoint_name
            if endpoint_type is None:
                raise TypeError("Missing required property 'endpoint_type'")
            __props__['endpoint_type'] = endpoint_type
            __props__['external_elasticsearch_logs_user_config'] = external_elasticsearch_logs_user_config
            if project is None:
                raise TypeError("Missing required property 'project'")
            __props__['project'] = project
            __props__['prometheus_user_config'] = prometheus_user_config
            __props__['rsyslog_user_config'] = rsyslog_user_config
            __props__['endpoint_config'] = None
        super(ServiceIntegrationEndpoint, __self__).__init__(
            'aiven:index/serviceIntegrationEndpoint:ServiceIntegrationEndpoint',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, datadog_user_config=None, endpoint_config=None, endpoint_name=None, endpoint_type=None, external_elasticsearch_logs_user_config=None, project=None, prometheus_user_config=None, rsyslog_user_config=None):
        """
        Get an existing ServiceIntegrationEndpoint resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[dict] datadog_user_config: Datadog specific user configurable settings
        :param pulumi.Input[dict] endpoint_config: Integration endpoint specific backend configuration
        :param pulumi.Input[str] endpoint_name: Name of the service integration endpoint
        :param pulumi.Input[str] endpoint_type: Type of the service integration endpoint
        :param pulumi.Input[dict] external_elasticsearch_logs_user_config: external elasticsearch specific user configurable settings
        :param pulumi.Input[str] project: Project the service integration endpoint belongs to
        :param pulumi.Input[dict] prometheus_user_config: Prometheus specific user configurable settings
        :param pulumi.Input[dict] rsyslog_user_config: rsyslog specific user configurable settings

        The **datadog_user_config** object supports the following:

          * `datadogApiKey` (`pulumi.Input[str]`)
          * `disableConsumerStats` (`pulumi.Input[str]`)
          * `maxPartitionContexts` (`pulumi.Input[float]`)
          * `site` (`pulumi.Input[str]`)

        The **external_elasticsearch_logs_user_config** object supports the following:

          * `ca` (`pulumi.Input[str]`)
          * `indexDaysMax` (`pulumi.Input[float]`)
          * `indexPrefix` (`pulumi.Input[str]`)
          * `timeout` (`pulumi.Input[float]`)
          * `url` (`pulumi.Input[str]`)

        The **prometheus_user_config** object supports the following:

          * `basicAuthPassword` (`pulumi.Input[str]`)
          * `basicAuthUsername` (`pulumi.Input[str]`)

        The **rsyslog_user_config** object supports the following:

          * `ca` (`pulumi.Input[str]`)
          * `cert` (`pulumi.Input[str]`)
          * `format` (`pulumi.Input[str]`)
          * `key` (`pulumi.Input[str]`)
          * `logline` (`pulumi.Input[str]`)
          * `port` (`pulumi.Input[float]`)
          * `sd` (`pulumi.Input[str]`)
          * `server` (`pulumi.Input[str]`)
          * `tls` (`pulumi.Input[bool]`)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["datadog_user_config"] = datadog_user_config
        __props__["endpoint_config"] = endpoint_config
        __props__["endpoint_name"] = endpoint_name
        __props__["endpoint_type"] = endpoint_type
        __props__["external_elasticsearch_logs_user_config"] = external_elasticsearch_logs_user_config
        __props__["project"] = project
        __props__["prometheus_user_config"] = prometheus_user_config
        __props__["rsyslog_user_config"] = rsyslog_user_config
        return ServiceIntegrationEndpoint(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

