import { Resource } from "@cdktf/provider-null";
import { ITerraformDependable, TerraformProvider, TerraformResourceLifecycle } from "cdktf";
import { Construct } from "constructs";
/**
 * @stability stable
 */
export interface LocalExecOptions {
    /**
     * @stability stable
     */
    readonly dependsOn?: ITerraformDependable[];
    /**
     * @stability stable
     */
    readonly provider?: TerraformProvider;
    /**
     * @stability stable
     */
    readonly lifecycle?: TerraformResourceLifecycle;
    /**
     * @stability stable
     */
    readonly triggers?: {
        [key: string]: string;
    };
    /**
     * The command to run.
     *
     * @stability stable
     */
    readonly command: string;
    /**
     * The working directory to run the command in.
     *
     * Defaults to process.pwd().
     * If copyBeforeRun is set to true it will copy the working directory to an asset directory and take that as the base to run.
     *
     * @stability stable
     */
    readonly cwd: string;
    /**
     * If set to true, the working directory will be copied to an asset directory.
     *
     * @default true
     * @stability stable
     */
    readonly copyBeforeRun?: boolean;
}
export { NullProvider as Provider } from "@cdktf/provider-null";
/**
 * @stability stable
 */
export declare class LocalExec extends Resource {
    /**
     * @stability stable
     */
    cwd: string;
    /**
     * @stability stable
     */
    command: string;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: LocalExecOptions);
}
