"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LocalExec = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const provider_null_1 = require("@cdktf/provider-null");
const cdktf_1 = require("cdktf");
var provider_null_2 = require("@cdktf/provider-null");
Object.defineProperty(exports, "Provider", { enumerable: true, get: function () { return provider_null_2.NullProvider; } });
/**
 * @stability stable
 */
class LocalExec extends provider_null_1.Resource {
    /**
     * @stability stable
     */
    constructor(scope, id, config) {
        super(scope, id, config);
        const workingDir = config.copyBeforeRun === true
            ? new cdktf_1.TerraformAsset(this, "workingDir", {
                path: config.cwd,
                type: cdktf_1.AssetType.DIRECTORY,
            }).path
            : config.cwd;
        this.cwd = workingDir;
        this.command = config.command;
        this.addOverride("provisioner", [
            {
                "local-exec": {
                    working_dir: workingDir,
                    command: cdktf_1.Lazy.stringValue({
                        // TODO: wrap command to capture stdout and stderr
                        produce: () => this.command,
                    }),
                },
            },
        ]);
    }
}
exports.LocalExec = LocalExec;
_a = JSII_RTTI_SYMBOL_1;
LocalExec[_a] = { fqn: "cdktf-local-exec.LocalExec", version: "0.0.28" };
//# sourceMappingURL=data:application/json;base64,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