# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from ._enums import *

__all__ = [
    'AppSpecArgs',
    'AppSpecDatabaseArgs',
    'AppSpecDomainNameArgs',
    'AppSpecEnvArgs',
    'AppSpecJobArgs',
    'AppSpecJobEnvArgs',
    'AppSpecJobGitArgs',
    'AppSpecJobGithubArgs',
    'AppSpecJobGitlabArgs',
    'AppSpecJobImageArgs',
    'AppSpecServiceArgs',
    'AppSpecServiceCorsArgs',
    'AppSpecServiceCorsAllowOriginsArgs',
    'AppSpecServiceEnvArgs',
    'AppSpecServiceGitArgs',
    'AppSpecServiceGithubArgs',
    'AppSpecServiceGitlabArgs',
    'AppSpecServiceHealthCheckArgs',
    'AppSpecServiceImageArgs',
    'AppSpecServiceRouteArgs',
    'AppSpecStaticSiteArgs',
    'AppSpecStaticSiteCorsArgs',
    'AppSpecStaticSiteCorsAllowOriginsArgs',
    'AppSpecStaticSiteEnvArgs',
    'AppSpecStaticSiteGitArgs',
    'AppSpecStaticSiteGithubArgs',
    'AppSpecStaticSiteGitlabArgs',
    'AppSpecStaticSiteRouteArgs',
    'AppSpecWorkerArgs',
    'AppSpecWorkerEnvArgs',
    'AppSpecWorkerGitArgs',
    'AppSpecWorkerGithubArgs',
    'AppSpecWorkerGitlabArgs',
    'AppSpecWorkerImageArgs',
    'DatabaseClusterMaintenanceWindowArgs',
    'DatabaseFirewallRuleArgs',
    'FirewallInboundRuleArgs',
    'FirewallOutboundRuleArgs',
    'FirewallPendingChangeArgs',
    'KubernetesClusterKubeConfigArgs',
    'KubernetesClusterMaintenancePolicyArgs',
    'KubernetesClusterNodePoolArgs',
    'KubernetesClusterNodePoolNodeArgs',
    'KubernetesClusterNodePoolTaintArgs',
    'KubernetesNodePoolNodeArgs',
    'KubernetesNodePoolTaintArgs',
    'LoadBalancerForwardingRuleArgs',
    'LoadBalancerHealthcheckArgs',
    'LoadBalancerStickySessionsArgs',
    'MonitorAlertAlertsArgs',
    'MonitorAlertAlertsSlackArgs',
    'SpacesBucketCorsRuleArgs',
    'SpacesBucketLifecycleRuleArgs',
    'SpacesBucketLifecycleRuleExpirationArgs',
    'SpacesBucketLifecycleRuleNoncurrentVersionExpirationArgs',
    'SpacesBucketVersioningArgs',
    'GetDomainsFilterArgs',
    'GetDomainsSortArgs',
    'GetDropletsFilterArgs',
    'GetDropletsSortArgs',
    'GetFirewallInboundRuleArgs',
    'GetFirewallOutboundRuleArgs',
    'GetImagesFilterArgs',
    'GetImagesSortArgs',
    'GetProjectsFilterArgs',
    'GetProjectsSortArgs',
    'GetRecordsFilterArgs',
    'GetRecordsSortArgs',
    'GetRegionsFilterArgs',
    'GetRegionsSortArgs',
    'GetSizesFilterArgs',
    'GetSizesSortArgs',
    'GetSpacesBucketsFilterArgs',
    'GetSpacesBucketsSortArgs',
    'GetSshKeysFilterArgs',
    'GetSshKeysSortArgs',
    'GetTagsFilterArgs',
    'GetTagsSortArgs',
]

@pulumi.input_type
class AppSpecArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 databases: Optional[pulumi.Input[Sequence[pulumi.Input['AppSpecDatabaseArgs']]]] = None,
                 domain_names: Optional[pulumi.Input[Sequence[pulumi.Input['AppSpecDomainNameArgs']]]] = None,
                 domains: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 envs: Optional[pulumi.Input[Sequence[pulumi.Input['AppSpecEnvArgs']]]] = None,
                 jobs: Optional[pulumi.Input[Sequence[pulumi.Input['AppSpecJobArgs']]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 services: Optional[pulumi.Input[Sequence[pulumi.Input['AppSpecServiceArgs']]]] = None,
                 static_sites: Optional[pulumi.Input[Sequence[pulumi.Input['AppSpecStaticSiteArgs']]]] = None,
                 workers: Optional[pulumi.Input[Sequence[pulumi.Input['AppSpecWorkerArgs']]]] = None):
        """
        :param pulumi.Input[str] name: The name of the component.
        :param pulumi.Input[Sequence[pulumi.Input['AppSpecDomainNameArgs']]] domain_names: Describes a domain where the application will be made available.
        :param pulumi.Input[Sequence[pulumi.Input['AppSpecEnvArgs']]] envs: Describes an environment variable made available to an app competent.
        :param pulumi.Input[str] region: The slug for the DigitalOcean data center region hosting the app.
        """
        pulumi.set(__self__, "name", name)
        if databases is not None:
            pulumi.set(__self__, "databases", databases)
        if domain_names is not None:
            pulumi.set(__self__, "domain_names", domain_names)
        if domains is not None:
            warnings.warn("""This attribute has been replaced by `domain` which supports additional functionality.""", DeprecationWarning)
            pulumi.log.warn("""domains is deprecated: This attribute has been replaced by `domain` which supports additional functionality.""")
        if domains is not None:
            pulumi.set(__self__, "domains", domains)
        if envs is not None:
            pulumi.set(__self__, "envs", envs)
        if jobs is not None:
            pulumi.set(__self__, "jobs", jobs)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if services is not None:
            pulumi.set(__self__, "services", services)
        if static_sites is not None:
            pulumi.set(__self__, "static_sites", static_sites)
        if workers is not None:
            pulumi.set(__self__, "workers", workers)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the component.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def databases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppSpecDatabaseArgs']]]]:
        return pulumi.get(self, "databases")

    @databases.setter
    def databases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppSpecDatabaseArgs']]]]):
        pulumi.set(self, "databases", value)

    @property
    @pulumi.getter(name="domainNames")
    def domain_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppSpecDomainNameArgs']]]]:
        """
        Describes a domain where the application will be made available.
        """
        return pulumi.get(self, "domain_names")

    @domain_names.setter
    def domain_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppSpecDomainNameArgs']]]]):
        pulumi.set(self, "domain_names", value)

    @property
    @pulumi.getter
    def domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "domains")

    @domains.setter
    def domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "domains", value)

    @property
    @pulumi.getter
    def envs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppSpecEnvArgs']]]]:
        """
        Describes an environment variable made available to an app competent.
        """
        return pulumi.get(self, "envs")

    @envs.setter
    def envs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppSpecEnvArgs']]]]):
        pulumi.set(self, "envs", value)

    @property
    @pulumi.getter
    def jobs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppSpecJobArgs']]]]:
        return pulumi.get(self, "jobs")

    @jobs.setter
    def jobs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppSpecJobArgs']]]]):
        pulumi.set(self, "jobs", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The slug for the DigitalOcean data center region hosting the app.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def services(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppSpecServiceArgs']]]]:
        return pulumi.get(self, "services")

    @services.setter
    def services(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppSpecServiceArgs']]]]):
        pulumi.set(self, "services", value)

    @property
    @pulumi.getter(name="staticSites")
    def static_sites(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppSpecStaticSiteArgs']]]]:
        return pulumi.get(self, "static_sites")

    @static_sites.setter
    def static_sites(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppSpecStaticSiteArgs']]]]):
        pulumi.set(self, "static_sites", value)

    @property
    @pulumi.getter
    def workers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppSpecWorkerArgs']]]]:
        return pulumi.get(self, "workers")

    @workers.setter
    def workers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppSpecWorkerArgs']]]]):
        pulumi.set(self, "workers", value)


@pulumi.input_type
class AppSpecDatabaseArgs:
    def __init__(__self__, *,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 db_name: Optional[pulumi.Input[str]] = None,
                 db_user: Optional[pulumi.Input[str]] = None,
                 engine: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 production: Optional[pulumi.Input[bool]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] cluster_name: The name of the underlying DigitalOcean DBaaS cluster. This is required for production databases. For dev databases, if `cluster_name` is not set, a new cluster will be provisioned.
        :param pulumi.Input[str] db_name: The name of the MySQL or PostgreSQL database to configure.
        :param pulumi.Input[str] db_user: The name of the MySQL or PostgreSQL user to configure.
        :param pulumi.Input[str] engine: The database engine to use (`MYSQL`, `PG`, `REDIS`, or `MONGODB`).
        :param pulumi.Input[str] name: The name of the component.
        :param pulumi.Input[bool] production: Whether this is a production or dev database.
        :param pulumi.Input[str] version: The version of the database engine.
        """
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if db_name is not None:
            pulumi.set(__self__, "db_name", db_name)
        if db_user is not None:
            pulumi.set(__self__, "db_user", db_user)
        if engine is not None:
            pulumi.set(__self__, "engine", engine)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if production is not None:
            pulumi.set(__self__, "production", production)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the underlying DigitalOcean DBaaS cluster. This is required for production databases. For dev databases, if `cluster_name` is not set, a new cluster will be provisioned.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_name", value)

    @property
    @pulumi.getter(name="dbName")
    def db_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the MySQL or PostgreSQL database to configure.
        """
        return pulumi.get(self, "db_name")

    @db_name.setter
    def db_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_name", value)

    @property
    @pulumi.getter(name="dbUser")
    def db_user(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the MySQL or PostgreSQL user to configure.
        """
        return pulumi.get(self, "db_user")

    @db_user.setter
    def db_user(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_user", value)

    @property
    @pulumi.getter
    def engine(self) -> Optional[pulumi.Input[str]]:
        """
        The database engine to use (`MYSQL`, `PG`, `REDIS`, or `MONGODB`).
        """
        return pulumi.get(self, "engine")

    @engine.setter
    def engine(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "engine", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the component.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def production(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether this is a production or dev database.
        """
        return pulumi.get(self, "production")

    @production.setter
    def production(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "production", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of the database engine.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class AppSpecDomainNameArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 type: Optional[pulumi.Input[str]] = None,
                 wildcard: Optional[pulumi.Input[bool]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: The name of the component.
        :param pulumi.Input[str] type: The type of the environment variable, `GENERAL` or `SECRET`.
        :param pulumi.Input[bool] wildcard: A boolean indicating whether the domain includes all sub-domains, in addition to the given domain.
        :param pulumi.Input[str] zone: If the domain uses DigitalOcean DNS and you would like App Platform to automatically manage it for you, set this to the name of the domain on your account.
        """
        pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if wildcard is not None:
            pulumi.set(__self__, "wildcard", wildcard)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the component.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the environment variable, `GENERAL` or `SECRET`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def wildcard(self) -> Optional[pulumi.Input[bool]]:
        """
        A boolean indicating whether the domain includes all sub-domains, in addition to the given domain.
        """
        return pulumi.get(self, "wildcard")

    @wildcard.setter
    def wildcard(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "wildcard", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        If the domain uses DigitalOcean DNS and you would like App Platform to automatically manage it for you, set this to the name of the domain on your account.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class AppSpecEnvArgs:
    def __init__(__self__, *,
                 key: Optional[pulumi.Input[str]] = None,
                 scope: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] key: The name of the environment variable.
        :param pulumi.Input[str] scope: The visibility scope of the environment variable. One of `RUN_TIME`, `BUILD_TIME`, or `RUN_AND_BUILD_TIME` (default).
        :param pulumi.Input[str] type: The type of the environment variable, `GENERAL` or `SECRET`.
        :param pulumi.Input[str] value: The value of the environment variable.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the environment variable.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[str]]:
        """
        The visibility scope of the environment variable. One of `RUN_TIME`, `BUILD_TIME`, or `RUN_AND_BUILD_TIME` (default).
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the environment variable, `GENERAL` or `SECRET`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        The value of the environment variable.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class AppSpecJobArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 build_command: Optional[pulumi.Input[str]] = None,
                 dockerfile_path: Optional[pulumi.Input[str]] = None,
                 environment_slug: Optional[pulumi.Input[str]] = None,
                 envs: Optional[pulumi.Input[Sequence[pulumi.Input['AppSpecJobEnvArgs']]]] = None,
                 git: Optional[pulumi.Input['AppSpecJobGitArgs']] = None,
                 github: Optional[pulumi.Input['AppSpecJobGithubArgs']] = None,
                 gitlab: Optional[pulumi.Input['AppSpecJobGitlabArgs']] = None,
                 image: Optional[pulumi.Input['AppSpecJobImageArgs']] = None,
                 instance_count: Optional[pulumi.Input[int]] = None,
                 instance_size_slug: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 run_command: Optional[pulumi.Input[str]] = None,
                 source_dir: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: The name of the component.
        :param pulumi.Input[str] build_command: An optional build command to run while building this component from source.
        :param pulumi.Input[str] dockerfile_path: The path to a Dockerfile relative to the root of the repo. If set, overrides usage of buildpacks.
        :param pulumi.Input[str] environment_slug: An environment slug describing the type of this app.
        :param pulumi.Input[Sequence[pulumi.Input['AppSpecJobEnvArgs']]] envs: Describes an environment variable made available to an app competent.
        :param pulumi.Input['AppSpecJobGitArgs'] git: A Git repo to use as the component's source. The repository must be able to be cloned without authentication.  Only one of `git`, `github` or `gitlab`  may be set
        :param pulumi.Input['AppSpecJobGithubArgs'] github: A GitHub repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/github/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        :param pulumi.Input['AppSpecJobGitlabArgs'] gitlab: A Gitlab repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/gitlab/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        :param pulumi.Input['AppSpecJobImageArgs'] image: An image to use as the component's source. Only one of `git`, `github`, `gitlab`, or `image` may be set.
        :param pulumi.Input[int] instance_count: The amount of instances that this component should be scaled to.
        :param pulumi.Input[str] instance_size_slug: The instance size to use for this component. This determines the plan (basic or professional) and the available CPU and memory. The list of available instance sizes can be [found with the API](https://docs.digitalocean.com/reference/api/api-reference/#operation/list_instance_sizes) or using the [doctl CLI](https://docs.digitalocean.com/reference/doctl/) (`doctl apps tier instance-size list`). Default: `basic-xxs`
        :param pulumi.Input[str] kind: The type of job and when it will be run during the deployment process. It may be one of:
               - `UNSPECIFIED`: Default job type, will auto-complete to POST_DEPLOY kind.
               - `PRE_DEPLOY`: Indicates a job that runs before an app deployment.
               - `POST_DEPLOY`: Indicates a job that runs after an app deployment.
               - `FAILED_DEPLOY`: Indicates a job that runs after a component fails to deploy.
        :param pulumi.Input[str] run_command: An optional run command to override the component's default.
        :param pulumi.Input[str] source_dir: An optional path to the working directory to use for the build.
        """
        pulumi.set(__self__, "name", name)
        if build_command is not None:
            pulumi.set(__self__, "build_command", build_command)
        if dockerfile_path is not None:
            pulumi.set(__self__, "dockerfile_path", dockerfile_path)
        if environment_slug is not None:
            pulumi.set(__self__, "environment_slug", environment_slug)
        if envs is not None:
            pulumi.set(__self__, "envs", envs)
        if git is not None:
            pulumi.set(__self__, "git", git)
        if github is not None:
            pulumi.set(__self__, "github", github)
        if gitlab is not None:
            pulumi.set(__self__, "gitlab", gitlab)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if instance_size_slug is not None:
            pulumi.set(__self__, "instance_size_slug", instance_size_slug)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if run_command is not None:
            pulumi.set(__self__, "run_command", run_command)
        if source_dir is not None:
            pulumi.set(__self__, "source_dir", source_dir)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the component.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="buildCommand")
    def build_command(self) -> Optional[pulumi.Input[str]]:
        """
        An optional build command to run while building this component from source.
        """
        return pulumi.get(self, "build_command")

    @build_command.setter
    def build_command(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "build_command", value)

    @property
    @pulumi.getter(name="dockerfilePath")
    def dockerfile_path(self) -> Optional[pulumi.Input[str]]:
        """
        The path to a Dockerfile relative to the root of the repo. If set, overrides usage of buildpacks.
        """
        return pulumi.get(self, "dockerfile_path")

    @dockerfile_path.setter
    def dockerfile_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dockerfile_path", value)

    @property
    @pulumi.getter(name="environmentSlug")
    def environment_slug(self) -> Optional[pulumi.Input[str]]:
        """
        An environment slug describing the type of this app.
        """
        return pulumi.get(self, "environment_slug")

    @environment_slug.setter
    def environment_slug(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "environment_slug", value)

    @property
    @pulumi.getter
    def envs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppSpecJobEnvArgs']]]]:
        """
        Describes an environment variable made available to an app competent.
        """
        return pulumi.get(self, "envs")

    @envs.setter
    def envs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppSpecJobEnvArgs']]]]):
        pulumi.set(self, "envs", value)

    @property
    @pulumi.getter
    def git(self) -> Optional[pulumi.Input['AppSpecJobGitArgs']]:
        """
        A Git repo to use as the component's source. The repository must be able to be cloned without authentication.  Only one of `git`, `github` or `gitlab`  may be set
        """
        return pulumi.get(self, "git")

    @git.setter
    def git(self, value: Optional[pulumi.Input['AppSpecJobGitArgs']]):
        pulumi.set(self, "git", value)

    @property
    @pulumi.getter
    def github(self) -> Optional[pulumi.Input['AppSpecJobGithubArgs']]:
        """
        A GitHub repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/github/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        """
        return pulumi.get(self, "github")

    @github.setter
    def github(self, value: Optional[pulumi.Input['AppSpecJobGithubArgs']]):
        pulumi.set(self, "github", value)

    @property
    @pulumi.getter
    def gitlab(self) -> Optional[pulumi.Input['AppSpecJobGitlabArgs']]:
        """
        A Gitlab repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/gitlab/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        """
        return pulumi.get(self, "gitlab")

    @gitlab.setter
    def gitlab(self, value: Optional[pulumi.Input['AppSpecJobGitlabArgs']]):
        pulumi.set(self, "gitlab", value)

    @property
    @pulumi.getter
    def image(self) -> Optional[pulumi.Input['AppSpecJobImageArgs']]:
        """
        An image to use as the component's source. Only one of `git`, `github`, `gitlab`, or `image` may be set.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input['AppSpecJobImageArgs']]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[pulumi.Input[int]]:
        """
        The amount of instances that this component should be scaled to.
        """
        return pulumi.get(self, "instance_count")

    @instance_count.setter
    def instance_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "instance_count", value)

    @property
    @pulumi.getter(name="instanceSizeSlug")
    def instance_size_slug(self) -> Optional[pulumi.Input[str]]:
        """
        The instance size to use for this component. This determines the plan (basic or professional) and the available CPU and memory. The list of available instance sizes can be [found with the API](https://docs.digitalocean.com/reference/api/api-reference/#operation/list_instance_sizes) or using the [doctl CLI](https://docs.digitalocean.com/reference/doctl/) (`doctl apps tier instance-size list`). Default: `basic-xxs`
        """
        return pulumi.get(self, "instance_size_slug")

    @instance_size_slug.setter
    def instance_size_slug(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_size_slug", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        The type of job and when it will be run during the deployment process. It may be one of:
        - `UNSPECIFIED`: Default job type, will auto-complete to POST_DEPLOY kind.
        - `PRE_DEPLOY`: Indicates a job that runs before an app deployment.
        - `POST_DEPLOY`: Indicates a job that runs after an app deployment.
        - `FAILED_DEPLOY`: Indicates a job that runs after a component fails to deploy.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter(name="runCommand")
    def run_command(self) -> Optional[pulumi.Input[str]]:
        """
        An optional run command to override the component's default.
        """
        return pulumi.get(self, "run_command")

    @run_command.setter
    def run_command(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "run_command", value)

    @property
    @pulumi.getter(name="sourceDir")
    def source_dir(self) -> Optional[pulumi.Input[str]]:
        """
        An optional path to the working directory to use for the build.
        """
        return pulumi.get(self, "source_dir")

    @source_dir.setter
    def source_dir(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_dir", value)


@pulumi.input_type
class AppSpecJobEnvArgs:
    def __init__(__self__, *,
                 key: Optional[pulumi.Input[str]] = None,
                 scope: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] key: The name of the environment variable.
        :param pulumi.Input[str] scope: The visibility scope of the environment variable. One of `RUN_TIME`, `BUILD_TIME`, or `RUN_AND_BUILD_TIME` (default).
        :param pulumi.Input[str] type: The type of the environment variable, `GENERAL` or `SECRET`.
        :param pulumi.Input[str] value: The value of the environment variable.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the environment variable.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[str]]:
        """
        The visibility scope of the environment variable. One of `RUN_TIME`, `BUILD_TIME`, or `RUN_AND_BUILD_TIME` (default).
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the environment variable, `GENERAL` or `SECRET`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        The value of the environment variable.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class AppSpecJobGitArgs:
    def __init__(__self__, *,
                 branch: Optional[pulumi.Input[str]] = None,
                 repo_clone_url: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] branch: The name of the branch to use.
        :param pulumi.Input[str] repo_clone_url: The clone URL of the repo.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if repo_clone_url is not None:
            pulumi.set(__self__, "repo_clone_url", repo_clone_url)

    @property
    @pulumi.getter
    def branch(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the branch to use.
        """
        return pulumi.get(self, "branch")

    @branch.setter
    def branch(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "branch", value)

    @property
    @pulumi.getter(name="repoCloneUrl")
    def repo_clone_url(self) -> Optional[pulumi.Input[str]]:
        """
        The clone URL of the repo.
        """
        return pulumi.get(self, "repo_clone_url")

    @repo_clone_url.setter
    def repo_clone_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "repo_clone_url", value)


@pulumi.input_type
class AppSpecJobGithubArgs:
    def __init__(__self__, *,
                 branch: Optional[pulumi.Input[str]] = None,
                 deploy_on_push: Optional[pulumi.Input[bool]] = None,
                 repo: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] branch: The name of the branch to use.
        :param pulumi.Input[bool] deploy_on_push: Whether to automatically deploy new commits made to the repo.
        :param pulumi.Input[str] repo: The name of the repo in the format `owner/repo`.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if deploy_on_push is not None:
            pulumi.set(__self__, "deploy_on_push", deploy_on_push)
        if repo is not None:
            pulumi.set(__self__, "repo", repo)

    @property
    @pulumi.getter
    def branch(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the branch to use.
        """
        return pulumi.get(self, "branch")

    @branch.setter
    def branch(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "branch", value)

    @property
    @pulumi.getter(name="deployOnPush")
    def deploy_on_push(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to automatically deploy new commits made to the repo.
        """
        return pulumi.get(self, "deploy_on_push")

    @deploy_on_push.setter
    def deploy_on_push(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "deploy_on_push", value)

    @property
    @pulumi.getter
    def repo(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the repo in the format `owner/repo`.
        """
        return pulumi.get(self, "repo")

    @repo.setter
    def repo(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "repo", value)


@pulumi.input_type
class AppSpecJobGitlabArgs:
    def __init__(__self__, *,
                 branch: Optional[pulumi.Input[str]] = None,
                 deploy_on_push: Optional[pulumi.Input[bool]] = None,
                 repo: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] branch: The name of the branch to use.
        :param pulumi.Input[bool] deploy_on_push: Whether to automatically deploy new commits made to the repo.
        :param pulumi.Input[str] repo: The name of the repo in the format `owner/repo`.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if deploy_on_push is not None:
            pulumi.set(__self__, "deploy_on_push", deploy_on_push)
        if repo is not None:
            pulumi.set(__self__, "repo", repo)

    @property
    @pulumi.getter
    def branch(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the branch to use.
        """
        return pulumi.get(self, "branch")

    @branch.setter
    def branch(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "branch", value)

    @property
    @pulumi.getter(name="deployOnPush")
    def deploy_on_push(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to automatically deploy new commits made to the repo.
        """
        return pulumi.get(self, "deploy_on_push")

    @deploy_on_push.setter
    def deploy_on_push(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "deploy_on_push", value)

    @property
    @pulumi.getter
    def repo(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the repo in the format `owner/repo`.
        """
        return pulumi.get(self, "repo")

    @repo.setter
    def repo(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "repo", value)


@pulumi.input_type
class AppSpecJobImageArgs:
    def __init__(__self__, *,
                 registry_type: pulumi.Input[str],
                 repository: pulumi.Input[str],
                 registry: Optional[pulumi.Input[str]] = None,
                 tag: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] registry_type: The registry type. One of `DOCR` (DigitalOcean container registry) or `DOCKER_HUB`.
        :param pulumi.Input[str] repository: The repository name.
        :param pulumi.Input[str] registry: The registry name. Must be left empty for the `DOCR` registry type. Required for the `DOCKER_HUB` registry type.
        :param pulumi.Input[str] tag: The repository tag. Defaults to `latest` if not provided.
        """
        pulumi.set(__self__, "registry_type", registry_type)
        pulumi.set(__self__, "repository", repository)
        if registry is not None:
            pulumi.set(__self__, "registry", registry)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)

    @property
    @pulumi.getter(name="registryType")
    def registry_type(self) -> pulumi.Input[str]:
        """
        The registry type. One of `DOCR` (DigitalOcean container registry) or `DOCKER_HUB`.
        """
        return pulumi.get(self, "registry_type")

    @registry_type.setter
    def registry_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "registry_type", value)

    @property
    @pulumi.getter
    def repository(self) -> pulumi.Input[str]:
        """
        The repository name.
        """
        return pulumi.get(self, "repository")

    @repository.setter
    def repository(self, value: pulumi.Input[str]):
        pulumi.set(self, "repository", value)

    @property
    @pulumi.getter
    def registry(self) -> Optional[pulumi.Input[str]]:
        """
        The registry name. Must be left empty for the `DOCR` registry type. Required for the `DOCKER_HUB` registry type.
        """
        return pulumi.get(self, "registry")

    @registry.setter
    def registry(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "registry", value)

    @property
    @pulumi.getter
    def tag(self) -> Optional[pulumi.Input[str]]:
        """
        The repository tag. Defaults to `latest` if not provided.
        """
        return pulumi.get(self, "tag")

    @tag.setter
    def tag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tag", value)


@pulumi.input_type
class AppSpecServiceArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 build_command: Optional[pulumi.Input[str]] = None,
                 cors: Optional[pulumi.Input['AppSpecServiceCorsArgs']] = None,
                 dockerfile_path: Optional[pulumi.Input[str]] = None,
                 environment_slug: Optional[pulumi.Input[str]] = None,
                 envs: Optional[pulumi.Input[Sequence[pulumi.Input['AppSpecServiceEnvArgs']]]] = None,
                 git: Optional[pulumi.Input['AppSpecServiceGitArgs']] = None,
                 github: Optional[pulumi.Input['AppSpecServiceGithubArgs']] = None,
                 gitlab: Optional[pulumi.Input['AppSpecServiceGitlabArgs']] = None,
                 health_check: Optional[pulumi.Input['AppSpecServiceHealthCheckArgs']] = None,
                 http_port: Optional[pulumi.Input[int]] = None,
                 image: Optional[pulumi.Input['AppSpecServiceImageArgs']] = None,
                 instance_count: Optional[pulumi.Input[int]] = None,
                 instance_size_slug: Optional[pulumi.Input[str]] = None,
                 internal_ports: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 routes: Optional[pulumi.Input[Sequence[pulumi.Input['AppSpecServiceRouteArgs']]]] = None,
                 run_command: Optional[pulumi.Input[str]] = None,
                 source_dir: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: The name of the component.
        :param pulumi.Input[str] build_command: An optional build command to run while building this component from source.
        :param pulumi.Input['AppSpecServiceCorsArgs'] cors: The [CORS](https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS) policies of the app.
        :param pulumi.Input[str] dockerfile_path: The path to a Dockerfile relative to the root of the repo. If set, overrides usage of buildpacks.
        :param pulumi.Input[str] environment_slug: An environment slug describing the type of this app.
        :param pulumi.Input[Sequence[pulumi.Input['AppSpecServiceEnvArgs']]] envs: Describes an environment variable made available to an app competent.
        :param pulumi.Input['AppSpecServiceGitArgs'] git: A Git repo to use as the component's source. The repository must be able to be cloned without authentication.  Only one of `git`, `github` or `gitlab`  may be set
        :param pulumi.Input['AppSpecServiceGithubArgs'] github: A GitHub repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/github/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        :param pulumi.Input['AppSpecServiceGitlabArgs'] gitlab: A Gitlab repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/gitlab/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        :param pulumi.Input['AppSpecServiceHealthCheckArgs'] health_check: A health check to determine the availability of this component.
        :param pulumi.Input[int] http_port: The internal port on which this service's run command will listen.
        :param pulumi.Input['AppSpecServiceImageArgs'] image: An image to use as the component's source. Only one of `git`, `github`, `gitlab`, or `image` may be set.
        :param pulumi.Input[int] instance_count: The amount of instances that this component should be scaled to.
        :param pulumi.Input[str] instance_size_slug: The instance size to use for this component. This determines the plan (basic or professional) and the available CPU and memory. The list of available instance sizes can be [found with the API](https://docs.digitalocean.com/reference/api/api-reference/#operation/list_instance_sizes) or using the [doctl CLI](https://docs.digitalocean.com/reference/doctl/) (`doctl apps tier instance-size list`). Default: `basic-xxs`
        :param pulumi.Input[Sequence[pulumi.Input[int]]] internal_ports: A list of ports on which this service will listen for internal traffic.
        :param pulumi.Input[str] run_command: An optional run command to override the component's default.
        :param pulumi.Input[str] source_dir: An optional path to the working directory to use for the build.
        """
        pulumi.set(__self__, "name", name)
        if build_command is not None:
            pulumi.set(__self__, "build_command", build_command)
        if cors is not None:
            pulumi.set(__self__, "cors", cors)
        if dockerfile_path is not None:
            pulumi.set(__self__, "dockerfile_path", dockerfile_path)
        if environment_slug is not None:
            pulumi.set(__self__, "environment_slug", environment_slug)
        if envs is not None:
            pulumi.set(__self__, "envs", envs)
        if git is not None:
            pulumi.set(__self__, "git", git)
        if github is not None:
            pulumi.set(__self__, "github", github)
        if gitlab is not None:
            pulumi.set(__self__, "gitlab", gitlab)
        if health_check is not None:
            pulumi.set(__self__, "health_check", health_check)
        if http_port is not None:
            pulumi.set(__self__, "http_port", http_port)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if instance_size_slug is not None:
            pulumi.set(__self__, "instance_size_slug", instance_size_slug)
        if internal_ports is not None:
            pulumi.set(__self__, "internal_ports", internal_ports)
        if routes is not None:
            pulumi.set(__self__, "routes", routes)
        if run_command is not None:
            pulumi.set(__self__, "run_command", run_command)
        if source_dir is not None:
            pulumi.set(__self__, "source_dir", source_dir)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the component.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="buildCommand")
    def build_command(self) -> Optional[pulumi.Input[str]]:
        """
        An optional build command to run while building this component from source.
        """
        return pulumi.get(self, "build_command")

    @build_command.setter
    def build_command(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "build_command", value)

    @property
    @pulumi.getter
    def cors(self) -> Optional[pulumi.Input['AppSpecServiceCorsArgs']]:
        """
        The [CORS](https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS) policies of the app.
        """
        return pulumi.get(self, "cors")

    @cors.setter
    def cors(self, value: Optional[pulumi.Input['AppSpecServiceCorsArgs']]):
        pulumi.set(self, "cors", value)

    @property
    @pulumi.getter(name="dockerfilePath")
    def dockerfile_path(self) -> Optional[pulumi.Input[str]]:
        """
        The path to a Dockerfile relative to the root of the repo. If set, overrides usage of buildpacks.
        """
        return pulumi.get(self, "dockerfile_path")

    @dockerfile_path.setter
    def dockerfile_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dockerfile_path", value)

    @property
    @pulumi.getter(name="environmentSlug")
    def environment_slug(self) -> Optional[pulumi.Input[str]]:
        """
        An environment slug describing the type of this app.
        """
        return pulumi.get(self, "environment_slug")

    @environment_slug.setter
    def environment_slug(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "environment_slug", value)

    @property
    @pulumi.getter
    def envs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppSpecServiceEnvArgs']]]]:
        """
        Describes an environment variable made available to an app competent.
        """
        return pulumi.get(self, "envs")

    @envs.setter
    def envs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppSpecServiceEnvArgs']]]]):
        pulumi.set(self, "envs", value)

    @property
    @pulumi.getter
    def git(self) -> Optional[pulumi.Input['AppSpecServiceGitArgs']]:
        """
        A Git repo to use as the component's source. The repository must be able to be cloned without authentication.  Only one of `git`, `github` or `gitlab`  may be set
        """
        return pulumi.get(self, "git")

    @git.setter
    def git(self, value: Optional[pulumi.Input['AppSpecServiceGitArgs']]):
        pulumi.set(self, "git", value)

    @property
    @pulumi.getter
    def github(self) -> Optional[pulumi.Input['AppSpecServiceGithubArgs']]:
        """
        A GitHub repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/github/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        """
        return pulumi.get(self, "github")

    @github.setter
    def github(self, value: Optional[pulumi.Input['AppSpecServiceGithubArgs']]):
        pulumi.set(self, "github", value)

    @property
    @pulumi.getter
    def gitlab(self) -> Optional[pulumi.Input['AppSpecServiceGitlabArgs']]:
        """
        A Gitlab repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/gitlab/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        """
        return pulumi.get(self, "gitlab")

    @gitlab.setter
    def gitlab(self, value: Optional[pulumi.Input['AppSpecServiceGitlabArgs']]):
        pulumi.set(self, "gitlab", value)

    @property
    @pulumi.getter(name="healthCheck")
    def health_check(self) -> Optional[pulumi.Input['AppSpecServiceHealthCheckArgs']]:
        """
        A health check to determine the availability of this component.
        """
        return pulumi.get(self, "health_check")

    @health_check.setter
    def health_check(self, value: Optional[pulumi.Input['AppSpecServiceHealthCheckArgs']]):
        pulumi.set(self, "health_check", value)

    @property
    @pulumi.getter(name="httpPort")
    def http_port(self) -> Optional[pulumi.Input[int]]:
        """
        The internal port on which this service's run command will listen.
        """
        return pulumi.get(self, "http_port")

    @http_port.setter
    def http_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "http_port", value)

    @property
    @pulumi.getter
    def image(self) -> Optional[pulumi.Input['AppSpecServiceImageArgs']]:
        """
        An image to use as the component's source. Only one of `git`, `github`, `gitlab`, or `image` may be set.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input['AppSpecServiceImageArgs']]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[pulumi.Input[int]]:
        """
        The amount of instances that this component should be scaled to.
        """
        return pulumi.get(self, "instance_count")

    @instance_count.setter
    def instance_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "instance_count", value)

    @property
    @pulumi.getter(name="instanceSizeSlug")
    def instance_size_slug(self) -> Optional[pulumi.Input[str]]:
        """
        The instance size to use for this component. This determines the plan (basic or professional) and the available CPU and memory. The list of available instance sizes can be [found with the API](https://docs.digitalocean.com/reference/api/api-reference/#operation/list_instance_sizes) or using the [doctl CLI](https://docs.digitalocean.com/reference/doctl/) (`doctl apps tier instance-size list`). Default: `basic-xxs`
        """
        return pulumi.get(self, "instance_size_slug")

    @instance_size_slug.setter
    def instance_size_slug(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_size_slug", value)

    @property
    @pulumi.getter(name="internalPorts")
    def internal_ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        A list of ports on which this service will listen for internal traffic.
        """
        return pulumi.get(self, "internal_ports")

    @internal_ports.setter
    def internal_ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "internal_ports", value)

    @property
    @pulumi.getter
    def routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppSpecServiceRouteArgs']]]]:
        return pulumi.get(self, "routes")

    @routes.setter
    def routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppSpecServiceRouteArgs']]]]):
        pulumi.set(self, "routes", value)

    @property
    @pulumi.getter(name="runCommand")
    def run_command(self) -> Optional[pulumi.Input[str]]:
        """
        An optional run command to override the component's default.
        """
        return pulumi.get(self, "run_command")

    @run_command.setter
    def run_command(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "run_command", value)

    @property
    @pulumi.getter(name="sourceDir")
    def source_dir(self) -> Optional[pulumi.Input[str]]:
        """
        An optional path to the working directory to use for the build.
        """
        return pulumi.get(self, "source_dir")

    @source_dir.setter
    def source_dir(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_dir", value)


@pulumi.input_type
class AppSpecServiceCorsArgs:
    def __init__(__self__, *,
                 allow_credentials: Optional[pulumi.Input[bool]] = None,
                 allow_headers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allow_methods: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allow_origins: Optional[pulumi.Input['AppSpecServiceCorsAllowOriginsArgs']] = None,
                 expose_headers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 max_age: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] allow_credentials: Whether browsers should expose the response to the client-side JavaScript code when the request's credentials mode is `include`. This configures the `Access-Control-Allow-Credentials` header.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allow_headers: The set of allowed HTTP request headers. This configures the `Access-Control-Allow-Headers` header.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allow_methods: The set of allowed HTTP methods. This configures the `Access-Control-Allow-Methods` header.
        :param pulumi.Input['AppSpecServiceCorsAllowOriginsArgs'] allow_origins: The `Access-Control-Allow-Origin` can be
        :param pulumi.Input[Sequence[pulumi.Input[str]]] expose_headers: The set of HTTP response headers that browsers are allowed to access. This configures the `Access-Control-Expose-Headers` header.
        :param pulumi.Input[str] max_age: An optional duration specifying how long browsers can cache the results of a preflight request. This configures the Access-Control-Max-Age header. Example: `5h30m`.
        """
        if allow_credentials is not None:
            pulumi.set(__self__, "allow_credentials", allow_credentials)
        if allow_headers is not None:
            pulumi.set(__self__, "allow_headers", allow_headers)
        if allow_methods is not None:
            pulumi.set(__self__, "allow_methods", allow_methods)
        if allow_origins is not None:
            pulumi.set(__self__, "allow_origins", allow_origins)
        if expose_headers is not None:
            pulumi.set(__self__, "expose_headers", expose_headers)
        if max_age is not None:
            pulumi.set(__self__, "max_age", max_age)

    @property
    @pulumi.getter(name="allowCredentials")
    def allow_credentials(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether browsers should expose the response to the client-side JavaScript code when the request's credentials mode is `include`. This configures the `Access-Control-Allow-Credentials` header.
        """
        return pulumi.get(self, "allow_credentials")

    @allow_credentials.setter
    def allow_credentials(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_credentials", value)

    @property
    @pulumi.getter(name="allowHeaders")
    def allow_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The set of allowed HTTP request headers. This configures the `Access-Control-Allow-Headers` header.
        """
        return pulumi.get(self, "allow_headers")

    @allow_headers.setter
    def allow_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allow_headers", value)

    @property
    @pulumi.getter(name="allowMethods")
    def allow_methods(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The set of allowed HTTP methods. This configures the `Access-Control-Allow-Methods` header.
        """
        return pulumi.get(self, "allow_methods")

    @allow_methods.setter
    def allow_methods(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allow_methods", value)

    @property
    @pulumi.getter(name="allowOrigins")
    def allow_origins(self) -> Optional[pulumi.Input['AppSpecServiceCorsAllowOriginsArgs']]:
        """
        The `Access-Control-Allow-Origin` can be
        """
        return pulumi.get(self, "allow_origins")

    @allow_origins.setter
    def allow_origins(self, value: Optional[pulumi.Input['AppSpecServiceCorsAllowOriginsArgs']]):
        pulumi.set(self, "allow_origins", value)

    @property
    @pulumi.getter(name="exposeHeaders")
    def expose_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The set of HTTP response headers that browsers are allowed to access. This configures the `Access-Control-Expose-Headers` header.
        """
        return pulumi.get(self, "expose_headers")

    @expose_headers.setter
    def expose_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "expose_headers", value)

    @property
    @pulumi.getter(name="maxAge")
    def max_age(self) -> Optional[pulumi.Input[str]]:
        """
        An optional duration specifying how long browsers can cache the results of a preflight request. This configures the Access-Control-Max-Age header. Example: `5h30m`.
        """
        return pulumi.get(self, "max_age")

    @max_age.setter
    def max_age(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_age", value)


@pulumi.input_type
class AppSpecServiceCorsAllowOriginsArgs:
    def __init__(__self__, *,
                 exact: Optional[pulumi.Input[str]] = None,
                 prefix: Optional[pulumi.Input[str]] = None,
                 regex: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] exact: The `Access-Control-Allow-Origin` header will be set to the client's origin only if the client's origin exactly matches the value you provide.
        :param pulumi.Input[str] prefix: The `Access-Control-Allow-Origin` header will be set to the client's origin if the beginning of the client's origin matches the value you provide.
        :param pulumi.Input[str] regex: The `Access-Control-Allow-Origin` header will be set to the client's origin if the client’s origin matches the regex you provide, in [RE2 style syntax](https://github.com/google/re2/wiki/Syntax).
        """
        if exact is not None:
            pulumi.set(__self__, "exact", exact)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def exact(self) -> Optional[pulumi.Input[str]]:
        """
        The `Access-Control-Allow-Origin` header will be set to the client's origin only if the client's origin exactly matches the value you provide.
        """
        return pulumi.get(self, "exact")

    @exact.setter
    def exact(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "exact", value)

    @property
    @pulumi.getter
    def prefix(self) -> Optional[pulumi.Input[str]]:
        """
        The `Access-Control-Allow-Origin` header will be set to the client's origin if the beginning of the client's origin matches the value you provide.
        """
        return pulumi.get(self, "prefix")

    @prefix.setter
    def prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "prefix", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[pulumi.Input[str]]:
        """
        The `Access-Control-Allow-Origin` header will be set to the client's origin if the client’s origin matches the regex you provide, in [RE2 style syntax](https://github.com/google/re2/wiki/Syntax).
        """
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class AppSpecServiceEnvArgs:
    def __init__(__self__, *,
                 key: Optional[pulumi.Input[str]] = None,
                 scope: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] key: The name of the environment variable.
        :param pulumi.Input[str] scope: The visibility scope of the environment variable. One of `RUN_TIME`, `BUILD_TIME`, or `RUN_AND_BUILD_TIME` (default).
        :param pulumi.Input[str] type: The type of the environment variable, `GENERAL` or `SECRET`.
        :param pulumi.Input[str] value: The value of the environment variable.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the environment variable.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[str]]:
        """
        The visibility scope of the environment variable. One of `RUN_TIME`, `BUILD_TIME`, or `RUN_AND_BUILD_TIME` (default).
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the environment variable, `GENERAL` or `SECRET`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        The value of the environment variable.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class AppSpecServiceGitArgs:
    def __init__(__self__, *,
                 branch: Optional[pulumi.Input[str]] = None,
                 repo_clone_url: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] branch: The name of the branch to use.
        :param pulumi.Input[str] repo_clone_url: The clone URL of the repo.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if repo_clone_url is not None:
            pulumi.set(__self__, "repo_clone_url", repo_clone_url)

    @property
    @pulumi.getter
    def branch(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the branch to use.
        """
        return pulumi.get(self, "branch")

    @branch.setter
    def branch(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "branch", value)

    @property
    @pulumi.getter(name="repoCloneUrl")
    def repo_clone_url(self) -> Optional[pulumi.Input[str]]:
        """
        The clone URL of the repo.
        """
        return pulumi.get(self, "repo_clone_url")

    @repo_clone_url.setter
    def repo_clone_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "repo_clone_url", value)


@pulumi.input_type
class AppSpecServiceGithubArgs:
    def __init__(__self__, *,
                 branch: Optional[pulumi.Input[str]] = None,
                 deploy_on_push: Optional[pulumi.Input[bool]] = None,
                 repo: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] branch: The name of the branch to use.
        :param pulumi.Input[bool] deploy_on_push: Whether to automatically deploy new commits made to the repo.
        :param pulumi.Input[str] repo: The name of the repo in the format `owner/repo`.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if deploy_on_push is not None:
            pulumi.set(__self__, "deploy_on_push", deploy_on_push)
        if repo is not None:
            pulumi.set(__self__, "repo", repo)

    @property
    @pulumi.getter
    def branch(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the branch to use.
        """
        return pulumi.get(self, "branch")

    @branch.setter
    def branch(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "branch", value)

    @property
    @pulumi.getter(name="deployOnPush")
    def deploy_on_push(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to automatically deploy new commits made to the repo.
        """
        return pulumi.get(self, "deploy_on_push")

    @deploy_on_push.setter
    def deploy_on_push(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "deploy_on_push", value)

    @property
    @pulumi.getter
    def repo(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the repo in the format `owner/repo`.
        """
        return pulumi.get(self, "repo")

    @repo.setter
    def repo(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "repo", value)


@pulumi.input_type
class AppSpecServiceGitlabArgs:
    def __init__(__self__, *,
                 branch: Optional[pulumi.Input[str]] = None,
                 deploy_on_push: Optional[pulumi.Input[bool]] = None,
                 repo: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] branch: The name of the branch to use.
        :param pulumi.Input[bool] deploy_on_push: Whether to automatically deploy new commits made to the repo.
        :param pulumi.Input[str] repo: The name of the repo in the format `owner/repo`.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if deploy_on_push is not None:
            pulumi.set(__self__, "deploy_on_push", deploy_on_push)
        if repo is not None:
            pulumi.set(__self__, "repo", repo)

    @property
    @pulumi.getter
    def branch(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the branch to use.
        """
        return pulumi.get(self, "branch")

    @branch.setter
    def branch(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "branch", value)

    @property
    @pulumi.getter(name="deployOnPush")
    def deploy_on_push(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to automatically deploy new commits made to the repo.
        """
        return pulumi.get(self, "deploy_on_push")

    @deploy_on_push.setter
    def deploy_on_push(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "deploy_on_push", value)

    @property
    @pulumi.getter
    def repo(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the repo in the format `owner/repo`.
        """
        return pulumi.get(self, "repo")

    @repo.setter
    def repo(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "repo", value)


@pulumi.input_type
class AppSpecServiceHealthCheckArgs:
    def __init__(__self__, *,
                 failure_threshold: Optional[pulumi.Input[int]] = None,
                 http_path: Optional[pulumi.Input[str]] = None,
                 initial_delay_seconds: Optional[pulumi.Input[int]] = None,
                 period_seconds: Optional[pulumi.Input[int]] = None,
                 success_threshold: Optional[pulumi.Input[int]] = None,
                 timeout_seconds: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] failure_threshold: The number of failed health checks before considered unhealthy.
        :param pulumi.Input[str] http_path: The route path used for the HTTP health check ping.
        :param pulumi.Input[int] initial_delay_seconds: The number of seconds to wait before beginning health checks.
        :param pulumi.Input[int] period_seconds: The number of seconds to wait between health checks.
        :param pulumi.Input[int] success_threshold: The number of successful health checks before considered healthy.
        :param pulumi.Input[int] timeout_seconds: The number of seconds after which the check times out.
        """
        if failure_threshold is not None:
            pulumi.set(__self__, "failure_threshold", failure_threshold)
        if http_path is not None:
            pulumi.set(__self__, "http_path", http_path)
        if initial_delay_seconds is not None:
            pulumi.set(__self__, "initial_delay_seconds", initial_delay_seconds)
        if period_seconds is not None:
            pulumi.set(__self__, "period_seconds", period_seconds)
        if success_threshold is not None:
            pulumi.set(__self__, "success_threshold", success_threshold)
        if timeout_seconds is not None:
            pulumi.set(__self__, "timeout_seconds", timeout_seconds)

    @property
    @pulumi.getter(name="failureThreshold")
    def failure_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        The number of failed health checks before considered unhealthy.
        """
        return pulumi.get(self, "failure_threshold")

    @failure_threshold.setter
    def failure_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "failure_threshold", value)

    @property
    @pulumi.getter(name="httpPath")
    def http_path(self) -> Optional[pulumi.Input[str]]:
        """
        The route path used for the HTTP health check ping.
        """
        return pulumi.get(self, "http_path")

    @http_path.setter
    def http_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "http_path", value)

    @property
    @pulumi.getter(name="initialDelaySeconds")
    def initial_delay_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        The number of seconds to wait before beginning health checks.
        """
        return pulumi.get(self, "initial_delay_seconds")

    @initial_delay_seconds.setter
    def initial_delay_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "initial_delay_seconds", value)

    @property
    @pulumi.getter(name="periodSeconds")
    def period_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        The number of seconds to wait between health checks.
        """
        return pulumi.get(self, "period_seconds")

    @period_seconds.setter
    def period_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period_seconds", value)

    @property
    @pulumi.getter(name="successThreshold")
    def success_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        The number of successful health checks before considered healthy.
        """
        return pulumi.get(self, "success_threshold")

    @success_threshold.setter
    def success_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "success_threshold", value)

    @property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        The number of seconds after which the check times out.
        """
        return pulumi.get(self, "timeout_seconds")

    @timeout_seconds.setter
    def timeout_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout_seconds", value)


@pulumi.input_type
class AppSpecServiceImageArgs:
    def __init__(__self__, *,
                 registry_type: pulumi.Input[str],
                 repository: pulumi.Input[str],
                 registry: Optional[pulumi.Input[str]] = None,
                 tag: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] registry_type: The registry type. One of `DOCR` (DigitalOcean container registry) or `DOCKER_HUB`.
        :param pulumi.Input[str] repository: The repository name.
        :param pulumi.Input[str] registry: The registry name. Must be left empty for the `DOCR` registry type. Required for the `DOCKER_HUB` registry type.
        :param pulumi.Input[str] tag: The repository tag. Defaults to `latest` if not provided.
        """
        pulumi.set(__self__, "registry_type", registry_type)
        pulumi.set(__self__, "repository", repository)
        if registry is not None:
            pulumi.set(__self__, "registry", registry)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)

    @property
    @pulumi.getter(name="registryType")
    def registry_type(self) -> pulumi.Input[str]:
        """
        The registry type. One of `DOCR` (DigitalOcean container registry) or `DOCKER_HUB`.
        """
        return pulumi.get(self, "registry_type")

    @registry_type.setter
    def registry_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "registry_type", value)

    @property
    @pulumi.getter
    def repository(self) -> pulumi.Input[str]:
        """
        The repository name.
        """
        return pulumi.get(self, "repository")

    @repository.setter
    def repository(self, value: pulumi.Input[str]):
        pulumi.set(self, "repository", value)

    @property
    @pulumi.getter
    def registry(self) -> Optional[pulumi.Input[str]]:
        """
        The registry name. Must be left empty for the `DOCR` registry type. Required for the `DOCKER_HUB` registry type.
        """
        return pulumi.get(self, "registry")

    @registry.setter
    def registry(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "registry", value)

    @property
    @pulumi.getter
    def tag(self) -> Optional[pulumi.Input[str]]:
        """
        The repository tag. Defaults to `latest` if not provided.
        """
        return pulumi.get(self, "tag")

    @tag.setter
    def tag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tag", value)


@pulumi.input_type
class AppSpecServiceRouteArgs:
    def __init__(__self__, *,
                 path: Optional[pulumi.Input[str]] = None,
                 preserve_path_prefix: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] path: Paths must start with `/` and must be unique within the app.
        :param pulumi.Input[bool] preserve_path_prefix: An optional flag to preserve the path that is forwarded to the backend service.
        """
        if path is not None:
            pulumi.set(__self__, "path", path)
        if preserve_path_prefix is not None:
            pulumi.set(__self__, "preserve_path_prefix", preserve_path_prefix)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        Paths must start with `/` and must be unique within the app.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="preservePathPrefix")
    def preserve_path_prefix(self) -> Optional[pulumi.Input[bool]]:
        """
        An optional flag to preserve the path that is forwarded to the backend service.
        """
        return pulumi.get(self, "preserve_path_prefix")

    @preserve_path_prefix.setter
    def preserve_path_prefix(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "preserve_path_prefix", value)


@pulumi.input_type
class AppSpecStaticSiteArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 build_command: Optional[pulumi.Input[str]] = None,
                 catchall_document: Optional[pulumi.Input[str]] = None,
                 cors: Optional[pulumi.Input['AppSpecStaticSiteCorsArgs']] = None,
                 dockerfile_path: Optional[pulumi.Input[str]] = None,
                 environment_slug: Optional[pulumi.Input[str]] = None,
                 envs: Optional[pulumi.Input[Sequence[pulumi.Input['AppSpecStaticSiteEnvArgs']]]] = None,
                 error_document: Optional[pulumi.Input[str]] = None,
                 git: Optional[pulumi.Input['AppSpecStaticSiteGitArgs']] = None,
                 github: Optional[pulumi.Input['AppSpecStaticSiteGithubArgs']] = None,
                 gitlab: Optional[pulumi.Input['AppSpecStaticSiteGitlabArgs']] = None,
                 index_document: Optional[pulumi.Input[str]] = None,
                 output_dir: Optional[pulumi.Input[str]] = None,
                 routes: Optional[pulumi.Input[Sequence[pulumi.Input['AppSpecStaticSiteRouteArgs']]]] = None,
                 source_dir: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: The name of the component.
        :param pulumi.Input[str] build_command: An optional build command to run while building this component from source.
        :param pulumi.Input[str] catchall_document: The name of the document to use as the fallback for any requests to documents that are not found when serving this static site.
        :param pulumi.Input['AppSpecStaticSiteCorsArgs'] cors: The [CORS](https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS) policies of the app.
        :param pulumi.Input[str] dockerfile_path: The path to a Dockerfile relative to the root of the repo. If set, overrides usage of buildpacks.
        :param pulumi.Input[str] environment_slug: An environment slug describing the type of this app.
        :param pulumi.Input[Sequence[pulumi.Input['AppSpecStaticSiteEnvArgs']]] envs: Describes an environment variable made available to an app competent.
        :param pulumi.Input[str] error_document: The name of the error document to use when serving this static site.
        :param pulumi.Input['AppSpecStaticSiteGitArgs'] git: A Git repo to use as the component's source. The repository must be able to be cloned without authentication.  Only one of `git`, `github` or `gitlab`  may be set
        :param pulumi.Input['AppSpecStaticSiteGithubArgs'] github: A GitHub repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/github/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        :param pulumi.Input['AppSpecStaticSiteGitlabArgs'] gitlab: A Gitlab repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/gitlab/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        :param pulumi.Input[str] index_document: The name of the index document to use when serving this static site.
        :param pulumi.Input[str] output_dir: An optional path to where the built assets will be located, relative to the build context. If not set, App Platform will automatically scan for these directory names: `_static`, `dist`, `public`.
        :param pulumi.Input[str] source_dir: An optional path to the working directory to use for the build.
        """
        pulumi.set(__self__, "name", name)
        if build_command is not None:
            pulumi.set(__self__, "build_command", build_command)
        if catchall_document is not None:
            pulumi.set(__self__, "catchall_document", catchall_document)
        if cors is not None:
            pulumi.set(__self__, "cors", cors)
        if dockerfile_path is not None:
            pulumi.set(__self__, "dockerfile_path", dockerfile_path)
        if environment_slug is not None:
            pulumi.set(__self__, "environment_slug", environment_slug)
        if envs is not None:
            pulumi.set(__self__, "envs", envs)
        if error_document is not None:
            pulumi.set(__self__, "error_document", error_document)
        if git is not None:
            pulumi.set(__self__, "git", git)
        if github is not None:
            pulumi.set(__self__, "github", github)
        if gitlab is not None:
            pulumi.set(__self__, "gitlab", gitlab)
        if index_document is not None:
            pulumi.set(__self__, "index_document", index_document)
        if output_dir is not None:
            pulumi.set(__self__, "output_dir", output_dir)
        if routes is not None:
            pulumi.set(__self__, "routes", routes)
        if source_dir is not None:
            pulumi.set(__self__, "source_dir", source_dir)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the component.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="buildCommand")
    def build_command(self) -> Optional[pulumi.Input[str]]:
        """
        An optional build command to run while building this component from source.
        """
        return pulumi.get(self, "build_command")

    @build_command.setter
    def build_command(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "build_command", value)

    @property
    @pulumi.getter(name="catchallDocument")
    def catchall_document(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the document to use as the fallback for any requests to documents that are not found when serving this static site.
        """
        return pulumi.get(self, "catchall_document")

    @catchall_document.setter
    def catchall_document(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "catchall_document", value)

    @property
    @pulumi.getter
    def cors(self) -> Optional[pulumi.Input['AppSpecStaticSiteCorsArgs']]:
        """
        The [CORS](https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS) policies of the app.
        """
        return pulumi.get(self, "cors")

    @cors.setter
    def cors(self, value: Optional[pulumi.Input['AppSpecStaticSiteCorsArgs']]):
        pulumi.set(self, "cors", value)

    @property
    @pulumi.getter(name="dockerfilePath")
    def dockerfile_path(self) -> Optional[pulumi.Input[str]]:
        """
        The path to a Dockerfile relative to the root of the repo. If set, overrides usage of buildpacks.
        """
        return pulumi.get(self, "dockerfile_path")

    @dockerfile_path.setter
    def dockerfile_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dockerfile_path", value)

    @property
    @pulumi.getter(name="environmentSlug")
    def environment_slug(self) -> Optional[pulumi.Input[str]]:
        """
        An environment slug describing the type of this app.
        """
        return pulumi.get(self, "environment_slug")

    @environment_slug.setter
    def environment_slug(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "environment_slug", value)

    @property
    @pulumi.getter
    def envs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppSpecStaticSiteEnvArgs']]]]:
        """
        Describes an environment variable made available to an app competent.
        """
        return pulumi.get(self, "envs")

    @envs.setter
    def envs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppSpecStaticSiteEnvArgs']]]]):
        pulumi.set(self, "envs", value)

    @property
    @pulumi.getter(name="errorDocument")
    def error_document(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the error document to use when serving this static site.
        """
        return pulumi.get(self, "error_document")

    @error_document.setter
    def error_document(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "error_document", value)

    @property
    @pulumi.getter
    def git(self) -> Optional[pulumi.Input['AppSpecStaticSiteGitArgs']]:
        """
        A Git repo to use as the component's source. The repository must be able to be cloned without authentication.  Only one of `git`, `github` or `gitlab`  may be set
        """
        return pulumi.get(self, "git")

    @git.setter
    def git(self, value: Optional[pulumi.Input['AppSpecStaticSiteGitArgs']]):
        pulumi.set(self, "git", value)

    @property
    @pulumi.getter
    def github(self) -> Optional[pulumi.Input['AppSpecStaticSiteGithubArgs']]:
        """
        A GitHub repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/github/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        """
        return pulumi.get(self, "github")

    @github.setter
    def github(self, value: Optional[pulumi.Input['AppSpecStaticSiteGithubArgs']]):
        pulumi.set(self, "github", value)

    @property
    @pulumi.getter
    def gitlab(self) -> Optional[pulumi.Input['AppSpecStaticSiteGitlabArgs']]:
        """
        A Gitlab repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/gitlab/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        """
        return pulumi.get(self, "gitlab")

    @gitlab.setter
    def gitlab(self, value: Optional[pulumi.Input['AppSpecStaticSiteGitlabArgs']]):
        pulumi.set(self, "gitlab", value)

    @property
    @pulumi.getter(name="indexDocument")
    def index_document(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the index document to use when serving this static site.
        """
        return pulumi.get(self, "index_document")

    @index_document.setter
    def index_document(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "index_document", value)

    @property
    @pulumi.getter(name="outputDir")
    def output_dir(self) -> Optional[pulumi.Input[str]]:
        """
        An optional path to where the built assets will be located, relative to the build context. If not set, App Platform will automatically scan for these directory names: `_static`, `dist`, `public`.
        """
        return pulumi.get(self, "output_dir")

    @output_dir.setter
    def output_dir(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "output_dir", value)

    @property
    @pulumi.getter
    def routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppSpecStaticSiteRouteArgs']]]]:
        return pulumi.get(self, "routes")

    @routes.setter
    def routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppSpecStaticSiteRouteArgs']]]]):
        pulumi.set(self, "routes", value)

    @property
    @pulumi.getter(name="sourceDir")
    def source_dir(self) -> Optional[pulumi.Input[str]]:
        """
        An optional path to the working directory to use for the build.
        """
        return pulumi.get(self, "source_dir")

    @source_dir.setter
    def source_dir(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_dir", value)


@pulumi.input_type
class AppSpecStaticSiteCorsArgs:
    def __init__(__self__, *,
                 allow_credentials: Optional[pulumi.Input[bool]] = None,
                 allow_headers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allow_methods: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allow_origins: Optional[pulumi.Input['AppSpecStaticSiteCorsAllowOriginsArgs']] = None,
                 expose_headers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 max_age: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] allow_credentials: Whether browsers should expose the response to the client-side JavaScript code when the request's credentials mode is `include`. This configures the `Access-Control-Allow-Credentials` header.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allow_headers: The set of allowed HTTP request headers. This configures the `Access-Control-Allow-Headers` header.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allow_methods: The set of allowed HTTP methods. This configures the `Access-Control-Allow-Methods` header.
        :param pulumi.Input['AppSpecStaticSiteCorsAllowOriginsArgs'] allow_origins: The `Access-Control-Allow-Origin` can be
        :param pulumi.Input[Sequence[pulumi.Input[str]]] expose_headers: The set of HTTP response headers that browsers are allowed to access. This configures the `Access-Control-Expose-Headers` header.
        :param pulumi.Input[str] max_age: An optional duration specifying how long browsers can cache the results of a preflight request. This configures the Access-Control-Max-Age header. Example: `5h30m`.
        """
        if allow_credentials is not None:
            pulumi.set(__self__, "allow_credentials", allow_credentials)
        if allow_headers is not None:
            pulumi.set(__self__, "allow_headers", allow_headers)
        if allow_methods is not None:
            pulumi.set(__self__, "allow_methods", allow_methods)
        if allow_origins is not None:
            pulumi.set(__self__, "allow_origins", allow_origins)
        if expose_headers is not None:
            pulumi.set(__self__, "expose_headers", expose_headers)
        if max_age is not None:
            pulumi.set(__self__, "max_age", max_age)

    @property
    @pulumi.getter(name="allowCredentials")
    def allow_credentials(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether browsers should expose the response to the client-side JavaScript code when the request's credentials mode is `include`. This configures the `Access-Control-Allow-Credentials` header.
        """
        return pulumi.get(self, "allow_credentials")

    @allow_credentials.setter
    def allow_credentials(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_credentials", value)

    @property
    @pulumi.getter(name="allowHeaders")
    def allow_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The set of allowed HTTP request headers. This configures the `Access-Control-Allow-Headers` header.
        """
        return pulumi.get(self, "allow_headers")

    @allow_headers.setter
    def allow_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allow_headers", value)

    @property
    @pulumi.getter(name="allowMethods")
    def allow_methods(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The set of allowed HTTP methods. This configures the `Access-Control-Allow-Methods` header.
        """
        return pulumi.get(self, "allow_methods")

    @allow_methods.setter
    def allow_methods(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allow_methods", value)

    @property
    @pulumi.getter(name="allowOrigins")
    def allow_origins(self) -> Optional[pulumi.Input['AppSpecStaticSiteCorsAllowOriginsArgs']]:
        """
        The `Access-Control-Allow-Origin` can be
        """
        return pulumi.get(self, "allow_origins")

    @allow_origins.setter
    def allow_origins(self, value: Optional[pulumi.Input['AppSpecStaticSiteCorsAllowOriginsArgs']]):
        pulumi.set(self, "allow_origins", value)

    @property
    @pulumi.getter(name="exposeHeaders")
    def expose_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The set of HTTP response headers that browsers are allowed to access. This configures the `Access-Control-Expose-Headers` header.
        """
        return pulumi.get(self, "expose_headers")

    @expose_headers.setter
    def expose_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "expose_headers", value)

    @property
    @pulumi.getter(name="maxAge")
    def max_age(self) -> Optional[pulumi.Input[str]]:
        """
        An optional duration specifying how long browsers can cache the results of a preflight request. This configures the Access-Control-Max-Age header. Example: `5h30m`.
        """
        return pulumi.get(self, "max_age")

    @max_age.setter
    def max_age(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_age", value)


@pulumi.input_type
class AppSpecStaticSiteCorsAllowOriginsArgs:
    def __init__(__self__, *,
                 exact: Optional[pulumi.Input[str]] = None,
                 prefix: Optional[pulumi.Input[str]] = None,
                 regex: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] exact: The `Access-Control-Allow-Origin` header will be set to the client's origin only if the client's origin exactly matches the value you provide.
        :param pulumi.Input[str] prefix: The `Access-Control-Allow-Origin` header will be set to the client's origin if the beginning of the client's origin matches the value you provide.
        :param pulumi.Input[str] regex: The `Access-Control-Allow-Origin` header will be set to the client's origin if the client’s origin matches the regex you provide, in [RE2 style syntax](https://github.com/google/re2/wiki/Syntax).
        """
        if exact is not None:
            pulumi.set(__self__, "exact", exact)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def exact(self) -> Optional[pulumi.Input[str]]:
        """
        The `Access-Control-Allow-Origin` header will be set to the client's origin only if the client's origin exactly matches the value you provide.
        """
        return pulumi.get(self, "exact")

    @exact.setter
    def exact(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "exact", value)

    @property
    @pulumi.getter
    def prefix(self) -> Optional[pulumi.Input[str]]:
        """
        The `Access-Control-Allow-Origin` header will be set to the client's origin if the beginning of the client's origin matches the value you provide.
        """
        return pulumi.get(self, "prefix")

    @prefix.setter
    def prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "prefix", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[pulumi.Input[str]]:
        """
        The `Access-Control-Allow-Origin` header will be set to the client's origin if the client’s origin matches the regex you provide, in [RE2 style syntax](https://github.com/google/re2/wiki/Syntax).
        """
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class AppSpecStaticSiteEnvArgs:
    def __init__(__self__, *,
                 key: Optional[pulumi.Input[str]] = None,
                 scope: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] key: The name of the environment variable.
        :param pulumi.Input[str] scope: The visibility scope of the environment variable. One of `RUN_TIME`, `BUILD_TIME`, or `RUN_AND_BUILD_TIME` (default).
        :param pulumi.Input[str] type: The type of the environment variable, `GENERAL` or `SECRET`.
        :param pulumi.Input[str] value: The value of the environment variable.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the environment variable.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[str]]:
        """
        The visibility scope of the environment variable. One of `RUN_TIME`, `BUILD_TIME`, or `RUN_AND_BUILD_TIME` (default).
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the environment variable, `GENERAL` or `SECRET`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        The value of the environment variable.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class AppSpecStaticSiteGitArgs:
    def __init__(__self__, *,
                 branch: Optional[pulumi.Input[str]] = None,
                 repo_clone_url: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] branch: The name of the branch to use.
        :param pulumi.Input[str] repo_clone_url: The clone URL of the repo.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if repo_clone_url is not None:
            pulumi.set(__self__, "repo_clone_url", repo_clone_url)

    @property
    @pulumi.getter
    def branch(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the branch to use.
        """
        return pulumi.get(self, "branch")

    @branch.setter
    def branch(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "branch", value)

    @property
    @pulumi.getter(name="repoCloneUrl")
    def repo_clone_url(self) -> Optional[pulumi.Input[str]]:
        """
        The clone URL of the repo.
        """
        return pulumi.get(self, "repo_clone_url")

    @repo_clone_url.setter
    def repo_clone_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "repo_clone_url", value)


@pulumi.input_type
class AppSpecStaticSiteGithubArgs:
    def __init__(__self__, *,
                 branch: Optional[pulumi.Input[str]] = None,
                 deploy_on_push: Optional[pulumi.Input[bool]] = None,
                 repo: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] branch: The name of the branch to use.
        :param pulumi.Input[bool] deploy_on_push: Whether to automatically deploy new commits made to the repo.
        :param pulumi.Input[str] repo: The name of the repo in the format `owner/repo`.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if deploy_on_push is not None:
            pulumi.set(__self__, "deploy_on_push", deploy_on_push)
        if repo is not None:
            pulumi.set(__self__, "repo", repo)

    @property
    @pulumi.getter
    def branch(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the branch to use.
        """
        return pulumi.get(self, "branch")

    @branch.setter
    def branch(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "branch", value)

    @property
    @pulumi.getter(name="deployOnPush")
    def deploy_on_push(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to automatically deploy new commits made to the repo.
        """
        return pulumi.get(self, "deploy_on_push")

    @deploy_on_push.setter
    def deploy_on_push(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "deploy_on_push", value)

    @property
    @pulumi.getter
    def repo(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the repo in the format `owner/repo`.
        """
        return pulumi.get(self, "repo")

    @repo.setter
    def repo(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "repo", value)


@pulumi.input_type
class AppSpecStaticSiteGitlabArgs:
    def __init__(__self__, *,
                 branch: Optional[pulumi.Input[str]] = None,
                 deploy_on_push: Optional[pulumi.Input[bool]] = None,
                 repo: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] branch: The name of the branch to use.
        :param pulumi.Input[bool] deploy_on_push: Whether to automatically deploy new commits made to the repo.
        :param pulumi.Input[str] repo: The name of the repo in the format `owner/repo`.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if deploy_on_push is not None:
            pulumi.set(__self__, "deploy_on_push", deploy_on_push)
        if repo is not None:
            pulumi.set(__self__, "repo", repo)

    @property
    @pulumi.getter
    def branch(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the branch to use.
        """
        return pulumi.get(self, "branch")

    @branch.setter
    def branch(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "branch", value)

    @property
    @pulumi.getter(name="deployOnPush")
    def deploy_on_push(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to automatically deploy new commits made to the repo.
        """
        return pulumi.get(self, "deploy_on_push")

    @deploy_on_push.setter
    def deploy_on_push(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "deploy_on_push", value)

    @property
    @pulumi.getter
    def repo(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the repo in the format `owner/repo`.
        """
        return pulumi.get(self, "repo")

    @repo.setter
    def repo(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "repo", value)


@pulumi.input_type
class AppSpecStaticSiteRouteArgs:
    def __init__(__self__, *,
                 path: Optional[pulumi.Input[str]] = None,
                 preserve_path_prefix: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] path: Paths must start with `/` and must be unique within the app.
        :param pulumi.Input[bool] preserve_path_prefix: An optional flag to preserve the path that is forwarded to the backend service.
        """
        if path is not None:
            pulumi.set(__self__, "path", path)
        if preserve_path_prefix is not None:
            pulumi.set(__self__, "preserve_path_prefix", preserve_path_prefix)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        Paths must start with `/` and must be unique within the app.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="preservePathPrefix")
    def preserve_path_prefix(self) -> Optional[pulumi.Input[bool]]:
        """
        An optional flag to preserve the path that is forwarded to the backend service.
        """
        return pulumi.get(self, "preserve_path_prefix")

    @preserve_path_prefix.setter
    def preserve_path_prefix(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "preserve_path_prefix", value)


@pulumi.input_type
class AppSpecWorkerArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 build_command: Optional[pulumi.Input[str]] = None,
                 dockerfile_path: Optional[pulumi.Input[str]] = None,
                 environment_slug: Optional[pulumi.Input[str]] = None,
                 envs: Optional[pulumi.Input[Sequence[pulumi.Input['AppSpecWorkerEnvArgs']]]] = None,
                 git: Optional[pulumi.Input['AppSpecWorkerGitArgs']] = None,
                 github: Optional[pulumi.Input['AppSpecWorkerGithubArgs']] = None,
                 gitlab: Optional[pulumi.Input['AppSpecWorkerGitlabArgs']] = None,
                 image: Optional[pulumi.Input['AppSpecWorkerImageArgs']] = None,
                 instance_count: Optional[pulumi.Input[int]] = None,
                 instance_size_slug: Optional[pulumi.Input[str]] = None,
                 run_command: Optional[pulumi.Input[str]] = None,
                 source_dir: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: The name of the component.
        :param pulumi.Input[str] build_command: An optional build command to run while building this component from source.
        :param pulumi.Input[str] dockerfile_path: The path to a Dockerfile relative to the root of the repo. If set, overrides usage of buildpacks.
        :param pulumi.Input[str] environment_slug: An environment slug describing the type of this app.
        :param pulumi.Input[Sequence[pulumi.Input['AppSpecWorkerEnvArgs']]] envs: Describes an environment variable made available to an app competent.
        :param pulumi.Input['AppSpecWorkerGitArgs'] git: A Git repo to use as the component's source. The repository must be able to be cloned without authentication.  Only one of `git`, `github` or `gitlab`  may be set
        :param pulumi.Input['AppSpecWorkerGithubArgs'] github: A GitHub repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/github/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        :param pulumi.Input['AppSpecWorkerGitlabArgs'] gitlab: A Gitlab repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/gitlab/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        :param pulumi.Input['AppSpecWorkerImageArgs'] image: An image to use as the component's source. Only one of `git`, `github`, `gitlab`, or `image` may be set.
        :param pulumi.Input[int] instance_count: The amount of instances that this component should be scaled to.
        :param pulumi.Input[str] instance_size_slug: The instance size to use for this component. This determines the plan (basic or professional) and the available CPU and memory. The list of available instance sizes can be [found with the API](https://docs.digitalocean.com/reference/api/api-reference/#operation/list_instance_sizes) or using the [doctl CLI](https://docs.digitalocean.com/reference/doctl/) (`doctl apps tier instance-size list`). Default: `basic-xxs`
        :param pulumi.Input[str] run_command: An optional run command to override the component's default.
        :param pulumi.Input[str] source_dir: An optional path to the working directory to use for the build.
        """
        pulumi.set(__self__, "name", name)
        if build_command is not None:
            pulumi.set(__self__, "build_command", build_command)
        if dockerfile_path is not None:
            pulumi.set(__self__, "dockerfile_path", dockerfile_path)
        if environment_slug is not None:
            pulumi.set(__self__, "environment_slug", environment_slug)
        if envs is not None:
            pulumi.set(__self__, "envs", envs)
        if git is not None:
            pulumi.set(__self__, "git", git)
        if github is not None:
            pulumi.set(__self__, "github", github)
        if gitlab is not None:
            pulumi.set(__self__, "gitlab", gitlab)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if instance_size_slug is not None:
            pulumi.set(__self__, "instance_size_slug", instance_size_slug)
        if run_command is not None:
            pulumi.set(__self__, "run_command", run_command)
        if source_dir is not None:
            pulumi.set(__self__, "source_dir", source_dir)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the component.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="buildCommand")
    def build_command(self) -> Optional[pulumi.Input[str]]:
        """
        An optional build command to run while building this component from source.
        """
        return pulumi.get(self, "build_command")

    @build_command.setter
    def build_command(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "build_command", value)

    @property
    @pulumi.getter(name="dockerfilePath")
    def dockerfile_path(self) -> Optional[pulumi.Input[str]]:
        """
        The path to a Dockerfile relative to the root of the repo. If set, overrides usage of buildpacks.
        """
        return pulumi.get(self, "dockerfile_path")

    @dockerfile_path.setter
    def dockerfile_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dockerfile_path", value)

    @property
    @pulumi.getter(name="environmentSlug")
    def environment_slug(self) -> Optional[pulumi.Input[str]]:
        """
        An environment slug describing the type of this app.
        """
        return pulumi.get(self, "environment_slug")

    @environment_slug.setter
    def environment_slug(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "environment_slug", value)

    @property
    @pulumi.getter
    def envs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppSpecWorkerEnvArgs']]]]:
        """
        Describes an environment variable made available to an app competent.
        """
        return pulumi.get(self, "envs")

    @envs.setter
    def envs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppSpecWorkerEnvArgs']]]]):
        pulumi.set(self, "envs", value)

    @property
    @pulumi.getter
    def git(self) -> Optional[pulumi.Input['AppSpecWorkerGitArgs']]:
        """
        A Git repo to use as the component's source. The repository must be able to be cloned without authentication.  Only one of `git`, `github` or `gitlab`  may be set
        """
        return pulumi.get(self, "git")

    @git.setter
    def git(self, value: Optional[pulumi.Input['AppSpecWorkerGitArgs']]):
        pulumi.set(self, "git", value)

    @property
    @pulumi.getter
    def github(self) -> Optional[pulumi.Input['AppSpecWorkerGithubArgs']]:
        """
        A GitHub repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/github/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        """
        return pulumi.get(self, "github")

    @github.setter
    def github(self, value: Optional[pulumi.Input['AppSpecWorkerGithubArgs']]):
        pulumi.set(self, "github", value)

    @property
    @pulumi.getter
    def gitlab(self) -> Optional[pulumi.Input['AppSpecWorkerGitlabArgs']]:
        """
        A Gitlab repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/gitlab/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        """
        return pulumi.get(self, "gitlab")

    @gitlab.setter
    def gitlab(self, value: Optional[pulumi.Input['AppSpecWorkerGitlabArgs']]):
        pulumi.set(self, "gitlab", value)

    @property
    @pulumi.getter
    def image(self) -> Optional[pulumi.Input['AppSpecWorkerImageArgs']]:
        """
        An image to use as the component's source. Only one of `git`, `github`, `gitlab`, or `image` may be set.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input['AppSpecWorkerImageArgs']]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[pulumi.Input[int]]:
        """
        The amount of instances that this component should be scaled to.
        """
        return pulumi.get(self, "instance_count")

    @instance_count.setter
    def instance_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "instance_count", value)

    @property
    @pulumi.getter(name="instanceSizeSlug")
    def instance_size_slug(self) -> Optional[pulumi.Input[str]]:
        """
        The instance size to use for this component. This determines the plan (basic or professional) and the available CPU and memory. The list of available instance sizes can be [found with the API](https://docs.digitalocean.com/reference/api/api-reference/#operation/list_instance_sizes) or using the [doctl CLI](https://docs.digitalocean.com/reference/doctl/) (`doctl apps tier instance-size list`). Default: `basic-xxs`
        """
        return pulumi.get(self, "instance_size_slug")

    @instance_size_slug.setter
    def instance_size_slug(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_size_slug", value)

    @property
    @pulumi.getter(name="runCommand")
    def run_command(self) -> Optional[pulumi.Input[str]]:
        """
        An optional run command to override the component's default.
        """
        return pulumi.get(self, "run_command")

    @run_command.setter
    def run_command(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "run_command", value)

    @property
    @pulumi.getter(name="sourceDir")
    def source_dir(self) -> Optional[pulumi.Input[str]]:
        """
        An optional path to the working directory to use for the build.
        """
        return pulumi.get(self, "source_dir")

    @source_dir.setter
    def source_dir(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_dir", value)


@pulumi.input_type
class AppSpecWorkerEnvArgs:
    def __init__(__self__, *,
                 key: Optional[pulumi.Input[str]] = None,
                 scope: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] key: The name of the environment variable.
        :param pulumi.Input[str] scope: The visibility scope of the environment variable. One of `RUN_TIME`, `BUILD_TIME`, or `RUN_AND_BUILD_TIME` (default).
        :param pulumi.Input[str] type: The type of the environment variable, `GENERAL` or `SECRET`.
        :param pulumi.Input[str] value: The value of the environment variable.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the environment variable.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[str]]:
        """
        The visibility scope of the environment variable. One of `RUN_TIME`, `BUILD_TIME`, or `RUN_AND_BUILD_TIME` (default).
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the environment variable, `GENERAL` or `SECRET`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        The value of the environment variable.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class AppSpecWorkerGitArgs:
    def __init__(__self__, *,
                 branch: Optional[pulumi.Input[str]] = None,
                 repo_clone_url: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] branch: The name of the branch to use.
        :param pulumi.Input[str] repo_clone_url: The clone URL of the repo.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if repo_clone_url is not None:
            pulumi.set(__self__, "repo_clone_url", repo_clone_url)

    @property
    @pulumi.getter
    def branch(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the branch to use.
        """
        return pulumi.get(self, "branch")

    @branch.setter
    def branch(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "branch", value)

    @property
    @pulumi.getter(name="repoCloneUrl")
    def repo_clone_url(self) -> Optional[pulumi.Input[str]]:
        """
        The clone URL of the repo.
        """
        return pulumi.get(self, "repo_clone_url")

    @repo_clone_url.setter
    def repo_clone_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "repo_clone_url", value)


@pulumi.input_type
class AppSpecWorkerGithubArgs:
    def __init__(__self__, *,
                 branch: Optional[pulumi.Input[str]] = None,
                 deploy_on_push: Optional[pulumi.Input[bool]] = None,
                 repo: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] branch: The name of the branch to use.
        :param pulumi.Input[bool] deploy_on_push: Whether to automatically deploy new commits made to the repo.
        :param pulumi.Input[str] repo: The name of the repo in the format `owner/repo`.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if deploy_on_push is not None:
            pulumi.set(__self__, "deploy_on_push", deploy_on_push)
        if repo is not None:
            pulumi.set(__self__, "repo", repo)

    @property
    @pulumi.getter
    def branch(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the branch to use.
        """
        return pulumi.get(self, "branch")

    @branch.setter
    def branch(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "branch", value)

    @property
    @pulumi.getter(name="deployOnPush")
    def deploy_on_push(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to automatically deploy new commits made to the repo.
        """
        return pulumi.get(self, "deploy_on_push")

    @deploy_on_push.setter
    def deploy_on_push(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "deploy_on_push", value)

    @property
    @pulumi.getter
    def repo(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the repo in the format `owner/repo`.
        """
        return pulumi.get(self, "repo")

    @repo.setter
    def repo(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "repo", value)


@pulumi.input_type
class AppSpecWorkerGitlabArgs:
    def __init__(__self__, *,
                 branch: Optional[pulumi.Input[str]] = None,
                 deploy_on_push: Optional[pulumi.Input[bool]] = None,
                 repo: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] branch: The name of the branch to use.
        :param pulumi.Input[bool] deploy_on_push: Whether to automatically deploy new commits made to the repo.
        :param pulumi.Input[str] repo: The name of the repo in the format `owner/repo`.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if deploy_on_push is not None:
            pulumi.set(__self__, "deploy_on_push", deploy_on_push)
        if repo is not None:
            pulumi.set(__self__, "repo", repo)

    @property
    @pulumi.getter
    def branch(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the branch to use.
        """
        return pulumi.get(self, "branch")

    @branch.setter
    def branch(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "branch", value)

    @property
    @pulumi.getter(name="deployOnPush")
    def deploy_on_push(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to automatically deploy new commits made to the repo.
        """
        return pulumi.get(self, "deploy_on_push")

    @deploy_on_push.setter
    def deploy_on_push(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "deploy_on_push", value)

    @property
    @pulumi.getter
    def repo(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the repo in the format `owner/repo`.
        """
        return pulumi.get(self, "repo")

    @repo.setter
    def repo(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "repo", value)


@pulumi.input_type
class AppSpecWorkerImageArgs:
    def __init__(__self__, *,
                 registry_type: pulumi.Input[str],
                 repository: pulumi.Input[str],
                 registry: Optional[pulumi.Input[str]] = None,
                 tag: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] registry_type: The registry type. One of `DOCR` (DigitalOcean container registry) or `DOCKER_HUB`.
        :param pulumi.Input[str] repository: The repository name.
        :param pulumi.Input[str] registry: The registry name. Must be left empty for the `DOCR` registry type. Required for the `DOCKER_HUB` registry type.
        :param pulumi.Input[str] tag: The repository tag. Defaults to `latest` if not provided.
        """
        pulumi.set(__self__, "registry_type", registry_type)
        pulumi.set(__self__, "repository", repository)
        if registry is not None:
            pulumi.set(__self__, "registry", registry)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)

    @property
    @pulumi.getter(name="registryType")
    def registry_type(self) -> pulumi.Input[str]:
        """
        The registry type. One of `DOCR` (DigitalOcean container registry) or `DOCKER_HUB`.
        """
        return pulumi.get(self, "registry_type")

    @registry_type.setter
    def registry_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "registry_type", value)

    @property
    @pulumi.getter
    def repository(self) -> pulumi.Input[str]:
        """
        The repository name.
        """
        return pulumi.get(self, "repository")

    @repository.setter
    def repository(self, value: pulumi.Input[str]):
        pulumi.set(self, "repository", value)

    @property
    @pulumi.getter
    def registry(self) -> Optional[pulumi.Input[str]]:
        """
        The registry name. Must be left empty for the `DOCR` registry type. Required for the `DOCKER_HUB` registry type.
        """
        return pulumi.get(self, "registry")

    @registry.setter
    def registry(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "registry", value)

    @property
    @pulumi.getter
    def tag(self) -> Optional[pulumi.Input[str]]:
        """
        The repository tag. Defaults to `latest` if not provided.
        """
        return pulumi.get(self, "tag")

    @tag.setter
    def tag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tag", value)


@pulumi.input_type
class DatabaseClusterMaintenanceWindowArgs:
    def __init__(__self__, *,
                 day: pulumi.Input[str],
                 hour: pulumi.Input[str]):
        """
        :param pulumi.Input[str] day: The day of the week on which to apply maintenance updates.
        :param pulumi.Input[str] hour: The hour in UTC at which maintenance updates will be applied in 24 hour format.
        """
        pulumi.set(__self__, "day", day)
        pulumi.set(__self__, "hour", hour)

    @property
    @pulumi.getter
    def day(self) -> pulumi.Input[str]:
        """
        The day of the week on which to apply maintenance updates.
        """
        return pulumi.get(self, "day")

    @day.setter
    def day(self, value: pulumi.Input[str]):
        pulumi.set(self, "day", value)

    @property
    @pulumi.getter
    def hour(self) -> pulumi.Input[str]:
        """
        The hour in UTC at which maintenance updates will be applied in 24 hour format.
        """
        return pulumi.get(self, "hour")

    @hour.setter
    def hour(self, value: pulumi.Input[str]):
        pulumi.set(self, "hour", value)


@pulumi.input_type
class DatabaseFirewallRuleArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 value: pulumi.Input[str],
                 created_at: Optional[pulumi.Input[str]] = None,
                 uuid: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] type: The type of resource that the firewall rule allows to access the database cluster. The possible values are: `droplet`, `k8s`, `ip_addr`, `tag`, or `app`.
        :param pulumi.Input[str] value: The ID of the specific resource, the name of a tag applied to a group of resources, or the IP address that the firewall rule allows to access the database cluster.
        :param pulumi.Input[str] created_at: The date and time when the firewall rule was created.
        :param pulumi.Input[str] uuid: A unique identifier for the firewall rule.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if uuid is not None:
            pulumi.set(__self__, "uuid", uuid)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of resource that the firewall rule allows to access the database cluster. The possible values are: `droplet`, `k8s`, `ip_addr`, `tag`, or `app`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The ID of the specific resource, the name of a tag applied to a group of resources, or the IP address that the firewall rule allows to access the database cluster.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time when the firewall rule was created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter
    def uuid(self) -> Optional[pulumi.Input[str]]:
        """
        A unique identifier for the firewall rule.
        """
        return pulumi.get(self, "uuid")

    @uuid.setter
    def uuid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uuid", value)


@pulumi.input_type
class FirewallInboundRuleArgs:
    def __init__(__self__, *,
                 protocol: pulumi.Input[str],
                 port_range: Optional[pulumi.Input[str]] = None,
                 source_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 source_droplet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 source_kubernetes_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 source_load_balancer_uids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 source_tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] protocol: The type of traffic to be allowed.
               This may be one of "tcp", "udp", or "icmp".
        :param pulumi.Input[str] port_range: The ports on which traffic will be allowed
               specified as a string containing a single port, a range (e.g. "8000-9000"),
               or "1-65535" to open all ports for a protocol. Required for when protocol is
               `tcp` or `udp`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] source_addresses: An array of strings containing the IPv4
               addresses, IPv6 addresses, IPv4 CIDRs, and/or IPv6 CIDRs from which the
               inbound traffic will be accepted.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] source_droplet_ids: An array containing the IDs of
               the Droplets from which the inbound traffic will be accepted.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] source_kubernetes_ids: An array containing the IDs of
               the Kubernetes clusters from which the inbound traffic will be accepted.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] source_load_balancer_uids: An array containing the IDs
               of the Load Balancers from which the inbound traffic will be accepted.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] source_tags: An array containing the names of Tags
               corresponding to groups of Droplets from which the inbound traffic
               will be accepted.
        """
        pulumi.set(__self__, "protocol", protocol)
        if port_range is not None:
            pulumi.set(__self__, "port_range", port_range)
        if source_addresses is not None:
            pulumi.set(__self__, "source_addresses", source_addresses)
        if source_droplet_ids is not None:
            pulumi.set(__self__, "source_droplet_ids", source_droplet_ids)
        if source_kubernetes_ids is not None:
            pulumi.set(__self__, "source_kubernetes_ids", source_kubernetes_ids)
        if source_load_balancer_uids is not None:
            pulumi.set(__self__, "source_load_balancer_uids", source_load_balancer_uids)
        if source_tags is not None:
            pulumi.set(__self__, "source_tags", source_tags)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[str]:
        """
        The type of traffic to be allowed.
        This may be one of "tcp", "udp", or "icmp".
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[str]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="portRange")
    def port_range(self) -> Optional[pulumi.Input[str]]:
        """
        The ports on which traffic will be allowed
        specified as a string containing a single port, a range (e.g. "8000-9000"),
        or "1-65535" to open all ports for a protocol. Required for when protocol is
        `tcp` or `udp`.
        """
        return pulumi.get(self, "port_range")

    @port_range.setter
    def port_range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "port_range", value)

    @property
    @pulumi.getter(name="sourceAddresses")
    def source_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An array of strings containing the IPv4
        addresses, IPv6 addresses, IPv4 CIDRs, and/or IPv6 CIDRs from which the
        inbound traffic will be accepted.
        """
        return pulumi.get(self, "source_addresses")

    @source_addresses.setter
    def source_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "source_addresses", value)

    @property
    @pulumi.getter(name="sourceDropletIds")
    def source_droplet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        An array containing the IDs of
        the Droplets from which the inbound traffic will be accepted.
        """
        return pulumi.get(self, "source_droplet_ids")

    @source_droplet_ids.setter
    def source_droplet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "source_droplet_ids", value)

    @property
    @pulumi.getter(name="sourceKubernetesIds")
    def source_kubernetes_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An array containing the IDs of
        the Kubernetes clusters from which the inbound traffic will be accepted.
        """
        return pulumi.get(self, "source_kubernetes_ids")

    @source_kubernetes_ids.setter
    def source_kubernetes_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "source_kubernetes_ids", value)

    @property
    @pulumi.getter(name="sourceLoadBalancerUids")
    def source_load_balancer_uids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An array containing the IDs
        of the Load Balancers from which the inbound traffic will be accepted.
        """
        return pulumi.get(self, "source_load_balancer_uids")

    @source_load_balancer_uids.setter
    def source_load_balancer_uids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "source_load_balancer_uids", value)

    @property
    @pulumi.getter(name="sourceTags")
    def source_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An array containing the names of Tags
        corresponding to groups of Droplets from which the inbound traffic
        will be accepted.
        """
        return pulumi.get(self, "source_tags")

    @source_tags.setter
    def source_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "source_tags", value)


@pulumi.input_type
class FirewallOutboundRuleArgs:
    def __init__(__self__, *,
                 protocol: pulumi.Input[str],
                 destination_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 destination_droplet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 destination_kubernetes_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 destination_load_balancer_uids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 destination_tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 port_range: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] protocol: The type of traffic to be allowed.
               This may be one of "tcp", "udp", or "icmp".
        :param pulumi.Input[Sequence[pulumi.Input[str]]] destination_addresses: An array of strings containing the IPv4
               addresses, IPv6 addresses, IPv4 CIDRs, and/or IPv6 CIDRs to which the
               outbound traffic will be allowed.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] destination_droplet_ids: An array containing the IDs of
               the Droplets to which the outbound traffic will be allowed.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] destination_kubernetes_ids: An array containing the IDs of
               the Kubernetes clusters to which the outbound traffic will be allowed.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] destination_load_balancer_uids: An array containing the IDs
               of the Load Balancers to which the outbound traffic will be allowed.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] destination_tags: An array containing the names of Tags
               corresponding to groups of Droplets to which the outbound traffic will
               be allowed.
        :param pulumi.Input[str] port_range: The ports on which traffic will be allowed
               specified as a string containing a single port, a range (e.g. "8000-9000"),
               or "1-65535" to open all ports for a protocol. Required for when protocol is
               `tcp` or `udp`.
        """
        pulumi.set(__self__, "protocol", protocol)
        if destination_addresses is not None:
            pulumi.set(__self__, "destination_addresses", destination_addresses)
        if destination_droplet_ids is not None:
            pulumi.set(__self__, "destination_droplet_ids", destination_droplet_ids)
        if destination_kubernetes_ids is not None:
            pulumi.set(__self__, "destination_kubernetes_ids", destination_kubernetes_ids)
        if destination_load_balancer_uids is not None:
            pulumi.set(__self__, "destination_load_balancer_uids", destination_load_balancer_uids)
        if destination_tags is not None:
            pulumi.set(__self__, "destination_tags", destination_tags)
        if port_range is not None:
            pulumi.set(__self__, "port_range", port_range)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[str]:
        """
        The type of traffic to be allowed.
        This may be one of "tcp", "udp", or "icmp".
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[str]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="destinationAddresses")
    def destination_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An array of strings containing the IPv4
        addresses, IPv6 addresses, IPv4 CIDRs, and/or IPv6 CIDRs to which the
        outbound traffic will be allowed.
        """
        return pulumi.get(self, "destination_addresses")

    @destination_addresses.setter
    def destination_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "destination_addresses", value)

    @property
    @pulumi.getter(name="destinationDropletIds")
    def destination_droplet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        An array containing the IDs of
        the Droplets to which the outbound traffic will be allowed.
        """
        return pulumi.get(self, "destination_droplet_ids")

    @destination_droplet_ids.setter
    def destination_droplet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "destination_droplet_ids", value)

    @property
    @pulumi.getter(name="destinationKubernetesIds")
    def destination_kubernetes_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An array containing the IDs of
        the Kubernetes clusters to which the outbound traffic will be allowed.
        """
        return pulumi.get(self, "destination_kubernetes_ids")

    @destination_kubernetes_ids.setter
    def destination_kubernetes_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "destination_kubernetes_ids", value)

    @property
    @pulumi.getter(name="destinationLoadBalancerUids")
    def destination_load_balancer_uids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An array containing the IDs
        of the Load Balancers to which the outbound traffic will be allowed.
        """
        return pulumi.get(self, "destination_load_balancer_uids")

    @destination_load_balancer_uids.setter
    def destination_load_balancer_uids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "destination_load_balancer_uids", value)

    @property
    @pulumi.getter(name="destinationTags")
    def destination_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An array containing the names of Tags
        corresponding to groups of Droplets to which the outbound traffic will
        be allowed.
        """
        return pulumi.get(self, "destination_tags")

    @destination_tags.setter
    def destination_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "destination_tags", value)

    @property
    @pulumi.getter(name="portRange")
    def port_range(self) -> Optional[pulumi.Input[str]]:
        """
        The ports on which traffic will be allowed
        specified as a string containing a single port, a range (e.g. "8000-9000"),
        or "1-65535" to open all ports for a protocol. Required for when protocol is
        `tcp` or `udp`.
        """
        return pulumi.get(self, "port_range")

    @port_range.setter
    def port_range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "port_range", value)


@pulumi.input_type
class FirewallPendingChangeArgs:
    def __init__(__self__, *,
                 droplet_id: Optional[pulumi.Input[int]] = None,
                 removing: Optional[pulumi.Input[bool]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] status: A status string indicating the current state of the Firewall.
               This can be "waiting", "succeeded", or "failed".
        """
        if droplet_id is not None:
            pulumi.set(__self__, "droplet_id", droplet_id)
        if removing is not None:
            pulumi.set(__self__, "removing", removing)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="dropletId")
    def droplet_id(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "droplet_id")

    @droplet_id.setter
    def droplet_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "droplet_id", value)

    @property
    @pulumi.getter
    def removing(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "removing")

    @removing.setter
    def removing(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "removing", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        A status string indicating the current state of the Firewall.
        This can be "waiting", "succeeded", or "failed".
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class KubernetesClusterKubeConfigArgs:
    def __init__(__self__, *,
                 client_certificate: Optional[pulumi.Input[str]] = None,
                 client_key: Optional[pulumi.Input[str]] = None,
                 cluster_ca_certificate: Optional[pulumi.Input[str]] = None,
                 expires_at: Optional[pulumi.Input[str]] = None,
                 host: Optional[pulumi.Input[str]] = None,
                 raw_config: Optional[pulumi.Input[str]] = None,
                 token: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] client_certificate: The base64 encoded public certificate used by clients to access the cluster. Only available if token authentication is not supported on your cluster.
        :param pulumi.Input[str] client_key: The base64 encoded private key used by clients to access the cluster. Only available if token authentication is not supported on your cluster.
        :param pulumi.Input[str] cluster_ca_certificate: The base64 encoded public certificate for the cluster's certificate authority.
        :param pulumi.Input[str] expires_at: The date and time when the credentials will expire and need to be regenerated.
        :param pulumi.Input[str] host: The URL of the API server on the Kubernetes master node.
        :param pulumi.Input[str] raw_config: The full contents of the Kubernetes cluster's kubeconfig file.
        :param pulumi.Input[str] token: The DigitalOcean API access token used by clients to access the cluster.
        """
        if client_certificate is not None:
            pulumi.set(__self__, "client_certificate", client_certificate)
        if client_key is not None:
            pulumi.set(__self__, "client_key", client_key)
        if cluster_ca_certificate is not None:
            pulumi.set(__self__, "cluster_ca_certificate", cluster_ca_certificate)
        if expires_at is not None:
            pulumi.set(__self__, "expires_at", expires_at)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if raw_config is not None:
            pulumi.set(__self__, "raw_config", raw_config)
        if token is not None:
            pulumi.set(__self__, "token", token)

    @property
    @pulumi.getter(name="clientCertificate")
    def client_certificate(self) -> Optional[pulumi.Input[str]]:
        """
        The base64 encoded public certificate used by clients to access the cluster. Only available if token authentication is not supported on your cluster.
        """
        return pulumi.get(self, "client_certificate")

    @client_certificate.setter
    def client_certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_certificate", value)

    @property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> Optional[pulumi.Input[str]]:
        """
        The base64 encoded private key used by clients to access the cluster. Only available if token authentication is not supported on your cluster.
        """
        return pulumi.get(self, "client_key")

    @client_key.setter
    def client_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_key", value)

    @property
    @pulumi.getter(name="clusterCaCertificate")
    def cluster_ca_certificate(self) -> Optional[pulumi.Input[str]]:
        """
        The base64 encoded public certificate for the cluster's certificate authority.
        """
        return pulumi.get(self, "cluster_ca_certificate")

    @cluster_ca_certificate.setter
    def cluster_ca_certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_ca_certificate", value)

    @property
    @pulumi.getter(name="expiresAt")
    def expires_at(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time when the credentials will expire and need to be regenerated.
        """
        return pulumi.get(self, "expires_at")

    @expires_at.setter
    def expires_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expires_at", value)

    @property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[str]]:
        """
        The URL of the API server on the Kubernetes master node.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter(name="rawConfig")
    def raw_config(self) -> Optional[pulumi.Input[str]]:
        """
        The full contents of the Kubernetes cluster's kubeconfig file.
        """
        return pulumi.get(self, "raw_config")

    @raw_config.setter
    def raw_config(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "raw_config", value)

    @property
    @pulumi.getter
    def token(self) -> Optional[pulumi.Input[str]]:
        """
        The DigitalOcean API access token used by clients to access the cluster.
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "token", value)


@pulumi.input_type
class KubernetesClusterMaintenancePolicyArgs:
    def __init__(__self__, *,
                 day: Optional[pulumi.Input[str]] = None,
                 duration: Optional[pulumi.Input[str]] = None,
                 start_time: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] day: The day of the maintenance window policy. May be one of "monday" through "sunday", or "any" to indicate an arbitrary week day.
        :param pulumi.Input[str] start_time: The start time in UTC of the maintenance window policy in 24-hour clock format / HH:MM notation (e.g., 15:00).
        """
        if day is not None:
            pulumi.set(__self__, "day", day)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter
    def day(self) -> Optional[pulumi.Input[str]]:
        """
        The day of the maintenance window policy. May be one of "monday" through "sunday", or "any" to indicate an arbitrary week day.
        """
        return pulumi.get(self, "day")

    @day.setter
    def day(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "day", value)

    @property
    @pulumi.getter
    def duration(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "duration", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[str]]:
        """
        The start time in UTC of the maintenance window policy in 24-hour clock format / HH:MM notation (e.g., 15:00).
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_time", value)


@pulumi.input_type
class KubernetesClusterNodePoolArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 size: pulumi.Input[str],
                 actual_node_count: Optional[pulumi.Input[int]] = None,
                 auto_scale: Optional[pulumi.Input[bool]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 max_nodes: Optional[pulumi.Input[int]] = None,
                 min_nodes: Optional[pulumi.Input[int]] = None,
                 node_count: Optional[pulumi.Input[int]] = None,
                 nodes: Optional[pulumi.Input[Sequence[pulumi.Input['KubernetesClusterNodePoolNodeArgs']]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input['KubernetesClusterNodePoolTaintArgs']]]] = None):
        """
        :param pulumi.Input[str] name: A name for the node pool.
        :param pulumi.Input[str] size: The slug identifier for the type of Droplet to be used as workers in the node pool.
        :param pulumi.Input[int] actual_node_count: A computed field representing the actual number of nodes in the node pool, which is especially useful when auto-scaling is enabled.
        :param pulumi.Input[bool] auto_scale: Enable auto-scaling of the number of nodes in the node pool within the given min/max range.
        :param pulumi.Input[str] id: A unique ID that can be used to identify and reference the node.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: A map of key/value pairs to apply to nodes in the pool. The labels are exposed in the Kubernetes API as labels in the metadata of the corresponding [Node resources](https://kubernetes.io/docs/concepts/architecture/nodes/).
        :param pulumi.Input[int] max_nodes: If auto-scaling is enabled, this represents the maximum number of nodes that the node pool can be scaled up to.
        :param pulumi.Input[int] min_nodes: If auto-scaling is enabled, this represents the minimum number of nodes that the node pool can be scaled down to.
        :param pulumi.Input[int] node_count: The number of Droplet instances in the node pool. If auto-scaling is enabled, this should only be set if the desired result is to explicitly reset the number of nodes to this value. If auto-scaling is enabled, and the node count is outside of the given min/max range, it will use the min nodes value.
        :param pulumi.Input[Sequence[pulumi.Input['KubernetesClusterNodePoolNodeArgs']]] nodes: A list of nodes in the pool. Each node exports the following attributes:
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A list of tag names to be applied to the Kubernetes cluster.
        :param pulumi.Input[Sequence[pulumi.Input['KubernetesClusterNodePoolTaintArgs']]] taints: A block representing a taint applied to all nodes in the pool. Each taint exports the following attributes (taints must be unique by key and effect pair):
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "size", size)
        if actual_node_count is not None:
            pulumi.set(__self__, "actual_node_count", actual_node_count)
        if auto_scale is not None:
            pulumi.set(__self__, "auto_scale", auto_scale)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if max_nodes is not None:
            pulumi.set(__self__, "max_nodes", max_nodes)
        if min_nodes is not None:
            pulumi.set(__self__, "min_nodes", min_nodes)
        if node_count is not None:
            pulumi.set(__self__, "node_count", node_count)
        if nodes is not None:
            pulumi.set(__self__, "nodes", nodes)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if taints is not None:
            pulumi.set(__self__, "taints", taints)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        A name for the node pool.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def size(self) -> pulumi.Input[str]:
        """
        The slug identifier for the type of Droplet to be used as workers in the node pool.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: pulumi.Input[str]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter(name="actualNodeCount")
    def actual_node_count(self) -> Optional[pulumi.Input[int]]:
        """
        A computed field representing the actual number of nodes in the node pool, which is especially useful when auto-scaling is enabled.
        """
        return pulumi.get(self, "actual_node_count")

    @actual_node_count.setter
    def actual_node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "actual_node_count", value)

    @property
    @pulumi.getter(name="autoScale")
    def auto_scale(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable auto-scaling of the number of nodes in the node pool within the given min/max range.
        """
        return pulumi.get(self, "auto_scale")

    @auto_scale.setter
    def auto_scale(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_scale", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        A unique ID that can be used to identify and reference the node.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of key/value pairs to apply to nodes in the pool. The labels are exposed in the Kubernetes API as labels in the metadata of the corresponding [Node resources](https://kubernetes.io/docs/concepts/architecture/nodes/).
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="maxNodes")
    def max_nodes(self) -> Optional[pulumi.Input[int]]:
        """
        If auto-scaling is enabled, this represents the maximum number of nodes that the node pool can be scaled up to.
        """
        return pulumi.get(self, "max_nodes")

    @max_nodes.setter
    def max_nodes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_nodes", value)

    @property
    @pulumi.getter(name="minNodes")
    def min_nodes(self) -> Optional[pulumi.Input[int]]:
        """
        If auto-scaling is enabled, this represents the minimum number of nodes that the node pool can be scaled down to.
        """
        return pulumi.get(self, "min_nodes")

    @min_nodes.setter
    def min_nodes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_nodes", value)

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of Droplet instances in the node pool. If auto-scaling is enabled, this should only be set if the desired result is to explicitly reset the number of nodes to this value. If auto-scaling is enabled, and the node count is outside of the given min/max range, it will use the min nodes value.
        """
        return pulumi.get(self, "node_count")

    @node_count.setter
    def node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "node_count", value)

    @property
    @pulumi.getter
    def nodes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KubernetesClusterNodePoolNodeArgs']]]]:
        """
        A list of nodes in the pool. Each node exports the following attributes:
        """
        return pulumi.get(self, "nodes")

    @nodes.setter
    def nodes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KubernetesClusterNodePoolNodeArgs']]]]):
        pulumi.set(self, "nodes", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of tag names to be applied to the Kubernetes cluster.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def taints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KubernetesClusterNodePoolTaintArgs']]]]:
        """
        A block representing a taint applied to all nodes in the pool. Each taint exports the following attributes (taints must be unique by key and effect pair):
        """
        return pulumi.get(self, "taints")

    @taints.setter
    def taints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KubernetesClusterNodePoolTaintArgs']]]]):
        pulumi.set(self, "taints", value)


@pulumi.input_type
class KubernetesClusterNodePoolNodeArgs:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[str]] = None,
                 droplet_id: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 updated_at: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] created_at: The date and time when the node was created.
        :param pulumi.Input[str] droplet_id: The id of the node's droplet
        :param pulumi.Input[str] id: A unique ID that can be used to identify and reference the node.
        :param pulumi.Input[str] name: A name for the node pool.
        :param pulumi.Input[str] status: A string indicating the current status of the individual node.
        :param pulumi.Input[str] updated_at: The date and time when the node was last updated.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if droplet_id is not None:
            pulumi.set(__self__, "droplet_id", droplet_id)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time when the node was created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter(name="dropletId")
    def droplet_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the node's droplet
        """
        return pulumi.get(self, "droplet_id")

    @droplet_id.setter
    def droplet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "droplet_id", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        A unique ID that can be used to identify and reference the node.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A name for the node pool.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        A string indicating the current status of the individual node.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time when the node was last updated.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "updated_at", value)


@pulumi.input_type
class KubernetesClusterNodePoolTaintArgs:
    def __init__(__self__, *,
                 effect: pulumi.Input[str],
                 key: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        :param pulumi.Input[str] effect: How the node reacts to pods that it won't tolerate. Available effect values are: "NoSchedule", "PreferNoSchedule", "NoExecute".
        :param pulumi.Input[str] key: An arbitrary string. The "key" and "value" fields of the "taint" object form a key-value pair.
        :param pulumi.Input[str] value: An arbitrary string. The "key" and "value" fields of the "taint" object form a key-value pair.
        """
        pulumi.set(__self__, "effect", effect)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def effect(self) -> pulumi.Input[str]:
        """
        How the node reacts to pods that it won't tolerate. Available effect values are: "NoSchedule", "PreferNoSchedule", "NoExecute".
        """
        return pulumi.get(self, "effect")

    @effect.setter
    def effect(self, value: pulumi.Input[str]):
        pulumi.set(self, "effect", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        An arbitrary string. The "key" and "value" fields of the "taint" object form a key-value pair.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        An arbitrary string. The "key" and "value" fields of the "taint" object form a key-value pair.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class KubernetesNodePoolNodeArgs:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[str]] = None,
                 droplet_id: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 updated_at: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] created_at: The date and time when the node was created.
        :param pulumi.Input[str] droplet_id: The id of the node's droplet
        :param pulumi.Input[str] id: A unique ID that can be used to identify and reference the node.
        :param pulumi.Input[str] name: A name for the node pool.
        :param pulumi.Input[str] status: A string indicating the current status of the individual node.
        :param pulumi.Input[str] updated_at: The date and time when the node was last updated.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if droplet_id is not None:
            pulumi.set(__self__, "droplet_id", droplet_id)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time when the node was created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter(name="dropletId")
    def droplet_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the node's droplet
        """
        return pulumi.get(self, "droplet_id")

    @droplet_id.setter
    def droplet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "droplet_id", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        A unique ID that can be used to identify and reference the node.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A name for the node pool.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        A string indicating the current status of the individual node.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time when the node was last updated.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "updated_at", value)


@pulumi.input_type
class KubernetesNodePoolTaintArgs:
    def __init__(__self__, *,
                 effect: pulumi.Input[str],
                 key: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        :param pulumi.Input[str] effect: How the node reacts to pods that it won't tolerate. Available effect values are: "NoSchedule", "PreferNoSchedule", "NoExecute".
        :param pulumi.Input[str] key: An arbitrary string. The "key" and "value" fields of the "taint" object form a key-value pair.
        :param pulumi.Input[str] value: An arbitrary string. The "key" and "value" fields of the "taint" object form a key-value pair.
        """
        pulumi.set(__self__, "effect", effect)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def effect(self) -> pulumi.Input[str]:
        """
        How the node reacts to pods that it won't tolerate. Available effect values are: "NoSchedule", "PreferNoSchedule", "NoExecute".
        """
        return pulumi.get(self, "effect")

    @effect.setter
    def effect(self, value: pulumi.Input[str]):
        pulumi.set(self, "effect", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        An arbitrary string. The "key" and "value" fields of the "taint" object form a key-value pair.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        An arbitrary string. The "key" and "value" fields of the "taint" object form a key-value pair.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class LoadBalancerForwardingRuleArgs:
    def __init__(__self__, *,
                 entry_port: pulumi.Input[int],
                 entry_protocol: pulumi.Input[str],
                 target_port: pulumi.Input[int],
                 target_protocol: pulumi.Input[str],
                 certificate_id: Optional[pulumi.Input[str]] = None,
                 certificate_name: Optional[pulumi.Input[str]] = None,
                 tls_passthrough: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[int] entry_port: An integer representing the port on which the Load Balancer instance will listen.
        :param pulumi.Input[str] entry_protocol: The protocol used for traffic to the Load Balancer. The possible values are: `http`, `https`, `http2` or `tcp`.
        :param pulumi.Input[int] target_port: An integer representing the port on the backend Droplets to which the Load Balancer will send traffic.
        :param pulumi.Input[str] target_protocol: The protocol used for traffic from the Load Balancer to the backend Droplets. The possible values are: `http`, `https`, `http2` or `tcp`.
        :param pulumi.Input[str] certificate_id: **Deprecated** The ID of the TLS certificate to be used for SSL termination.
        :param pulumi.Input[str] certificate_name: The unique name of the TLS certificate to be used for SSL termination.
        :param pulumi.Input[bool] tls_passthrough: A boolean value indicating whether SSL encrypted traffic will be passed through to the backend Droplets. The default value is `false`.
        """
        pulumi.set(__self__, "entry_port", entry_port)
        pulumi.set(__self__, "entry_protocol", entry_protocol)
        pulumi.set(__self__, "target_port", target_port)
        pulumi.set(__self__, "target_protocol", target_protocol)
        if certificate_id is not None:
            warnings.warn("""Certificate IDs may change, for example when a Let's Encrypt certificate is auto-renewed. Please specify 'certificate_name' instead.""", DeprecationWarning)
            pulumi.log.warn("""certificate_id is deprecated: Certificate IDs may change, for example when a Let's Encrypt certificate is auto-renewed. Please specify 'certificate_name' instead.""")
        if certificate_id is not None:
            pulumi.set(__self__, "certificate_id", certificate_id)
        if certificate_name is not None:
            pulumi.set(__self__, "certificate_name", certificate_name)
        if tls_passthrough is not None:
            pulumi.set(__self__, "tls_passthrough", tls_passthrough)

    @property
    @pulumi.getter(name="entryPort")
    def entry_port(self) -> pulumi.Input[int]:
        """
        An integer representing the port on which the Load Balancer instance will listen.
        """
        return pulumi.get(self, "entry_port")

    @entry_port.setter
    def entry_port(self, value: pulumi.Input[int]):
        pulumi.set(self, "entry_port", value)

    @property
    @pulumi.getter(name="entryProtocol")
    def entry_protocol(self) -> pulumi.Input[str]:
        """
        The protocol used for traffic to the Load Balancer. The possible values are: `http`, `https`, `http2` or `tcp`.
        """
        return pulumi.get(self, "entry_protocol")

    @entry_protocol.setter
    def entry_protocol(self, value: pulumi.Input[str]):
        pulumi.set(self, "entry_protocol", value)

    @property
    @pulumi.getter(name="targetPort")
    def target_port(self) -> pulumi.Input[int]:
        """
        An integer representing the port on the backend Droplets to which the Load Balancer will send traffic.
        """
        return pulumi.get(self, "target_port")

    @target_port.setter
    def target_port(self, value: pulumi.Input[int]):
        pulumi.set(self, "target_port", value)

    @property
    @pulumi.getter(name="targetProtocol")
    def target_protocol(self) -> pulumi.Input[str]:
        """
        The protocol used for traffic from the Load Balancer to the backend Droplets. The possible values are: `http`, `https`, `http2` or `tcp`.
        """
        return pulumi.get(self, "target_protocol")

    @target_protocol.setter
    def target_protocol(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_protocol", value)

    @property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> Optional[pulumi.Input[str]]:
        """
        **Deprecated** The ID of the TLS certificate to be used for SSL termination.
        """
        return pulumi.get(self, "certificate_id")

    @certificate_id.setter
    def certificate_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_id", value)

    @property
    @pulumi.getter(name="certificateName")
    def certificate_name(self) -> Optional[pulumi.Input[str]]:
        """
        The unique name of the TLS certificate to be used for SSL termination.
        """
        return pulumi.get(self, "certificate_name")

    @certificate_name.setter
    def certificate_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_name", value)

    @property
    @pulumi.getter(name="tlsPassthrough")
    def tls_passthrough(self) -> Optional[pulumi.Input[bool]]:
        """
        A boolean value indicating whether SSL encrypted traffic will be passed through to the backend Droplets. The default value is `false`.
        """
        return pulumi.get(self, "tls_passthrough")

    @tls_passthrough.setter
    def tls_passthrough(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "tls_passthrough", value)


@pulumi.input_type
class LoadBalancerHealthcheckArgs:
    def __init__(__self__, *,
                 port: pulumi.Input[int],
                 protocol: pulumi.Input[str],
                 check_interval_seconds: Optional[pulumi.Input[int]] = None,
                 healthy_threshold: Optional[pulumi.Input[int]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 response_timeout_seconds: Optional[pulumi.Input[int]] = None,
                 unhealthy_threshold: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] port: An integer representing the port on the backend Droplets on which the health check will attempt a connection.
        :param pulumi.Input[str] protocol: The protocol used for health checks sent to the backend Droplets. The possible values are `http`, `https` or `tcp`.
        :param pulumi.Input[int] check_interval_seconds: The number of seconds between between two consecutive health checks. If not specified, the default value is `10`.
        :param pulumi.Input[int] healthy_threshold: The number of times a health check must pass for a backend Droplet to be marked "healthy" and be re-added to the pool. If not specified, the default value is `5`.
        :param pulumi.Input[str] path: The path on the backend Droplets to which the Load Balancer instance will send a request.
        :param pulumi.Input[int] response_timeout_seconds: The number of seconds the Load Balancer instance will wait for a response until marking a health check as failed. If not specified, the default value is `5`.
        :param pulumi.Input[int] unhealthy_threshold: The number of times a health check must fail for a backend Droplet to be marked "unhealthy" and be removed from the pool. If not specified, the default value is `3`.
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)
        if check_interval_seconds is not None:
            pulumi.set(__self__, "check_interval_seconds", check_interval_seconds)
        if healthy_threshold is not None:
            pulumi.set(__self__, "healthy_threshold", healthy_threshold)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if response_timeout_seconds is not None:
            pulumi.set(__self__, "response_timeout_seconds", response_timeout_seconds)
        if unhealthy_threshold is not None:
            pulumi.set(__self__, "unhealthy_threshold", unhealthy_threshold)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[int]:
        """
        An integer representing the port on the backend Droplets on which the health check will attempt a connection.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[int]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[str]:
        """
        The protocol used for health checks sent to the backend Droplets. The possible values are `http`, `https` or `tcp`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[str]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="checkIntervalSeconds")
    def check_interval_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        The number of seconds between between two consecutive health checks. If not specified, the default value is `10`.
        """
        return pulumi.get(self, "check_interval_seconds")

    @check_interval_seconds.setter
    def check_interval_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "check_interval_seconds", value)

    @property
    @pulumi.getter(name="healthyThreshold")
    def healthy_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        The number of times a health check must pass for a backend Droplet to be marked "healthy" and be re-added to the pool. If not specified, the default value is `5`.
        """
        return pulumi.get(self, "healthy_threshold")

    @healthy_threshold.setter
    def healthy_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "healthy_threshold", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        The path on the backend Droplets to which the Load Balancer instance will send a request.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="responseTimeoutSeconds")
    def response_timeout_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        The number of seconds the Load Balancer instance will wait for a response until marking a health check as failed. If not specified, the default value is `5`.
        """
        return pulumi.get(self, "response_timeout_seconds")

    @response_timeout_seconds.setter
    def response_timeout_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "response_timeout_seconds", value)

    @property
    @pulumi.getter(name="unhealthyThreshold")
    def unhealthy_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        The number of times a health check must fail for a backend Droplet to be marked "unhealthy" and be removed from the pool. If not specified, the default value is `3`.
        """
        return pulumi.get(self, "unhealthy_threshold")

    @unhealthy_threshold.setter
    def unhealthy_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "unhealthy_threshold", value)


@pulumi.input_type
class LoadBalancerStickySessionsArgs:
    def __init__(__self__, *,
                 cookie_name: Optional[pulumi.Input[str]] = None,
                 cookie_ttl_seconds: Optional[pulumi.Input[int]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] cookie_name: The name to be used for the cookie sent to the client. This attribute is required when using `cookies` for the sticky sessions type.
        :param pulumi.Input[int] cookie_ttl_seconds: The number of seconds until the cookie set by the Load Balancer expires. This attribute is required when using `cookies` for the sticky sessions type.
        :param pulumi.Input[str] type: An attribute indicating how and if requests from a client will be persistently served by the same backend Droplet. The possible values are `cookies` or `none`. If not specified, the default value is `none`.
        """
        if cookie_name is not None:
            pulumi.set(__self__, "cookie_name", cookie_name)
        if cookie_ttl_seconds is not None:
            pulumi.set(__self__, "cookie_ttl_seconds", cookie_ttl_seconds)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="cookieName")
    def cookie_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name to be used for the cookie sent to the client. This attribute is required when using `cookies` for the sticky sessions type.
        """
        return pulumi.get(self, "cookie_name")

    @cookie_name.setter
    def cookie_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cookie_name", value)

    @property
    @pulumi.getter(name="cookieTtlSeconds")
    def cookie_ttl_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        The number of seconds until the cookie set by the Load Balancer expires. This attribute is required when using `cookies` for the sticky sessions type.
        """
        return pulumi.get(self, "cookie_ttl_seconds")

    @cookie_ttl_seconds.setter
    def cookie_ttl_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cookie_ttl_seconds", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        An attribute indicating how and if requests from a client will be persistently served by the same backend Droplet. The possible values are `cookies` or `none`. If not specified, the default value is `none`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class MonitorAlertAlertsArgs:
    def __init__(__self__, *,
                 emails: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 slacks: Optional[pulumi.Input[Sequence[pulumi.Input['MonitorAlertAlertsSlackArgs']]]] = None):
        if emails is not None:
            pulumi.set(__self__, "emails", emails)
        if slacks is not None:
            pulumi.set(__self__, "slacks", slacks)

    @property
    @pulumi.getter
    def emails(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "emails")

    @emails.setter
    def emails(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "emails", value)

    @property
    @pulumi.getter
    def slacks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MonitorAlertAlertsSlackArgs']]]]:
        return pulumi.get(self, "slacks")

    @slacks.setter
    def slacks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MonitorAlertAlertsSlackArgs']]]]):
        pulumi.set(self, "slacks", value)


@pulumi.input_type
class MonitorAlertAlertsSlackArgs:
    def __init__(__self__, *,
                 channel: pulumi.Input[str],
                 url: pulumi.Input[str]):
        pulumi.set(__self__, "channel", channel)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def channel(self) -> pulumi.Input[str]:
        return pulumi.get(self, "channel")

    @channel.setter
    def channel(self, value: pulumi.Input[str]):
        pulumi.set(self, "channel", value)

    @property
    @pulumi.getter
    def url(self) -> pulumi.Input[str]:
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[str]):
        pulumi.set(self, "url", value)


@pulumi.input_type
class SpacesBucketCorsRuleArgs:
    def __init__(__self__, *,
                 allowed_methods: pulumi.Input[Sequence[pulumi.Input[str]]],
                 allowed_origins: pulumi.Input[Sequence[pulumi.Input[str]]],
                 allowed_headers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 max_age_seconds: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_methods: A list of HTTP methods (e.g. `GET`) which are allowed from the specified origin.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_origins: A list of hosts from which requests using the specified methods are allowed. A host may contain one wildcard (e.g. http://*.example.com).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_headers: A list of headers that will be included in the CORS preflight request's `Access-Control-Request-Headers`. A header may contain one wildcard (e.g. `x-amz-*`).
        :param pulumi.Input[int] max_age_seconds: The time in seconds that browser can cache the response for a preflight request.
        """
        pulumi.set(__self__, "allowed_methods", allowed_methods)
        pulumi.set(__self__, "allowed_origins", allowed_origins)
        if allowed_headers is not None:
            pulumi.set(__self__, "allowed_headers", allowed_headers)
        if max_age_seconds is not None:
            pulumi.set(__self__, "max_age_seconds", max_age_seconds)

    @property
    @pulumi.getter(name="allowedMethods")
    def allowed_methods(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        A list of HTTP methods (e.g. `GET`) which are allowed from the specified origin.
        """
        return pulumi.get(self, "allowed_methods")

    @allowed_methods.setter
    def allowed_methods(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "allowed_methods", value)

    @property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        A list of hosts from which requests using the specified methods are allowed. A host may contain one wildcard (e.g. http://*.example.com).
        """
        return pulumi.get(self, "allowed_origins")

    @allowed_origins.setter
    def allowed_origins(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "allowed_origins", value)

    @property
    @pulumi.getter(name="allowedHeaders")
    def allowed_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of headers that will be included in the CORS preflight request's `Access-Control-Request-Headers`. A header may contain one wildcard (e.g. `x-amz-*`).
        """
        return pulumi.get(self, "allowed_headers")

    @allowed_headers.setter
    def allowed_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_headers", value)

    @property
    @pulumi.getter(name="maxAgeSeconds")
    def max_age_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        The time in seconds that browser can cache the response for a preflight request.
        """
        return pulumi.get(self, "max_age_seconds")

    @max_age_seconds.setter
    def max_age_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_age_seconds", value)


@pulumi.input_type
class SpacesBucketLifecycleRuleArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[bool],
                 abort_incomplete_multipart_upload_days: Optional[pulumi.Input[int]] = None,
                 expiration: Optional[pulumi.Input['SpacesBucketLifecycleRuleExpirationArgs']] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 noncurrent_version_expiration: Optional[pulumi.Input['SpacesBucketLifecycleRuleNoncurrentVersionExpirationArgs']] = None,
                 prefix: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] enabled: Specifies lifecycle rule status.
        :param pulumi.Input[int] abort_incomplete_multipart_upload_days: Specifies the number of days after initiating a multipart
               upload when the multipart upload must be completed or else Spaces will abort the upload.
        :param pulumi.Input['SpacesBucketLifecycleRuleExpirationArgs'] expiration: Specifies a time period after which applicable objects expire (documented below).
        :param pulumi.Input[str] id: Unique identifier for the rule.
        :param pulumi.Input['SpacesBucketLifecycleRuleNoncurrentVersionExpirationArgs'] noncurrent_version_expiration: Specifies when non-current object versions expire (documented below).
        :param pulumi.Input[str] prefix: Object key prefix identifying one or more objects to which the rule applies.
        """
        pulumi.set(__self__, "enabled", enabled)
        if abort_incomplete_multipart_upload_days is not None:
            pulumi.set(__self__, "abort_incomplete_multipart_upload_days", abort_incomplete_multipart_upload_days)
        if expiration is not None:
            pulumi.set(__self__, "expiration", expiration)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if noncurrent_version_expiration is not None:
            pulumi.set(__self__, "noncurrent_version_expiration", noncurrent_version_expiration)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        Specifies lifecycle rule status.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="abortIncompleteMultipartUploadDays")
    def abort_incomplete_multipart_upload_days(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the number of days after initiating a multipart
        upload when the multipart upload must be completed or else Spaces will abort the upload.
        """
        return pulumi.get(self, "abort_incomplete_multipart_upload_days")

    @abort_incomplete_multipart_upload_days.setter
    def abort_incomplete_multipart_upload_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "abort_incomplete_multipart_upload_days", value)

    @property
    @pulumi.getter
    def expiration(self) -> Optional[pulumi.Input['SpacesBucketLifecycleRuleExpirationArgs']]:
        """
        Specifies a time period after which applicable objects expire (documented below).
        """
        return pulumi.get(self, "expiration")

    @expiration.setter
    def expiration(self, value: Optional[pulumi.Input['SpacesBucketLifecycleRuleExpirationArgs']]):
        pulumi.set(self, "expiration", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier for the rule.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="noncurrentVersionExpiration")
    def noncurrent_version_expiration(self) -> Optional[pulumi.Input['SpacesBucketLifecycleRuleNoncurrentVersionExpirationArgs']]:
        """
        Specifies when non-current object versions expire (documented below).
        """
        return pulumi.get(self, "noncurrent_version_expiration")

    @noncurrent_version_expiration.setter
    def noncurrent_version_expiration(self, value: Optional[pulumi.Input['SpacesBucketLifecycleRuleNoncurrentVersionExpirationArgs']]):
        pulumi.set(self, "noncurrent_version_expiration", value)

    @property
    @pulumi.getter
    def prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Object key prefix identifying one or more objects to which the rule applies.
        """
        return pulumi.get(self, "prefix")

    @prefix.setter
    def prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "prefix", value)


@pulumi.input_type
class SpacesBucketLifecycleRuleExpirationArgs:
    def __init__(__self__, *,
                 date: Optional[pulumi.Input[str]] = None,
                 days: Optional[pulumi.Input[int]] = None,
                 expired_object_delete_marker: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] date: Specifies the date/time after which you want applicable objects to expire. The argument uses
               RFC3339 format, e.g. "2020-03-22T15:03:55Z" or parts thereof e.g. "2019-02-28".
        :param pulumi.Input[int] days: Specifies the number of days after object creation when the applicable objects will expire.
        :param pulumi.Input[bool] expired_object_delete_marker: On a versioned bucket (versioning-enabled or versioning-suspended
               bucket), setting this to true directs Spaces to delete expired object delete markers.
        """
        if date is not None:
            pulumi.set(__self__, "date", date)
        if days is not None:
            pulumi.set(__self__, "days", days)
        if expired_object_delete_marker is not None:
            pulumi.set(__self__, "expired_object_delete_marker", expired_object_delete_marker)

    @property
    @pulumi.getter
    def date(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the date/time after which you want applicable objects to expire. The argument uses
        RFC3339 format, e.g. "2020-03-22T15:03:55Z" or parts thereof e.g. "2019-02-28".
        """
        return pulumi.get(self, "date")

    @date.setter
    def date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "date", value)

    @property
    @pulumi.getter
    def days(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the number of days after object creation when the applicable objects will expire.
        """
        return pulumi.get(self, "days")

    @days.setter
    def days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "days", value)

    @property
    @pulumi.getter(name="expiredObjectDeleteMarker")
    def expired_object_delete_marker(self) -> Optional[pulumi.Input[bool]]:
        """
        On a versioned bucket (versioning-enabled or versioning-suspended
        bucket), setting this to true directs Spaces to delete expired object delete markers.
        """
        return pulumi.get(self, "expired_object_delete_marker")

    @expired_object_delete_marker.setter
    def expired_object_delete_marker(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "expired_object_delete_marker", value)


@pulumi.input_type
class SpacesBucketLifecycleRuleNoncurrentVersionExpirationArgs:
    def __init__(__self__, *,
                 days: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] days: Specifies the number of days after which an object's non-current versions expire.
        """
        if days is not None:
            pulumi.set(__self__, "days", days)

    @property
    @pulumi.getter
    def days(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the number of days after which an object's non-current versions expire.
        """
        return pulumi.get(self, "days")

    @days.setter
    def days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "days", value)


@pulumi.input_type
class SpacesBucketVersioningArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[bool] enabled: Enable versioning. Once you version-enable a bucket, it can never return to an unversioned
               state. You can, however, suspend versioning on that bucket.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable versioning. Once you version-enable a bucket, it can never return to an unversioned
        state. You can, however, suspend versioning on that bucket.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)


@pulumi.input_type
class GetDomainsFilterArgs:
    def __init__(__self__, *,
                 key: str,
                 values: Sequence[str],
                 all: Optional[bool] = None,
                 match_by: Optional[str] = None):
        """
        :param str key: Filter the domains by this key. This may be one of `name`, `urn`, and `ttl`.
        :param Sequence[str] values: A list of values to match against the `key` field. Only retrieves domains
               where the `key` field takes on one or more of the values provided here.
        :param bool all: Set to `true` to require that a field match all of the `values` instead of just one or more of
               them. This is useful when matching against multi-valued fields such as lists or sets where you want to ensure
               that all of the `values` are present in the list or set.
        :param str match_by: One of `exact` (default), `re`, or `substring`. For string-typed fields, specify `re` to
               match by using the `values` as regular expressions, or specify `substring` to match by treating the `values` as
               substrings to find within the string field.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)
        if all is not None:
            pulumi.set(__self__, "all", all)
        if match_by is not None:
            pulumi.set(__self__, "match_by", match_by)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Filter the domains by this key. This may be one of `name`, `urn`, and `ttl`.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: str):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        A list of values to match against the `key` field. Only retrieves domains
        where the `key` field takes on one or more of the values provided here.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def all(self) -> Optional[bool]:
        """
        Set to `true` to require that a field match all of the `values` instead of just one or more of
        them. This is useful when matching against multi-valued fields such as lists or sets where you want to ensure
        that all of the `values` are present in the list or set.
        """
        return pulumi.get(self, "all")

    @all.setter
    def all(self, value: Optional[bool]):
        pulumi.set(self, "all", value)

    @property
    @pulumi.getter(name="matchBy")
    def match_by(self) -> Optional[str]:
        """
        One of `exact` (default), `re`, or `substring`. For string-typed fields, specify `re` to
        match by using the `values` as regular expressions, or specify `substring` to match by treating the `values` as
        substrings to find within the string field.
        """
        return pulumi.get(self, "match_by")

    @match_by.setter
    def match_by(self, value: Optional[str]):
        pulumi.set(self, "match_by", value)


@pulumi.input_type
class GetDomainsSortArgs:
    def __init__(__self__, *,
                 key: str,
                 direction: Optional[str] = None):
        """
        :param str key: Sort the domains by this key. This may be one of `name`, `urn`, and `ttl`.
        :param str direction: The sort direction. This may be either `asc` or `desc`.
        """
        pulumi.set(__self__, "key", key)
        if direction is not None:
            pulumi.set(__self__, "direction", direction)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Sort the domains by this key. This may be one of `name`, `urn`, and `ttl`.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: str):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def direction(self) -> Optional[str]:
        """
        The sort direction. This may be either `asc` or `desc`.
        """
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: Optional[str]):
        pulumi.set(self, "direction", value)


@pulumi.input_type
class GetDropletsFilterArgs:
    def __init__(__self__, *,
                 key: str,
                 values: Sequence[str],
                 all: Optional[bool] = None,
                 match_by: Optional[str] = None):
        """
        :param str key: Filter the Droplets by this key. This may be one of `backups`, `created_at`, `disk`, `id`,
               `image`, `ipv4_address`, `ipv4_address_private`, `ipv6`, `ipv6_address`, `ipv6_address_private`, `locked`,
               `memory`, `monitoring`, `name`, `price_hourly`, `price_monthly`, `private_networking`, `region`, `size`,
               `status`, `tags`, `urn`, `vcpus`, `volume_ids`, or `vpc_uuid`.
        :param Sequence[str] values: A list of values to match against the `key` field. Only retrieves Droplets
               where the `key` field takes on one or more of the values provided here.
        :param bool all: Set to `true` to require that a field match all of the `values` instead of just one or more of
               them. This is useful when matching against multi-valued fields such as lists or sets where you want to ensure
               that all of the `values` are present in the list or set.
        :param str match_by: One of `exact` (default), `re`, or `substring`. For string-typed fields, specify `re` to
               match by using the `values` as regular expressions, or specify `substring` to match by treating the `values` as
               substrings to find within the string field.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)
        if all is not None:
            pulumi.set(__self__, "all", all)
        if match_by is not None:
            pulumi.set(__self__, "match_by", match_by)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Filter the Droplets by this key. This may be one of `backups`, `created_at`, `disk`, `id`,
        `image`, `ipv4_address`, `ipv4_address_private`, `ipv6`, `ipv6_address`, `ipv6_address_private`, `locked`,
        `memory`, `monitoring`, `name`, `price_hourly`, `price_monthly`, `private_networking`, `region`, `size`,
        `status`, `tags`, `urn`, `vcpus`, `volume_ids`, or `vpc_uuid`.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: str):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        A list of values to match against the `key` field. Only retrieves Droplets
        where the `key` field takes on one or more of the values provided here.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def all(self) -> Optional[bool]:
        """
        Set to `true` to require that a field match all of the `values` instead of just one or more of
        them. This is useful when matching against multi-valued fields such as lists or sets where you want to ensure
        that all of the `values` are present in the list or set.
        """
        return pulumi.get(self, "all")

    @all.setter
    def all(self, value: Optional[bool]):
        pulumi.set(self, "all", value)

    @property
    @pulumi.getter(name="matchBy")
    def match_by(self) -> Optional[str]:
        """
        One of `exact` (default), `re`, or `substring`. For string-typed fields, specify `re` to
        match by using the `values` as regular expressions, or specify `substring` to match by treating the `values` as
        substrings to find within the string field.
        """
        return pulumi.get(self, "match_by")

    @match_by.setter
    def match_by(self, value: Optional[str]):
        pulumi.set(self, "match_by", value)


@pulumi.input_type
class GetDropletsSortArgs:
    def __init__(__self__, *,
                 key: str,
                 direction: Optional[str] = None):
        """
        :param str key: Sort the Droplets by this key. This may be one of `backups`, `created_at`, `disk`, `id`,
               `image`, `ipv4_address`, `ipv4_address_private`, `ipv6`, `ipv6_address`, `ipv6_address_private`, `locked`,
               `memory`, `monitoring`, `name`, `price_hourly`, `price_monthly`, `private_networking`, `region`, `size`,
               `status`, `urn`, `vcpus`, or `vpc_uuid`.
        :param str direction: The sort direction. This may be either `asc` or `desc`.
        """
        pulumi.set(__self__, "key", key)
        if direction is not None:
            pulumi.set(__self__, "direction", direction)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Sort the Droplets by this key. This may be one of `backups`, `created_at`, `disk`, `id`,
        `image`, `ipv4_address`, `ipv4_address_private`, `ipv6`, `ipv6_address`, `ipv6_address_private`, `locked`,
        `memory`, `monitoring`, `name`, `price_hourly`, `price_monthly`, `private_networking`, `region`, `size`,
        `status`, `urn`, `vcpus`, or `vpc_uuid`.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: str):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def direction(self) -> Optional[str]:
        """
        The sort direction. This may be either `asc` or `desc`.
        """
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: Optional[str]):
        pulumi.set(self, "direction", value)


@pulumi.input_type
class GetFirewallInboundRuleArgs:
    def __init__(__self__, *,
                 protocol: str,
                 port_range: Optional[str] = None,
                 source_addresses: Optional[Sequence[str]] = None,
                 source_droplet_ids: Optional[Sequence[int]] = None,
                 source_kubernetes_ids: Optional[Sequence[str]] = None,
                 source_load_balancer_uids: Optional[Sequence[str]] = None,
                 source_tags: Optional[Sequence[str]] = None):
        """
        :param str protocol: The type of traffic to be allowed.
               This may be one of "tcp", "udp", or "icmp".
        :param str port_range: The ports on which traffic will be allowed
               specified as a string containing a single port, a range (e.g. "8000-9000"),
               or "1-65535" to open all ports for a protocol. Required for when protocol is
               `tcp` or `udp`.
        :param Sequence[str] source_addresses: An array of strings containing the IPv4
               addresses, IPv6 addresses, IPv4 CIDRs, and/or IPv6 CIDRs from which the
               inbound traffic will be accepted.
        :param Sequence[int] source_droplet_ids: An array containing the IDs of
               the Droplets from which the inbound traffic will be accepted.
        :param Sequence[str] source_load_balancer_uids: An array containing the IDs
               of the Load Balancers from which the inbound traffic will be accepted.
        :param Sequence[str] source_tags: A set of names of Tags corresponding to group of
               Droplets from which the inbound traffic will be accepted.
        """
        pulumi.set(__self__, "protocol", protocol)
        if port_range is not None:
            pulumi.set(__self__, "port_range", port_range)
        if source_addresses is not None:
            pulumi.set(__self__, "source_addresses", source_addresses)
        if source_droplet_ids is not None:
            pulumi.set(__self__, "source_droplet_ids", source_droplet_ids)
        if source_kubernetes_ids is not None:
            pulumi.set(__self__, "source_kubernetes_ids", source_kubernetes_ids)
        if source_load_balancer_uids is not None:
            pulumi.set(__self__, "source_load_balancer_uids", source_load_balancer_uids)
        if source_tags is not None:
            pulumi.set(__self__, "source_tags", source_tags)

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        The type of traffic to be allowed.
        This may be one of "tcp", "udp", or "icmp".
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: str):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="portRange")
    def port_range(self) -> Optional[str]:
        """
        The ports on which traffic will be allowed
        specified as a string containing a single port, a range (e.g. "8000-9000"),
        or "1-65535" to open all ports for a protocol. Required for when protocol is
        `tcp` or `udp`.
        """
        return pulumi.get(self, "port_range")

    @port_range.setter
    def port_range(self, value: Optional[str]):
        pulumi.set(self, "port_range", value)

    @property
    @pulumi.getter(name="sourceAddresses")
    def source_addresses(self) -> Optional[Sequence[str]]:
        """
        An array of strings containing the IPv4
        addresses, IPv6 addresses, IPv4 CIDRs, and/or IPv6 CIDRs from which the
        inbound traffic will be accepted.
        """
        return pulumi.get(self, "source_addresses")

    @source_addresses.setter
    def source_addresses(self, value: Optional[Sequence[str]]):
        pulumi.set(self, "source_addresses", value)

    @property
    @pulumi.getter(name="sourceDropletIds")
    def source_droplet_ids(self) -> Optional[Sequence[int]]:
        """
        An array containing the IDs of
        the Droplets from which the inbound traffic will be accepted.
        """
        return pulumi.get(self, "source_droplet_ids")

    @source_droplet_ids.setter
    def source_droplet_ids(self, value: Optional[Sequence[int]]):
        pulumi.set(self, "source_droplet_ids", value)

    @property
    @pulumi.getter(name="sourceKubernetesIds")
    def source_kubernetes_ids(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "source_kubernetes_ids")

    @source_kubernetes_ids.setter
    def source_kubernetes_ids(self, value: Optional[Sequence[str]]):
        pulumi.set(self, "source_kubernetes_ids", value)

    @property
    @pulumi.getter(name="sourceLoadBalancerUids")
    def source_load_balancer_uids(self) -> Optional[Sequence[str]]:
        """
        An array containing the IDs
        of the Load Balancers from which the inbound traffic will be accepted.
        """
        return pulumi.get(self, "source_load_balancer_uids")

    @source_load_balancer_uids.setter
    def source_load_balancer_uids(self, value: Optional[Sequence[str]]):
        pulumi.set(self, "source_load_balancer_uids", value)

    @property
    @pulumi.getter(name="sourceTags")
    def source_tags(self) -> Optional[Sequence[str]]:
        """
        A set of names of Tags corresponding to group of
        Droplets from which the inbound traffic will be accepted.
        """
        return pulumi.get(self, "source_tags")

    @source_tags.setter
    def source_tags(self, value: Optional[Sequence[str]]):
        pulumi.set(self, "source_tags", value)


@pulumi.input_type
class GetFirewallOutboundRuleArgs:
    def __init__(__self__, *,
                 protocol: str,
                 destination_addresses: Optional[Sequence[str]] = None,
                 destination_droplet_ids: Optional[Sequence[int]] = None,
                 destination_kubernetes_ids: Optional[Sequence[str]] = None,
                 destination_load_balancer_uids: Optional[Sequence[str]] = None,
                 destination_tags: Optional[Sequence[str]] = None,
                 port_range: Optional[str] = None):
        """
        :param str protocol: The type of traffic to be allowed.
               This may be one of "tcp", "udp", or "icmp".
        :param Sequence[str] destination_addresses: An array of strings containing the IPv4
               addresses, IPv6 addresses, IPv4 CIDRs, and/or IPv6 CIDRs to which the
               outbound traffic will be allowed.
        :param Sequence[int] destination_droplet_ids: An array containing the IDs of
               the Droplets to which the outbound traffic will be allowed.
        :param Sequence[str] destination_load_balancer_uids: An array containing the IDs
               of the Load Balancers to which the outbound traffic will be allowed.
        :param Sequence[str] destination_tags: An array containing the names of Tags
               corresponding to groups of Droplets to which the outbound traffic will
               be allowed.
               traffic.
        :param str port_range: The ports on which traffic will be allowed
               specified as a string containing a single port, a range (e.g. "8000-9000"),
               or "1-65535" to open all ports for a protocol. Required for when protocol is
               `tcp` or `udp`.
        """
        pulumi.set(__self__, "protocol", protocol)
        if destination_addresses is not None:
            pulumi.set(__self__, "destination_addresses", destination_addresses)
        if destination_droplet_ids is not None:
            pulumi.set(__self__, "destination_droplet_ids", destination_droplet_ids)
        if destination_kubernetes_ids is not None:
            pulumi.set(__self__, "destination_kubernetes_ids", destination_kubernetes_ids)
        if destination_load_balancer_uids is not None:
            pulumi.set(__self__, "destination_load_balancer_uids", destination_load_balancer_uids)
        if destination_tags is not None:
            pulumi.set(__self__, "destination_tags", destination_tags)
        if port_range is not None:
            pulumi.set(__self__, "port_range", port_range)

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        The type of traffic to be allowed.
        This may be one of "tcp", "udp", or "icmp".
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: str):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="destinationAddresses")
    def destination_addresses(self) -> Optional[Sequence[str]]:
        """
        An array of strings containing the IPv4
        addresses, IPv6 addresses, IPv4 CIDRs, and/or IPv6 CIDRs to which the
        outbound traffic will be allowed.
        """
        return pulumi.get(self, "destination_addresses")

    @destination_addresses.setter
    def destination_addresses(self, value: Optional[Sequence[str]]):
        pulumi.set(self, "destination_addresses", value)

    @property
    @pulumi.getter(name="destinationDropletIds")
    def destination_droplet_ids(self) -> Optional[Sequence[int]]:
        """
        An array containing the IDs of
        the Droplets to which the outbound traffic will be allowed.
        """
        return pulumi.get(self, "destination_droplet_ids")

    @destination_droplet_ids.setter
    def destination_droplet_ids(self, value: Optional[Sequence[int]]):
        pulumi.set(self, "destination_droplet_ids", value)

    @property
    @pulumi.getter(name="destinationKubernetesIds")
    def destination_kubernetes_ids(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "destination_kubernetes_ids")

    @destination_kubernetes_ids.setter
    def destination_kubernetes_ids(self, value: Optional[Sequence[str]]):
        pulumi.set(self, "destination_kubernetes_ids", value)

    @property
    @pulumi.getter(name="destinationLoadBalancerUids")
    def destination_load_balancer_uids(self) -> Optional[Sequence[str]]:
        """
        An array containing the IDs
        of the Load Balancers to which the outbound traffic will be allowed.
        """
        return pulumi.get(self, "destination_load_balancer_uids")

    @destination_load_balancer_uids.setter
    def destination_load_balancer_uids(self, value: Optional[Sequence[str]]):
        pulumi.set(self, "destination_load_balancer_uids", value)

    @property
    @pulumi.getter(name="destinationTags")
    def destination_tags(self) -> Optional[Sequence[str]]:
        """
        An array containing the names of Tags
        corresponding to groups of Droplets to which the outbound traffic will
        be allowed.
        traffic.
        """
        return pulumi.get(self, "destination_tags")

    @destination_tags.setter
    def destination_tags(self, value: Optional[Sequence[str]]):
        pulumi.set(self, "destination_tags", value)

    @property
    @pulumi.getter(name="portRange")
    def port_range(self) -> Optional[str]:
        """
        The ports on which traffic will be allowed
        specified as a string containing a single port, a range (e.g. "8000-9000"),
        or "1-65535" to open all ports for a protocol. Required for when protocol is
        `tcp` or `udp`.
        """
        return pulumi.get(self, "port_range")

    @port_range.setter
    def port_range(self, value: Optional[str]):
        pulumi.set(self, "port_range", value)


@pulumi.input_type
class GetImagesFilterArgs:
    def __init__(__self__, *,
                 key: str,
                 values: Sequence[str],
                 all: Optional[bool] = None,
                 match_by: Optional[str] = None):
        """
        :param str key: Filter the images by this key. This may be one of `distribution`, `error_message`,
               `id`, `image`, `min_disk_size`, `name`, `private`, `regions`, `size_gigabytes`, `slug`, `status`,
               `tags`, or `type`.
        :param Sequence[str] values: A list of values to match against the `key` field. Only retrieves images
               where the `key` field takes on one or more of the values provided here.
        :param bool all: Set to `true` to require that a field match all of the `values` instead of just one or more of
               them. This is useful when matching against multi-valued fields such as lists or sets where you want to ensure
               that all of the `values` are present in the list or set.
        :param str match_by: One of `exact` (default), `re`, or `substring`. For string-typed fields, specify `re` to
               match by using the `values` as regular expressions, or specify `substring` to match by treating the `values` as
               substrings to find within the string field.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)
        if all is not None:
            pulumi.set(__self__, "all", all)
        if match_by is not None:
            pulumi.set(__self__, "match_by", match_by)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Filter the images by this key. This may be one of `distribution`, `error_message`,
        `id`, `image`, `min_disk_size`, `name`, `private`, `regions`, `size_gigabytes`, `slug`, `status`,
        `tags`, or `type`.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: str):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        A list of values to match against the `key` field. Only retrieves images
        where the `key` field takes on one or more of the values provided here.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def all(self) -> Optional[bool]:
        """
        Set to `true` to require that a field match all of the `values` instead of just one or more of
        them. This is useful when matching against multi-valued fields such as lists or sets where you want to ensure
        that all of the `values` are present in the list or set.
        """
        return pulumi.get(self, "all")

    @all.setter
    def all(self, value: Optional[bool]):
        pulumi.set(self, "all", value)

    @property
    @pulumi.getter(name="matchBy")
    def match_by(self) -> Optional[str]:
        """
        One of `exact` (default), `re`, or `substring`. For string-typed fields, specify `re` to
        match by using the `values` as regular expressions, or specify `substring` to match by treating the `values` as
        substrings to find within the string field.
        """
        return pulumi.get(self, "match_by")

    @match_by.setter
    def match_by(self, value: Optional[str]):
        pulumi.set(self, "match_by", value)


@pulumi.input_type
class GetImagesSortArgs:
    def __init__(__self__, *,
                 key: str,
                 direction: Optional[str] = None):
        """
        :param str key: Sort the images by this key. This may be one of `distribution`, `error_message`, `id`,
               `image`, `min_disk_size`, `name`, `private`, `size_gigabytes`, `slug`, `status`, or `type`.
        :param str direction: The sort direction. This may be either `asc` or `desc`.
        """
        pulumi.set(__self__, "key", key)
        if direction is not None:
            pulumi.set(__self__, "direction", direction)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Sort the images by this key. This may be one of `distribution`, `error_message`, `id`,
        `image`, `min_disk_size`, `name`, `private`, `size_gigabytes`, `slug`, `status`, or `type`.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: str):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def direction(self) -> Optional[str]:
        """
        The sort direction. This may be either `asc` or `desc`.
        """
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: Optional[str]):
        pulumi.set(self, "direction", value)


@pulumi.input_type
class GetProjectsFilterArgs:
    def __init__(__self__, *,
                 key: str,
                 values: Sequence[str],
                 all: Optional[bool] = None,
                 match_by: Optional[str] = None):
        """
        :param str key: Filter the projects by this key. This may be one of `name`,
               `purpose`, `description`, `environment`, or `is_default`.
        :param Sequence[str] values: A list of values to match against the `key` field. Only retrieves projects
               where the `key` field takes on one or more of the values provided here.
        :param bool all: Set to `true` to require that a field match all of the `values` instead of just one or more of
               them. This is useful when matching against multi-valued fields such as lists or sets where you want to ensure
               that all of the `values` are present in the list or set.
        :param str match_by: One of `exact` (default), `re`, or `substring`. For string-typed fields, specify `re` to
               match by using the `values` as regular expressions, or specify `substring` to match by treating the `values` as
               substrings to find within the string field.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)
        if all is not None:
            pulumi.set(__self__, "all", all)
        if match_by is not None:
            pulumi.set(__self__, "match_by", match_by)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Filter the projects by this key. This may be one of `name`,
        `purpose`, `description`, `environment`, or `is_default`.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: str):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        A list of values to match against the `key` field. Only retrieves projects
        where the `key` field takes on one or more of the values provided here.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def all(self) -> Optional[bool]:
        """
        Set to `true` to require that a field match all of the `values` instead of just one or more of
        them. This is useful when matching against multi-valued fields such as lists or sets where you want to ensure
        that all of the `values` are present in the list or set.
        """
        return pulumi.get(self, "all")

    @all.setter
    def all(self, value: Optional[bool]):
        pulumi.set(self, "all", value)

    @property
    @pulumi.getter(name="matchBy")
    def match_by(self) -> Optional[str]:
        """
        One of `exact` (default), `re`, or `substring`. For string-typed fields, specify `re` to
        match by using the `values` as regular expressions, or specify `substring` to match by treating the `values` as
        substrings to find within the string field.
        """
        return pulumi.get(self, "match_by")

    @match_by.setter
    def match_by(self, value: Optional[str]):
        pulumi.set(self, "match_by", value)


@pulumi.input_type
class GetProjectsSortArgs:
    def __init__(__self__, *,
                 key: str,
                 direction: Optional[str] = None):
        """
        :param str key: Sort the projects by this key. This may be one of `name`,
               `purpose`, `description`, or `environment`.
        :param str direction: The sort direction. This may be either `asc` or `desc`.
        """
        pulumi.set(__self__, "key", key)
        if direction is not None:
            pulumi.set(__self__, "direction", direction)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Sort the projects by this key. This may be one of `name`,
        `purpose`, `description`, or `environment`.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: str):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def direction(self) -> Optional[str]:
        """
        The sort direction. This may be either `asc` or `desc`.
        """
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: Optional[str]):
        pulumi.set(self, "direction", value)


@pulumi.input_type
class GetRecordsFilterArgs:
    def __init__(__self__, *,
                 key: str,
                 values: Sequence[str],
                 all: Optional[bool] = None,
                 match_by: Optional[str] = None):
        """
        :param str key: Filter the DNS records by this key. This may be one of `domain`, `flags`, `name`, `port`,
               `priority`, `tag`, `ttl`, `type`, `value`, or `weight`.
        :param Sequence[str] values: A list of values to match against the `key` field. Only retrieves DNS records
               where the `key` field takes on one or more of the values provided here.
        :param bool all: Set to `true` to require that a field match all of the `values` instead of just one or more of
               them. This is useful when matching against multi-valued fields such as lists or sets where you want to ensure
               that all of the `values` are present in the list or set.
        :param str match_by: One of `exact` (default), `re`, or `substring`. For string-typed fields, specify `re` to
               match by using the `values` as regular expressions, or specify `substring` to match by treating the `values` as
               substrings to find within the string field.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)
        if all is not None:
            pulumi.set(__self__, "all", all)
        if match_by is not None:
            pulumi.set(__self__, "match_by", match_by)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Filter the DNS records by this key. This may be one of `domain`, `flags`, `name`, `port`,
        `priority`, `tag`, `ttl`, `type`, `value`, or `weight`.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: str):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        A list of values to match against the `key` field. Only retrieves DNS records
        where the `key` field takes on one or more of the values provided here.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def all(self) -> Optional[bool]:
        """
        Set to `true` to require that a field match all of the `values` instead of just one or more of
        them. This is useful when matching against multi-valued fields such as lists or sets where you want to ensure
        that all of the `values` are present in the list or set.
        """
        return pulumi.get(self, "all")

    @all.setter
    def all(self, value: Optional[bool]):
        pulumi.set(self, "all", value)

    @property
    @pulumi.getter(name="matchBy")
    def match_by(self) -> Optional[str]:
        """
        One of `exact` (default), `re`, or `substring`. For string-typed fields, specify `re` to
        match by using the `values` as regular expressions, or specify `substring` to match by treating the `values` as
        substrings to find within the string field.
        """
        return pulumi.get(self, "match_by")

    @match_by.setter
    def match_by(self, value: Optional[str]):
        pulumi.set(self, "match_by", value)


@pulumi.input_type
class GetRecordsSortArgs:
    def __init__(__self__, *,
                 key: str,
                 direction: Optional[str] = None):
        """
        :param str key: Sort the DNS records by this key. This may be one of `domain`, `flags`, `name`, `port`,
               `priority`, `tag`, `ttl`, `type`, `value`, or `weight`.
        :param str direction: The sort direction. This may be either `asc` or `desc`.
        """
        pulumi.set(__self__, "key", key)
        if direction is not None:
            pulumi.set(__self__, "direction", direction)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Sort the DNS records by this key. This may be one of `domain`, `flags`, `name`, `port`,
        `priority`, `tag`, `ttl`, `type`, `value`, or `weight`.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: str):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def direction(self) -> Optional[str]:
        """
        The sort direction. This may be either `asc` or `desc`.
        """
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: Optional[str]):
        pulumi.set(self, "direction", value)


@pulumi.input_type
class GetRegionsFilterArgs:
    def __init__(__self__, *,
                 key: str,
                 values: Sequence[str],
                 all: Optional[bool] = None,
                 match_by: Optional[str] = None):
        """
        :param str key: Filter the regions by this key. This may be one of `slug`,
               `name`, `available`, `features`, or `sizes`.
        :param Sequence[str] values: A list of values to match against the `key` field. Only retrieves regions
               where the `key` field takes on one or more of the values provided here.
        :param bool all: Set to `true` to require that a field match all of the `values` instead of just one or more of
               them. This is useful when matching against multi-valued fields such as lists or sets where you want to ensure
               that all of the `values` are present in the list or set.
        :param str match_by: One of `exact` (default), `re`, or `substring`. For string-typed fields, specify `re` to
               match by using the `values` as regular expressions, or specify `substring` to match by treating the `values` as
               substrings to find within the string field.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)
        if all is not None:
            pulumi.set(__self__, "all", all)
        if match_by is not None:
            pulumi.set(__self__, "match_by", match_by)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Filter the regions by this key. This may be one of `slug`,
        `name`, `available`, `features`, or `sizes`.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: str):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        A list of values to match against the `key` field. Only retrieves regions
        where the `key` field takes on one or more of the values provided here.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def all(self) -> Optional[bool]:
        """
        Set to `true` to require that a field match all of the `values` instead of just one or more of
        them. This is useful when matching against multi-valued fields such as lists or sets where you want to ensure
        that all of the `values` are present in the list or set.
        """
        return pulumi.get(self, "all")

    @all.setter
    def all(self, value: Optional[bool]):
        pulumi.set(self, "all", value)

    @property
    @pulumi.getter(name="matchBy")
    def match_by(self) -> Optional[str]:
        """
        One of `exact` (default), `re`, or `substring`. For string-typed fields, specify `re` to
        match by using the `values` as regular expressions, or specify `substring` to match by treating the `values` as
        substrings to find within the string field.
        """
        return pulumi.get(self, "match_by")

    @match_by.setter
    def match_by(self, value: Optional[str]):
        pulumi.set(self, "match_by", value)


@pulumi.input_type
class GetRegionsSortArgs:
    def __init__(__self__, *,
                 key: str,
                 direction: Optional[str] = None):
        """
        :param str key: Sort the regions by this key. This may be one of `slug`,
               `name`, or `available`.
        :param str direction: The sort direction. This may be either `asc` or `desc`.
        """
        pulumi.set(__self__, "key", key)
        if direction is not None:
            pulumi.set(__self__, "direction", direction)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Sort the regions by this key. This may be one of `slug`,
        `name`, or `available`.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: str):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def direction(self) -> Optional[str]:
        """
        The sort direction. This may be either `asc` or `desc`.
        """
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: Optional[str]):
        pulumi.set(self, "direction", value)


@pulumi.input_type
class GetSizesFilterArgs:
    def __init__(__self__, *,
                 key: str,
                 values: Sequence[str],
                 all: Optional[bool] = None,
                 match_by: Optional[str] = None):
        """
        :param str key: Filter the sizes by this key. This may be one of `slug`,
               `regions`, `memory`, `vcpus`, `disk`, `transfer`, `price_monthly`,
               `price_hourly`, or `available`.
        :param Sequence[str] values: Only retrieves sizes which keys has value that matches
               one of the values provided here.
        :param bool all: Set to `true` to require that a field match all of the `values` instead of just one or more of
               them. This is useful when matching against multi-valued fields such as lists or sets where you want to ensure
               that all of the `values` are present in the list or set.
        :param str match_by: One of `exact` (default), `re`, or `substring`. For string-typed fields, specify `re` to
               match by using the `values` as regular expressions, or specify `substring` to match by treating the `values` as
               substrings to find within the string field.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)
        if all is not None:
            pulumi.set(__self__, "all", all)
        if match_by is not None:
            pulumi.set(__self__, "match_by", match_by)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Filter the sizes by this key. This may be one of `slug`,
        `regions`, `memory`, `vcpus`, `disk`, `transfer`, `price_monthly`,
        `price_hourly`, or `available`.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: str):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        Only retrieves sizes which keys has value that matches
        one of the values provided here.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def all(self) -> Optional[bool]:
        """
        Set to `true` to require that a field match all of the `values` instead of just one or more of
        them. This is useful when matching against multi-valued fields such as lists or sets where you want to ensure
        that all of the `values` are present in the list or set.
        """
        return pulumi.get(self, "all")

    @all.setter
    def all(self, value: Optional[bool]):
        pulumi.set(self, "all", value)

    @property
    @pulumi.getter(name="matchBy")
    def match_by(self) -> Optional[str]:
        """
        One of `exact` (default), `re`, or `substring`. For string-typed fields, specify `re` to
        match by using the `values` as regular expressions, or specify `substring` to match by treating the `values` as
        substrings to find within the string field.
        """
        return pulumi.get(self, "match_by")

    @match_by.setter
    def match_by(self, value: Optional[str]):
        pulumi.set(self, "match_by", value)


@pulumi.input_type
class GetSizesSortArgs:
    def __init__(__self__, *,
                 key: str,
                 direction: Optional[str] = None):
        """
        :param str key: Sort the sizes by this key. This may be one of `slug`,
               `memory`, `vcpus`, `disk`, `transfer`, `price_monthly`, or `price_hourly`.
        :param str direction: The sort direction. This may be either `asc` or `desc`.
        """
        pulumi.set(__self__, "key", key)
        if direction is not None:
            pulumi.set(__self__, "direction", direction)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Sort the sizes by this key. This may be one of `slug`,
        `memory`, `vcpus`, `disk`, `transfer`, `price_monthly`, or `price_hourly`.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: str):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def direction(self) -> Optional[str]:
        """
        The sort direction. This may be either `asc` or `desc`.
        """
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: Optional[str]):
        pulumi.set(self, "direction", value)


@pulumi.input_type
class GetSpacesBucketsFilterArgs:
    def __init__(__self__, *,
                 key: str,
                 values: Sequence[str],
                 all: Optional[bool] = None,
                 match_by: Optional[str] = None):
        """
        :param str key: Filter the images by this key. This may be one of `bucket_domain_name`, `name`, `region`, or `urn`.
        :param Sequence[str] values: A list of values to match against the `key` field. Only retrieves Spaces buckets
               where the `key` field takes on one or more of the values provided here.
        :param bool all: Set to `true` to require that a field match all of the `values` instead of just one or more of
               them. This is useful when matching against multi-valued fields such as lists or sets where you want to ensure
               that all of the `values` are present in the list or set.
        :param str match_by: One of `exact` (default), `re`, or `substring`. For string-typed fields, specify `re` to
               match by using the `values` as regular expressions, or specify `substring` to match by treating the `values` as
               substrings to find within the string field.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)
        if all is not None:
            pulumi.set(__self__, "all", all)
        if match_by is not None:
            pulumi.set(__self__, "match_by", match_by)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Filter the images by this key. This may be one of `bucket_domain_name`, `name`, `region`, or `urn`.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: str):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        A list of values to match against the `key` field. Only retrieves Spaces buckets
        where the `key` field takes on one or more of the values provided here.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def all(self) -> Optional[bool]:
        """
        Set to `true` to require that a field match all of the `values` instead of just one or more of
        them. This is useful when matching against multi-valued fields such as lists or sets where you want to ensure
        that all of the `values` are present in the list or set.
        """
        return pulumi.get(self, "all")

    @all.setter
    def all(self, value: Optional[bool]):
        pulumi.set(self, "all", value)

    @property
    @pulumi.getter(name="matchBy")
    def match_by(self) -> Optional[str]:
        """
        One of `exact` (default), `re`, or `substring`. For string-typed fields, specify `re` to
        match by using the `values` as regular expressions, or specify `substring` to match by treating the `values` as
        substrings to find within the string field.
        """
        return pulumi.get(self, "match_by")

    @match_by.setter
    def match_by(self, value: Optional[str]):
        pulumi.set(self, "match_by", value)


@pulumi.input_type
class GetSpacesBucketsSortArgs:
    def __init__(__self__, *,
                 key: str,
                 direction: Optional[str] = None):
        """
        :param str key: Sort the images by this key. This may be one of `bucket_domain_name`, `name`, `region`, or `urn`.
        :param str direction: The sort direction. This may be either `asc` or `desc`.
        """
        pulumi.set(__self__, "key", key)
        if direction is not None:
            pulumi.set(__self__, "direction", direction)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Sort the images by this key. This may be one of `bucket_domain_name`, `name`, `region`, or `urn`.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: str):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def direction(self) -> Optional[str]:
        """
        The sort direction. This may be either `asc` or `desc`.
        """
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: Optional[str]):
        pulumi.set(self, "direction", value)


@pulumi.input_type
class GetSshKeysFilterArgs:
    def __init__(__self__, *,
                 key: str,
                 values: Sequence[str],
                 all: Optional[bool] = None,
                 match_by: Optional[str] = None):
        """
        :param str key: Filter the SSH Keys by this key. This may be one of `name`, `public_key`, or `fingerprint`.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)
        if all is not None:
            pulumi.set(__self__, "all", all)
        if match_by is not None:
            pulumi.set(__self__, "match_by", match_by)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Filter the SSH Keys by this key. This may be one of `name`, `public_key`, or `fingerprint`.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: str):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def all(self) -> Optional[bool]:
        return pulumi.get(self, "all")

    @all.setter
    def all(self, value: Optional[bool]):
        pulumi.set(self, "all", value)

    @property
    @pulumi.getter(name="matchBy")
    def match_by(self) -> Optional[str]:
        return pulumi.get(self, "match_by")

    @match_by.setter
    def match_by(self, value: Optional[str]):
        pulumi.set(self, "match_by", value)


@pulumi.input_type
class GetSshKeysSortArgs:
    def __init__(__self__, *,
                 key: str,
                 direction: Optional[str] = None):
        """
        :param str key: Sort the SSH Keys by this key. This may be one of `name`, `public_key`, or `fingerprint`.
        :param str direction: The sort direction. This may be either `asc` or `desc`.
        """
        pulumi.set(__self__, "key", key)
        if direction is not None:
            pulumi.set(__self__, "direction", direction)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Sort the SSH Keys by this key. This may be one of `name`, `public_key`, or `fingerprint`.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: str):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def direction(self) -> Optional[str]:
        """
        The sort direction. This may be either `asc` or `desc`.
        """
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: Optional[str]):
        pulumi.set(self, "direction", value)


@pulumi.input_type
class GetTagsFilterArgs:
    def __init__(__self__, *,
                 key: str,
                 values: Sequence[str],
                 all: Optional[bool] = None,
                 match_by: Optional[str] = None):
        """
        :param str key: Filter the tags by this key. This may be one of `name`, `total_resource_count`,  `droplets_count`, `images_count`, `volumes_count`, `volume_snapshots_count`, or `databases_count`.
        :param Sequence[str] values: Only retrieves tags which keys has value that matches
               one of the values provided here.
        :param bool all: Set to `true` to require that a field match all of the `values` instead of just one or more of
               them. This is useful when matching against multi-valued fields such as lists or sets where you want to ensure
               that all of the `values` are present in the list or set.
        :param str match_by: One of `exact` (default), `re`, or `substring`. For string-typed fields, specify `re` to
               match by using the `values` as regular expressions, or specify `substring` to match by treating the `values` as
               substrings to find within the string field.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)
        if all is not None:
            pulumi.set(__self__, "all", all)
        if match_by is not None:
            pulumi.set(__self__, "match_by", match_by)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Filter the tags by this key. This may be one of `name`, `total_resource_count`,  `droplets_count`, `images_count`, `volumes_count`, `volume_snapshots_count`, or `databases_count`.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: str):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        Only retrieves tags which keys has value that matches
        one of the values provided here.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def all(self) -> Optional[bool]:
        """
        Set to `true` to require that a field match all of the `values` instead of just one or more of
        them. This is useful when matching against multi-valued fields such as lists or sets where you want to ensure
        that all of the `values` are present in the list or set.
        """
        return pulumi.get(self, "all")

    @all.setter
    def all(self, value: Optional[bool]):
        pulumi.set(self, "all", value)

    @property
    @pulumi.getter(name="matchBy")
    def match_by(self) -> Optional[str]:
        """
        One of `exact` (default), `re`, or `substring`. For string-typed fields, specify `re` to
        match by using the `values` as regular expressions, or specify `substring` to match by treating the `values` as
        substrings to find within the string field.
        """
        return pulumi.get(self, "match_by")

    @match_by.setter
    def match_by(self, value: Optional[str]):
        pulumi.set(self, "match_by", value)


@pulumi.input_type
class GetTagsSortArgs:
    def __init__(__self__, *,
                 key: str,
                 direction: Optional[str] = None):
        """
        :param str key: Sort the tags by this key. This may be one of `name`, `total_resource_count`,  `droplets_count`, `images_count`, `volumes_count`, `volume_snapshots_count`, or `databases_count`.
        :param str direction: The sort direction. This may be either `asc` or `desc`.
        """
        pulumi.set(__self__, "key", key)
        if direction is not None:
            pulumi.set(__self__, "direction", direction)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Sort the tags by this key. This may be one of `name`, `total_resource_count`,  `droplets_count`, `images_count`, `volumes_count`, `volume_snapshots_count`, or `databases_count`.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: str):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def direction(self) -> Optional[str]:
        """
        The sort direction. This may be either `asc` or `desc`.
        """
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: Optional[str]):
        pulumi.set(self, "direction", value)


