/*!
 * Copyright (c) 2012 - 2021, Anaconda, Inc., and Bokeh Contributors
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * Neither the name of Anaconda nor the names of any contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */
(function(root, factory) {
  factory(root["Bokeh"], undefined);
})(this, function(Bokeh, version) {
  let define;
  return (function(modules, entry, aliases, externals) {
    const bokeh = typeof Bokeh !== "undefined" && (version != null ? Bokeh[version] : Bokeh);
    if (bokeh != null) {
      return bokeh.register_plugin(modules, entry, aliases);
    } else {
      throw new Error("Cannot find Bokeh " + version + ". You have to load it prior to loading plugins.");
    }
  })
({
"988b553afa": function _(a,e,t,c,o){c();const r=a("989790dae8");o("DataPipe",r.DataPipe);const p=a("86e287dc15");o("ImagePipe",p.ImagePipe);const D=a("20c0382ad2");o("ImageDataSource",D.ImageDataSource);const S=a("e5ac72e4af");o("SpectraDataSource",S.SpectraDataSource);(0,a("@bokehjs/base").register_models)({DataPipe:r.DataPipe,ImagePipe:p.ImagePipe,ImageDataSource:D.ImageDataSource,SpectraDataSource:S.SpectraDataSource})},
"989790dae8": function _(e,i,s,t,n){t();const c=e("@bokehjs/models/sources/data_source"),o=e("@bokehjs/core/util/serialization");class a extends c.DataSource{constructor(e){super(e),this.send_queue={},this.pending={},this.incoming_callbacks={};let i=`ws://${this.address[0]}:${this.address[1]}`;console.log("datapipe url:",i),this.websocket=new WebSocket(i),this.websocket.binaryType="arraybuffer",this.websocket.onmessage=e=>{if("string"==typeof e.data||e.data instanceof String){let i=function e(i){const s=Array.isArray(i)?new Array:{};for(const t in i){let n=i[t];if((0,o.is_NDArray_ref)(n)){const e=new Map;s[t]=(0,o.decode_NDArray)(n,e)}else s[t]="object"==typeof n&&null!==n?e(n):n}return s}(JSON.parse(e.data));if("id"in i&&"direction"in i&&"message"in i){let{id:e,message:s,direction:t}=i;if("j2p"==t)if(e in this.pending){let{cb:i}=this.pending[e];if(delete this.pending[e],e in this.send_queue&&this.send_queue[e].length>0){let{cb:i,msg:s}=this.send_queue[e].shift();this.pending[e]={cb:i},this.websocket.send(JSON.stringify(s))}i(s)}else console.log("message received but could not find id");else if(e in this.incoming_callbacks){let i=this.incoming_callbacks[e](s);this.websocket.send(JSON.stringify({id:e,direction:t,message:i,session:object_id(this)}))}}else console.log(`datapipe received message without one of 'id', 'message' or 'direction': ${i}`)}else console.log("datapipe received binary data",e.data.byteLength,"bytes")};let s=object_id(this);this.websocket.onopen=()=>{this.websocket.send(JSON.stringify({id:"initialize",direction:"j2p",session:s}))}}initialize(){super.initialize();(()=>{null!=this.init_script&&this.init_script.execute(this)})()}register(e,i){this.incoming_callbacks[e]=i}send(e,i,s){let t={id:e,message:i,direction:"j2p",session:object_id(this)};if(e in this.pending)e in this.send_queue?this.send_queue[e].push({cb:s,msg:t}):this.send_queue[e]=[{cb:s,msg:t}];else if(e in this.send_queue&&this.send_queue[e].length>0){this.send_queue[e].push({cb:s,msg:t});{let{cb:i,msg:s}=this.send_queue[e].shift();this.pending[e]={cb:i},this.websocket.send(JSON.stringify(s))}}else this.pending[e]={cb:s},this.websocket.send(JSON.stringify(t))}static init_DataPipe(){this.define((({Tuple:e,String:i,Number:s,Any:t})=>({init_script:[t],address:[e(i,s)]})))}}s.DataPipe=a,a.__name__="DataPipe",a.init_DataPipe()},
"86e287dc15": function _(e,i,s,t,n){t();const d=e("@bokehjs/models/sources/data_source"),o=e("@bokehjs/core/util/serialization");class a extends d.DataSource{constructor(e){super(e),this.queue={},this.pending={},this.position={};let i=`ws://${this.address[0]}:${this.address[1]}`;console.log("imagepipe url:",i),this.websocket=new WebSocket(i),this.websocket.binaryType="arraybuffer",this.websocket.onmessage=e=>{if("string"==typeof e.data||e.data instanceof String){let i=function e(i){const s=Array.isArray(i)?new Array:{};for(const t in i){let n=i[t];if((0,o.is_NDArray_ref)(n)){const e=new Map;s[t]=(0,o.decode_NDArray)(n,e)}else s[t]="object"==typeof n&&null!==n?e(n):n}return s}(JSON.parse(e.data));if("id"in i&&"message"in i){let{id:e,message:s}=i,{cb:t,index:n}=this.pending[e];if(delete this.pending[e],e in this.queue){let{cb:i,message:s,index:t}=this.queue[e];delete this.queue[e],this.pending[e]={cb:i,index:t},this.websocket.send(JSON.stringify(s))}this.position[e]={index:n},t(s)}else console.log(`imagepipe received data without 'id' and/or 'message' field: ${i}`)}else console.log("imagepipe received binary data",e.data.byteLength,"bytes")};let s=object_id(this);this.websocket.onopen=()=>{this.websocket.send(JSON.stringify({action:"initialize",session:s}))}}initialize(){super.initialize();(()=>{null!=this.init_script&&this.init_script.execute(this)})()}channel(e,i,s){let t={action:"channel",index:e,id:s,session:object_id(this)};s in this.pending?this.queue[s]={cb:i,message:t,index:e}:(this.websocket.send(JSON.stringify(t)),this.pending[s]={cb:i,index:e})}spectra(e,i,s){let t={action:"spectra",index:e,id:s,session:object_id(this)};s in this.pending?this.queue[s]={cb:i,message:t,index:e}:(this.websocket.send(JSON.stringify(t)),this.pending[s]={cb:i,index:e})}refresh(e,i,s=[]){let{index:t}=i in this.position?this.position[i]:{index:s};if(2===t.length){let s={action:"channel",index:t,id:i,session:object_id(this)};i in this.pending?this.queue[i]={cb:e,message:s,index:t}:(this.websocket.send(JSON.stringify(s)),this.pending[i]={cb:e,index:t})}else if(3===t.length){let s={action:"spectra",index:t,id:i,session:object_id(this)};i in this.pending?this.queue[i]={cb:e,message:s,index:t}:(this.websocket.send(JSON.stringify(s)),this.pending[i]={cb:e,index:t})}}static init_ImagePipe(){this.define((({Tuple:e,String:i,Number:s,Any:t})=>({init_script:[t],address:[e(i,s)],shape:[e(s,s,s,s)]})))}}s.ImagePipe=a,a.__name__="ImagePipe",a.init_ImagePipe()},
"20c0382ad2": function _(i,e,t,a,s){a();const c=i("@bokehjs/models/sources/column_data_source"),n=i("@bokehjs/core/util/string"),r=i("86e287dc15");class u extends c.ColumnDataSource{constructor(i){super(i),this.imid=(0,n.uuid4)()}initialize(){super.initialize();(()=>{null!=this.init_script&&this.init_script.execute(this)})()}channel(i,e=0,t){this.image_source.channel([e,i],(a=>{this.cur_chan=[e,i],t&&t(a),this.data=a.chan}),this.imid)}refresh(i){this.image_source.refresh((e=>{i&&i(e),this.data=e.chan}),this.imid,[0,0])}static init_ImageDataSource(){this.define((({Tuple:i,Number:e,Ref:t,Any:a})=>({init_script:[a],image_source:[t(r.ImagePipe)],num_chans:[i(e,e)],cur_chan:[i(e,e)]})))}}t.ImageDataSource=u,u.__name__="ImageDataSource",u.init_ImageDataSource()},
"e5ac72e4af": function _(e,i,t,s,a){s();const c=e("@bokehjs/models/sources/column_data_source"),r=e("@bokehjs/core/util/string"),o=e("86e287dc15");class u extends c.ColumnDataSource{constructor(e){super(e),this.imid=(0,r.uuid4)(),console.log("spectra data source id:",this.imid)}initialize(){super.initialize()}spectra(e,i,t=0){this.image_source.spectra([e,i,t],(e=>this.data=e.spectrum),this.imid)}refresh(){this.image_source.refresh((e=>this.data=e.spectrum),this.imid,[0,0,0])}static init_SpectraDataSource(){this.define((({Ref:e})=>({image_source:[e(o.ImagePipe)]})))}}t.SpectraDataSource=u,u.__name__="SpectraDataSource",u.init_SpectraDataSource()},
}, "988b553afa", {"index":"988b553afa","src/bokeh/sources/data_pipe":"989790dae8","src/bokeh/sources/image_pipe":"86e287dc15","src/bokeh/sources/image_data_source":"20c0382ad2","src/bokeh/sources/spectra_data_source":"e5ac72e4af"}, {});});
