# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Mon Jan 24 11:35:04 2022
#  Target Database = postgresql
#
import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_fura.db.tables.usr_auth_key import tUsrAuthKey
from bs_fura.db.tables.usr_auth import tUsrAuth

class dUsrAuthLockOne:

    def __init__(self, dbcon: mettle.db.IConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self._dbcon   = dbcon
        self._dbstmnt = None
        self.irec     = tUsrAuthKey()
        self.orec     = tUsrAuth()

    def __del__(self):
        """
        Destructor.
        """
        del self._dbstmnt

    def __enter__(self):
        """
        With statement enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        With statement exit.
        """
        self._destroy()

    def _destroy(self):
        if self._dbstmnt == None:
            return

        del self._dbstmnt
        self._dbstmnt = None

    def exec_deft(self,
                  site_id: int,
                  usr_id: str,
                  auth_type: str) -> "dUsrAuthLockOne":
        """
        Execute the query by setting all the inputs.

        :param site_id: int
        :param usr_id: str
        :param auth_type: str
        :return: Self for convenience.
        """
        self.irec.site_id = site_id
        self.irec.usr_id = usr_id
        self.irec.auth_type = auth_type

        return self.exec()

    def exec(self, irec: tUsrAuthKey = None) -> "dUsrAuthLockOne":
        """
        Execute the query, optionally passing in the input rec.

        :param irec:
        :return: Self for convenience.
        """
        if irec:
            self.irec._copy_from(irec)

        self._destroy()

        self._dbstmnt = self._dbcon.statement("UsrAuthLockOne", self._dbcon.STMNT_TYPE_READ)

        self._dbstmnt.sql("""select
  site_id,
  usr_id,
  auth_type,
  auth_data,
  fail_cnt,
  salt,
  last_ip,
  last_geo,
  last_succ,
  last_fail,
  modified_by,
  tm_stamp
from
  fura.UsrAuth
where
  site_id = :site_id and
  usr_id = :usr_id and
  auth_type = :auth_type for update nowait""")

        self._dbstmnt.bind_in("site_id", self.irec.site_id, int, 4)
        self._dbstmnt.bind_in("usr_id", self.irec.usr_id, str, 128)
        self._dbstmnt.bind_in("auth_type", self.irec.auth_type, str, 1)

        self._dbstmnt.bind_out("site_id", int, 4)
        self._dbstmnt.bind_out("usr_id", str, 128)
        self._dbstmnt.bind_out("auth_type", str, 1)
        self._dbstmnt.bind_out("auth_data", str, 4096)
        self._dbstmnt.bind_out("fail_cnt", int, 4)
        self._dbstmnt.bind_out("salt", str, 128)
        self._dbstmnt.bind_out("last_ip", str, 32)
        self._dbstmnt.bind_out("last_geo", str, 64)
        self._dbstmnt.bind_out("last_succ", datetime.datetime)
        self._dbstmnt.bind_out("last_fail", datetime.datetime)
        self._dbstmnt.bind_out("modified_by", str, 128)
        self._dbstmnt.bind_out("tm_stamp", datetime.datetime)

        self._dbcon.lock(self._dbstmnt)

        self._dbcon.execute(self._dbstmnt)

        if irec:
            irec._copy_from(self.irec)

        return self

    def fetch(self) -> bool:
        """
        Fetches the next row from the executed query.

        :return: True if a row is retreived.
        """
        if not self._dbcon.fetch(self._dbstmnt):
            return False

        self.orec.site_id = self._dbstmnt.result[0]
        self.orec.usr_id = self._dbstmnt.result[1]
        self.orec.auth_type = self._dbstmnt.result[2]
        self.orec.auth_data = self._dbstmnt.result[3]
        self.orec.fail_cnt = self._dbstmnt.result[4]
        self.orec.salt = self._dbstmnt.result[5]
        self.orec.last_ip = self._dbstmnt.result[6]
        self.orec.last_geo = self._dbstmnt.result[7]
        self.orec.last_succ = self._dbstmnt.result[8]
        self.orec.last_fail = self._dbstmnt.result[9]
        self.orec.modified_by = self._dbstmnt.result[10]
        self.orec.tm_stamp = self._dbstmnt.result[11]

        return True

    def fetch_all(self, outList: tUsrAuth.List, clearList: bool = True) -> int:
        """
        Fetch all the rows into the specified list and return the list count.

        :param outList:
        :param clearList:
        :return: Number of rows fetched.
        """
        if clearList:
            outList.clear()

        while self.fetch():
            outList.append(copy.deepcopy(self.orec))

        return len(outList)

