# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Mon Jan 24 11:35:04 2022
#  Target Database = postgresql
#
import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_fura.db.tables.site_cfg import tSiteCfg

class dSiteCfgUpdate:

    def __init__(self, dbcon: mettle.db.IAConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self._dbcon   = dbcon
        self._dbstmnt = None
        self.irec     = tSiteCfg()

    def __del__(self):
        """
        Destructor.
        """
        del self._dbstmnt

    def __enter__(self):
        """
        With statement enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        With statement exit.
        """
        self._destroy()

    def _destroy(self):
        if self._dbstmnt == None:
            return

        del self._dbstmnt
        self._dbstmnt = None

    async def exec_deft(self,
                        site_id: int,
                        id: str,
                        descr: str,
                        value: str,
                        modified_by: str) -> "dSiteCfgUpdate":
        """
        Execute the query by setting all the inputs.

        :param site_id: int
        :param id: str
        :param descr: str
        :param value: str
        :param modified_by: str
        :param tm_stamp: datetime.datetime
        :return: Self for convenience.
        """
        self.irec.site_id = site_id
        self.irec.id = id
        self.irec.descr = descr
        self.irec.value = value
        self.irec.modified_by = modified_by

        return await self.exec()

    async def exec(self, irec: tSiteCfg = None) -> "dSiteCfgUpdate":
        """
        Execute the query, optionally passing in the input rec.

        :param irec:
        :return: Self for convenience.
        """
        if irec:
            self.irec._copy_from(irec)

        self._destroy()

        self._dbstmnt = await self._dbcon.statement("SiteCfgUpdate", self._dbcon.STMNT_TYPE_CUD)

        self._dbstmnt.sql("""update
  fura.SiteCfg
set
  descr = :descr,
  value = :value,
  modified_by = :modified_by,
  tm_stamp = :tm_stamp
where
  site_id = :site_id and
  id = :id""")

        self.irec.tm_stamp = await self._dbcon.get_timestamp()

        self._dbstmnt.bind_in("site_id", self.irec.site_id, int, 4)
        self._dbstmnt.bind_in("id", self.irec.id, str, 256)
        self._dbstmnt.bind_in("descr", self.irec.descr, str, 256)
        self._dbstmnt.bind_in("value", self.irec.value, str, 4096)
        self._dbstmnt.bind_in("modified_by", self.irec.modified_by, str, 64)
        self._dbstmnt.bind_in("tm_stamp", self.irec.tm_stamp, datetime.datetime)

        await self._dbcon.execute(self._dbstmnt)

        if irec:
            irec._copy_from(self.irec)

        return self

