# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Mon Jan 24 11:35:04 2022
#  Target Database = postgresql
#
import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_fura.db.tables.site import tSite

class dSiteInsert:

    def __init__(self, dbcon: mettle.db.IAConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self._dbcon   = dbcon
        self._dbstmnt = None
        self.irec     = tSite()

    def __del__(self):
        """
        Destructor.
        """
        del self._dbstmnt

    def __enter__(self):
        """
        With statement enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        With statement exit.
        """
        self._destroy()

    def _destroy(self):
        if self._dbstmnt == None:
            return

        del self._dbstmnt
        self._dbstmnt = None

    async def exec_deft(self,
                        id: int,
                        code: str,
                        descr: str,
                        status: str,
                        cc: str,
                        ccy: str,
                        dc: str,
                        modified_by: str,
                        tm_stamp: datetime.datetime) -> "dSiteInsert":
        """
        Execute the query by setting all the inputs.

        :param id: int
        :param code: str
        :param descr: str
        :param status: str
        :param cc: str
        :param ccy: str
        :param dc: str
        :param modified_by: str
        :param tm_stamp: datetime.datetime
        :return: Self for convenience.
        """
        self.irec.id = id
        self.irec.code = code
        self.irec.descr = descr
        self.irec.status = status
        self.irec.cc = cc
        self.irec.ccy = ccy
        self.irec.dc = dc
        self.irec.modified_by = modified_by
        self.irec.tm_stamp = tm_stamp

        return await self.exec()

    async def exec(self, irec: tSite = None) -> "dSiteInsert":
        """
        Execute the query, optionally passing in the input rec.

        :param irec:
        :return: Self for convenience.
        """
        if irec:
            self.irec._copy_from(irec)

        self._destroy()

        self._dbstmnt = await self._dbcon.statement("SiteInsert", self._dbcon.STMNT_TYPE_CUD)

        self._dbstmnt.sql("""insert into fura.Site (
  code,
  descr,
  status,
  cc,
  ccy,
  dc,
  modified_by,
  tm_stamp
) values (
  :code,
  :descr,
  :status,
  :cc,
  :ccy,
  :dc,
  :modified_by,
  :tm_stamp
)""")

        self.irec.tm_stamp = await self._dbcon.get_timestamp()

        self._dbstmnt.bind_in("code", self.irec.code, str, 32)
        self._dbstmnt.bind_in("descr", self.irec.descr, str, 256)
        self._dbstmnt.bind_in("status", self.irec.status, str, 1)
        self._dbstmnt.bind_in("cc", self.irec.cc, str, 2)
        self._dbstmnt.bind_in("ccy", self.irec.ccy, str, 3)
        self._dbstmnt.bind_in("dc", self.irec.dc, str, 3)
        self._dbstmnt.bind_in("modified_by", self.irec.modified_by, str, 128)
        self._dbstmnt.bind_in("tm_stamp", self.irec.tm_stamp, datetime.datetime)

        await self._dbcon.execute(self._dbstmnt)

        self.irec.id = await self._dbcon.post_get_sequence(self._dbstmnt, "fura.Site", "id", 4)

        if irec:
            irec._copy_from(self.irec)

        return self

