# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Mon Jan 24 11:35:04 2022
#  Target Database = postgresql
#
import asyncio
import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_fura.db.tables.token_hist import tTokenHist

from .token_hist_insert import dTokenHistInsert

class dTokenHist:

    def __init__(self, dbcon: mettle.db.IAConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self.rec    = tTokenHist()
        self._dbcon = dbcon

    def __enter__(self):
        """
        DAO enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        DAO exit.
        """
        pass

    async def insert_deft(self,
                          site_id: int,
                          id: str,
                          usr_id: str,
                          date_created: datetime.datetime,
                          expires: datetime.datetime,
                          use_cnt: int,
                          aud_id: str):
        """
        Insert the record setting all column values.

        :param site_id: int
        :param id: str
        :param usr_id: str
        :param date_created: datetime.datetime
        :param expires: datetime.datetime
        :param use_cnt: int
        :param aud_id: str
        :param tm_stamp: datetime.datetime
        """
        self.rec.site_id = site_id
        self.rec.id = id
        self.rec.usr_id = usr_id
        self.rec.date_created = date_created
        self.rec.expires = expires
        self.rec.use_cnt = use_cnt
        self.rec.aud_id = aud_id

        await self.insert()

    async def insert(self, irec: tTokenHist = None):
        """
        Insert the record in the database with the record or irec if it is not None.

        :param irec: If not None use this record to insert into the database.
        """
        if irec:
            self.rec._copy_from(irec)

        with dTokenHistInsert(self._dbcon) as _qry:
            await _qry.exec(self.rec)

        if irec:
            irec._copy_from(self.rec)

