# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Mon Jan 24 11:35:04 2022
#  Target Database = postgresql
#
import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_fura.db.tables.token_sentry import tTokenSentry

class dTokenSentryUpdate:

    def __init__(self, dbcon: mettle.db.IAConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self._dbcon   = dbcon
        self._dbstmnt = None
        self.irec     = tTokenSentry()

    def __del__(self):
        """
        Destructor.
        """
        del self._dbstmnt

    def __enter__(self):
        """
        With statement enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        With statement exit.
        """
        self._destroy()

    def _destroy(self):
        if self._dbstmnt == None:
            return

        del self._dbstmnt
        self._dbstmnt = None

    async def exec_deft(self,
                        site_id: int,
                        token_cnt: int,
                        last_poll: datetime.datetime) -> "dTokenSentryUpdate":
        """
        Execute the query by setting all the inputs.

        :param site_id: int
        :param token_cnt: int
        :param last_poll: datetime.datetime
        :return: Self for convenience.
        """
        self.irec.site_id = site_id
        self.irec.token_cnt = token_cnt
        self.irec.last_poll = last_poll

        return await self.exec()

    async def exec(self, irec: tTokenSentry = None) -> "dTokenSentryUpdate":
        """
        Execute the query, optionally passing in the input rec.

        :param irec:
        :return: Self for convenience.
        """
        if irec:
            self.irec._copy_from(irec)

        self._destroy()

        self._dbstmnt = await self._dbcon.statement("TokenSentryUpdate", self._dbcon.STMNT_TYPE_CUD)

        self._dbstmnt.sql("""update
  fura.TokenSentry
set
  token_cnt = :token_cnt,
  last_poll = :last_poll
where
  site_id = :site_id""")

        self._dbstmnt.bind_in("site_id", self.irec.site_id, int, 4)
        self._dbstmnt.bind_in("token_cnt", self.irec.token_cnt, int, 8)
        self._dbstmnt.bind_in("last_poll", self.irec.last_poll, datetime.datetime)

        await self._dbcon.execute(self._dbstmnt)

        if irec:
            irec._copy_from(self.irec)

        return self

