# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Mon Jan 24 11:35:04 2022
#  Target Database = postgresql
#
import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_fura.db.tables.usr_otp_key import tUsrOtpKey
from bs_fura.db.tables.usr_otp import tUsrOtp

class dUsrOtpSelectOne:

    def __init__(self, dbcon: mettle.db.IAConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self._dbcon   = dbcon
        self._dbstmnt = None
        self.irec     = tUsrOtpKey()
        self.orec     = tUsrOtp()

    def __del__(self):
        """
        Destructor.
        """
        del self._dbstmnt

    def __enter__(self):
        """
        With statement enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        With statement exit.
        """
        self._destroy()

    def _destroy(self):
        if self._dbstmnt == None:
            return

        del self._dbstmnt
        self._dbstmnt = None

    async def exec_deft(self,
                        site_id: int,
                        usr_id: str) -> "dUsrOtpSelectOne":
        """
        Execute the query by setting all the inputs.

        :param site_id: int
        :param usr_id: str
        :return: Self for convenience.
        """
        self.irec.site_id = site_id
        self.irec.usr_id = usr_id

        return await self.exec()

    async def exec(self, irec: tUsrOtpKey = None) -> "dUsrOtpSelectOne":
        """
        Execute the query, optionally passing in the input rec.

        :param irec:
        :return: Self for convenience.
        """
        if irec:
            self.irec._copy_from(irec)

        self._destroy()

        self._dbstmnt = await self._dbcon.statement("UsrOtpSelectOne", self._dbcon.STMNT_TYPE_READ)

        self._dbstmnt.sql("""select
  site_id,
  usr_id,
  otp_method,
  otp,
  expire,
  used,
  target,
  fail_cnt,
  meta_data,
  tm_stamp
from
  fura.UsrOtp
where
  site_id = :site_id and
  usr_id = :usr_id""")

        self._dbstmnt.bind_in("site_id", self.irec.site_id, int, 4)
        self._dbstmnt.bind_in("usr_id", self.irec.usr_id, str, 128)

        self._dbstmnt.bind_out("site_id", int, 4)
        self._dbstmnt.bind_out("usr_id", str, 128)
        self._dbstmnt.bind_out("otp_method", str, 1)
        self._dbstmnt.bind_out("otp", str, 128)
        self._dbstmnt.bind_out("expire", datetime.datetime)
        self._dbstmnt.bind_out("used", bool)
        self._dbstmnt.bind_out("target", str, 64)
        self._dbstmnt.bind_out("fail_cnt", int, 4)
        self._dbstmnt.bind_out("meta_data", dict)
        self._dbstmnt.bind_out("tm_stamp", datetime.datetime)

        await self._dbcon.execute(self._dbstmnt)

        if irec:
            irec._copy_from(self.irec)

        return self

    async def fetch(self) -> bool:
        """
        Fetches the next row from the executed query.

        :return: True if a row is retreived.
        """
        if not await self._dbcon.fetch(self._dbstmnt):
            return False

        self.orec.site_id = self._dbstmnt.result[0]
        self.orec.usr_id = self._dbstmnt.result[1]
        self.orec.otp_method = self._dbstmnt.result[2]
        self.orec.otp = self._dbstmnt.result[3]
        self.orec.expire = self._dbstmnt.result[4]
        self.orec.used = self._dbstmnt.result[5]
        self.orec.target = self._dbstmnt.result[6]
        self.orec.fail_cnt = self._dbstmnt.result[7]
        self.orec.meta_data = self._dbstmnt.result[8]
        self.orec.tm_stamp = self._dbstmnt.result[9]

        return True

    async def fetch_all(self, outList: tUsrOtp.List, clearList: bool = True) -> int:
        """
        Fetch all the rows into the specified list and return the list count.

        :param outList:
        :param clearList:
        :return: Number of rows fetched.
        """
        if clearList:
            outList.clear()

        while await self.fetch():
            outList.append(copy.deepcopy(self.orec))

        return len(outList)

