# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Mon Jan 24 11:35:04 2022
#

import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from .site_key import tSiteKey

class tSite(mettle.io.ISerializable, mettle.db.IPrimaryKey):

    def __init__(self,
                 id: int = 0,
                 code: str = '',
                 descr: str = '',
                 status: str = '',
                 cc: str = '',
                 ccy: str = '',
                 dc: str = '',
                 modified_by: str = ''):
        """
        Constructor.

        :param id: int
        :param code: str
        :param descr: str
        :param status: str
        :param cc: str
        :param ccy: str
        :param dc: str
        :param modified_by: str
        :param tm_stamp: datetime.datetime
        """
        self.id = id
        self.code = code
        self.descr = descr
        self.status = status
        self.cc = cc
        self.ccy = ccy
        self.dc = dc
        self.modified_by = modified_by
        self.tm_stamp = None

    def clear(self):
        """
        Clears all member variables for this database record.
        """
        self.id = 0
        self.code = ''
        self.descr = ''
        self.status = ''
        self.cc = ''
        self.ccy = ''
        self.dc = ''
        self.modified_by = ''
        self.tm_stamp = None

    def _name(self) -> str:
        """
        Name of the record.

        :return: The name.
        """
        return 'tSite'

    def _serialize(self, _w: mettle.io.IWriter, _oname: str = None):
        """
        Serialize record to a stream.

        :param _w:
        :param _oname:
        """
        if _oname == None:
            _oname = self._name()

        _w.write_start(_oname)
        _w.write_int32("id", self.id)
        _w.write_string("code", self.code)
        _w.write_string("descr", self.descr)
        _w.write_char("status", self.status)
        _w.write_string("cc", self.cc)
        _w.write_string("ccy", self.ccy)
        _w.write_string("dc", self.dc)
        _w.write_string("modified_by", self.modified_by)
        _w.write_datetime("tm_stamp", self.tm_stamp)
        _w.write_end(_oname)

    def _deserialize(self, _r: mettle.io.IReader, _oname: str = None):
        """
        Deserialize record from a stream.

        :param _r:
        :param _oname:
        """
        if _oname == None:
            _oname = self._name()

        _r.read_start(_oname)
        self.id = _r.read_int32("id")
        self.code = _r.read_string("code")
        self.descr = _r.read_string("descr")
        self.status = _r.read_char("status")
        self.cc = _r.read_string("cc")
        self.ccy = _r.read_string("ccy")
        self.dc = _r.read_string("dc")
        self.modified_by = _r.read_string("modified_by")
        self.tm_stamp = _r.read_datetime("tm_stamp")
        _r.read_end(_oname)

    def _copy_from(self, rec: "tSite"):
        """
        Copies the column from the rec into this record.

        :param rec: The source record.
        """
        self.id = rec.id
        self.code = rec.code
        self.descr = rec.descr
        self.status = rec.status
        self.cc = rec.cc
        self.ccy = rec.ccy
        self.dc = rec.dc
        self.modified_by = rec.modified_by
        self.tm_stamp = rec.tm_stamp

    def _write_pk(self, _key: "tSite"):
        """
        Write the primary key columns to the key object.

        :param _key:
        """
        self._write_key(_key)

    def _read_pk(self, _key: "tSite"):
        """
        Read the primary key columns from the key object.

        :param _key:
        """
        self._read_key(_key)

    def _serialize_key(self, _w: mettle.io.IWriter):
        """
        Serialize the primary key to a stream.

        :param _w:
        """
        _key = tSiteKey()

        self._write_key(_key)
        _key._serialize(_w)

    def _deserialize_key(self, _r: mettle.io.IReader):
        """
        Deserialize the primary key from a stream.

        :param _r:
        """
        _key = tSiteKey()

        _key._deserialize(_r)
        self._read_key(_key)

    @staticmethod
    def _cache_davs(dvc=None, for_ins: bool = False, key_only: bool = False):
        """
        Cache the DAV into the dav cache (or create one) and return it.

        :param dvc: (mettle.lib.DavCache), target cache, if None a new one is created and returned.
        :param for_ins: Davs for insert.
        :param key_only: Davs by key only, ie for delete/selectone.
        """
        if dvc is None:
            dvc = mettle.lib.DavCache()

        if not for_ins:
            dvc.add_targ("id", mettle.lib.Dav(mettle.lib.Dav.eDavType.Min, 1))
            dvc.add_targ("id", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))

        if key_only:
            return dvc

        dvc.add_targ("code", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 32))
        dvc.add_targ("descr", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("descr", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 256))
        dvc.add_targ("status", mettle.lib.Dav(mettle.lib.Dav.eDavType.Min, 1))
        dvc.add_targ("status", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 1))
        dvc.add_targ("status", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("status", mettle.lib.Dav(mettle.lib.Dav.eDavType.In, ['A','D']))
        dvc.add_targ("cc", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 2))
        dvc.add_targ("ccy", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 3))
        dvc.add_targ("dc", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 3))
        dvc.add_targ("modified_by", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("modified_by", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 128))

        return dvc

    def _get_davs(self, dvc=None, for_ins: bool = False, key_only: bool = False):
        tSite._cache_davs(dvc, for_ins, key_only)

    def _write_key(self, _key: tSiteKey):
        """
        Write primary key columns to _key.

        :param _key:
        """
        _key.id = self.id

    def _read_key(self, _key: tSiteKey):
        """
        Read the primary key columns from _key.

        :param _key:
        """
        self.id = _key.id

    class Status_Couplet(dict):
        key_active = "A"
        key_disabled = "D"

        value_active = "Active"
        value_disabled = "Disabled"

        def __init__(self):
            self[self.key_active] = self.value_active
            self[self.key_disabled] = self.value_disabled

        @staticmethod
        def get_value(key):
            if key == tSite.Status_Couplet.key_active:
                return tSite.Status_Couplet.value_active

            if key == tSite.Status_Couplet.key_disabled:
                return tSite.Status_Couplet.value_disabled

            return ""

    @staticmethod
    def _pk_compare(x, y) -> int:
        """
        Compare function do primary key comparisons for list sorts and searches.

        :return: zero for x == y, negative for x < y, positive for x > y
        """
        return x.id - y.id

    def __lt__(self, other):
        return other and self._pk_compare(self, other) < 0

    def __gt__(self, other):
        return other and self._pk_compare(self, other) > 0

    def __eq__(self, other):
        return other and self._pk_compare(self, other) == 0

    def __le__(self, other):
        return other and self._pk_compare(self, other) <= 0

    def __ge__(self, other):
        return other and self._pk_compare(self, other) >= 0

    def __ne__(self, other):
        return other == None or self._pk_compare(self, other)

    def __repr__(self) -> str:
        return '<Site [id:%r, code:%.32s, descr:%.32s, status:%.32s, cc:%.32s, ccy:%.32s, dc:%.32s, modified_by:%.32s, tm_stamp:%s]>' % (
            self.id, self.code, self.descr, self.status, self.cc, self.ccy, self.dc, self.modified_by, self.tm_stamp)


    class List(list, mettle.io.ISerializable):
        """
        List Class
        """

        def _name(self) -> str:
            """
            Name of the list.

            :return: The name
            """
            return 'tSite.List'

        def _serialize(self, _w: mettle.io.IWriter, _oname: str = None):
            """
            Serialize the list to a stream.

            :param _w:
            :param _oname:
            """
            if _oname == None:
                _oname = self._name()

            _w.write_start_list(_oname, len(self))

            for _rec in self:
                _rec._serialize(_w)

            _w.write_end(_oname)

        def _deserialize(self, _r: mettle.io.IReader, _oname: str = None):
            """
            Deserialize the list from a stream.

            :param _r:
            :param _oname:
            """
            if _oname == None:
                _oname = self._name()

            _cnt = _r.read_start_list(_oname)

            while _cnt >= 1:
                _rec  = tSite()
                _cnt -= 1
                _rec._deserialize(_r)
                self.append(_rec)

            _r.read_end(_oname)

        def __repr__(self) -> str:
            return '<tSite.List[%d]>' % (len(self))

        def _get_davs(self, dvc=None, for_ins: bool = False, key_only: bool = False):
            return tSite._cache_davs(dvc, for_ins, key_only)

