# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Mon Jan 24 11:35:04 2022
#

import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from .token_sentry_key import tTokenSentryKey

class tTokenSentry(mettle.io.ISerializable, mettle.db.IPrimaryKey):

    def __init__(self,
                 site_id: int = 0,
                 token_cnt: int = 0,
                 last_poll: datetime.datetime = None):
        """
        Constructor.

        :param site_id: int
        :param token_cnt: int
        :param last_poll: datetime.datetime
        """
        self.site_id = site_id
        self.token_cnt = token_cnt
        self.last_poll = last_poll

    def clear(self):
        """
        Clears all member variables for this database record.
        """
        self.site_id = 0
        self.token_cnt = 0
        self.last_poll = None

    def _name(self) -> str:
        """
        Name of the record.

        :return: The name.
        """
        return 'tTokenSentry'

    def _serialize(self, _w: mettle.io.IWriter, _oname: str = None):
        """
        Serialize record to a stream.

        :param _w:
        :param _oname:
        """
        if _oname == None:
            _oname = self._name()

        _w.write_start(_oname)
        _w.write_int32("site_id", self.site_id)
        _w.write_int64("token_cnt", self.token_cnt)
        _w.write_datetime("last_poll", self.last_poll)
        _w.write_end(_oname)

    def _deserialize(self, _r: mettle.io.IReader, _oname: str = None):
        """
        Deserialize record from a stream.

        :param _r:
        :param _oname:
        """
        if _oname == None:
            _oname = self._name()

        _r.read_start(_oname)
        self.site_id = _r.read_int32("site_id")
        self.token_cnt = _r.read_int64("token_cnt")
        self.last_poll = _r.read_datetime("last_poll")
        _r.read_end(_oname)

    def _copy_from(self, rec: "tTokenSentry"):
        """
        Copies the column from the rec into this record.

        :param rec: The source record.
        """
        self.site_id = rec.site_id
        self.token_cnt = rec.token_cnt
        self.last_poll = rec.last_poll

    def _write_pk(self, _key: "tTokenSentry"):
        """
        Write the primary key columns to the key object.

        :param _key:
        """
        self._write_key(_key)

    def _read_pk(self, _key: "tTokenSentry"):
        """
        Read the primary key columns from the key object.

        :param _key:
        """
        self._read_key(_key)

    def _serialize_key(self, _w: mettle.io.IWriter):
        """
        Serialize the primary key to a stream.

        :param _w:
        """
        _key = tTokenSentryKey()

        self._write_key(_key)
        _key._serialize(_w)

    def _deserialize_key(self, _r: mettle.io.IReader):
        """
        Deserialize the primary key from a stream.

        :param _r:
        """
        _key = tTokenSentryKey()

        _key._deserialize(_r)
        self._read_key(_key)

    @staticmethod
    def _cache_davs(dvc=None, for_ins: bool = False, key_only: bool = False):
        """
        Cache the DAV into the dav cache (or create one) and return it.

        :param dvc: (mettle.lib.DavCache), target cache, if None a new one is created and returned.
        :param for_ins: Davs for insert.
        :param key_only: Davs by key only, ie for delete/selectone.
        """
        if dvc is None:
            dvc = mettle.lib.DavCache()

        dvc.add_targ("site_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        if key_only:
            return dvc

        dvc.add_targ("token_cnt", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("last_poll", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))

        return dvc

    def _get_davs(self, dvc=None, for_ins: bool = False, key_only: bool = False):
        tTokenSentry._cache_davs(dvc, for_ins, key_only)

    def _write_key(self, _key: tTokenSentryKey):
        """
        Write primary key columns to _key.

        :param _key:
        """
        _key.site_id = self.site_id

    def _read_key(self, _key: tTokenSentryKey):
        """
        Read the primary key columns from _key.

        :param _key:
        """
        self.site_id = _key.site_id

    @staticmethod
    def _pk_compare(x, y) -> int:
        """
        Compare function do primary key comparisons for list sorts and searches.

        :return: zero for x == y, negative for x < y, positive for x > y
        """
        return x.site_id - y.site_id

    def __lt__(self, other):
        return other and self._pk_compare(self, other) < 0

    def __gt__(self, other):
        return other and self._pk_compare(self, other) > 0

    def __eq__(self, other):
        return other and self._pk_compare(self, other) == 0

    def __le__(self, other):
        return other and self._pk_compare(self, other) <= 0

    def __ge__(self, other):
        return other and self._pk_compare(self, other) >= 0

    def __ne__(self, other):
        return other == None or self._pk_compare(self, other)

    def __repr__(self) -> str:
        return '<TokenSentry [site_id:%r, token_cnt:%r, last_poll:%s]>' % (
            self.site_id, self.token_cnt, self.last_poll)


    class List(list, mettle.io.ISerializable):
        """
        List Class
        """

        def _name(self) -> str:
            """
            Name of the list.

            :return: The name
            """
            return 'tTokenSentry.List'

        def _serialize(self, _w: mettle.io.IWriter, _oname: str = None):
            """
            Serialize the list to a stream.

            :param _w:
            :param _oname:
            """
            if _oname == None:
                _oname = self._name()

            _w.write_start_list(_oname, len(self))

            for _rec in self:
                _rec._serialize(_w)

            _w.write_end(_oname)

        def _deserialize(self, _r: mettle.io.IReader, _oname: str = None):
            """
            Deserialize the list from a stream.

            :param _r:
            :param _oname:
            """
            if _oname == None:
                _oname = self._name()

            _cnt = _r.read_start_list(_oname)

            while _cnt >= 1:
                _rec  = tTokenSentry()
                _cnt -= 1
                _rec._deserialize(_r)
                self.append(_rec)

            _r.read_end(_oname)

        def __repr__(self) -> str:
            return '<tTokenSentry.List[%d]>' % (len(self))

        def _get_davs(self, dvc=None, for_ins: bool = False, key_only: bool = False):
            return tTokenSentry._cache_davs(dvc, for_ins, key_only)

