# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Mon Jan 24 11:35:04 2022
#

import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from .usr_auth_key import tUsrAuthKey

class tUsrAuth(mettle.io.ISerializable, mettle.db.IPrimaryKey):

    def __init__(self,
                 site_id: int = 0,
                 usr_id: str = '',
                 auth_type: str = '',
                 auth_data: str = '',
                 fail_cnt: int = 0,
                 salt: str = '',
                 last_ip: str = '',
                 last_geo: str = '',
                 last_succ: datetime.datetime = None,
                 last_fail: datetime.datetime = None,
                 modified_by: str = ''):
        """
        Constructor.

        :param site_id: int
        :param usr_id: str
        :param auth_type: str
        :param auth_data: str
        :param fail_cnt: int
        :param salt: str
        :param last_ip: str
        :param last_geo: str
        :param last_succ: datetime.datetime
        :param last_fail: datetime.datetime
        :param modified_by: str
        :param tm_stamp: datetime.datetime
        """
        self.site_id = site_id
        self.usr_id = usr_id
        self.auth_type = auth_type
        self.auth_data = auth_data
        self.fail_cnt = fail_cnt
        self.salt = salt
        self.last_ip = last_ip
        self.last_geo = last_geo
        self.last_succ = last_succ
        self.last_fail = last_fail
        self.modified_by = modified_by
        self.tm_stamp = None

    def clear(self):
        """
        Clears all member variables for this database record.
        """
        self.site_id = 0
        self.usr_id = ''
        self.auth_type = ''
        self.auth_data = ''
        self.fail_cnt = 0
        self.salt = ''
        self.last_ip = ''
        self.last_geo = ''
        self.last_succ = None
        self.last_fail = None
        self.modified_by = ''
        self.tm_stamp = None

    def _name(self) -> str:
        """
        Name of the record.

        :return: The name.
        """
        return 'tUsrAuth'

    def _serialize(self, _w: mettle.io.IWriter, _oname: str = None):
        """
        Serialize record to a stream.

        :param _w:
        :param _oname:
        """
        if _oname == None:
            _oname = self._name()

        _w.write_start(_oname)
        _w.write_int32("site_id", self.site_id)
        _w.write_string("usr_id", self.usr_id)
        _w.write_char("auth_type", self.auth_type)
        _w.write_string("auth_data", self.auth_data)
        _w.write_int32("fail_cnt", self.fail_cnt)
        _w.write_string("salt", self.salt)
        _w.write_string("last_ip", self.last_ip)
        _w.write_string("last_geo", self.last_geo)
        _w.write_datetime("last_succ", self.last_succ)
        _w.write_datetime("last_fail", self.last_fail)
        _w.write_string("modified_by", self.modified_by)
        _w.write_datetime("tm_stamp", self.tm_stamp)
        _w.write_end(_oname)

    def _deserialize(self, _r: mettle.io.IReader, _oname: str = None):
        """
        Deserialize record from a stream.

        :param _r:
        :param _oname:
        """
        if _oname == None:
            _oname = self._name()

        _r.read_start(_oname)
        self.site_id = _r.read_int32("site_id")
        self.usr_id = _r.read_string("usr_id")
        self.auth_type = _r.read_char("auth_type")
        self.auth_data = _r.read_string("auth_data")
        self.fail_cnt = _r.read_int32("fail_cnt")
        self.salt = _r.read_string("salt")
        self.last_ip = _r.read_string("last_ip")
        self.last_geo = _r.read_string("last_geo")
        self.last_succ = _r.read_datetime("last_succ")
        self.last_fail = _r.read_datetime("last_fail")
        self.modified_by = _r.read_string("modified_by")
        self.tm_stamp = _r.read_datetime("tm_stamp")
        _r.read_end(_oname)

    def _copy_from(self, rec: "tUsrAuth"):
        """
        Copies the column from the rec into this record.

        :param rec: The source record.
        """
        self.site_id = rec.site_id
        self.usr_id = rec.usr_id
        self.auth_type = rec.auth_type
        self.auth_data = rec.auth_data
        self.fail_cnt = rec.fail_cnt
        self.salt = rec.salt
        self.last_ip = rec.last_ip
        self.last_geo = rec.last_geo
        self.last_succ = rec.last_succ
        self.last_fail = rec.last_fail
        self.modified_by = rec.modified_by
        self.tm_stamp = rec.tm_stamp

    def _write_pk(self, _key: "tUsrAuth"):
        """
        Write the primary key columns to the key object.

        :param _key:
        """
        self._write_key(_key)

    def _read_pk(self, _key: "tUsrAuth"):
        """
        Read the primary key columns from the key object.

        :param _key:
        """
        self._read_key(_key)

    def _serialize_key(self, _w: mettle.io.IWriter):
        """
        Serialize the primary key to a stream.

        :param _w:
        """
        _key = tUsrAuthKey()

        self._write_key(_key)
        _key._serialize(_w)

    def _deserialize_key(self, _r: mettle.io.IReader):
        """
        Deserialize the primary key from a stream.

        :param _r:
        """
        _key = tUsrAuthKey()

        _key._deserialize(_r)
        self._read_key(_key)

    @staticmethod
    def _cache_davs(dvc=None, for_ins: bool = False, key_only: bool = False):
        """
        Cache the DAV into the dav cache (or create one) and return it.

        :param dvc: (mettle.lib.DavCache), target cache, if None a new one is created and returned.
        :param for_ins: Davs for insert.
        :param key_only: Davs by key only, ie for delete/selectone.
        """
        if dvc is None:
            dvc = mettle.lib.DavCache()

        dvc.add_targ("site_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("usr_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("usr_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 128))
        dvc.add_targ("auth_type", mettle.lib.Dav(mettle.lib.Dav.eDavType.Min, 1))
        dvc.add_targ("auth_type", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 1))
        dvc.add_targ("auth_type", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("auth_type", mettle.lib.Dav(mettle.lib.Dav.eDavType.In, ['P','S','T']))
        if key_only:
            return dvc

        dvc.add_targ("auth_data", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 4096))
        dvc.add_targ("fail_cnt", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("salt", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 128))
        dvc.add_targ("last_ip", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 32))
        dvc.add_targ("last_geo", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 64))
        dvc.add_targ("modified_by", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("modified_by", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 128))

        return dvc

    def _get_davs(self, dvc=None, for_ins: bool = False, key_only: bool = False):
        tUsrAuth._cache_davs(dvc, for_ins, key_only)

    def _write_key(self, _key: tUsrAuthKey):
        """
        Write primary key columns to _key.

        :param _key:
        """
        _key.site_id = self.site_id
        _key.usr_id = self.usr_id
        _key.auth_type = self.auth_type

    def _read_key(self, _key: tUsrAuthKey):
        """
        Read the primary key columns from _key.

        :param _key:
        """
        self.site_id = _key.site_id
        self.usr_id = _key.usr_id
        self.auth_type = _key.auth_type

    class AuthType_Couplet(dict):
        key_password = "P"
        key_s_s_h_key = "S"
        key_token = "T"

        value_password = "Password"
        value_s_s_h_key = "SSH Key"
        value_token = "Token"

        def __init__(self):
            self[self.key_password] = self.value_password
            self[self.key_s_s_h_key] = self.value_s_s_h_key
            self[self.key_token] = self.value_token

        @staticmethod
        def get_value(key):
            if key == tUsrAuth.AuthType_Couplet.key_password:
                return tUsrAuth.AuthType_Couplet.value_password

            if key == tUsrAuth.AuthType_Couplet.key_s_s_h_key:
                return tUsrAuth.AuthType_Couplet.value_s_s_h_key

            if key == tUsrAuth.AuthType_Couplet.key_token:
                return tUsrAuth.AuthType_Couplet.value_token

            return ""

    @staticmethod
    def _pk_compare(x, y) -> int:
        """
        Compare function do primary key comparisons for list sorts and searches.

        :return: zero for x == y, negative for x < y, positive for x > y
        """
        rc = x.site_id - y.site_id

        if rc != 0:
            return rc

        rc = (x.usr_id > y.usr_id) - (x.usr_id < y.usr_id)

        if rc != 0:
            return rc

        rc = (x.auth_type > y.auth_type) - (x.auth_type < y.auth_type)

        return rc

    def __lt__(self, other):
        return other and self._pk_compare(self, other) < 0

    def __gt__(self, other):
        return other and self._pk_compare(self, other) > 0

    def __eq__(self, other):
        return other and self._pk_compare(self, other) == 0

    def __le__(self, other):
        return other and self._pk_compare(self, other) <= 0

    def __ge__(self, other):
        return other and self._pk_compare(self, other) >= 0

    def __ne__(self, other):
        return other == None or self._pk_compare(self, other)

    def __repr__(self) -> str:
        return '<UsrAuth [site_id:%r, usr_id:%.32s, auth_type:%.32s, auth_data:%.32s, fail_cnt:%r, salt:%.32s, last_ip:%.32s, last_geo:%.32s, last_succ:%s, last_fail:%s, modified_by:%.32s, tm_stamp:%s]>' % (
            self.site_id, self.usr_id, self.auth_type, self.auth_data, self.fail_cnt, self.salt, self.last_ip, self.last_geo, self.last_succ, self.last_fail, self.modified_by, self.tm_stamp)


    class List(list, mettle.io.ISerializable):
        """
        List Class
        """

        def _name(self) -> str:
            """
            Name of the list.

            :return: The name
            """
            return 'tUsrAuth.List'

        def _serialize(self, _w: mettle.io.IWriter, _oname: str = None):
            """
            Serialize the list to a stream.

            :param _w:
            :param _oname:
            """
            if _oname == None:
                _oname = self._name()

            _w.write_start_list(_oname, len(self))

            for _rec in self:
                _rec._serialize(_w)

            _w.write_end(_oname)

        def _deserialize(self, _r: mettle.io.IReader, _oname: str = None):
            """
            Deserialize the list from a stream.

            :param _r:
            :param _oname:
            """
            if _oname == None:
                _oname = self._name()

            _cnt = _r.read_start_list(_oname)

            while _cnt >= 1:
                _rec  = tUsrAuth()
                _cnt -= 1
                _rec._deserialize(_r)
                self.append(_rec)

            _r.read_end(_oname)

        def __repr__(self) -> str:
            return '<tUsrAuth.List[%d]>' % (len(self))

        def _get_davs(self, dvc=None, for_ins: bool = False, key_only: bool = False):
            return tUsrAuth._cache_davs(dvc, for_ins, key_only)

