# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Mon Jan 24 11:35:04 2022
#

import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from .usr_otp_key import tUsrOtpKey

class tUsrOtp(mettle.io.ISerializable, mettle.db.IPrimaryKey):

    def __init__(self,
                 site_id: int = 0,
                 usr_id: str = '',
                 otp_method: str = '',
                 otp: str = '',
                 expire: datetime.datetime = None,
                 used: bool = False,
                 target: str = '',
                 fail_cnt: int = 0,
                 meta_data: dict = None):
        """
        Constructor.

        :param site_id: int
        :param usr_id: str
        :param otp_method: str
        :param otp: str
        :param expire: datetime.datetime
        :param used: bool
        :param target: str
        :param fail_cnt: int
        :param meta_data: dict
        :param tm_stamp: datetime.datetime
        """
        self.site_id = site_id
        self.usr_id = usr_id
        self.otp_method = otp_method
        self.otp = otp
        self.expire = expire
        self.used = used
        self.target = target
        self.fail_cnt = fail_cnt
        self.meta_data = meta_data
        self.tm_stamp = None

    def clear(self):
        """
        Clears all member variables for this database record.
        """
        self.site_id = 0
        self.usr_id = ''
        self.otp_method = ''
        self.otp = ''
        self.expire = None
        self.used = False
        self.target = ''
        self.fail_cnt = 0
        self.meta_data = None
        self.tm_stamp = None

    def _name(self) -> str:
        """
        Name of the record.

        :return: The name.
        """
        return 'tUsrOtp'

    def _serialize(self, _w: mettle.io.IWriter, _oname: str = None):
        """
        Serialize record to a stream.

        :param _w:
        :param _oname:
        """
        if _oname == None:
            _oname = self._name()

        _w.write_start(_oname)
        _w.write_int32("site_id", self.site_id)
        _w.write_string("usr_id", self.usr_id)
        _w.write_char("otp_method", self.otp_method)
        _w.write_string("otp", self.otp)
        _w.write_datetime("expire", self.expire)
        _w.write_bool("used", self.used)
        _w.write_string("target", self.target)
        _w.write_int32("fail_cnt", self.fail_cnt)
        _w.write_json("meta_data", self.meta_data)
        _w.write_datetime("tm_stamp", self.tm_stamp)
        _w.write_end(_oname)

    def _deserialize(self, _r: mettle.io.IReader, _oname: str = None):
        """
        Deserialize record from a stream.

        :param _r:
        :param _oname:
        """
        if _oname == None:
            _oname = self._name()

        _r.read_start(_oname)
        self.site_id = _r.read_int32("site_id")
        self.usr_id = _r.read_string("usr_id")
        self.otp_method = _r.read_char("otp_method")
        self.otp = _r.read_string("otp")
        self.expire = _r.read_datetime("expire")
        self.used = _r.read_bool("used")
        self.target = _r.read_string("target")
        self.fail_cnt = _r.read_int32("fail_cnt")
        self.meta_data = _r.read_json("meta_data")
        self.tm_stamp = _r.read_datetime("tm_stamp")
        _r.read_end(_oname)

    def _copy_from(self, rec: "tUsrOtp"):
        """
        Copies the column from the rec into this record.

        :param rec: The source record.
        """
        self.site_id = rec.site_id
        self.usr_id = rec.usr_id
        self.otp_method = rec.otp_method
        self.otp = rec.otp
        self.expire = rec.expire
        self.used = rec.used
        self.target = rec.target
        self.fail_cnt = rec.fail_cnt
        self.meta_data = rec.meta_data
        self.tm_stamp = rec.tm_stamp

    def _write_pk(self, _key: "tUsrOtp"):
        """
        Write the primary key columns to the key object.

        :param _key:
        """
        self._write_key(_key)

    def _read_pk(self, _key: "tUsrOtp"):
        """
        Read the primary key columns from the key object.

        :param _key:
        """
        self._read_key(_key)

    def _serialize_key(self, _w: mettle.io.IWriter):
        """
        Serialize the primary key to a stream.

        :param _w:
        """
        _key = tUsrOtpKey()

        self._write_key(_key)
        _key._serialize(_w)

    def _deserialize_key(self, _r: mettle.io.IReader):
        """
        Deserialize the primary key from a stream.

        :param _r:
        """
        _key = tUsrOtpKey()

        _key._deserialize(_r)
        self._read_key(_key)

    @staticmethod
    def _cache_davs(dvc=None, for_ins: bool = False, key_only: bool = False):
        """
        Cache the DAV into the dav cache (or create one) and return it.

        :param dvc: (mettle.lib.DavCache), target cache, if None a new one is created and returned.
        :param for_ins: Davs for insert.
        :param key_only: Davs by key only, ie for delete/selectone.
        """
        if dvc is None:
            dvc = mettle.lib.DavCache()

        dvc.add_targ("site_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("usr_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("usr_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 128))
        if key_only:
            return dvc

        dvc.add_targ("otp_method", mettle.lib.Dav(mettle.lib.Dav.eDavType.Min, 1))
        dvc.add_targ("otp_method", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 1))
        dvc.add_targ("otp_method", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("otp_method", mettle.lib.Dav(mettle.lib.Dav.eDavType.In, ['E','S','Z']))
        dvc.add_targ("otp", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 128))
        dvc.add_targ("used", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("target", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 64))
        dvc.add_targ("fail_cnt", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))

        return dvc

    def _get_davs(self, dvc=None, for_ins: bool = False, key_only: bool = False):
        tUsrOtp._cache_davs(dvc, for_ins, key_only)

    def _write_key(self, _key: tUsrOtpKey):
        """
        Write primary key columns to _key.

        :param _key:
        """
        _key.site_id = self.site_id
        _key.usr_id = self.usr_id

    def _read_key(self, _key: tUsrOtpKey):
        """
        Read the primary key columns from _key.

        :param _key:
        """
        self.site_id = _key.site_id
        self.usr_id = _key.usr_id

    class OtpMethod_Couplet(dict):
        key_email = "E"
        key_sms = "S"
        key_none = "Z"

        value_email = "Email"
        value_sms = "Sms"
        value_none = "None"

        def __init__(self):
            self[self.key_email] = self.value_email
            self[self.key_sms] = self.value_sms
            self[self.key_none] = self.value_none

        @staticmethod
        def get_value(key):
            if key == tUsrOtp.OtpMethod_Couplet.key_email:
                return tUsrOtp.OtpMethod_Couplet.value_email

            if key == tUsrOtp.OtpMethod_Couplet.key_sms:
                return tUsrOtp.OtpMethod_Couplet.value_sms

            if key == tUsrOtp.OtpMethod_Couplet.key_none:
                return tUsrOtp.OtpMethod_Couplet.value_none

            return ""

    @staticmethod
    def _pk_compare(x, y) -> int:
        """
        Compare function do primary key comparisons for list sorts and searches.

        :return: zero for x == y, negative for x < y, positive for x > y
        """
        rc = x.site_id - y.site_id

        if rc != 0:
            return rc

        rc = (x.usr_id > y.usr_id) - (x.usr_id < y.usr_id)

        return rc

    def __lt__(self, other):
        return other and self._pk_compare(self, other) < 0

    def __gt__(self, other):
        return other and self._pk_compare(self, other) > 0

    def __eq__(self, other):
        return other and self._pk_compare(self, other) == 0

    def __le__(self, other):
        return other and self._pk_compare(self, other) <= 0

    def __ge__(self, other):
        return other and self._pk_compare(self, other) >= 0

    def __ne__(self, other):
        return other == None or self._pk_compare(self, other)

    def __repr__(self) -> str:
        return '<UsrOtp [site_id:%r, usr_id:%.32s, otp_method:%.32s, otp:%.32s, expire:%s, used:%r, target:%.32s, fail_cnt:%r, meta_data:%.32s, tm_stamp:%s]>' % (
            self.site_id, self.usr_id, self.otp_method, self.otp, self.expire, self.used, self.target, self.fail_cnt, self.meta_data, self.tm_stamp)


    class List(list, mettle.io.ISerializable):
        """
        List Class
        """

        def _name(self) -> str:
            """
            Name of the list.

            :return: The name
            """
            return 'tUsrOtp.List'

        def _serialize(self, _w: mettle.io.IWriter, _oname: str = None):
            """
            Serialize the list to a stream.

            :param _w:
            :param _oname:
            """
            if _oname == None:
                _oname = self._name()

            _w.write_start_list(_oname, len(self))

            for _rec in self:
                _rec._serialize(_w)

            _w.write_end(_oname)

        def _deserialize(self, _r: mettle.io.IReader, _oname: str = None):
            """
            Deserialize the list from a stream.

            :param _r:
            :param _oname:
            """
            if _oname == None:
                _oname = self._name()

            _cnt = _r.read_start_list(_oname)

            while _cnt >= 1:
                _rec  = tUsrOtp()
                _cnt -= 1
                _rec._deserialize(_r)
                self.append(_rec)

            _r.read_end(_oname)

        def __repr__(self) -> str:
            return '<tUsrOtp.List[%d]>' % (len(self))

        def _get_davs(self, dvc=None, for_ins: bool = False, key_only: bool = False):
            return tUsrOtp._cache_davs(dvc, for_ins, key_only)

