# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from odahuflow.sdk.models.base_model_ import Model
from odahuflow.sdk.models.json_schema import JsonSchema  # noqa: F401,E501
from odahuflow.sdk.models.target_schema import TargetSchema  # noqa: F401,E501
from odahuflow.sdk.models import util


class Schema(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    def __init__(self, arguments: JsonSchema=None, targets: List[TargetSchema]=None):  # noqa: E501
        """Schema - a model defined in Swagger

        :param arguments: The arguments of this Schema.  # noqa: E501
        :type arguments: JsonSchema
        :param targets: The targets of this Schema.  # noqa: E501
        :type targets: List[TargetSchema]
        """
        self.swagger_types = {
            'arguments': JsonSchema,
            'targets': List[TargetSchema]
        }

        self.attribute_map = {
            'arguments': 'arguments',
            'targets': 'targets'
        }

        self._arguments = arguments
        self._targets = targets

    @classmethod
    def from_dict(cls, dikt) -> 'Schema':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The Schema of this Schema.  # noqa: E501
        :rtype: Schema
        """
        return util.deserialize_model(dikt, cls)

    @property
    def arguments(self) -> JsonSchema:
        """Gets the arguments of this Schema.

        Arguments schema  # noqa: E501

        :return: The arguments of this Schema.
        :rtype: JsonSchema
        """
        return self._arguments

    @arguments.setter
    def arguments(self, arguments: JsonSchema):
        """Sets the arguments of this Schema.

        Arguments schema  # noqa: E501

        :param arguments: The arguments of this Schema.
        :type arguments: JsonSchema
        """

        self._arguments = arguments

    @property
    def targets(self) -> List[TargetSchema]:
        """Gets the targets of this Schema.

        Targets schema  # noqa: E501

        :return: The targets of this Schema.
        :rtype: List[TargetSchema]
        """
        return self._targets

    @targets.setter
    def targets(self, targets: List[TargetSchema]):
        """Sets the targets of this Schema.

        Targets schema  # noqa: E501

        :param targets: The targets of this Schema.
        :type targets: List[TargetSchema]
        """

        self._targets = targets
