#!/bin/bash
if [ "$EUID" -ne 0 ]
then echo "Please run as root"
	exit
fi

mkdir -p "$INSTALL_DIRECTORY"
rsync --info=progress2 -a --exclude=static/admin --exclude=static/libs . "$INSTALL_DIRECTORY"
cd "$INSTALL_DIRECTORY"

# clean up files that might have been generated by a user install
# basically some contents of the .gitignores
rm -rf backup_*
rm -f db.sqlite3
rm -f yarn.lock
rm -f yarn-error.log
rm -f config/secret_key.txt
rm -f config/homewifi
rm -f config/youtube_cookies.pickle
rm -f config/cache_dir
rm -f logs/*
rm -rf static/CACHE
rm -f static/admin

export SERVER_ROOT="$PWD"
echo "*** Using this directory ($SERVER_ROOT) as install directory ***"

export BACKUP_DIR="backup_$(date +%Y-%m-%d-%H:%M:%S)"
mkdir $BACKUP_DIR

echo "***** Installing Dependencies *****"
setup/install.sh || { echo "Could not install required dependencies"; exit 1; }

echo "***** Configuring Network *****"
setup/network.sh

echo "***** Configuring System *****"
setup/system.sh

echo "***** Configuring Database *****"
setup/database.sh

echo "***** Configuring Webserver *****"
setup/server.sh

echo ""
echo "***** Finished *****"
echo ""
echo "Raveberry was installed on this system!"
echo "You can now visit http://raveberry/"
echo "A reboot might be necessary for all features to be active."
