"""File generated by TLObjects' generator. All changes will be ERASED"""
from ...tl.tlobject import TLObject
from ...tl.tlobject import TLRequest
from typing import Optional, List, Union, TYPE_CHECKING
import os
import struct
from datetime import datetime
if TYPE_CHECKING:
    from ...tl.types import TypeChannelAdminLogEventsFilter, TypeChannelParticipantsFilter, TypeChatAdminRights, TypeChatBannedRights, TypeInputChannel, TypeInputChatPhoto, TypeInputCheckPasswordSRP, TypeInputGeoPoint, TypeInputMessage, TypeInputPeer, TypeInputStickerSet, TypeInputUser



class CheckUsernameRequest(TLRequest):
    CONSTRUCTOR_ID = 0x10e6bd2c
    SUBCLASS_OF_ID = 0xf5b399ac

    def __init__(self, channel: 'TypeInputChannel', username: str):
        """
        :returns Bool: This type has no constructors.
        """
        self.channel = channel
        self.username = username

    async def resolve(self, client, utils):
        self.channel = utils.get_input_channel(await client.get_input_entity(self.channel))

    def to_dict(self):
        return {
            '_': 'CheckUsernameRequest',
            'channel': self.channel.to_dict() if isinstance(self.channel, TLObject) else self.channel,
            'username': self.username
        }

    def _bytes(self):
        return b''.join((
            b',\xbd\xe6\x10',
            self.channel._bytes(),
            self.serialize_bytes(self.username),
        ))

    @classmethod
    def from_reader(cls, reader):
        _channel = reader.tgread_object()
        _username = reader.tgread_string()
        return cls(channel=_channel, username=_username)


class ConvertToGigagroupRequest(TLRequest):
    CONSTRUCTOR_ID = 0xb290c69
    SUBCLASS_OF_ID = 0x8af52aac

    def __init__(self, channel: 'TypeInputChannel'):
        """
        :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
        """
        self.channel = channel

    async def resolve(self, client, utils):
        self.channel = utils.get_input_channel(await client.get_input_entity(self.channel))

    def to_dict(self):
        return {
            '_': 'ConvertToGigagroupRequest',
            'channel': self.channel.to_dict() if isinstance(self.channel, TLObject) else self.channel
        }

    def _bytes(self):
        return b''.join((
            b'i\x0c)\x0b',
            self.channel._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _channel = reader.tgread_object()
        return cls(channel=_channel)


class CreateChannelRequest(TLRequest):
    CONSTRUCTOR_ID = 0x3d5fb10f
    SUBCLASS_OF_ID = 0x8af52aac

    def __init__(self, title: str, about: str, broadcast: Optional[bool]=None, megagroup: Optional[bool]=None, for_import: Optional[bool]=None, geo_point: Optional['TypeInputGeoPoint']=None, address: Optional[str]=None):
        """
        :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
        """
        self.title = title
        self.about = about
        self.broadcast = broadcast
        self.megagroup = megagroup
        self.for_import = for_import
        self.geo_point = geo_point
        self.address = address

    def to_dict(self):
        return {
            '_': 'CreateChannelRequest',
            'title': self.title,
            'about': self.about,
            'broadcast': self.broadcast,
            'megagroup': self.megagroup,
            'for_import': self.for_import,
            'geo_point': self.geo_point.to_dict() if isinstance(self.geo_point, TLObject) else self.geo_point,
            'address': self.address
        }

    def _bytes(self):
        assert ((self.geo_point or self.geo_point is not None) and (self.address or self.address is not None)) or ((self.geo_point is None or self.geo_point is False) and (self.address is None or self.address is False)), 'geo_point, address parameters must all be False-y (like None) or all me True-y'
        return b''.join((
            b'\x0f\xb1_=',
            struct.pack('<I', (0 if self.broadcast is None or self.broadcast is False else 1) | (0 if self.megagroup is None or self.megagroup is False else 2) | (0 if self.for_import is None or self.for_import is False else 8) | (0 if self.geo_point is None or self.geo_point is False else 4) | (0 if self.address is None or self.address is False else 4)),
            self.serialize_bytes(self.title),
            self.serialize_bytes(self.about),
            b'' if self.geo_point is None or self.geo_point is False else (self.geo_point._bytes()),
            b'' if self.address is None or self.address is False else (self.serialize_bytes(self.address)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _broadcast = bool(flags & 1)
        _megagroup = bool(flags & 2)
        _for_import = bool(flags & 8)
        _title = reader.tgread_string()
        _about = reader.tgread_string()
        if flags & 4:
            _geo_point = reader.tgread_object()
        else:
            _geo_point = None
        if flags & 4:
            _address = reader.tgread_string()
        else:
            _address = None
        return cls(title=_title, about=_about, broadcast=_broadcast, megagroup=_megagroup, for_import=_for_import, geo_point=_geo_point, address=_address)


class DeleteChannelRequest(TLRequest):
    CONSTRUCTOR_ID = 0xc0111fe3
    SUBCLASS_OF_ID = 0x8af52aac

    def __init__(self, channel: 'TypeInputChannel'):
        """
        :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
        """
        self.channel = channel

    async def resolve(self, client, utils):
        self.channel = utils.get_input_channel(await client.get_input_entity(self.channel))

    def to_dict(self):
        return {
            '_': 'DeleteChannelRequest',
            'channel': self.channel.to_dict() if isinstance(self.channel, TLObject) else self.channel
        }

    def _bytes(self):
        return b''.join((
            b'\xe3\x1f\x11\xc0',
            self.channel._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _channel = reader.tgread_object()
        return cls(channel=_channel)


class DeleteHistoryRequest(TLRequest):
    CONSTRUCTOR_ID = 0xaf369d42
    SUBCLASS_OF_ID = 0xf5b399ac

    def __init__(self, channel: 'TypeInputChannel', max_id: int):
        """
        :returns Bool: This type has no constructors.
        """
        self.channel = channel
        self.max_id = max_id

    async def resolve(self, client, utils):
        self.channel = utils.get_input_channel(await client.get_input_entity(self.channel))

    def to_dict(self):
        return {
            '_': 'DeleteHistoryRequest',
            'channel': self.channel.to_dict() if isinstance(self.channel, TLObject) else self.channel,
            'max_id': self.max_id
        }

    def _bytes(self):
        return b''.join((
            b'B\x9d6\xaf',
            self.channel._bytes(),
            struct.pack('<i', self.max_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _channel = reader.tgread_object()
        _max_id = reader.read_int()
        return cls(channel=_channel, max_id=_max_id)


class DeleteMessagesRequest(TLRequest):
    CONSTRUCTOR_ID = 0x84c1fd4e
    SUBCLASS_OF_ID = 0xced3c06e

    # noinspection PyShadowingBuiltins
    def __init__(self, channel: 'TypeInputChannel', id: List[int]):
        """
        :returns messages.AffectedMessages: Instance of AffectedMessages.
        """
        self.channel = channel
        self.id = id

    async def resolve(self, client, utils):
        self.channel = utils.get_input_channel(await client.get_input_entity(self.channel))

    def to_dict(self):
        return {
            '_': 'DeleteMessagesRequest',
            'channel': self.channel.to_dict() if isinstance(self.channel, TLObject) else self.channel,
            'id': [] if self.id is None else self.id[:]
        }

    def _bytes(self):
        return b''.join((
            b'N\xfd\xc1\x84',
            self.channel._bytes(),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.id)),b''.join(struct.pack('<i', x) for x in self.id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _channel = reader.tgread_object()
        reader.read_int()
        _id = []
        for _ in range(reader.read_int()):
            _x = reader.read_int()
            _id.append(_x)

        return cls(channel=_channel, id=_id)


class DeleteUserHistoryRequest(TLRequest):
    CONSTRUCTOR_ID = 0xd10dd71b
    SUBCLASS_OF_ID = 0x2c49c116

    def __init__(self, channel: 'TypeInputChannel', user_id: 'TypeInputUser'):
        """
        :returns messages.AffectedHistory: Instance of AffectedHistory.
        """
        self.channel = channel
        self.user_id = user_id

    async def resolve(self, client, utils):
        self.channel = utils.get_input_channel(await client.get_input_entity(self.channel))
        self.user_id = utils.get_input_user(await client.get_input_entity(self.user_id))

    def to_dict(self):
        return {
            '_': 'DeleteUserHistoryRequest',
            'channel': self.channel.to_dict() if isinstance(self.channel, TLObject) else self.channel,
            'user_id': self.user_id.to_dict() if isinstance(self.user_id, TLObject) else self.user_id
        }

    def _bytes(self):
        return b''.join((
            b'\x1b\xd7\r\xd1',
            self.channel._bytes(),
            self.user_id._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _channel = reader.tgread_object()
        _user_id = reader.tgread_object()
        return cls(channel=_channel, user_id=_user_id)


class EditAdminRequest(TLRequest):
    CONSTRUCTOR_ID = 0xd33c8902
    SUBCLASS_OF_ID = 0x8af52aac

    def __init__(self, channel: 'TypeInputChannel', user_id: 'TypeInputUser', admin_rights: 'TypeChatAdminRights', rank: str):
        """
        :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
        """
        self.channel = channel
        self.user_id = user_id
        self.admin_rights = admin_rights
        self.rank = rank

    async def resolve(self, client, utils):
        self.channel = utils.get_input_channel(await client.get_input_entity(self.channel))
        self.user_id = utils.get_input_user(await client.get_input_entity(self.user_id))

    def to_dict(self):
        return {
            '_': 'EditAdminRequest',
            'channel': self.channel.to_dict() if isinstance(self.channel, TLObject) else self.channel,
            'user_id': self.user_id.to_dict() if isinstance(self.user_id, TLObject) else self.user_id,
            'admin_rights': self.admin_rights.to_dict() if isinstance(self.admin_rights, TLObject) else self.admin_rights,
            'rank': self.rank
        }

    def _bytes(self):
        return b''.join((
            b'\x02\x89<\xd3',
            self.channel._bytes(),
            self.user_id._bytes(),
            self.admin_rights._bytes(),
            self.serialize_bytes(self.rank),
        ))

    @classmethod
    def from_reader(cls, reader):
        _channel = reader.tgread_object()
        _user_id = reader.tgread_object()
        _admin_rights = reader.tgread_object()
        _rank = reader.tgread_string()
        return cls(channel=_channel, user_id=_user_id, admin_rights=_admin_rights, rank=_rank)


class EditBannedRequest(TLRequest):
    CONSTRUCTOR_ID = 0x96e6cd81
    SUBCLASS_OF_ID = 0x8af52aac

    def __init__(self, channel: 'TypeInputChannel', participant: 'TypeInputPeer', banned_rights: 'TypeChatBannedRights'):
        """
        :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
        """
        self.channel = channel
        self.participant = participant
        self.banned_rights = banned_rights

    async def resolve(self, client, utils):
        self.channel = utils.get_input_channel(await client.get_input_entity(self.channel))
        self.participant = utils.get_input_peer(await client.get_input_entity(self.participant))

    def to_dict(self):
        return {
            '_': 'EditBannedRequest',
            'channel': self.channel.to_dict() if isinstance(self.channel, TLObject) else self.channel,
            'participant': self.participant.to_dict() if isinstance(self.participant, TLObject) else self.participant,
            'banned_rights': self.banned_rights.to_dict() if isinstance(self.banned_rights, TLObject) else self.banned_rights
        }

    def _bytes(self):
        return b''.join((
            b'\x81\xcd\xe6\x96',
            self.channel._bytes(),
            self.participant._bytes(),
            self.banned_rights._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _channel = reader.tgread_object()
        _participant = reader.tgread_object()
        _banned_rights = reader.tgread_object()
        return cls(channel=_channel, participant=_participant, banned_rights=_banned_rights)


class EditCreatorRequest(TLRequest):
    CONSTRUCTOR_ID = 0x8f38cd1f
    SUBCLASS_OF_ID = 0x8af52aac

    def __init__(self, channel: 'TypeInputChannel', user_id: 'TypeInputUser', password: 'TypeInputCheckPasswordSRP'):
        """
        :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
        """
        self.channel = channel
        self.user_id = user_id
        self.password = password

    async def resolve(self, client, utils):
        self.channel = utils.get_input_channel(await client.get_input_entity(self.channel))
        self.user_id = utils.get_input_user(await client.get_input_entity(self.user_id))

    def to_dict(self):
        return {
            '_': 'EditCreatorRequest',
            'channel': self.channel.to_dict() if isinstance(self.channel, TLObject) else self.channel,
            'user_id': self.user_id.to_dict() if isinstance(self.user_id, TLObject) else self.user_id,
            'password': self.password.to_dict() if isinstance(self.password, TLObject) else self.password
        }

    def _bytes(self):
        return b''.join((
            b'\x1f\xcd8\x8f',
            self.channel._bytes(),
            self.user_id._bytes(),
            self.password._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _channel = reader.tgread_object()
        _user_id = reader.tgread_object()
        _password = reader.tgread_object()
        return cls(channel=_channel, user_id=_user_id, password=_password)


class EditLocationRequest(TLRequest):
    CONSTRUCTOR_ID = 0x58e63f6d
    SUBCLASS_OF_ID = 0xf5b399ac

    def __init__(self, channel: 'TypeInputChannel', geo_point: 'TypeInputGeoPoint', address: str):
        """
        :returns Bool: This type has no constructors.
        """
        self.channel = channel
        self.geo_point = geo_point
        self.address = address

    async def resolve(self, client, utils):
        self.channel = utils.get_input_channel(await client.get_input_entity(self.channel))

    def to_dict(self):
        return {
            '_': 'EditLocationRequest',
            'channel': self.channel.to_dict() if isinstance(self.channel, TLObject) else self.channel,
            'geo_point': self.geo_point.to_dict() if isinstance(self.geo_point, TLObject) else self.geo_point,
            'address': self.address
        }

    def _bytes(self):
        return b''.join((
            b'm?\xe6X',
            self.channel._bytes(),
            self.geo_point._bytes(),
            self.serialize_bytes(self.address),
        ))

    @classmethod
    def from_reader(cls, reader):
        _channel = reader.tgread_object()
        _geo_point = reader.tgread_object()
        _address = reader.tgread_string()
        return cls(channel=_channel, geo_point=_geo_point, address=_address)


class EditPhotoRequest(TLRequest):
    CONSTRUCTOR_ID = 0xf12e57c9
    SUBCLASS_OF_ID = 0x8af52aac

    def __init__(self, channel: 'TypeInputChannel', photo: 'TypeInputChatPhoto'):
        """
        :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
        """
        self.channel = channel
        self.photo = photo

    async def resolve(self, client, utils):
        self.channel = utils.get_input_channel(await client.get_input_entity(self.channel))
        self.photo = utils.get_input_chat_photo(self.photo)

    def to_dict(self):
        return {
            '_': 'EditPhotoRequest',
            'channel': self.channel.to_dict() if isinstance(self.channel, TLObject) else self.channel,
            'photo': self.photo.to_dict() if isinstance(self.photo, TLObject) else self.photo
        }

    def _bytes(self):
        return b''.join((
            b'\xc9W.\xf1',
            self.channel._bytes(),
            self.photo._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _channel = reader.tgread_object()
        _photo = reader.tgread_object()
        return cls(channel=_channel, photo=_photo)


class EditTitleRequest(TLRequest):
    CONSTRUCTOR_ID = 0x566decd0
    SUBCLASS_OF_ID = 0x8af52aac

    def __init__(self, channel: 'TypeInputChannel', title: str):
        """
        :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
        """
        self.channel = channel
        self.title = title

    async def resolve(self, client, utils):
        self.channel = utils.get_input_channel(await client.get_input_entity(self.channel))

    def to_dict(self):
        return {
            '_': 'EditTitleRequest',
            'channel': self.channel.to_dict() if isinstance(self.channel, TLObject) else self.channel,
            'title': self.title
        }

    def _bytes(self):
        return b''.join((
            b'\xd0\xecmV',
            self.channel._bytes(),
            self.serialize_bytes(self.title),
        ))

    @classmethod
    def from_reader(cls, reader):
        _channel = reader.tgread_object()
        _title = reader.tgread_string()
        return cls(channel=_channel, title=_title)


class ExportMessageLinkRequest(TLRequest):
    CONSTRUCTOR_ID = 0xe63fadeb
    SUBCLASS_OF_ID = 0xdee644cc

    # noinspection PyShadowingBuiltins
    def __init__(self, channel: 'TypeInputChannel', id: int, grouped: Optional[bool]=None, thread: Optional[bool]=None):
        """
        :returns ExportedMessageLink: Instance of ExportedMessageLink.
        """
        self.channel = channel
        self.id = id
        self.grouped = grouped
        self.thread = thread

    async def resolve(self, client, utils):
        self.channel = utils.get_input_channel(await client.get_input_entity(self.channel))

    def to_dict(self):
        return {
            '_': 'ExportMessageLinkRequest',
            'channel': self.channel.to_dict() if isinstance(self.channel, TLObject) else self.channel,
            'id': self.id,
            'grouped': self.grouped,
            'thread': self.thread
        }

    def _bytes(self):
        return b''.join((
            b'\xeb\xad?\xe6',
            struct.pack('<I', (0 if self.grouped is None or self.grouped is False else 1) | (0 if self.thread is None or self.thread is False else 2)),
            self.channel._bytes(),
            struct.pack('<i', self.id),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _grouped = bool(flags & 1)
        _thread = bool(flags & 2)
        _channel = reader.tgread_object()
        _id = reader.read_int()
        return cls(channel=_channel, id=_id, grouped=_grouped, thread=_thread)


class GetAdminLogRequest(TLRequest):
    CONSTRUCTOR_ID = 0x33ddf480
    SUBCLASS_OF_ID = 0x51f076bc

    def __init__(self, channel: 'TypeInputChannel', q: str, max_id: int, min_id: int, limit: int, events_filter: Optional['TypeChannelAdminLogEventsFilter']=None, admins: Optional[List['TypeInputUser']]=None):
        """
        :returns channels.AdminLogResults: Instance of AdminLogResults.
        """
        self.channel = channel
        self.q = q
        self.max_id = max_id
        self.min_id = min_id
        self.limit = limit
        self.events_filter = events_filter
        self.admins = admins

    async def resolve(self, client, utils):
        self.channel = utils.get_input_channel(await client.get_input_entity(self.channel))
        if self.admins:
            _tmp = []
            for _x in self.admins:
                _tmp.append(utils.get_input_user(await client.get_input_entity(_x)))

            self.admins = _tmp

    def to_dict(self):
        return {
            '_': 'GetAdminLogRequest',
            'channel': self.channel.to_dict() if isinstance(self.channel, TLObject) else self.channel,
            'q': self.q,
            'max_id': self.max_id,
            'min_id': self.min_id,
            'limit': self.limit,
            'events_filter': self.events_filter.to_dict() if isinstance(self.events_filter, TLObject) else self.events_filter,
            'admins': [] if self.admins is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.admins]
        }

    def _bytes(self):
        return b''.join((
            b'\x80\xf4\xdd3',
            struct.pack('<I', (0 if self.events_filter is None or self.events_filter is False else 1) | (0 if self.admins is None or self.admins is False else 2)),
            self.channel._bytes(),
            self.serialize_bytes(self.q),
            b'' if self.events_filter is None or self.events_filter is False else (self.events_filter._bytes()),
            b'' if self.admins is None or self.admins is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.admins)),b''.join(x._bytes() for x in self.admins))),
            struct.pack('<q', self.max_id),
            struct.pack('<q', self.min_id),
            struct.pack('<i', self.limit),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _channel = reader.tgread_object()
        _q = reader.tgread_string()
        if flags & 1:
            _events_filter = reader.tgread_object()
        else:
            _events_filter = None
        if flags & 2:
            reader.read_int()
            _admins = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _admins.append(_x)

        else:
            _admins = None
        _max_id = reader.read_long()
        _min_id = reader.read_long()
        _limit = reader.read_int()
        return cls(channel=_channel, q=_q, max_id=_max_id, min_id=_min_id, limit=_limit, events_filter=_events_filter, admins=_admins)


class GetAdminedPublicChannelsRequest(TLRequest):
    CONSTRUCTOR_ID = 0xf8b036af
    SUBCLASS_OF_ID = 0x99d5cb14

    def __init__(self, by_location: Optional[bool]=None, check_limit: Optional[bool]=None):
        """
        :returns messages.Chats: Instance of either Chats, ChatsSlice.
        """
        self.by_location = by_location
        self.check_limit = check_limit

    def to_dict(self):
        return {
            '_': 'GetAdminedPublicChannelsRequest',
            'by_location': self.by_location,
            'check_limit': self.check_limit
        }

    def _bytes(self):
        return b''.join((
            b'\xaf6\xb0\xf8',
            struct.pack('<I', (0 if self.by_location is None or self.by_location is False else 1) | (0 if self.check_limit is None or self.check_limit is False else 2)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _by_location = bool(flags & 1)
        _check_limit = bool(flags & 2)
        return cls(by_location=_by_location, check_limit=_check_limit)


class GetChannelsRequest(TLRequest):
    CONSTRUCTOR_ID = 0xa7f6bbb
    SUBCLASS_OF_ID = 0x99d5cb14

    # noinspection PyShadowingBuiltins
    def __init__(self, id: List['TypeInputChannel']):
        """
        :returns messages.Chats: Instance of either Chats, ChatsSlice.
        """
        self.id = id

    async def resolve(self, client, utils):
        _tmp = []
        for _x in self.id:
            _tmp.append(utils.get_input_channel(await client.get_input_entity(_x)))

        self.id = _tmp

    def to_dict(self):
        return {
            '_': 'GetChannelsRequest',
            'id': [] if self.id is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.id]
        }

    def _bytes(self):
        return b''.join((
            b'\xbbk\x7f\n',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.id)),b''.join(x._bytes() for x in self.id),
        ))

    @classmethod
    def from_reader(cls, reader):
        reader.read_int()
        _id = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _id.append(_x)

        return cls(id=_id)


class GetFullChannelRequest(TLRequest):
    CONSTRUCTOR_ID = 0x8736a09
    SUBCLASS_OF_ID = 0x225a5109

    def __init__(self, channel: 'TypeInputChannel'):
        """
        :returns messages.ChatFull: Instance of ChatFull.
        """
        self.channel = channel

    async def resolve(self, client, utils):
        self.channel = utils.get_input_channel(await client.get_input_entity(self.channel))

    def to_dict(self):
        return {
            '_': 'GetFullChannelRequest',
            'channel': self.channel.to_dict() if isinstance(self.channel, TLObject) else self.channel
        }

    def _bytes(self):
        return b''.join((
            b'\tjs\x08',
            self.channel._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _channel = reader.tgread_object()
        return cls(channel=_channel)


class GetGroupsForDiscussionRequest(TLRequest):
    CONSTRUCTOR_ID = 0xf5dad378
    SUBCLASS_OF_ID = 0x99d5cb14

    def to_dict(self):
        return {
            '_': 'GetGroupsForDiscussionRequest'
        }

    def _bytes(self):
        return b''.join((
            b'x\xd3\xda\xf5',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class GetInactiveChannelsRequest(TLRequest):
    CONSTRUCTOR_ID = 0x11e831ee
    SUBCLASS_OF_ID = 0x8bf3d7d4

    def to_dict(self):
        return {
            '_': 'GetInactiveChannelsRequest'
        }

    def _bytes(self):
        return b''.join((
            b'\xee1\xe8\x11',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class GetLeftChannelsRequest(TLRequest):
    CONSTRUCTOR_ID = 0x8341ecc0
    SUBCLASS_OF_ID = 0x99d5cb14

    def __init__(self, offset: int):
        """
        :returns messages.Chats: Instance of either Chats, ChatsSlice.
        """
        self.offset = offset

    def to_dict(self):
        return {
            '_': 'GetLeftChannelsRequest',
            'offset': self.offset
        }

    def _bytes(self):
        return b''.join((
            b'\xc0\xecA\x83',
            struct.pack('<i', self.offset),
        ))

    @classmethod
    def from_reader(cls, reader):
        _offset = reader.read_int()
        return cls(offset=_offset)


class GetMessagesRequest(TLRequest):
    CONSTRUCTOR_ID = 0xad8c9a23
    SUBCLASS_OF_ID = 0xd4b40b5e

    # noinspection PyShadowingBuiltins
    def __init__(self, channel: 'TypeInputChannel', id: List['TypeInputMessage']):
        """
        :returns messages.Messages: Instance of either Messages, MessagesSlice, ChannelMessages, MessagesNotModified.
        """
        self.channel = channel
        self.id = id

    async def resolve(self, client, utils):
        self.channel = utils.get_input_channel(await client.get_input_entity(self.channel))
        _tmp = []
        for _x in self.id:
            _tmp.append(utils.get_input_message(_x))

        self.id = _tmp

    def to_dict(self):
        return {
            '_': 'GetMessagesRequest',
            'channel': self.channel.to_dict() if isinstance(self.channel, TLObject) else self.channel,
            'id': [] if self.id is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.id]
        }

    def _bytes(self):
        return b''.join((
            b'#\x9a\x8c\xad',
            self.channel._bytes(),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.id)),b''.join(x._bytes() for x in self.id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _channel = reader.tgread_object()
        reader.read_int()
        _id = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _id.append(_x)

        return cls(channel=_channel, id=_id)


class GetParticipantRequest(TLRequest):
    CONSTRUCTOR_ID = 0xa0ab6cc6
    SUBCLASS_OF_ID = 0x6658151a

    def __init__(self, channel: 'TypeInputChannel', participant: 'TypeInputPeer'):
        """
        :returns channels.ChannelParticipant: Instance of ChannelParticipant.
        """
        self.channel = channel
        self.participant = participant

    async def resolve(self, client, utils):
        self.channel = utils.get_input_channel(await client.get_input_entity(self.channel))
        self.participant = utils.get_input_peer(await client.get_input_entity(self.participant))

    def to_dict(self):
        return {
            '_': 'GetParticipantRequest',
            'channel': self.channel.to_dict() if isinstance(self.channel, TLObject) else self.channel,
            'participant': self.participant.to_dict() if isinstance(self.participant, TLObject) else self.participant
        }

    def _bytes(self):
        return b''.join((
            b'\xc6l\xab\xa0',
            self.channel._bytes(),
            self.participant._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _channel = reader.tgread_object()
        _participant = reader.tgread_object()
        return cls(channel=_channel, participant=_participant)


class GetParticipantsRequest(TLRequest):
    CONSTRUCTOR_ID = 0x77ced9d0
    SUBCLASS_OF_ID = 0xe60a6e64

    # noinspection PyShadowingBuiltins
    def __init__(self, channel: 'TypeInputChannel', filter: 'TypeChannelParticipantsFilter', offset: int, limit: int, hash: int):
        """
        :returns channels.ChannelParticipants: Instance of either ChannelParticipants, ChannelParticipantsNotModified.
        """
        self.channel = channel
        self.filter = filter
        self.offset = offset
        self.limit = limit
        self.hash = hash

    async def resolve(self, client, utils):
        self.channel = utils.get_input_channel(await client.get_input_entity(self.channel))

    def to_dict(self):
        return {
            '_': 'GetParticipantsRequest',
            'channel': self.channel.to_dict() if isinstance(self.channel, TLObject) else self.channel,
            'filter': self.filter.to_dict() if isinstance(self.filter, TLObject) else self.filter,
            'offset': self.offset,
            'limit': self.limit,
            'hash': self.hash
        }

    def _bytes(self):
        return b''.join((
            b'\xd0\xd9\xcew',
            self.channel._bytes(),
            self.filter._bytes(),
            struct.pack('<i', self.offset),
            struct.pack('<i', self.limit),
            struct.pack('<q', self.hash),
        ))

    @classmethod
    def from_reader(cls, reader):
        _channel = reader.tgread_object()
        _filter = reader.tgread_object()
        _offset = reader.read_int()
        _limit = reader.read_int()
        _hash = reader.read_long()
        return cls(channel=_channel, filter=_filter, offset=_offset, limit=_limit, hash=_hash)


class GetSponsoredMessagesRequest(TLRequest):
    CONSTRUCTOR_ID = 0xec210fbf
    SUBCLASS_OF_ID = 0x7f4169e0

    def __init__(self, channel: 'TypeInputChannel'):
        """
        :returns messages.SponsoredMessages: Instance of SponsoredMessages.
        """
        self.channel = channel

    async def resolve(self, client, utils):
        self.channel = utils.get_input_channel(await client.get_input_entity(self.channel))

    def to_dict(self):
        return {
            '_': 'GetSponsoredMessagesRequest',
            'channel': self.channel.to_dict() if isinstance(self.channel, TLObject) else self.channel
        }

    def _bytes(self):
        return b''.join((
            b'\xbf\x0f!\xec',
            self.channel._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _channel = reader.tgread_object()
        return cls(channel=_channel)


class InviteToChannelRequest(TLRequest):
    CONSTRUCTOR_ID = 0x199f3a6c
    SUBCLASS_OF_ID = 0x8af52aac

    def __init__(self, channel: 'TypeInputChannel', users: List['TypeInputUser']):
        """
        :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
        """
        self.channel = channel
        self.users = users

    async def resolve(self, client, utils):
        self.channel = utils.get_input_channel(await client.get_input_entity(self.channel))
        _tmp = []
        for _x in self.users:
            _tmp.append(utils.get_input_user(await client.get_input_entity(_x)))

        self.users = _tmp

    def to_dict(self):
        return {
            '_': 'InviteToChannelRequest',
            'channel': self.channel.to_dict() if isinstance(self.channel, TLObject) else self.channel,
            'users': [] if self.users is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.users]
        }

    def _bytes(self):
        return b''.join((
            b'l:\x9f\x19',
            self.channel._bytes(),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.users)),b''.join(x._bytes() for x in self.users),
        ))

    @classmethod
    def from_reader(cls, reader):
        _channel = reader.tgread_object()
        reader.read_int()
        _users = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _users.append(_x)

        return cls(channel=_channel, users=_users)


class JoinChannelRequest(TLRequest):
    CONSTRUCTOR_ID = 0x24b524c5
    SUBCLASS_OF_ID = 0x8af52aac

    def __init__(self, channel: 'TypeInputChannel'):
        """
        :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
        """
        self.channel = channel

    async def resolve(self, client, utils):
        self.channel = utils.get_input_channel(await client.get_input_entity(self.channel))

    def to_dict(self):
        return {
            '_': 'JoinChannelRequest',
            'channel': self.channel.to_dict() if isinstance(self.channel, TLObject) else self.channel
        }

    def _bytes(self):
        return b''.join((
            b'\xc5$\xb5$',
            self.channel._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _channel = reader.tgread_object()
        return cls(channel=_channel)


class LeaveChannelRequest(TLRequest):
    CONSTRUCTOR_ID = 0xf836aa95
    SUBCLASS_OF_ID = 0x8af52aac

    def __init__(self, channel: 'TypeInputChannel'):
        """
        :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
        """
        self.channel = channel

    async def resolve(self, client, utils):
        self.channel = utils.get_input_channel(await client.get_input_entity(self.channel))

    def to_dict(self):
        return {
            '_': 'LeaveChannelRequest',
            'channel': self.channel.to_dict() if isinstance(self.channel, TLObject) else self.channel
        }

    def _bytes(self):
        return b''.join((
            b'\x95\xaa6\xf8',
            self.channel._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _channel = reader.tgread_object()
        return cls(channel=_channel)


class ReadHistoryRequest(TLRequest):
    CONSTRUCTOR_ID = 0xcc104937
    SUBCLASS_OF_ID = 0xf5b399ac

    def __init__(self, channel: 'TypeInputChannel', max_id: int):
        """
        :returns Bool: This type has no constructors.
        """
        self.channel = channel
        self.max_id = max_id

    async def resolve(self, client, utils):
        self.channel = utils.get_input_channel(await client.get_input_entity(self.channel))

    def to_dict(self):
        return {
            '_': 'ReadHistoryRequest',
            'channel': self.channel.to_dict() if isinstance(self.channel, TLObject) else self.channel,
            'max_id': self.max_id
        }

    def _bytes(self):
        return b''.join((
            b'7I\x10\xcc',
            self.channel._bytes(),
            struct.pack('<i', self.max_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _channel = reader.tgread_object()
        _max_id = reader.read_int()
        return cls(channel=_channel, max_id=_max_id)


class ReadMessageContentsRequest(TLRequest):
    CONSTRUCTOR_ID = 0xeab5dc38
    SUBCLASS_OF_ID = 0xf5b399ac

    # noinspection PyShadowingBuiltins
    def __init__(self, channel: 'TypeInputChannel', id: List[int]):
        """
        :returns Bool: This type has no constructors.
        """
        self.channel = channel
        self.id = id

    async def resolve(self, client, utils):
        self.channel = utils.get_input_channel(await client.get_input_entity(self.channel))

    def to_dict(self):
        return {
            '_': 'ReadMessageContentsRequest',
            'channel': self.channel.to_dict() if isinstance(self.channel, TLObject) else self.channel,
            'id': [] if self.id is None else self.id[:]
        }

    def _bytes(self):
        return b''.join((
            b'8\xdc\xb5\xea',
            self.channel._bytes(),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.id)),b''.join(struct.pack('<i', x) for x in self.id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _channel = reader.tgread_object()
        reader.read_int()
        _id = []
        for _ in range(reader.read_int()):
            _x = reader.read_int()
            _id.append(_x)

        return cls(channel=_channel, id=_id)


class ReportSpamRequest(TLRequest):
    CONSTRUCTOR_ID = 0xfe087810
    SUBCLASS_OF_ID = 0xf5b399ac

    # noinspection PyShadowingBuiltins
    def __init__(self, channel: 'TypeInputChannel', user_id: 'TypeInputUser', id: List[int]):
        """
        :returns Bool: This type has no constructors.
        """
        self.channel = channel
        self.user_id = user_id
        self.id = id

    async def resolve(self, client, utils):
        self.channel = utils.get_input_channel(await client.get_input_entity(self.channel))
        self.user_id = utils.get_input_user(await client.get_input_entity(self.user_id))

    def to_dict(self):
        return {
            '_': 'ReportSpamRequest',
            'channel': self.channel.to_dict() if isinstance(self.channel, TLObject) else self.channel,
            'user_id': self.user_id.to_dict() if isinstance(self.user_id, TLObject) else self.user_id,
            'id': [] if self.id is None else self.id[:]
        }

    def _bytes(self):
        return b''.join((
            b'\x10x\x08\xfe',
            self.channel._bytes(),
            self.user_id._bytes(),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.id)),b''.join(struct.pack('<i', x) for x in self.id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _channel = reader.tgread_object()
        _user_id = reader.tgread_object()
        reader.read_int()
        _id = []
        for _ in range(reader.read_int()):
            _x = reader.read_int()
            _id.append(_x)

        return cls(channel=_channel, user_id=_user_id, id=_id)


class SetDiscussionGroupRequest(TLRequest):
    CONSTRUCTOR_ID = 0x40582bb2
    SUBCLASS_OF_ID = 0xf5b399ac

    def __init__(self, broadcast: 'TypeInputChannel', group: 'TypeInputChannel'):
        """
        :returns Bool: This type has no constructors.
        """
        self.broadcast = broadcast
        self.group = group

    async def resolve(self, client, utils):
        self.broadcast = utils.get_input_channel(await client.get_input_entity(self.broadcast))
        self.group = utils.get_input_channel(await client.get_input_entity(self.group))

    def to_dict(self):
        return {
            '_': 'SetDiscussionGroupRequest',
            'broadcast': self.broadcast.to_dict() if isinstance(self.broadcast, TLObject) else self.broadcast,
            'group': self.group.to_dict() if isinstance(self.group, TLObject) else self.group
        }

    def _bytes(self):
        return b''.join((
            b'\xb2+X@',
            self.broadcast._bytes(),
            self.group._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _broadcast = reader.tgread_object()
        _group = reader.tgread_object()
        return cls(broadcast=_broadcast, group=_group)


class SetStickersRequest(TLRequest):
    CONSTRUCTOR_ID = 0xea8ca4f9
    SUBCLASS_OF_ID = 0xf5b399ac

    def __init__(self, channel: 'TypeInputChannel', stickerset: 'TypeInputStickerSet'):
        """
        :returns Bool: This type has no constructors.
        """
        self.channel = channel
        self.stickerset = stickerset

    async def resolve(self, client, utils):
        self.channel = utils.get_input_channel(await client.get_input_entity(self.channel))

    def to_dict(self):
        return {
            '_': 'SetStickersRequest',
            'channel': self.channel.to_dict() if isinstance(self.channel, TLObject) else self.channel,
            'stickerset': self.stickerset.to_dict() if isinstance(self.stickerset, TLObject) else self.stickerset
        }

    def _bytes(self):
        return b''.join((
            b'\xf9\xa4\x8c\xea',
            self.channel._bytes(),
            self.stickerset._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _channel = reader.tgread_object()
        _stickerset = reader.tgread_object()
        return cls(channel=_channel, stickerset=_stickerset)


class TogglePreHistoryHiddenRequest(TLRequest):
    CONSTRUCTOR_ID = 0xeabbb94c
    SUBCLASS_OF_ID = 0x8af52aac

    def __init__(self, channel: 'TypeInputChannel', enabled: bool):
        """
        :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
        """
        self.channel = channel
        self.enabled = enabled

    async def resolve(self, client, utils):
        self.channel = utils.get_input_channel(await client.get_input_entity(self.channel))

    def to_dict(self):
        return {
            '_': 'TogglePreHistoryHiddenRequest',
            'channel': self.channel.to_dict() if isinstance(self.channel, TLObject) else self.channel,
            'enabled': self.enabled
        }

    def _bytes(self):
        return b''.join((
            b'L\xb9\xbb\xea',
            self.channel._bytes(),
            b'\xb5ur\x99' if self.enabled else b'7\x97y\xbc',
        ))

    @classmethod
    def from_reader(cls, reader):
        _channel = reader.tgread_object()
        _enabled = reader.tgread_bool()
        return cls(channel=_channel, enabled=_enabled)


class ToggleSignaturesRequest(TLRequest):
    CONSTRUCTOR_ID = 0x1f69b606
    SUBCLASS_OF_ID = 0x8af52aac

    def __init__(self, channel: 'TypeInputChannel', enabled: bool):
        """
        :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
        """
        self.channel = channel
        self.enabled = enabled

    async def resolve(self, client, utils):
        self.channel = utils.get_input_channel(await client.get_input_entity(self.channel))

    def to_dict(self):
        return {
            '_': 'ToggleSignaturesRequest',
            'channel': self.channel.to_dict() if isinstance(self.channel, TLObject) else self.channel,
            'enabled': self.enabled
        }

    def _bytes(self):
        return b''.join((
            b'\x06\xb6i\x1f',
            self.channel._bytes(),
            b'\xb5ur\x99' if self.enabled else b'7\x97y\xbc',
        ))

    @classmethod
    def from_reader(cls, reader):
        _channel = reader.tgread_object()
        _enabled = reader.tgread_bool()
        return cls(channel=_channel, enabled=_enabled)


class ToggleSlowModeRequest(TLRequest):
    CONSTRUCTOR_ID = 0xedd49ef0
    SUBCLASS_OF_ID = 0x8af52aac

    def __init__(self, channel: 'TypeInputChannel', seconds: int):
        """
        :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
        """
        self.channel = channel
        self.seconds = seconds

    async def resolve(self, client, utils):
        self.channel = utils.get_input_channel(await client.get_input_entity(self.channel))

    def to_dict(self):
        return {
            '_': 'ToggleSlowModeRequest',
            'channel': self.channel.to_dict() if isinstance(self.channel, TLObject) else self.channel,
            'seconds': self.seconds
        }

    def _bytes(self):
        return b''.join((
            b'\xf0\x9e\xd4\xed',
            self.channel._bytes(),
            struct.pack('<i', self.seconds),
        ))

    @classmethod
    def from_reader(cls, reader):
        _channel = reader.tgread_object()
        _seconds = reader.read_int()
        return cls(channel=_channel, seconds=_seconds)


class UpdateUsernameRequest(TLRequest):
    CONSTRUCTOR_ID = 0x3514b3de
    SUBCLASS_OF_ID = 0xf5b399ac

    def __init__(self, channel: 'TypeInputChannel', username: str):
        """
        :returns Bool: This type has no constructors.
        """
        self.channel = channel
        self.username = username

    async def resolve(self, client, utils):
        self.channel = utils.get_input_channel(await client.get_input_entity(self.channel))

    def to_dict(self):
        return {
            '_': 'UpdateUsernameRequest',
            'channel': self.channel.to_dict() if isinstance(self.channel, TLObject) else self.channel,
            'username': self.username
        }

    def _bytes(self):
        return b''.join((
            b'\xde\xb3\x145',
            self.channel._bytes(),
            self.serialize_bytes(self.username),
        ))

    @classmethod
    def from_reader(cls, reader):
        _channel = reader.tgread_object()
        _username = reader.tgread_string()
        return cls(channel=_channel, username=_username)


class ViewSponsoredMessageRequest(TLRequest):
    CONSTRUCTOR_ID = 0xbeaedb94
    SUBCLASS_OF_ID = 0xf5b399ac

    def __init__(self, channel: 'TypeInputChannel', random_id: bytes=None):
        """
        :returns Bool: This type has no constructors.
        """
        self.channel = channel
        self.random_id = random_id if random_id is not None else int.from_bytes(os.urandom(4), 'big', signed=True)

    async def resolve(self, client, utils):
        self.channel = utils.get_input_channel(await client.get_input_entity(self.channel))

    def to_dict(self):
        return {
            '_': 'ViewSponsoredMessageRequest',
            'channel': self.channel.to_dict() if isinstance(self.channel, TLObject) else self.channel,
            'random_id': self.random_id
        }

    def _bytes(self):
        return b''.join((
            b'\x94\xdb\xae\xbe',
            self.channel._bytes(),
            self.serialize_bytes(self.random_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _channel = reader.tgread_object()
        _random_id = reader.tgread_bytes()
        return cls(channel=_channel, random_id=_random_id)

