# -*- coding: utf-8 -*-
# Generated by Django 1.11.24 on 2020-01-09 20:53
from __future__ import unicode_literals

from datetime import timedelta
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone


def set_due_dates(apps, schema_editor):
    Event = apps.get_model('leprikon', 'Event')
    Event.objects.update(
        due_from=models.F('start_date') - timedelta(180),
        due_date=models.F('start_date'),
    )

    SchoolYearPeriod = apps.get_model('leprikon', 'SchoolYearPeriod')
    SchoolYearPeriod.objects.update(
        due_from=models.F('start') - timedelta(30),
        due_date=models.F('start') + timedelta(30),
    )


class Migration(migrations.Migration):

    dependencies = [
        ('leprikon', '0039_editable_texts'),
    ]

    operations = [
        migrations.AddField(
            model_name='event',
            name='due_date',
            field=models.DateField(default=django.utils.timezone.now, verbose_name='due date'),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='event',
            name='due_from',
            field=models.DateField(default=django.utils.timezone.now, verbose_name='due from'),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='schoolyearperiod',
            name='due_date',
            field=models.DateField(default=django.utils.timezone.now, verbose_name='due date'),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='schoolyearperiod',
            name='due_from',
            field=models.DateField(default=django.utils.timezone.now, verbose_name='due from'),
            preserve_default=False,
        ),
        migrations.RunPython(set_due_dates),
    ]
