from givenergy_modbus.model.battery import Battery
from tests.model.test_register_cache import (  # noqa: F401
    register_cache,
    register_cache_battery_daytime_discharging,
    register_cache_battery_missing,
    register_cache_battery_unsure,
)

EXPECTED_BATTERY_DICT = {
    'bms_firmware_version': 3005,
    'battery_design_capacity': 160.0,
    'battery_design_capacity_2': 160.0,
    'battery_full_capacity': 190.97,
    'battery_num_cells': 16,
    'battery_num_cycles': 12,
    'battery_remaining_capacity': 18.04,
    'battery_serial_number': 'BG1234G567',
    'battery_soc': 9,
    'battery_status_1_2': (0, 0),
    'battery_status_3_4': (6, 16),
    'battery_status_5_6': (1, 0),
    'battery_status_7': (0, 0),
    'temp_bms_mos': 17.2,
    'temp_battery_cells_1': 17.5,
    'temp_battery_cells_2': 16.7,
    'temp_battery_cells_3': 17.1,
    'temp_battery_cells_4': 16.1,
    'temp_battery_max': 17.4,
    'temp_battery_min': 16.7,
    'usb_inserted': True,
    'v_battery_cell_01': 3.117,
    'v_battery_cell_02': 3.124,
    'v_battery_cell_03': 3.129,
    'v_battery_cell_04': 3.129,
    'v_battery_cell_05': 3.125,
    'v_battery_cell_06': 3.13,
    'v_battery_cell_07': 3.122,
    'v_battery_cell_08': 3.116,
    'v_battery_cell_09': 3.111,
    'v_battery_cell_10': 3.105,
    'v_battery_cell_11': 3.119,
    'v_battery_cell_12': 3.134,
    'v_battery_cell_13': 3.146,
    'v_battery_cell_14': 3.116,
    'v_battery_cell_15': 3.135,
    'v_battery_cell_16': 3.119,
    'v_battery_cells_sum': 49.97,
    'v_battery_out': 50.029,
    'battery_warning_1_2': (0, 0),
    'e_battery_charge_total_2': 174.4,
    'e_battery_discharge_total_2': 169.6,
}


def test_from_orm(register_cache):  # noqa: F811
    """Ensure we can return a dict view of battery data."""
    assert Battery.from_orm(register_cache).dict() == EXPECTED_BATTERY_DICT


def test_from_orm_actual_data(register_cache_battery_daytime_discharging):  # noqa: F811
    """Ensure we can instantiate an instance of battery data from actual registers."""
    assert Battery.from_orm(register_cache_battery_daytime_discharging).dict() == {
        'battery_design_capacity': 160.0,
        'battery_design_capacity_2': 160.0,
        'battery_full_capacity': 195.13,
        'battery_num_cells': 16,
        'battery_num_cycles': 23,
        'battery_remaining_capacity': 131.42,
        'battery_serial_number': 'BG1234G567',
        'battery_soc': 67,
        'battery_status_1_2': (0, 0),
        'battery_status_3_4': (14, 16),
        'battery_status_5_6': (1, 0),
        'battery_status_7': (0, 0),
        'battery_warning_1_2': (0, 0),
        'bms_firmware_version': 3005,
        'temp_battery_cells_1': 16.8,
        'temp_battery_cells_2': 15.7,
        'temp_battery_cells_3': 16.5,
        'temp_battery_cells_4': 14.6,
        'temp_battery_max': 16.8,
        'temp_battery_min': 15.7,
        'temp_bms_mos': 17.2,
        'usb_inserted': True,
        'v_battery_cell_01': 3.232,
        'v_battery_cell_02': 3.237,
        'v_battery_cell_03': 3.235,
        'v_battery_cell_04': 3.232,
        'v_battery_cell_05': 3.235,
        'v_battery_cell_06': 3.229,
        'v_battery_cell_07': 3.237,
        'v_battery_cell_08': 3.233,
        'v_battery_cell_09': 3.238,
        'v_battery_cell_10': 3.237,
        'v_battery_cell_11': 3.235,
        'v_battery_cell_12': 3.235,
        'v_battery_cell_13': 3.235,
        'v_battery_cell_14': 3.235,
        'v_battery_cell_15': 3.24,
        'v_battery_cell_16': 3.238,
        'v_battery_cells_sum': 51.832,
        'v_battery_out': 51.816,
        'e_battery_charge_total_2': 174.4,
        'e_battery_discharge_total_2': 169.6,
    }


def test_from_orm_unsure_data(register_cache_battery_unsure):  # noqa: F811
    """Ensure we can instantiate an instance of battery data from actual registers."""
    assert Battery.from_orm(register_cache_battery_unsure).dict() == {
        'battery_design_capacity': 0.0,
        'battery_design_capacity_2': 0.0,
        'battery_full_capacity': 0.0,
        'battery_num_cells': 0,
        'battery_num_cycles': 0,
        'battery_remaining_capacity': 0.0,
        'battery_serial_number': '\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00',
        'battery_soc': 0,
        'battery_status_1_2': (0, 0),
        'battery_status_3_4': (0, 0),
        'battery_status_5_6': (0, 0),
        'battery_status_7': (0, 0),
        'battery_warning_1_2': (0, 0),
        'bms_firmware_version': 0,
        'temp_battery_cells_1': 5.2,
        'temp_battery_cells_2': 0.0,
        'temp_battery_cells_3': 0.0,
        'temp_battery_cells_4': 0.0,
        'temp_battery_max': 0.0,
        'temp_battery_min': 0.0,
        'temp_bms_mos': 25.6,
        'usb_inserted': False,
        'v_battery_cell_01': 0.0,
        'v_battery_cell_02': 0.0,
        'v_battery_cell_03': 0.0,
        'v_battery_cell_04': 0.0,
        'v_battery_cell_05': 0.0,
        'v_battery_cell_06': 0.0,
        'v_battery_cell_07': 0.0,
        'v_battery_cell_08': 0.0,
        'v_battery_cell_09': 0.0,
        'v_battery_cell_10': 0.0,
        'v_battery_cell_11': 0.0,
        'v_battery_cell_12': 0.0,
        'v_battery_cell_13': 0.0,
        'v_battery_cell_14': 0.0,
        'v_battery_cell_15': 0.0,
        'v_battery_cell_16': 0.0,
        'v_battery_cells_sum': 0.0,
        'v_battery_out': 0.0,
        'e_battery_charge_total_2': 0.0,
        'e_battery_discharge_total_2': 0.0,
    }


def test_from_orm_missing_data(register_cache_battery_missing):  # noqa: F811
    """Ensure we can instantiate an instance of battery data from actual registers."""
    assert Battery.from_orm(register_cache_battery_missing).dict() == {
        'battery_design_capacity': 0.0,
        'battery_design_capacity_2': 0.0,
        'battery_full_capacity': 0.0,
        'battery_num_cells': 0,
        'battery_num_cycles': 0,
        'battery_remaining_capacity': 0.0,
        'battery_serial_number': '\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00',
        'battery_soc': 0,
        'battery_status_1_2': (0, 0),
        'battery_status_3_4': (0, 0),
        'battery_status_5_6': (0, 0),
        'battery_status_7': (0, 0),
        'battery_warning_1_2': (0, 0),
        'bms_firmware_version': 0,
        'temp_battery_cells_1': 0.0,
        'temp_battery_cells_2': 0.0,
        'temp_battery_cells_3': 0.0,
        'temp_battery_cells_4': 0.0,
        'temp_battery_max': 0.0,
        'temp_battery_min': 0.0,
        'temp_bms_mos': 0.0,
        'usb_inserted': False,
        'v_battery_cell_01': 0.0,
        'v_battery_cell_02': 0.0,
        'v_battery_cell_03': 0.0,
        'v_battery_cell_04': 0.0,
        'v_battery_cell_05': 0.0,
        'v_battery_cell_06': 0.0,
        'v_battery_cell_07': 0.0,
        'v_battery_cell_08': 0.0,
        'v_battery_cell_09': 0.0,
        'v_battery_cell_10': 0.0,
        'v_battery_cell_11': 0.0,
        'v_battery_cell_12': 0.0,
        'v_battery_cell_13': 0.0,
        'v_battery_cell_14': 0.0,
        'v_battery_cell_15': 0.0,
        'v_battery_cell_16': 0.0,
        'v_battery_cells_sum': 0.0,
        'v_battery_out': 0.0,
        'e_battery_charge_total_2': 0.0,
        'e_battery_discharge_total_2': 0.0,
    }
