# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Dict, List, Mapping, Optional, Tuple, Union
from . import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['AlertTarget']


class AlertTarget(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 content_type: Optional[pulumi.Input[str]] = None,
                 custom_headers: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 email_subject: Optional[pulumi.Input[str]] = None,
                 is_html_content: Optional[pulumi.Input[bool]] = None,
                 method: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 recipient: Optional[pulumi.Input[str]] = None,
                 routes: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['AlertTargetRouteArgs']]]]] = None,
                 template: Optional[pulumi.Input[str]] = None,
                 triggers: Optional[pulumi.Input[List[pulumi.Input[str]]]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Provides a wavefront Alert Target resource. This allows alert targets to created, updated, and deleted.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_wavefront as wavefront

        test_target = wavefront.AlertTarget("testTarget",
            content_type="application/json",
            custom_headers={
                "Testing": "true",
            },
            description="Test target",
            method="WEBHOOK",
            recipient="https://hooks.slack.com/services/test/me",
            template="{}",
            triggers=[
                "ALERT_OPENED",
                "ALERT_RESOLVED",
            ])
        ```
        ## Attributes Reference

        * `target_id` - The target ID prefixed with `target:` for interpolating into a Wavefront Alert.

        ### Route

        The `route` mapping supports the following:

        * `method` - (Required)  The notification method used for notification target. One of `WEBHOOK`, `EMAIL`, `PAGERDUTY`.
        * `target` - (Required) The endpoint for the alert route. `EMAIL`: email address. `PAGERDUTY`: PagerDuty routing
          key. `WEBHOOK`: URL endpoint.
        * `filter` - (Required) String that filters the route. Space delimited.  Currently only allows a single key value pair.
          (e.g. `env prod`)

        ### Example

        ```python
        import pulumi
        import pulumi_wavefront as wavefront

        test_target = wavefront.AlertTarget("testTarget",
            content_type="application/json",
            custom_headers={
                "Testing": "true",
            },
            description="Test target",
            method="WEBHOOK",
            recipient="https://hooks.slack.com/services/test/me",
            routes=[
                wavefront.AlertTargetRouteArgs(
                    filter={
                        "key": "env",
                        "value": "prod",
                    },
                    method="WEBHOOK",
                    target="https://hooks.slack.com/services/test/me/prod",
                ),
                wavefront.AlertTargetRouteArgs(
                    filter={
                        "key": "env",
                        "value": "dev",
                    },
                    method="WEBHOOK",
                    target="https://hooks.slack.com/services/test/me/dev",
                ),
            ],
            template="{}",
            triggers=[
                "ALERT_OPENED",
                "ALERT_RESOLVED",
            ])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] content_type: The value of the `Content-Type` header of the webhook.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] custom_headers: A `string->string` map specifying the custome HTTP header key/value pairs that will be 
               sent in the requests with a method of `WEBHOOK`.
        :param pulumi.Input[str] description: Description describing this alert target.
        :param pulumi.Input[str] email_subject: The subject title of an email notification target.
        :param pulumi.Input[bool] is_html_content: Determine whether the email alert content is sent as HTML or text.
        :param pulumi.Input[str] method: The notification method used for notification target. One of `WEBHOOK`, `EMAIL`, `PAGERDUTY`.
        :param pulumi.Input[str] name: The name of the alert target as it is displayed in wavefront
        :param pulumi.Input[str] recipient: The end point for the notification Target.  `EMAIL`: email address. `PAGERDUTY`: PagerDuty 
               routing key. `WEBHOOK`: URL endpoint.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['AlertTargetRouteArgs']]]] routes: List of routing targets that this alert target will notify. See Route
        :param pulumi.Input[str] template: A mustache template that will form the body of the POST request, email and summary of the PagerDuty.
        :param pulumi.Input[List[pulumi.Input[str]]] triggers: A list of occurrences on which this webhook will be fired. Valid values are `ALERT_OPENED`,
               `ALERT_UPDATED`, `ALERT_RESOLVED`, `ALERT_MAINTENANCE`, `ALERT_SNOOZED`, `ALERT_INVALID`, `ALERT_NO_LONGER_INVALID`,
               `ALERT_RETRIGGERED`, `ALERT_NO_DATA`, `ALERT_NO_DATA_RESOLVED`, `ALERT_NO_DATA_MAINTENANCE`, `ALERT_SEVERITY_UPDATE`.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['content_type'] = content_type
            __props__['custom_headers'] = custom_headers
            if description is None:
                raise TypeError("Missing required property 'description'")
            __props__['description'] = description
            __props__['email_subject'] = email_subject
            __props__['is_html_content'] = is_html_content
            __props__['method'] = method
            __props__['name'] = name
            if recipient is None:
                raise TypeError("Missing required property 'recipient'")
            __props__['recipient'] = recipient
            __props__['routes'] = routes
            if template is None:
                raise TypeError("Missing required property 'template'")
            __props__['template'] = template
            if triggers is None:
                raise TypeError("Missing required property 'triggers'")
            __props__['triggers'] = triggers
            __props__['target_id'] = None
        super(AlertTarget, __self__).__init__(
            'wavefront:index/alertTarget:AlertTarget',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            content_type: Optional[pulumi.Input[str]] = None,
            custom_headers: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            email_subject: Optional[pulumi.Input[str]] = None,
            is_html_content: Optional[pulumi.Input[bool]] = None,
            method: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            recipient: Optional[pulumi.Input[str]] = None,
            routes: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['AlertTargetRouteArgs']]]]] = None,
            target_id: Optional[pulumi.Input[str]] = None,
            template: Optional[pulumi.Input[str]] = None,
            triggers: Optional[pulumi.Input[List[pulumi.Input[str]]]] = None) -> 'AlertTarget':
        """
        Get an existing AlertTarget resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] content_type: The value of the `Content-Type` header of the webhook.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] custom_headers: A `string->string` map specifying the custome HTTP header key/value pairs that will be 
               sent in the requests with a method of `WEBHOOK`.
        :param pulumi.Input[str] description: Description describing this alert target.
        :param pulumi.Input[str] email_subject: The subject title of an email notification target.
        :param pulumi.Input[bool] is_html_content: Determine whether the email alert content is sent as HTML or text.
        :param pulumi.Input[str] method: The notification method used for notification target. One of `WEBHOOK`, `EMAIL`, `PAGERDUTY`.
        :param pulumi.Input[str] name: The name of the alert target as it is displayed in wavefront
        :param pulumi.Input[str] recipient: The end point for the notification Target.  `EMAIL`: email address. `PAGERDUTY`: PagerDuty 
               routing key. `WEBHOOK`: URL endpoint.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['AlertTargetRouteArgs']]]] routes: List of routing targets that this alert target will notify. See Route
        :param pulumi.Input[str] template: A mustache template that will form the body of the POST request, email and summary of the PagerDuty.
        :param pulumi.Input[List[pulumi.Input[str]]] triggers: A list of occurrences on which this webhook will be fired. Valid values are `ALERT_OPENED`,
               `ALERT_UPDATED`, `ALERT_RESOLVED`, `ALERT_MAINTENANCE`, `ALERT_SNOOZED`, `ALERT_INVALID`, `ALERT_NO_LONGER_INVALID`,
               `ALERT_RETRIGGERED`, `ALERT_NO_DATA`, `ALERT_NO_DATA_RESOLVED`, `ALERT_NO_DATA_MAINTENANCE`, `ALERT_SEVERITY_UPDATE`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["content_type"] = content_type
        __props__["custom_headers"] = custom_headers
        __props__["description"] = description
        __props__["email_subject"] = email_subject
        __props__["is_html_content"] = is_html_content
        __props__["method"] = method
        __props__["name"] = name
        __props__["recipient"] = recipient
        __props__["routes"] = routes
        __props__["target_id"] = target_id
        __props__["template"] = template
        __props__["triggers"] = triggers
        return AlertTarget(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[str]:
        """
        The value of the `Content-Type` header of the webhook.
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter(name="customHeaders")
    def custom_headers(self) -> Optional[Mapping[str, str]]:
        """
        A `string->string` map specifying the custome HTTP header key/value pairs that will be 
        sent in the requests with a method of `WEBHOOK`.
        """
        return pulumi.get(self, "custom_headers")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description describing this alert target.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="emailSubject")
    def email_subject(self) -> Optional[str]:
        """
        The subject title of an email notification target.
        """
        return pulumi.get(self, "email_subject")

    @property
    @pulumi.getter(name="isHtmlContent")
    def is_html_content(self) -> Optional[bool]:
        """
        Determine whether the email alert content is sent as HTML or text.
        """
        return pulumi.get(self, "is_html_content")

    @property
    @pulumi.getter
    def method(self) -> Optional[str]:
        """
        The notification method used for notification target. One of `WEBHOOK`, `EMAIL`, `PAGERDUTY`.
        """
        return pulumi.get(self, "method")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the alert target as it is displayed in wavefront
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def recipient(self) -> str:
        """
        The end point for the notification Target.  `EMAIL`: email address. `PAGERDUTY`: PagerDuty 
        routing key. `WEBHOOK`: URL endpoint.
        """
        return pulumi.get(self, "recipient")

    @property
    @pulumi.getter
    def routes(self) -> Optional[List['outputs.AlertTargetRoute']]:
        """
        List of routing targets that this alert target will notify. See Route
        """
        return pulumi.get(self, "routes")

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> str:
        return pulumi.get(self, "target_id")

    @property
    @pulumi.getter
    def template(self) -> str:
        """
        A mustache template that will form the body of the POST request, email and summary of the PagerDuty.
        """
        return pulumi.get(self, "template")

    @property
    @pulumi.getter
    def triggers(self) -> List[str]:
        """
        A list of occurrences on which this webhook will be fired. Valid values are `ALERT_OPENED`,
        `ALERT_UPDATED`, `ALERT_RESOLVED`, `ALERT_MAINTENANCE`, `ALERT_SNOOZED`, `ALERT_INVALID`, `ALERT_NO_LONGER_INVALID`,
        `ALERT_RETRIGGERED`, `ALERT_NO_DATA`, `ALERT_NO_DATA_RESOLVED`, `ALERT_NO_DATA_MAINTENANCE`, `ALERT_SEVERITY_UPDATE`.
        """
        return pulumi.get(self, "triggers")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

