# Configuration file for the Sphinx documentation builder.
# For the full list of built-in configuration values, see the documentation:
# https://www.sphinx-doc.org/en/master/usage/configuration.html.

# Make sure adadmire can be found even when building from this directory
import os
import sys
import toml
sys.stdout.write(os.getcwd())
sys.path.insert(0, os.path.abspath('../src'))  # Source code dir relative to this file
sys.path.insert(0, os.path.abspath('../src/adadmire'))  # Source code dir relative to this file
sys.path.insert(0, os.path.abspath('../../src'))  # Source code dir relative to this file
sys.path.insert(0, os.path.abspath('../../src/adadmire'))  # Source code dir relative to this file

# Project Info
project = 'adadmire'
copyright = '2023, Lena Buck, Tobias Schmidt'
author = 'Lena Buck, Tobias Schmidt'
pyproject = toml.load("../../pyproject.toml")
release = pyproject['project']['version']

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
    'myst_parser', # markdown support
    'sphinx_rtd_theme', # read-the-docs theme
    'sphinx.ext.autodoc', # docstring support
    'sphinx.ext.napoleon' # support for numpy docstrings
]

# Mappings for sphinx.ext.intersphinx. Projects have to have Sphinx-generated doc! (.inv file)
intersphinx_mapping = {
    "python": ("https://docs.python.org/3/", None),
}

autosummary_generate = True  # Turn on sphinx.ext.autosummary
autoclass_content = "both"  # Add __init__ doc (ie. params) to class summaries
html_show_sourcelink = True  # Remove 'view source code' from top of page (for html, not python)
autodoc_inherit_docstrings = True  # If no docstring, inherit from base class
set_type_checking_flag = True  # Enable 'expensive' imports for sphinx_autodoc_typehints
nbsphinx_allow_errors = True  # Continue through Jupyter errors
autodoc_typehints = "description" # Sphinx-native method. Not as good as sphinx_autodoc_typehints
add_module_names = False # Remove namespaces from class/method signatures

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files. This pattern also affects
# html_static_path and html_extra_path.
exclude_patterns = []

# The theme to use for HTML and HTML Help pages. See the documentation for a
# list of builtin themes.
html_theme = "sphinx_rtd_theme"

# https://sphinx-rtd-theme.readthedocs.io/en/stable/configuring.html#theme-options
html_theme_options = {}

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files, so
# a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ['_static']
