"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Redis = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
const service_deployment_1 = require("./service-deployment");
/**
 * @experimental
 */
class Redis extends constructs_1.Construct {
    /**
     * @experimental
     */
    constructor(scope, id, options = {}) {
        var _b;
        super(scope, id);
        const primary = new service_deployment_1.ServiceDeployment(this, 'primary', {
            image: 'k8s.gcr.io/redis:e2e',
            containerPort: 6379,
            externalPort: 6379,
            containerName: 'primary',
            env: { GET_HOSTS_FROM: 'dns' },
            labels: {
                app: 'redis',
                role: 'primary',
                ...options.labels,
            },
        });
        this.primaryHost = primary.host;
        const replicas = (_b = options.replicas) !== null && _b !== void 0 ? _b : 2;
        if (replicas > 0) {
            const replica = new service_deployment_1.ServiceDeployment(this, 'replica', {
                image: 'gcr.io/google_samples/gb-redisslave:v1',
                containerName: 'replica',
                containerPort: 6379,
                externalPort: 6379,
                env: { GET_HOSTS_FROM: 'env', REDIS_MASTER_SERVICE_HOST: this.primaryHost },
                replicas: replicas,
                labels: {
                    app: 'redis',
                    role: 'replica',
                    ...options.labels,
                },
            });
            this.replicaHost = replica.host;
        }
        else {
            // if we have no slave, then use the same host as the primary
            this.replicaHost = primary.host;
        }
    }
}
exports.Redis = Redis;
_a = JSII_RTTI_SYMBOL_1;
Redis[_a] = { fqn: "cdk8s-redis.Redis", version: "0.1.142" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicmVkaXMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvcmVkaXMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSwyQ0FBdUM7QUFDdkMsNkRBQXlEOzs7O0FBVXpELE1BQWEsS0FBTSxTQUFRLHNCQUFTOzs7O0lBT2xDLFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsVUFBd0IsRUFBRzs7UUFDbkUsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUVqQixNQUFNLE9BQU8sR0FBRyxJQUFJLHNDQUFpQixDQUFDLElBQUksRUFBRSxTQUFTLEVBQUU7WUFDckQsS0FBSyxFQUFFLHNCQUFzQjtZQUM3QixhQUFhLEVBQUUsSUFBSTtZQUNuQixZQUFZLEVBQUUsSUFBSTtZQUNsQixhQUFhLEVBQUUsU0FBUztZQUN4QixHQUFHLEVBQUUsRUFBRSxjQUFjLEVBQUUsS0FBSyxFQUFFO1lBQzlCLE1BQU0sRUFBRTtnQkFDTixHQUFHLEVBQUUsT0FBTztnQkFDWixJQUFJLEVBQUUsU0FBUztnQkFDZixHQUFHLE9BQU8sQ0FBQyxNQUFNO2FBQ2xCO1NBQ0YsQ0FBQyxDQUFDO1FBRUgsSUFBSSxDQUFDLFdBQVcsR0FBRyxPQUFPLENBQUMsSUFBSSxDQUFDO1FBRWhDLE1BQU0sUUFBUSxTQUFHLE9BQU8sQ0FBQyxRQUFRLG1DQUFJLENBQUMsQ0FBQztRQUN2QyxJQUFJLFFBQVEsR0FBRyxDQUFDLEVBQUU7WUFDaEIsTUFBTSxPQUFPLEdBQUcsSUFBSSxzQ0FBaUIsQ0FBQyxJQUFJLEVBQUUsU0FBUyxFQUFFO2dCQUNyRCxLQUFLLEVBQUUsd0NBQXdDO2dCQUMvQyxhQUFhLEVBQUUsU0FBUztnQkFDeEIsYUFBYSxFQUFFLElBQUk7Z0JBQ25CLFlBQVksRUFBRSxJQUFJO2dCQUNsQixHQUFHLEVBQUUsRUFBRSxjQUFjLEVBQUUsS0FBSyxFQUFFLHlCQUF5QixFQUFFLElBQUksQ0FBQyxXQUFXLEVBQUU7Z0JBQzNFLFFBQVEsRUFBRSxRQUFRO2dCQUNsQixNQUFNLEVBQUU7b0JBQ04sR0FBRyxFQUFFLE9BQU87b0JBQ1osSUFBSSxFQUFFLFNBQVM7b0JBQ2YsR0FBRyxPQUFPLENBQUMsTUFBTTtpQkFDbEI7YUFDRixDQUFDLENBQUM7WUFFSCxJQUFJLENBQUMsV0FBVyxHQUFHLE9BQU8sQ0FBQyxJQUFJLENBQUM7U0FDakM7YUFBTTtZQUNMLDZEQUE2RDtZQUM3RCxJQUFJLENBQUMsV0FBVyxHQUFHLE9BQU8sQ0FBQyxJQUFJLENBQUM7U0FDakM7SUFDSCxDQUFDOztBQTlDSCxzQkErQ0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcbmltcG9ydCB7IFNlcnZpY2VEZXBsb3ltZW50IH0gZnJvbSAnLi9zZXJ2aWNlLWRlcGxveW1lbnQnO1xuXG5leHBvcnQgaW50ZXJmYWNlIFJlZGlzT3B0aW9ucyB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHJlcGxpY2FzPzogbnVtYmVyO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGxhYmVscz86IHsgW25hbWU6IHN0cmluZ106IHN0cmluZyB9O1xufVxuXG5leHBvcnQgY2xhc3MgUmVkaXMgZXh0ZW5kcyBDb25zdHJ1Y3Qge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyByZWFkb25seSBwcmltYXJ5SG9zdDogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHJlYWRvbmx5IHJlcGxpY2FIb3N0OiBzdHJpbmc7XG5cbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgb3B0aW9uczogUmVkaXNPcHRpb25zID0geyB9KSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcblxuICAgIGNvbnN0IHByaW1hcnkgPSBuZXcgU2VydmljZURlcGxveW1lbnQodGhpcywgJ3ByaW1hcnknLCB7XG4gICAgICBpbWFnZTogJ2s4cy5nY3IuaW8vcmVkaXM6ZTJlJyxcbiAgICAgIGNvbnRhaW5lclBvcnQ6IDYzNzksXG4gICAgICBleHRlcm5hbFBvcnQ6IDYzNzksXG4gICAgICBjb250YWluZXJOYW1lOiAncHJpbWFyeScsXG4gICAgICBlbnY6IHsgR0VUX0hPU1RTX0ZST006ICdkbnMnIH0sXG4gICAgICBsYWJlbHM6IHtcbiAgICAgICAgYXBwOiAncmVkaXMnLFxuICAgICAgICByb2xlOiAncHJpbWFyeScsXG4gICAgICAgIC4uLm9wdGlvbnMubGFiZWxzLFxuICAgICAgfSxcbiAgICB9KTtcblxuICAgIHRoaXMucHJpbWFyeUhvc3QgPSBwcmltYXJ5Lmhvc3Q7XG5cbiAgICBjb25zdCByZXBsaWNhcyA9IG9wdGlvbnMucmVwbGljYXMgPz8gMjtcbiAgICBpZiAocmVwbGljYXMgPiAwKSB7XG4gICAgICBjb25zdCByZXBsaWNhID0gbmV3IFNlcnZpY2VEZXBsb3ltZW50KHRoaXMsICdyZXBsaWNhJywge1xuICAgICAgICBpbWFnZTogJ2djci5pby9nb29nbGVfc2FtcGxlcy9nYi1yZWRpc3NsYXZlOnYxJyxcbiAgICAgICAgY29udGFpbmVyTmFtZTogJ3JlcGxpY2EnLFxuICAgICAgICBjb250YWluZXJQb3J0OiA2Mzc5LFxuICAgICAgICBleHRlcm5hbFBvcnQ6IDYzNzksXG4gICAgICAgIGVudjogeyBHRVRfSE9TVFNfRlJPTTogJ2VudicsIFJFRElTX01BU1RFUl9TRVJWSUNFX0hPU1Q6IHRoaXMucHJpbWFyeUhvc3QgfSxcbiAgICAgICAgcmVwbGljYXM6IHJlcGxpY2FzLFxuICAgICAgICBsYWJlbHM6IHtcbiAgICAgICAgICBhcHA6ICdyZWRpcycsXG4gICAgICAgICAgcm9sZTogJ3JlcGxpY2EnLFxuICAgICAgICAgIC4uLm9wdGlvbnMubGFiZWxzLFxuICAgICAgICB9LFxuICAgICAgfSk7XG5cbiAgICAgIHRoaXMucmVwbGljYUhvc3QgPSByZXBsaWNhLmhvc3Q7XG4gICAgfSBlbHNlIHtcbiAgICAgIC8vIGlmIHdlIGhhdmUgbm8gc2xhdmUsIHRoZW4gdXNlIHRoZSBzYW1lIGhvc3QgYXMgdGhlIHByaW1hcnlcbiAgICAgIHRoaXMucmVwbGljYUhvc3QgPSBwcmltYXJ5Lmhvc3Q7XG4gICAgfVxuICB9XG59XG4iXX0=