from toscametrics.blueprint.blueprint_metric import BlueprintMetric

class TDB(BlueprintMetric):
    """ This class is responsible for providing the method to check the existance of a tosca_definitions_version in a given .yaml file"""
    
    def check(self):
        '''Function which checks the existance of a tosca_definitions_version''' 
        try:
            tosca_df = self.getyml.get('tosca_definitions_version')
            if tosca_df == None:
                return False
            return True
        
        except AttributeError:
            return False


# string = "# Mapping definition for alien 4 cloud specific dsl 1.2.0\n\n# declare custom parsers for complex types that requires specific parser.\n- scalar: alien4cloud.tosca.parser.impl.base.ScalarParser\n- import_definition: alien4cloud.tosca.parser.impl.advanced.ImportParser\n- occurrences: alien4cloud.tosca.parser.impl.advanced.OccurrencesParser\n- implementation_artifact: alien4cloud.tosca.parser.impl.v12.advanced.ImplementationArtifactParser\n- tag: alien4cloud.tosca.parser.impl.advanced.TagParser\n- interface: alien4cloud.tosca.parser.impl.advanced.InterfaceParser\n- interfaces: alien4cloud.tosca.parser.impl.advanced.InterfacesParser\n- outputs_type: alien4cloud.tosca.parser.impl.advanced.OuputsParser\n- group_policy_parser: alien4cloud.tosca.parser.impl.advanced.GroupPolicyParser\n- artifact_ref_parser: alien4cloud.tosca.parser.impl.advanced.ArtifactReferenceParser\n- sustitution_mapping_parser: alien4cloud.tosca.parser.impl.advanced.SustitutionMappingParser\n- constraint: alien4cloud.tosca.parser.impl.advanced.ConstraintParser\n- abstract_property_value: alien4cloud.tosca.parser.impl.advanced.AbstractPropertyValueParser\n- fail_get_artifact: alien4cloud.tosca.parser.impl.advanced.FailGetArtifactParser\n- string_list: alien4cloud.tosca.parser.impl.advanced.StringListParser\n- relationship_template: alien4cloud.tosca.parser.impl.advanced.RelationshipTemplateParser\n\n# declare standard mapping based parsers\n- definition: alien4cloud.tosca.model.ArchiveRoot\n  tosca_definitions_version: archive.toscaDefinitionsVersion\n  tosca_default_namespace: archive.toscaDefaultNamespace\n  template_name: archive.name\n  template_author: archive.templateAuthor\n  template_version: archive.version\n  description: archive.description\n  imports:\n    set: archive.dependencies\n    type: import_definition\n  dsl_definitions: null # this means we take this node in charge but won't parse it's content\n  node_types:\n    map: nodeTypes\n    key: elementId\n    type: node_type\n  data_types:\n    map: dataTypes\n    key: elementId\n    type: data_type\n  capability_types:\n    map: capabilityTypes\n    key: elementId\n    type: capability_type\n  relationship_types:\n    map: relationshipTypes\n    key: elementId\n    type: relationship_type\n  artifact_types:\n    map: artifactTypes\n    key: elementId\n    type: artifact_type\n    # inputs:\n  topology_template:\n    reference: topology\n    type: topology_template_type\n\n- topology_template_type: org.alien4cloud.tosca.model.templates.Topology\n  description: .topologyTemplateDescription # mapped to a root's property\n  inputs:\n    map: inputs\n    type: property_definition\n  input_artifacts:\n    map: inputArtifacts\n    type: template_deployment_artifact\n  substitution_mappings:\n    reference: substitutionMapping\n    type: sustitution_mapping_parser\n  node_templates:\n    map: nodeTemplates\n    type: node_template\n  outputs:\n    reference: void # means : do the parsing but do not set anything\n    type: outputs_type\n  groups:\n    map: groups\n    key: name\n    type: node_group\n  workflows:\n    map: workflows\n    key: name\n    type: workflow\n\n- workflow: org.alien4cloud.tosca.model.workflow.Workflow\n  description: description\n  steps:\n    map: steps\n    key: name\n    type: workflow_step\n\n- workflow_step : org.alien4cloud.tosca.model.workflow.NodeWorkflowStep\n  node: target\n  activity:\n    reference: activity\n    type: workflow_activity\n  on-success:\n    set: onSuccess\n    type: scalar\n\n- workflow_activity: __discriminator\n  keys:\n    set_state: set_state_activity\n    call_operation: call_operation_activity\n    delegate: delegate_activity\n\n- set_state_activity: org.alien4cloud.tosca.model.workflow.activities.SetStateWorkflowActivity\n  set_state: stateName\n\n- call_operation_activity: org.alien4cloud.tosca.model.workflow.activities.CallOperationWorkflowActivity\n  call_operation: operationFqn\n\n- delegate_activity: org.alien4cloud.tosca.model.workflow.activities.DelegateWorkflowActivity\n  delegate: delegate\n\n- template_deployment_artifact: org.alien4cloud.tosca.model.definitions.DeploymentArtifact\n  type: artifactType\n  implementation:\n    reference: artifactRef\n    type: artifact_ref_parser\n  description: artifactName\n\n- node_group: org.alien4cloud.tosca.model.templates.NodeGroup\n  members:\n    set: members\n    type: scalar\n  policies:\n    list: policies\n    type: group_policy_parser\n\n- node_template: org.alien4cloud.tosca.model.templates.NodeTemplate\n  type: type\n  name: name\n  properties:\n    map: properties\n    type: node_template_property\n  requirements:\n    sequence_to_map: relationships\n    type: relationship_template\n    allow_duplicate: true\n  capabilities:\n    map: capabilities\n    type: node_template_capability_definition\n  interfaces:\n    reference: interfaces\n    type: interfaces\n  artifacts:\n    map: artifacts\n    type: template_deployment_artifact\n\n- node_template_capability_definition: org.alien4cloud.tosca.model.templates.Capability\n  type: type\n  properties:\n    map: properties\n    type: node_template_property\n\n- attribute_definition: org.alien4cloud.tosca.model.definitions.AttributeDefinition\n  description: description\n  type: type\n  default: default\n\n- property_definition: org.alien4cloud.tosca.model.definitions.PropertyDefinition\n  type: type\n  entry_schema:\n    reference: entrySchema\n    type: property_definition\n  required: required\n  description: description\n  default:\n    reference: default\n    type: abstract_property_value\n  constraints:\n    list: constraints\n    type: constraint\n\n# capability definition supports a simple definition or more advanced.\n- capability_definition: org.alien4cloud.tosca.model.definitions.CapabilityDefinition\n  description: description\n  type: type\n  occurrences:\n    reference: void\n    type: occurrences\n  valid_source_types:\n    list: validSources\n    type: scalar\n  properties:\n    map: properties\n    type: node_template_property\n\n- constraint_list: list # This element must be parsed as a list\n  type: constraint # the elements in the list are constraints\n\n# Node filter related types\n- filter_definition: org.alien4cloud.tosca.model.definitions.FilterDefinition\n  properties:\n    sequence_to_map: properties\n    type: constraint_list\n    node_is_value: false\n\n- node_filter_type: org.alien4cloud.tosca.model.definitions.NodeFilter\n  properties:\n    sequence_to_map: properties\n    type: constraint_list\n    node_is_value: false\n  capabilities:\n    sequence_to_map: capabilities\n    type: filter_definition\n    node_is_value: false\n\n- requirement_definition: org.alien4cloud.tosca.model.definitions.RequirementDefinition\n  __0: # define mapping for the first tuple of a requirement_definition. Both key and values must be mapped to different fields.\n    key: id # map the key of the first mapping\n    value: # map the value as a capability_or_node_type_reference\n      reference: type\n      type: scalar\n  description: description\n  occurrences:\n    reference: void\n    type: occurrences\n  type: relationshipType\n  relationship: relationshipType\n  capability: capabilityName\n  node_filter:\n    reference: nodeFilter\n    type: node_filter_type\n\n- deployment_artifact: org.alien4cloud.tosca.model.definitions.DeploymentArtifact\n  __0:\n    value: artifactRef\n  description: description\n  type: artifactType\n\n- tosca_function: org.alien4cloud.tosca.model.definitions.FunctionPropertyValue\n  __0:\n    key: function\n    value:\n      list: parameters\n      type: scalar\n\n- scalar_property_value: org.alien4cloud.tosca.model.definitions.ScalarPropertyValue\n\n- complex_property_value: alien4cloud.tosca.parser.impl.advanced.ComplexPropertyValueParser\n\n- tosca_concat: org.alien4cloud.tosca.model.definitions.ConcatPropertyValue\n  __0:\n    key: function_concat\n    value:\n      list: parameters\n      type: input\n\n- node_template_property: __discriminator\n  keys:\n    type: property_definition\n    get_input: tosca_function\n    get_property: tosca_function\n    get_attribute: tosca_function\n  default: abstract_property_value\n\n- input: __discriminator\n  keys:\n    type: property_definition\n    get_artifact: fail_get_artifact\n    get_input: tosca_function\n    get_property: tosca_function\n    get_attribute: tosca_function\n    get_operation_output: tosca_function\n    concat: tosca_concat\n  default: abstract_property_value\n\n- attribute: __discriminator\n  keys:\n    type: attribute_definition\n    concat: tosca_concat\n    get_operation_output: tosca_function\n    get_attribute: tosca_function\n    get_property: tosca_function\n  default: attribute_definition\n\n- operation_definition: org.alien4cloud.tosca.model.definitions.Operation\n  implementation:\n    reference: implementationArtifact\n    type: implementation_artifact\n  description: description\n  inputs:\n    map: inputParameters\n    type: input\n  input: # add tolerance to input as wd03 is inconsistent.\n    map: inputParameters\n    type: input\n\n- node_type: org.alien4cloud.tosca.model.types.NodeType\n  description: description\n  abstract: abstract\n  tags:\n    reference: tags\n    type: tag\n  derived_from:\n    reference: derivedFrom\n    type: string_list\n  properties:\n    map: properties\n    type: property_definition\n  attributes:\n    map: attributes\n    type: attribute\n  requirements:\n    list: requirements\n    key: id\n    type: requirement_definition\n  capabilities:\n    list: capabilities\n    key: id\n    type: capability_definition\n  interfaces:\n    reference: interfaces\n    type: interfaces\n  artifacts:\n    sequence_to_map: artifacts\n    type: deployment_artifact\n  portability:\n    map: portability\n    type: node_template_property\n\n- data_type: __discriminator\n  keys:\n    constraints: simple_data_type\n  default: complex_data_type\n\n- simple_data_type: org.alien4cloud.tosca.model.types.PrimitiveDataType\n  description: description\n  abstract: abstract\n  tags:\n    reference: tags\n    type: tag\n  derived_from:\n    reference: derivedFrom\n    type: string_list\n  constraints:\n    list: constraints\n    type: constraint\n\n- complex_data_type: org.alien4cloud.tosca.model.types.DataType\n  description: description\n  abstract: abstract\n  tags:\n    reference: tags\n    type: tag\n  derived_from:\n    reference: derivedFrom\n    type: string_list\n  properties:\n    map: properties\n    type: property_definition\n\n- capability_type: org.alien4cloud.tosca.model.types.CapabilityType\n  description: description\n  abstract: abstract\n  tags:\n    reference: tags\n    type: tag\n  derived_from:\n    reference: derivedFrom\n    type: string_list\n  properties:\n    map: properties\n    type: property_definition\n  valid_source_types:\n    list: validSources\n    type: scalar\n\n- relationship_type: org.alien4cloud.tosca.model.types.RelationshipType\n  description: description\n  abstract: abstract\n  tags:\n    reference: tags\n    type: tag\n  derived_from:\n    reference: derivedFrom\n    type: string_list\n  properties:\n    map: properties\n    type: property_definition\n  attributes:\n    map: attributes\n    type: attribute\n  interfaces:\n    reference: interfaces\n    type: interfaces\n  artifacts:\n    sequence_to_map: artifacts\n    type: deployment_artifact\n  valid_target_types:\n    list: validTargets\n    type: scalar\n\n- artifact_type: org.alien4cloud.tosca.model.types.ArtifactType\n  description: description\n  abstract: abstract\n  tags:\n    reference: tags\n    type: tag\n  derived_from:\n    reference: derivedFrom\n    type: string_list\n  properties:\n    map: properties\n    type: property_definition\n  mime_type: mimeType\n  file_ext:\n    list: fileExt\n    type: scalar\n"


# from io import StringIO

# yml = StringIO(string.expandtabs(2)) 
# metric = TDB(yml)

