# -*- coding: ISO-8859-1 -*-
#
# generated by wxGlade 0.9.3 on Fri Jun 28 16:25:14 2019
#
import threading

import wx

from meerk40t.gui.icons import (
    icons8_connected_50,
    icons8_disconnected_50,
    icons8_emergency_stop_button_50,
    icons8_laser_beam_hazard_50,
    icons8_pause_50,
    icons8_play_50,
)
from meerk40t.gui.mwindow import MWindow
from meerk40t.gui.wxutils import ScrolledPanel
from meerk40t.kernel import (
    STATE_ACTIVE,
    STATE_BUSY,
    STATE_END,
    STATE_IDLE,
    STATE_INITIALIZE,
    STATE_PAUSE,
    STATE_TERMINATE,
    STATE_WAIT,
    signal_listener,
)

_ = wx.GetTranslation

_simple_width = 500
_advanced_width = 952
_default_height = 584


class LihuiyuControllerPanel(ScrolledPanel):
    def __init__(self, *args, context=None, **kwds):
        kwds["style"] = kwds.get("style", 0) | wx.TAB_TRAVERSAL
        wx.Panel.__init__(self, *args, **kwds)
        self.context = context.device

        self.button_device_connect = wx.Button(self, wx.ID_ANY, _("Connection"))
        self.text_connection_status = wx.TextCtrl(
            self, wx.ID_ANY, "", style=wx.TE_READONLY
        )
        self.button_controller_control = wx.Button(
            self, wx.ID_ANY, _("Start Controller")
        )
        self.button_controller_control.function = lambda: self.context("start\n")
        self.text_controller_status = wx.TextCtrl(
            self, wx.ID_ANY, "", style=wx.TE_READONLY
        )
        self.packet_count_text = wx.TextCtrl(self, wx.ID_ANY, "", style=wx.TE_READONLY)
        self.rejected_packet_count_text = wx.TextCtrl(
            self, wx.ID_ANY, "", style=wx.TE_READONLY
        )
        self.packet_text_text = wx.TextCtrl(self, wx.ID_ANY, "", style=wx.TE_READONLY)
        self.text_byte_0 = wx.TextCtrl(self, wx.ID_ANY, "", style=wx.TE_READONLY)
        self.text_byte_1 = wx.TextCtrl(self, wx.ID_ANY, "", style=wx.TE_READONLY)
        self.text_desc = wx.TextCtrl(self, wx.ID_ANY, "", style=wx.TE_READONLY)
        self.text_byte_2 = wx.TextCtrl(self, wx.ID_ANY, "", style=wx.TE_READONLY)
        self.text_byte_3 = wx.TextCtrl(self, wx.ID_ANY, "", style=wx.TE_READONLY)
        self.text_byte_4 = wx.TextCtrl(self, wx.ID_ANY, "", style=wx.TE_READONLY)
        self.text_byte_5 = wx.TextCtrl(self, wx.ID_ANY, "", style=wx.TE_READONLY)
        self.checkbox_show_usb_log = wx.CheckBox(self, wx.ID_ANY, _("Show USB Log"))
        self.text_usb_log = wx.TextCtrl(
            self, wx.ID_ANY, "", style=wx.TE_MULTILINE | wx.TE_READONLY
        )

        self.__set_properties()
        self.__do_layout()

        self.Bind(wx.EVT_BUTTON, self.on_button_start_usb, self.button_device_connect)
        self.Bind(
            wx.EVT_BUTTON,
            self.on_button_start_controller,
            self.button_controller_control,
        )
        self.Bind(
            wx.EVT_CHECKBOX, self.on_check_show_usb_log, self.checkbox_show_usb_log
        )
        self.last_control_state = None
        self.retries = 0
        self._buffer = ""
        self._buffer_lock = threading.Lock()
        self.set_widgets()
        self.SetupScrolling()

    def __set_properties(self):
        self.SetFont(
            wx.Font(
                9,
                wx.FONTFAMILY_DEFAULT,
                wx.FONTSTYLE_NORMAL,
                wx.FONTWEIGHT_NORMAL,
                0,
                "Segoe UI",
            )
        )
        self.button_device_connect.SetBackgroundColour(wx.Colour(102, 255, 102))
        self.button_device_connect.SetForegroundColour(wx.BLACK)
        self.button_device_connect.SetFont(
            wx.Font(
                12,
                wx.FONTFAMILY_DEFAULT,
                wx.FONTSTYLE_NORMAL,
                wx.FONTWEIGHT_NORMAL,
                0,
                "Segoe UI",
            )
        )
        self.button_device_connect.SetToolTip(
            _("Force connection/disconnection from the device.")
        )
        self.text_connection_status.SetToolTip(_("Connection status"))

        self.button_controller_control.SetBackgroundColour(wx.Colour(102, 255, 102))
        self.button_controller_control.SetForegroundColour(wx.BLACK)
        self.button_controller_control.SetFont(
            wx.Font(
                12,
                wx.FONTFAMILY_DEFAULT,
                wx.FONTSTYLE_NORMAL,
                wx.FONTWEIGHT_NORMAL,
                0,
                "Segoe UI",
            )
        )
        self.button_controller_control.SetToolTip(
            _("Change the currently performed operation.")
        )
        self.text_controller_status.SetToolTip(
            _("Displays the controller's current process.")
        )
        self.packet_count_text.SetMinSize((77, 23))
        self.packet_count_text.SetToolTip(_("Total number of packets sent"))
        self.rejected_packet_count_text.SetMinSize((77, 23))
        self.rejected_packet_count_text.SetToolTip(
            _("Total number of packets rejected")
        )
        self.packet_text_text.SetToolTip(_("Last packet information sent"))
        self.text_byte_0.SetMinSize((77, 23))
        self.text_byte_1.SetMinSize((77, 23))
        self.text_desc.SetMinSize((75, 23))
        self.text_desc.SetToolTip(_("The meaning of Byte 1"))
        self.text_byte_2.SetMinSize((77, 23))
        self.text_byte_3.SetMinSize((77, 23))
        self.text_byte_4.SetMinSize((77, 23))
        self.text_byte_5.SetMinSize((77, 23))
        self.checkbox_show_usb_log.SetValue(1)
        self.button_device_connect.SetBitmap(
            icons8_disconnected_50.GetBitmap(use_theme=False)
        )
        self.button_controller_control.SetBitmap(
            icons8_play_50.GetBitmap(use_theme=False)
        )
        # end wxGlade

    def __do_layout(self):
        sizer_24 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_1 = wx.BoxSizer(wx.VERTICAL)
        sizer_show_usb_log = wx.BoxSizer(wx.HORIZONTAL)
        packet_count = wx.StaticBoxSizer(
            wx.StaticBox(self, wx.ID_ANY, _("Packet Info")), wx.VERTICAL
        )
        byte_data_status = wx.StaticBoxSizer(
            wx.StaticBox(self, wx.ID_ANY, _("Byte Data Status")), wx.HORIZONTAL
        )
        byte5sizer = wx.BoxSizer(wx.VERTICAL)
        byte4sizer = wx.BoxSizer(wx.VERTICAL)
        byte3sizer = wx.BoxSizer(wx.VERTICAL)
        byte2sizer = wx.BoxSizer(wx.VERTICAL)
        byte1sizer = wx.BoxSizer(wx.VERTICAL)
        byte0sizer = wx.BoxSizer(wx.VERTICAL)
        packet_info = wx.StaticBoxSizer(
            wx.StaticBox(self, wx.ID_ANY, _("Last Packet")), wx.HORIZONTAL
        )
        sizer_25 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_21 = wx.StaticBoxSizer(
            wx.StaticBox(self, wx.ID_ANY, _("Rejected Packets")), wx.VERTICAL
        )
        sizer_22 = wx.StaticBoxSizer(
            wx.StaticBox(self, wx.ID_ANY, _("Packet Count")), wx.VERTICAL
        )
        sizer_controller = wx.StaticBoxSizer(
            wx.StaticBox(self, wx.ID_ANY, _("Controller")), wx.VERTICAL
        )
        sizer_usb_settings = wx.StaticBoxSizer(
            wx.StaticBox(self, wx.ID_ANY, _("USB Settings")), wx.VERTICAL
        )
        sizer_23 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_12 = wx.StaticBoxSizer(
            wx.StaticBox(self, wx.ID_ANY, _("Chip Version")), wx.HORIZONTAL
        )
        sizer_11 = wx.StaticBoxSizer(
            wx.StaticBox(self, wx.ID_ANY, _("Device Bus:")), wx.HORIZONTAL
        )
        sizer_10 = wx.StaticBoxSizer(
            wx.StaticBox(self, wx.ID_ANY, _("Device Address:")), wx.HORIZONTAL
        )
        sizer_3 = wx.StaticBoxSizer(
            wx.StaticBox(self, wx.ID_ANY, _("Device Index:")), wx.HORIZONTAL
        )
        sizer_usb_connect = wx.StaticBoxSizer(
            wx.StaticBox(self, wx.ID_ANY, _("USB Connection")), wx.VERTICAL
        )
        sizer_usb_connect.Add(self.button_device_connect, 0, wx.EXPAND, 0)
        sizer_usb_connect.Add(self.text_connection_status, 0, wx.EXPAND, 0)
        sizer_1.Add(sizer_usb_connect, 0, wx.EXPAND, 0)
        sizer_controller.Add(self.button_controller_control, 0, wx.EXPAND, 0)
        sizer_controller.Add(self.text_controller_status, 0, wx.EXPAND, 0)
        sizer_1.Add(sizer_controller, 0, wx.EXPAND, 0)
        sizer_22.Add(self.packet_count_text, 0, wx.EXPAND, 0)
        sizer_25.Add(sizer_22, 1, wx.EXPAND, 0)
        sizer_21.Add(self.rejected_packet_count_text, 0, wx.EXPAND, 0)
        sizer_25.Add(sizer_21, 1, wx.EXPAND, 0)
        packet_count.Add(sizer_25, 1, wx.EXPAND, 0)
        packet_info.Add(self.packet_text_text, 11, wx.EXPAND, 0)
        packet_count.Add(packet_info, 0, wx.EXPAND, 0)
        byte0sizer.Add(self.text_byte_0, 0, 0, 0)
        label_1 = wx.StaticText(self, wx.ID_ANY, _("Byte 0"))
        byte0sizer.Add(label_1, 0, 0, 0)
        byte_data_status.Add(byte0sizer, 1, wx.EXPAND, 0)
        byte1sizer.Add(self.text_byte_1, 0, 0, 0)
        label_2 = wx.StaticText(self, wx.ID_ANY, _("Byte 1"))
        byte1sizer.Add(label_2, 0, 0, 0)
        byte1sizer.Add(self.text_desc, 0, 0, 0)
        byte_data_status.Add(byte1sizer, 1, wx.EXPAND, 0)
        byte2sizer.Add(self.text_byte_2, 0, 0, 0)
        label_3 = wx.StaticText(self, wx.ID_ANY, _("Byte 2"))
        byte2sizer.Add(label_3, 0, 0, 0)
        byte_data_status.Add(byte2sizer, 1, wx.EXPAND, 0)
        byte3sizer.Add(self.text_byte_3, 0, 0, 0)
        label_4 = wx.StaticText(self, wx.ID_ANY, _("Byte 3"))
        byte3sizer.Add(label_4, 0, 0, 0)
        byte_data_status.Add(byte3sizer, 1, wx.EXPAND, 0)
        byte4sizer.Add(self.text_byte_4, 0, 0, 0)
        label_5 = wx.StaticText(self, wx.ID_ANY, _("Byte 4"))
        byte4sizer.Add(label_5, 0, 0, 0)
        byte_data_status.Add(byte4sizer, 1, wx.EXPAND, 0)
        byte5sizer.Add(self.text_byte_5, 0, 0, 0)
        label_18 = wx.StaticText(self, wx.ID_ANY, _("Byte 5"))
        byte5sizer.Add(label_18, 0, 0, 0)
        byte_data_status.Add(byte5sizer, 1, wx.EXPAND, 0)
        packet_count.Add(byte_data_status, 0, wx.EXPAND, 0)
        sizer_1.Add(packet_count, 0, 0, 0)
        label_6 = wx.StaticText(self, wx.ID_ANY, "")
        sizer_show_usb_log.Add(label_6, 10, wx.EXPAND, 0)
        sizer_show_usb_log.Add(self.checkbox_show_usb_log, 0, 0, 0)
        sizer_1.Add(sizer_show_usb_log, 1, wx.EXPAND, 0)
        sizer_24.Add(sizer_1, 1, 0, 0)
        sizer_24.Add(self.text_usb_log, 2, wx.EXPAND, 0)
        self.SetSizer(sizer_24)
        self.Layout()
        # end wxGlade

    def module_open(self, *args, **kwargs):
        self.pane_show()

    def module_close(self, *args, **kwargs):
        self.pane_hide()

    def pane_show(self):
        self.context.channel(f"{self.context.label}/usb", buffer_size=500).watch(
            self.update_text
        )
        self.on_network_update()

    def pane_hide(self):
        self.context.channel(f"{self.context.label}/usb").unwatch(self.update_text)

    @signal_listener("network_update")
    def on_network_update(self, origin=None, *args):
        if self.context.networked:
            self.button_device_connect.Enable(False)
        else:
            self.button_device_connect.Enable(True)

    def restore(self, *args, **kwargs):
        self.set_widgets()

    def update_text(self, text):
        with self._buffer_lock:
            self._buffer += f"{text}\n"
        self.context.signal("lihuiyu_controller_update", True)

    @signal_listener("lihuiyu_controller_update")
    def update_text_gui(self, origin, *args):
        try:
            with self._buffer_lock:
                buffer = self._buffer
                self._buffer = ""
            if self.text_usb_log.IsShown():
                self.text_usb_log.AppendText(buffer)
        except RuntimeError:
            pass

    def set_widgets(self):
        self.checkbox_show_usb_log.SetValue(self.context.show_usb_log)
        self.on_check_show_usb_log()

    def device_execute(self, control_name):
        def menu_element(event=None):
            self.context.execute(control_name)

        return menu_element

    @signal_listener("pipe;status")
    def update_status(self, origin, status_data, code_string):
        if origin != self.context.path:
            return
        if status_data is not None:
            if isinstance(status_data, int):
                self.text_desc.SetValue(str(status_data))
                self.text_desc.SetValue(code_string)
            else:
                if len(status_data) == 6:
                    self.text_byte_0.SetValue(str(status_data[0]))
                    self.text_byte_1.SetValue(str(status_data[1]))
                    self.text_byte_2.SetValue(str(status_data[2]))
                    self.text_byte_3.SetValue(str(status_data[3]))
                    self.text_byte_4.SetValue(str(status_data[4]))
                    self.text_byte_5.SetValue(str(status_data[5]))
                    self.text_desc.SetValue(code_string)
        self.packet_count_text.SetValue(str(self.context.packet_count))
        self.rejected_packet_count_text.SetValue(str(self.context.rejected_count))

    @signal_listener("pipe;packet_text")
    def update_packet_text(self, origin, string_data):
        if origin != self.context._path:
            return
        if string_data is not None and len(string_data) != 0:
            self.packet_text_text.SetValue(str(string_data))

    @signal_listener("pipe;usb_status")
    def on_connection_status_change(self, origin, status):
        if origin != self.context._path:
            return
        self.text_connection_status.SetValue(str(status))

    @signal_listener("pipe;state")
    def on_connection_state_change(self, origin, state):
        if origin != self.context._path:
            return
        if state == "STATE_CONNECTION_FAILED":
            self.button_device_connect.SetBackgroundColour("#dfdf00")
            origin, usb_status = self.context.last_signal("pipe;usb_status")
            self.button_device_connect.SetLabel(_("Connect Failed"))
            self.button_device_connect.SetBitmap(
                icons8_disconnected_50.GetBitmap(use_theme=False)
            )
            self.button_device_connect.Enable()
        elif state == "STATE_FAILED_RETRYING":
            self.button_device_connect.SetBackgroundColour("#df0000")
            origin, usb_status = self.context.last_signal("pipe;usb_status")
            self.button_device_connect.SetLabel(_("Retrying..."))
            self.button_device_connect.SetBitmap(
                icons8_disconnected_50.GetBitmap(use_theme=False)
            )
            self.button_device_connect.Enable()
        elif state == "STATE_FAILED_SUSPENDED":
            self.button_device_connect.SetBackgroundColour("#0000df")
            origin, usb_status = self.context.last_signal("pipe;usb_status")
            self.button_device_connect.SetLabel(_("Suspended Retrying"))
            self.button_device_connect.SetBitmap(
                icons8_disconnected_50.GetBitmap(use_theme=False)
            )
            self.button_device_connect.Enable()
        elif state == "STATE_DRIVER_NO_BACKEND":
            self.button_device_connect.SetBackgroundColour("#dfdf00")
            origin, usb_status = self.context.last_signal("pipe;usb_status")
            self.button_device_connect.SetLabel(_("No Backend"))
            self.button_device_connect.SetBitmap(
                icons8_disconnected_50.GetBitmap(use_theme=False)
            )
            self.button_device_connect.Enable()
        elif state == "STATE_UNINITIALIZED" or state == "STATE_USB_DISCONNECTED":
            self.button_device_connect.SetBackgroundColour("#ffff00")
            self.button_device_connect.SetLabel(_("Connect"))
            self.button_device_connect.SetBitmap(
                icons8_connected_50.GetBitmap(use_theme=False)
            )
            self.button_device_connect.Enable()
        elif state == "STATE_USB_SET_DISCONNECTING":
            self.button_device_connect.SetBackgroundColour("#ffff00")
            self.button_device_connect.SetLabel(_("Disconnecting..."))
            self.button_device_connect.SetBitmap(
                icons8_disconnected_50.GetBitmap(use_theme=False)
            )
            self.button_device_connect.Disable()
        elif state == "STATE_USB_CONNECTED" or state == "STATE_CONNECTED":
            self.button_device_connect.SetBackgroundColour("#00ff00")
            self.button_device_connect.SetLabel(_("Disconnect"))
            self.button_device_connect.SetBitmap(
                icons8_connected_50.GetBitmap(use_theme=False)
            )
            self.button_device_connect.Enable()
        elif state == "STATE_CONNECTING":
            self.button_device_connect.SetBackgroundColour("#ffff00")
            self.button_device_connect.SetLabel(_("Connecting..."))
            self.button_device_connect.SetBitmap(
                icons8_connected_50.GetBitmap(use_theme=False)
            )
            self.button_device_connect.Disable()

    def on_button_start_usb(self, event=None):  # wxGlade: Controller.<event_handler>
        origin, state = self.context.last_signal("pipe;state")
        if state is not None and isinstance(state, tuple):
            state = state[0]

        if state == "STATE_FAILED_RETRYING":
            self.retries = 0
            self.context("usb_abort\n")
        elif state == "STATE_FAILED_SUSPENDED":
            self.context("usb_continue\n")
        elif state in (
            "STATE_USB_DISCONNECTED",
            "STATE_UNINITIALIZED",
            "STATE_CONNECTION_FAILED",
            "STATE_DRIVER_MOCK",
            None,
        ):
            try:
                self.context("usb_connect\n")
            except ConnectionRefusedError:
                dlg = wx.MessageDialog(
                    None,
                    _("Connection Refused. See USB Log for detailed information."),
                    _("Manual Connection"),
                    wx.OK | wx.ICON_WARNING,
                )
                result = dlg.ShowModal()
                dlg.Destroy()
        elif state in ("STATE_CONNECTED", "STATE_USB_CONNECTED"):
            self.context("usb_disconnect\n")

    @signal_listener("pipe;thread")
    def on_control_state(self, origin, state):
        if origin != self.context._path:
            return

        if self.last_control_state == state:
            return
        self.last_control_state = state
        button = self.button_controller_control
        if self.text_controller_status is None:
            return
        value = self.context.kernel.get_text_thread_state(state)
        self.text_controller_status.SetValue(str(value))
        if state == STATE_INITIALIZE or state == STATE_END or state == STATE_IDLE:

            def f(event=None):
                self.context("start\n")
                self.context("hold\n")

            button.function = f
            button.SetBackgroundColour("#009900")
            button.SetLabel(_("Hold Controller"))
            button.SetBitmap(icons8_play_50.GetBitmap(use_theme=False))
            button.Enable(True)
        elif state == STATE_BUSY:
            button.SetBackgroundColour("#00dd00")
            button.SetLabel(_("LOCKED"))
            button.SetBitmap(icons8_play_50.GetBitmap(use_theme=False))
            button.Enable(False)
        elif state == STATE_WAIT:

            def f(event=None):
                self.context("continue\n")

            button.function = f
            button.SetBackgroundColour("#dddd00")
            button.SetLabel(_("Force Continue"))
            button.SetBitmap(icons8_laser_beam_hazard_50.GetBitmap(use_theme=False))
            button.Enable(True)
        elif state == STATE_PAUSE:

            def f(event=None):
                self.context("resume\n")

            button.function = f
            button.SetBackgroundColour("#00dd00")
            button.SetLabel(_("Resume Controller"))
            button.SetBitmap(icons8_play_50.GetBitmap(use_theme=False))
            button.Enable(True)
        elif state == STATE_ACTIVE:

            def f(event=None):
                self.context("hold\n")

            button.function = f
            button.SetBackgroundColour("#00ff00")
            button.SetLabel(_("Pause Controller"))
            button.SetBitmap(icons8_pause_50.GetBitmap(use_theme=False))
            button.Enable(True)
        elif state == STATE_TERMINATE:

            def f(event=None):
                self.context("abort\n")

            button.function = f
            button.SetBackgroundColour("#00ffff")
            button.SetLabel(_("Manual Reset"))
            button.SetBitmap(icons8_emergency_stop_button_50.GetBitmap(use_theme=False))
            button.Enable(True)

    @signal_listener("pipe;failing")
    def on_usb_failing(self, origin, count):
        self.retries = count

    def on_button_start_controller(self, event=None):
        event.Skip()
        self.button_controller_control.function()

    def on_check_show_usb_log(self, event=None):
        on = self.checkbox_show_usb_log.GetValue()
        self.text_usb_log.Show(on)
        self.context.show_usb_log = bool(on)
        if on:
            self.GetParent().SetSize((_advanced_width, _default_height))
        else:
            self.GetParent().SetSize((_simple_width, _default_height))


class LihuiyuControllerGui(MWindow):
    def __init__(self, *args, **kwds):
        super().__init__(_advanced_width, _default_height, *args, **kwds)

        # ==========
        # MENU BAR
        # ==========
        from platform import system as _sys

        if _sys() != "Darwin":
            self.LihuiyuController_menubar = wx.MenuBar()
            self.create_menu(self.LihuiyuController_menubar.Append)
            self.SetMenuBar(self.LihuiyuController_menubar)
        # ==========
        # MENUBAR END
        # ==========

        self.panel = LihuiyuControllerPanel(self, wx.ID_ANY, context=self.context)
        self.add_module_delegate(self.panel)
        _icon = wx.NullIcon
        _icon.CopyFromBitmap(icons8_connected_50.GetBitmap())
        self.SetIcon(_icon)
        self.SetTitle(_("Lihuiyu-Controller"))

    def create_menu(self, append):
        wxglade_tmp_menu = wx.Menu()
        item = wxglade_tmp_menu.Append(
            wx.ID_ANY, _("Reset USB"), _("Reset USB connection")
        )
        self.Bind(wx.EVT_MENU, self.on_menu_usb_reset, id=item.GetId())
        item = wxglade_tmp_menu.Append(
            wx.ID_ANY, _("Release USB"), _("Release USB resources")
        )
        self.Bind(wx.EVT_MENU, self.on_menu_usb_release, id=item.GetId())
        append(wxglade_tmp_menu, _("Tools"))
        wxglade_tmp_menu = wx.Menu()
        item = wxglade_tmp_menu.Append(wx.ID_ANY, _("Pause"), "")
        self.Bind(wx.EVT_MENU, self.on_menu_pause, id=item.GetId())
        item = wxglade_tmp_menu.Append(wx.ID_ANY, _("Stop"), "")
        self.Bind(wx.EVT_MENU, self.on_menu_stop, id=item.GetId())
        append(wxglade_tmp_menu, _("Commands"))
        wxglade_tmp_menu = wx.Menu()
        item = wxglade_tmp_menu.Append(
            wx.ID_ANY, _("BufferView"), _("Views the Controller Buffer")
        )
        self.Bind(wx.EVT_MENU, self.on_menu_bufferview, id=item.GetId())
        append(wxglade_tmp_menu, _("Views"))

    def window_preserve(self):
        return False

    def on_menu_usb_reset(self, event):
        try:
            self.context("usb_reset\n")
        except AttributeError:
            pass

    def on_menu_usb_release(self, event):
        try:
            self.context("usb_release\n")
        except AttributeError:
            pass

    def on_menu_pause(self, event=None):
        try:
            self.context("pause\n")
        except AttributeError:
            pass

    def on_menu_stop(self, event=None):
        try:
            self.context("estop\n")
        except AttributeError:
            pass

    def on_menu_bufferview(self, event=None):
        self.context("window open BufferView\n")

    @staticmethod
    def submenu():
        return ("Device-Control", "Controller")
