# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator (autorest: 3.1.3, generator: {generator})
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import functools
from typing import TYPE_CHECKING
import warnings

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import HttpResponse
from azure.core.pipeline.transport._base import _format_url_section
from azure.core.rest import HttpRequest
from msrest import Serializer

from .. import models as _models

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from typing import Any, Callable, Dict, Generic, IO, Optional, TypeVar, Union

    T = TypeVar("T")
    ClsType = Optional[
        Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]
    ]

_SERIALIZER = Serializer()
# fmt: off

def build_get_all_resumes_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    limit = kwargs.pop('limit', 300)  # type: Optional[int]
    offset = kwargs.pop('offset', None)  # type: Optional[int]

    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/resumes')

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if limit is not None:
        query_parameters['limit'] = _SERIALIZER.query("limit", limit, 'int', minimum=1)
    if offset is not None:
        query_parameters['offset'] = _SERIALIZER.query("offset", offset, 'int', minimum=0)

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_create_resume_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    content_type = kwargs.pop('content_type', None)  # type: Optional[str]

    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/resumes')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=url,
        headers=header_parameters,
        **kwargs
    )


def build_get_resume_request(
    identifier,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/resumes/{identifier}')
    path_format_arguments = {
        "identifier": _SERIALIZER.url("identifier", identifier, 'str'),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        headers=header_parameters,
        **kwargs
    )


def build_delete_resume_request(
    identifier,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/resumes/{identifier}')
    path_format_arguments = {
        "identifier": _SERIALIZER.url("identifier", identifier, 'str'),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="DELETE",
        url=url,
        headers=header_parameters,
        **kwargs
    )


def build_get_all_redacted_resumes_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    limit = kwargs.pop('limit', 300)  # type: Optional[int]
    offset = kwargs.pop('offset', None)  # type: Optional[int]

    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/redacted_resumes')

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if limit is not None:
        query_parameters['limit'] = _SERIALIZER.query("limit", limit, 'int', minimum=1)
    if offset is not None:
        query_parameters['offset'] = _SERIALIZER.query("offset", offset, 'int', minimum=0)

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_create_redacted_resume_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    content_type = kwargs.pop('content_type', None)  # type: Optional[str]

    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/redacted_resumes')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=url,
        headers=header_parameters,
        **kwargs
    )


def build_get_redacted_resume_request(
    identifier,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/redacted_resumes/{identifier}')
    path_format_arguments = {
        "identifier": _SERIALIZER.url("identifier", identifier, 'str'),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        headers=header_parameters,
        **kwargs
    )


def build_delete_redacted_resume_request(
    identifier,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/redacted_resumes/{identifier}')
    path_format_arguments = {
        "identifier": _SERIALIZER.url("identifier", identifier, 'str'),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="DELETE",
        url=url,
        headers=header_parameters,
        **kwargs
    )


def build_get_all_resume_formats_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    limit = kwargs.pop('limit', 300)  # type: Optional[int]
    offset = kwargs.pop('offset', None)  # type: Optional[int]

    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/resume_formats')

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if limit is not None:
        query_parameters['limit'] = _SERIALIZER.query("limit", limit, 'int', minimum=1)
    if offset is not None:
        query_parameters['offset'] = _SERIALIZER.query("offset", offset, 'int', minimum=0)

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_get_all_reformatted_resumes_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    limit = kwargs.pop('limit', 300)  # type: Optional[int]
    offset = kwargs.pop('offset', None)  # type: Optional[int]

    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/reformatted_resumes')

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if limit is not None:
        query_parameters['limit'] = _SERIALIZER.query("limit", limit, 'int', minimum=1)
    if offset is not None:
        query_parameters['offset'] = _SERIALIZER.query("offset", offset, 'int', minimum=0)

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_create_reformatted_resume_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    content_type = kwargs.pop('content_type', None)  # type: Optional[str]

    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/reformatted_resumes')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=url,
        headers=header_parameters,
        **kwargs
    )


def build_get_reformatted_resume_request(
    identifier,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/reformatted_resumes/{identifier}')
    path_format_arguments = {
        "identifier": _SERIALIZER.url("identifier", identifier, 'str'),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        headers=header_parameters,
        **kwargs
    )


def build_delete_reformatted_resume_request(
    identifier,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/reformatted_resumes/{identifier}')
    path_format_arguments = {
        "identifier": _SERIALIZER.url("identifier", identifier, 'str'),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="DELETE",
        url=url,
        headers=header_parameters,
        **kwargs
    )

# fmt: on
class AffindaAPIOperationsMixin(object):
    def get_all_resumes(
        self, **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.GetAllDocumentsResults", "_models.RequestError"]
        """Gets list of all resumes.

        Returns all the resume summaries for that user, limited to 300 per page.

        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: GetAllDocumentsResults or RequestError, or the result of cls(response)
        :rtype: ~affinda.models.GetAllDocumentsResults or ~affinda.models.RequestError
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop(
            "cls", None
        )  # type: ClsType[Union["_models.GetAllDocumentsResults", "_models.RequestError"]]
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}))

        request = build_get_all_resumes_request(
            limit=self._config.limit,
            offset=self._config.offset,
            template_url=self.get_all_resumes.metadata["url"],
        )._to_pipeline_transport_request()
        request.url = self._client.format_url(request.url)

        pipeline_response = self._client.send_request(
            request, stream=False, _return_pipeline_response=True, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize("GetAllDocumentsResults", pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_all_resumes.metadata = {"url": "/resumes"}  # type: ignore

    def create_resume(
        self,
        file=None,  # type: Optional[IO]
        identifier=None,  # type: Optional[str]
        file_name=None,  # type: Optional[str]
        url=None,  # type: Optional[str]
        wait=True,  # type: Optional[bool]
        resume_language=None,  # type: Optional[str]
        expiry_time=None,  # type: Optional[str]
        **kwargs,  # type: Any
    ):
        # type: (...) -> Union["_models.Resume", "_models.RequestError"]
        """Uploads a resume for parsing.

        Uploads a resume for parsing.
        When successful, returns an ``identifier`` in the response for subsequent use with the
        `/resumes/{identifier} <#operation/getResume>`_ endpoint to check processing status and
        retrieve results.

        :param file:
        :type file: IO
        :param identifier:
        :type identifier: str
        :param file_name:
        :type file_name: str
        :param url:
        :type url: str
        :param wait:
        :type wait: bool
        :param resume_language:
        :type resume_language: str
        :param expiry_time:
        :type expiry_time: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Resume or RequestError, or the result of cls(response)
        :rtype: ~affinda.models.Resume or ~affinda.models.RequestError
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop(
            "cls", None
        )  # type: ClsType[Union["_models.Resume", "_models.RequestError"]]
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}))

        content_type = kwargs.pop("content_type", None)  # type: Optional[str]

        files = None
        data = None
        # Construct form data
        files = {
            "file": file,
            "identifier": identifier,
            "fileName": file_name,
            "url": url,
            "wait": wait,
            "resumeLanguage": resume_language,
            "expiryTime": expiry_time,
        }

        request = build_create_resume_request(
            content_type=content_type,
            files=files,
            data=data,
            template_url=self.create_resume.metadata["url"],
        )._to_pipeline_transport_request()
        request.url = self._client.format_url(request.url)

        pipeline_response = self._client.send_request(
            request, stream=False, _return_pipeline_response=True, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 201, 400, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize("Resume", pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize("Resume", pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_resume.metadata = {"url": "/resumes"}  # type: ignore

    def get_resume(
        self,
        identifier,  # type: str
        **kwargs,  # type: Any
    ):
        # type: (...) -> Union["_models.Resume", "_models.RequestError"]
        """Gets parse results for a specific resume.

        Returns all the parse results for that resume if processing is completed.
        The ``identifier`` is the unique ID returned after POST-ing the resume via the `/resumes
        <#operation/createResume>`_ endpoint.

        :param identifier: Document identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Resume or RequestError, or the result of cls(response)
        :rtype: ~affinda.models.Resume or ~affinda.models.RequestError
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop(
            "cls", None
        )  # type: ClsType[Union["_models.Resume", "_models.RequestError"]]
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}))

        request = build_get_resume_request(
            identifier=identifier,
            template_url=self.get_resume.metadata["url"],
        )._to_pipeline_transport_request()
        request.url = self._client.format_url(request.url)

        pipeline_response = self._client.send_request(
            request, stream=False, _return_pipeline_response=True, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize("Resume", pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_resume.metadata = {"url": "/resumes/{identifier}"}  # type: ignore

    def delete_resume(
        self,
        identifier,  # type: str
        **kwargs,  # type: Any
    ):
        # type: (...) -> Optional["_models.RequestError"]
        """Deletes a resume.

        Deletes the specified resume from the database.

        :param identifier: Resume identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: RequestError, or the result of cls(response)
        :rtype: ~affinda.models.RequestError or None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop("cls", None)  # type: ClsType[Optional["_models.RequestError"]]
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}))

        request = build_delete_resume_request(
            identifier=identifier,
            template_url=self.delete_resume.metadata["url"],
        )._to_pipeline_transport_request()
        request.url = self._client.format_url(request.url)

        pipeline_response = self._client.send_request(
            request, stream=False, _return_pipeline_response=True, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204, 400, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, response)
            raise HttpResponseError(response=response, model=error)

        deserialized = None
        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    delete_resume.metadata = {"url": "/resumes/{identifier}"}  # type: ignore

    def get_all_redacted_resumes(
        self, **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.GetAllDocumentsResults", "_models.RequestError"]
        """Gets list of all redacted resumes.

        Returns all the redacted resume information for that resume.

        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: GetAllDocumentsResults or RequestError, or the result of cls(response)
        :rtype: ~affinda.models.GetAllDocumentsResults or ~affinda.models.RequestError
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop(
            "cls", None
        )  # type: ClsType[Union["_models.GetAllDocumentsResults", "_models.RequestError"]]
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}))

        request = build_get_all_redacted_resumes_request(
            limit=self._config.limit,
            offset=self._config.offset,
            template_url=self.get_all_redacted_resumes.metadata["url"],
        )._to_pipeline_transport_request()
        request.url = self._client.format_url(request.url)

        pipeline_response = self._client.send_request(
            request, stream=False, _return_pipeline_response=True, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize("GetAllDocumentsResults", pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_all_redacted_resumes.metadata = {"url": "/redacted_resumes"}  # type: ignore

    def create_redacted_resume(
        self,
        file=None,  # type: Optional[IO]
        identifier=None,  # type: Optional[str]
        file_name=None,  # type: Optional[str]
        url=None,  # type: Optional[str]
        resume_language=None,  # type: Optional[str]
        wait=True,  # type: Optional[bool]
        redact_headshot="true",  # type: Optional[str]
        redact_personal_details="true",  # type: Optional[str]
        redact_work_details="true",  # type: Optional[str]
        redact_education_details="true",  # type: Optional[str]
        redact_referees="true",  # type: Optional[str]
        redact_locations="true",  # type: Optional[str]
        redact_dates="true",  # type: Optional[str]
        expiry_time=None,  # type: Optional[str]
        **kwargs,  # type: Any
    ):
        # type: (...) -> Union["_models.RedactedResume", "_models.RequestError"]
        """Uploads a resume for redacting.

        Uploads a resume for redacting.

        :param file:
        :type file: IO
        :param identifier:
        :type identifier: str
        :param file_name:
        :type file_name: str
        :param url:
        :type url: str
        :param resume_language:
        :type resume_language: str
        :param wait:
        :type wait: bool
        :param redact_headshot: Whether to redact headshot.
        :type redact_headshot: str
        :param redact_personal_details: Whether to redact personal details (e.g. name, address).
        :type redact_personal_details: str
        :param redact_work_details: Whether to redact work details (e.g. company names).
        :type redact_work_details: str
        :param redact_education_details: Whether to redact education details (e.g. university names).
        :type redact_education_details: str
        :param redact_referees: Whether to redact referee details.
        :type redact_referees: str
        :param redact_locations: Whether to redact location names.
        :type redact_locations: str
        :param redact_dates: Whether to redact dates.
        :type redact_dates: str
        :param expiry_time:
        :type expiry_time: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: RedactedResume or RequestError, or the result of cls(response)
        :rtype: ~affinda.models.RedactedResume or ~affinda.models.RequestError
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop(
            "cls", None
        )  # type: ClsType[Union["_models.RedactedResume", "_models.RequestError"]]
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}))

        content_type = kwargs.pop("content_type", None)  # type: Optional[str]

        files = None
        data = None
        # Construct form data
        files = {
            "file": file,
            "identifier": identifier,
            "fileName": file_name,
            "url": url,
            "resumeLanguage": resume_language,
            "wait": wait,
            "redactHeadshot": redact_headshot,
            "redactPersonalDetails": redact_personal_details,
            "redactWorkDetails": redact_work_details,
            "redactEducationDetails": redact_education_details,
            "redactReferees": redact_referees,
            "redactLocations": redact_locations,
            "redactDates": redact_dates,
            "expiryTime": expiry_time,
        }

        request = build_create_redacted_resume_request(
            content_type=content_type,
            files=files,
            data=data,
            template_url=self.create_redacted_resume.metadata["url"],
        )._to_pipeline_transport_request()
        request.url = self._client.format_url(request.url)

        pipeline_response = self._client.send_request(
            request, stream=False, _return_pipeline_response=True, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 201, 400, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize("RedactedResume", pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize("RedactedResume", pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_redacted_resume.metadata = {"url": "/redacted_resumes"}  # type: ignore

    def get_redacted_resume(
        self,
        identifier,  # type: str
        **kwargs,  # type: Any
    ):
        # type: (...) -> Union["_models.RedactedResume", "_models.RequestError"]
        """Gets redaction results for a specific resume.

        Returns all the redaction results for that resume if processing is completed.
        The ``identifier`` is the unique ID returned after POST-ing the resume via the
        `/redacted_resumes <#operation/createRedactedResume>`_ endpoint.

        :param identifier: Document identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: RedactedResume or RequestError, or the result of cls(response)
        :rtype: ~affinda.models.RedactedResume or ~affinda.models.RequestError
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop(
            "cls", None
        )  # type: ClsType[Union["_models.RedactedResume", "_models.RequestError"]]
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}))

        request = build_get_redacted_resume_request(
            identifier=identifier,
            template_url=self.get_redacted_resume.metadata["url"],
        )._to_pipeline_transport_request()
        request.url = self._client.format_url(request.url)

        pipeline_response = self._client.send_request(
            request, stream=False, _return_pipeline_response=True, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize("RedactedResume", pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_redacted_resume.metadata = {"url": "/redacted_resumes/{identifier}"}  # type: ignore

    def delete_redacted_resume(
        self,
        identifier,  # type: str
        **kwargs,  # type: Any
    ):
        # type: (...) -> Optional["_models.RequestError"]
        """Deletes a redacted resume.

        Deletes the specified resume from the database.

        :param identifier: Document identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: RequestError, or the result of cls(response)
        :rtype: ~affinda.models.RequestError or None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop("cls", None)  # type: ClsType[Optional["_models.RequestError"]]
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}))

        request = build_delete_redacted_resume_request(
            identifier=identifier,
            template_url=self.delete_redacted_resume.metadata["url"],
        )._to_pipeline_transport_request()
        request.url = self._client.format_url(request.url)

        pipeline_response = self._client.send_request(
            request, stream=False, _return_pipeline_response=True, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204, 400, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, response)
            raise HttpResponseError(response=response, model=error)

        deserialized = None
        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    delete_redacted_resume.metadata = {"url": "/redacted_resumes/{identifier}"}  # type: ignore

    def get_all_resume_formats(
        self, **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.Paths1UtuacyResumeFormatsGetResponses200ContentApplicationJsonSchema", "_models.RequestError"]
        """Gets list of all resume formats.

        Returns all the resume formats.

        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Paths1UtuacyResumeFormatsGetResponses200ContentApplicationJsonSchema or RequestError,
         or the result of cls(response)
        :rtype: ~affinda.models.Paths1UtuacyResumeFormatsGetResponses200ContentApplicationJsonSchema or
         ~affinda.models.RequestError
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop(
            "cls", None
        )  # type: ClsType[Union["_models.Paths1UtuacyResumeFormatsGetResponses200ContentApplicationJsonSchema", "_models.RequestError"]]
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}))

        request = build_get_all_resume_formats_request(
            limit=self._config.limit,
            offset=self._config.offset,
            template_url=self.get_all_resume_formats.metadata["url"],
        )._to_pipeline_transport_request()
        request.url = self._client.format_url(request.url)

        pipeline_response = self._client.send_request(
            request, stream=False, _return_pipeline_response=True, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize(
                "Paths1UtuacyResumeFormatsGetResponses200ContentApplicationJsonSchema",
                pipeline_response,
            )

        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_all_resume_formats.metadata = {"url": "/resume_formats"}  # type: ignore

    def get_all_reformatted_resumes(
        self, **kwargs  # type: Any
    ):
        # type: (...) -> Union["_models.GetAllDocumentsResults", "_models.RequestError"]
        """Gets list of all reformatted resumes.

        Returns all the reformatted resume information for that resume.

        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: GetAllDocumentsResults or RequestError, or the result of cls(response)
        :rtype: ~affinda.models.GetAllDocumentsResults or ~affinda.models.RequestError
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop(
            "cls", None
        )  # type: ClsType[Union["_models.GetAllDocumentsResults", "_models.RequestError"]]
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}))

        request = build_get_all_reformatted_resumes_request(
            limit=self._config.limit,
            offset=self._config.offset,
            template_url=self.get_all_reformatted_resumes.metadata["url"],
        )._to_pipeline_transport_request()
        request.url = self._client.format_url(request.url)

        pipeline_response = self._client.send_request(
            request, stream=False, _return_pipeline_response=True, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize("GetAllDocumentsResults", pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_all_reformatted_resumes.metadata = {"url": "/reformatted_resumes"}  # type: ignore

    def create_reformatted_resume(
        self,
        resume_format,  # type: str
        file=None,  # type: Optional[IO]
        identifier=None,  # type: Optional[str]
        file_name=None,  # type: Optional[str]
        url=None,  # type: Optional[str]
        resume_language=None,  # type: Optional[str]
        wait=True,  # type: Optional[bool]
        **kwargs,  # type: Any
    ):
        # type: (...) -> Union["_models.ReformattedResume", "_models.RequestError"]
        """Uploads a resume for reformatting.

        Uploads a resume for reformatting.

        :param resume_format:
        :type resume_format: str
        :param file:
        :type file: IO
        :param identifier:
        :type identifier: str
        :param file_name:
        :type file_name: str
        :param url:
        :type url: str
        :param resume_language:
        :type resume_language: str
        :param wait:
        :type wait: bool
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ReformattedResume or RequestError, or the result of cls(response)
        :rtype: ~affinda.models.ReformattedResume or ~affinda.models.RequestError
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop(
            "cls", None
        )  # type: ClsType[Union["_models.ReformattedResume", "_models.RequestError"]]
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}))

        content_type = kwargs.pop("content_type", None)  # type: Optional[str]

        files = None
        data = None
        # Construct form data
        files = {
            "file": file,
            "identifier": identifier,
            "fileName": file_name,
            "url": url,
            "resumeLanguage": resume_language,
            "resumeFormat": resume_format,
            "wait": wait,
        }

        request = build_create_reformatted_resume_request(
            content_type=content_type,
            files=files,
            data=data,
            template_url=self.create_reformatted_resume.metadata["url"],
        )._to_pipeline_transport_request()
        request.url = self._client.format_url(request.url)

        pipeline_response = self._client.send_request(
            request, stream=False, _return_pipeline_response=True, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 201, 400, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize("ReformattedResume", pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize("ReformattedResume", pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_reformatted_resume.metadata = {"url": "/reformatted_resumes"}  # type: ignore

    def get_reformatted_resume(
        self,
        identifier,  # type: str
        **kwargs,  # type: Any
    ):
        # type: (...) -> Union["_models.ReformattedResume", "_models.RequestError"]
        """Gets reformatting results for a specific resume.

        Returns all the reformatting results for that resume if processing is completed.
        The ``identifier`` is the unique ID returned after POST-ing the resume via the
        `/reformatted_resumes <#operation/createReformattedResume>`_ endpoint.

        :param identifier: Document identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ReformattedResume or RequestError, or the result of cls(response)
        :rtype: ~affinda.models.ReformattedResume or ~affinda.models.RequestError
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop(
            "cls", None
        )  # type: ClsType[Union["_models.ReformattedResume", "_models.RequestError"]]
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}))

        request = build_get_reformatted_resume_request(
            identifier=identifier,
            template_url=self.get_reformatted_resume.metadata["url"],
        )._to_pipeline_transport_request()
        request.url = self._client.format_url(request.url)

        pipeline_response = self._client.send_request(
            request, stream=False, _return_pipeline_response=True, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize("ReformattedResume", pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_reformatted_resume.metadata = {"url": "/reformatted_resumes/{identifier}"}  # type: ignore

    def delete_reformatted_resume(
        self,
        identifier,  # type: str
        **kwargs,  # type: Any
    ):
        # type: (...) -> Optional["_models.RequestError"]
        """Deletes a reformatted resume.

        Deletes the specified resume from the database.

        :param identifier: Document identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: RequestError, or the result of cls(response)
        :rtype: ~affinda.models.RequestError or None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop("cls", None)  # type: ClsType[Optional["_models.RequestError"]]
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}))

        request = build_delete_reformatted_resume_request(
            identifier=identifier,
            template_url=self.delete_reformatted_resume.metadata["url"],
        )._to_pipeline_transport_request()
        request.url = self._client.format_url(request.url)

        pipeline_response = self._client.send_request(
            request, stream=False, _return_pipeline_response=True, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204, 400, 401, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, response)
            raise HttpResponseError(response=response, model=error)

        deserialized = None
        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    delete_reformatted_resume.metadata = {"url": "/reformatted_resumes/{identifier}"}  # type: ignore
