/*
 * Decompiled with CFR 0.152.
 */
package net.trustyuri;

import java.net.URI;
import javax.activation.MimetypesFileTypeMap;
import javax.xml.bind.DatatypeConverter;
import net.trustyuri.ModuleDirectory;
import net.trustyuri.TrustyUriModule;

public class TrustyUriUtils {
    private static final MimetypesFileTypeMap mimeMap = new MimetypesFileTypeMap();

    public static String getArtifactCode(String trustyUriString) {
        if (!trustyUriString.matches("(.*[^A-Za-z0-9\\-_]|)[A-Za-z0-9\\-_]{25,}(\\.[A-Za-z0-9\\-_\\.]{0,20})?")) {
            return null;
        }
        return trustyUriString.replaceFirst("^(.*[^A-Za-z0-9\\-_]|)([A-Za-z0-9\\-_]{25,})(\\.[A-Za-z0-9\\-_\\.]{0,20})?$", "$2");
    }

    public static boolean isPotentialArtifactCode(String ac) {
        if (ac == null) {
            return false;
        }
        String id = TrustyUriUtils.getModuleId(ac);
        TrustyUriModule module = ModuleDirectory.getModule(id);
        if (module == null) {
            return false;
        }
        int l = TrustyUriUtils.getDataPart(ac).length();
        return l == module.getDataPartLength();
    }

    public static boolean isPotentialTrustyUri(Object stringObject) {
        return TrustyUriUtils.isPotentialArtifactCode(TrustyUriUtils.getArtifactCode(stringObject.toString()));
    }

    public static String getModuleId(String artifactCode) {
        return artifactCode.substring(0, 2);
    }

    public static String getDataPart(String artifactCode) {
        return artifactCode.substring(2);
    }

    public static String getNiUri(String s) {
        return TrustyUriUtils.getNiUri(s, true);
    }

    public static String getNiUri(String s, boolean withAuthority) {
        String ac = TrustyUriUtils.getArtifactCode(s);
        if (ac == null) {
            return null;
        }
        String moduleId = TrustyUriUtils.getModuleId(ac);
        String hash = TrustyUriUtils.getDataPart(ac);
        TrustyUriModule module = ModuleDirectory.getModule(moduleId);
        String tail = "/" + module.getAlgorithmId() + ";" + hash + "?module=" + moduleId;
        if (withAuthority) {
            try {
                String autority = new URI(s).getAuthority().toString();
                return "ni://" + autority + tail;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "ni://" + tail;
    }

    public static String getBase64(byte[] bytes) {
        String h = DatatypeConverter.printBase64Binary(bytes);
        h = h.replaceFirst("=*$", "");
        h = h.replace('+', '-');
        h = h.replace('/', '_');
        return h;
    }

    public static String getMimetype(String filename) {
        return mimeMap.getContentType(filename);
    }
}

