/*
 * Decompiled with CFR 0.152.
 */
package net.trustyuri.rdf;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.security.MessageDigest;
import net.trustyuri.TrustyUriException;
import net.trustyuri.TrustyUriResource;
import net.trustyuri.rdf.RdfHasher;
import net.trustyuri.rdf.RdfPreprocessor;
import net.trustyuri.rdf.RdfUtils;
import net.trustyuri.rdf.StatementComparator;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.helpers.AbstractRDFHandler;

public class CheckSortedRdf {
    private File file;
    private MessageDigest md;
    private Statement previous;
    private TrustyUriResource r;

    public static void main(String[] args) throws IOException, TrustyUriException {
        File file = new File(args[0]);
        CheckSortedRdf ch = new CheckSortedRdf(file);
        boolean isCorrect = ch.check();
        if (isCorrect) {
            System.out.println("Correct hash: " + ch.getArtifactCode());
        } else {
            System.out.println("*** INCORRECT HASH ***");
        }
    }

    public CheckSortedRdf(File file) {
        this.file = file;
    }

    public boolean check() throws IOException, TrustyUriException {
        String moduleId;
        this.md = RdfHasher.getDigest();
        this.r = new TrustyUriResource(this.file);
        if (this.r.getArtifactCode() == null) {
            System.out.println("ERROR: Not a trusty URI or unknown module");
            System.exit(1);
        }
        if (!(moduleId = this.r.getModuleId()).equals("RA")) {
            System.out.println("ERROR: Unsupported module: " + moduleId + " (this function only supports " + "RA" + ")");
            System.exit(1);
        }
        RDFFormat format = this.r.getFormat(RDFFormat.TURTLE);
        RDFParser p = RdfUtils.getParser(format);
        this.previous = null;
        p.setRDFHandler(new RdfPreprocessor((RDFHandler)new AbstractRDFHandler(){

            @Override
            public void handleStatement(Statement st) throws RDFHandlerException {
                if (CheckSortedRdf.this.previous != null && StatementComparator.compareStatement(CheckSortedRdf.this.previous, st) > 0) {
                    throw new RuntimeException("File not sorted");
                }
                if (!st.equals(CheckSortedRdf.this.previous)) {
                    RdfHasher.digest(st, CheckSortedRdf.this.md);
                }
                CheckSortedRdf.this.previous = st;
            }
        }, this.r.getArtifactCode()));
        try (BufferedReader reader = new BufferedReader(this.r.getInputStreamReader(), 65536);){
            p.parse(reader, "");
        }
        String artifactCode = RdfHasher.getArtifactCode(this.md);
        return artifactCode.equals(this.r.getArtifactCode());
    }

    public String getArtifactCode() {
        return this.r.getArtifactCode();
    }
}

