/*
 * Decompiled with CFR 0.152.
 */
package net.trustyuri.rdf;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.trustyuri.TrustyUriException;
import net.trustyuri.TrustyUriUtils;
import net.trustyuri.rdf.RdfUtils;
import net.trustyuri.rdf.StatementComparator;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;

public class RdfHasher {
    private static final boolean DEBUG = false;

    private RdfHasher() {
    }

    public static String makeArtifactCode(List<Statement> statements) {
        return RdfHasher.getArtifactCode(RdfHasher.digest(statements));
    }

    public static String makeGraphArtifactCode(List<Statement> statements) throws TrustyUriException {
        IRI graphUri = null;
        ArrayList<Statement> graph = new ArrayList<Statement>();
        for (Statement st : statements) {
            Resource c = st.getContext();
            if (c == null) {
                throw new TrustyUriException("Graph is null");
            }
            if (c instanceof BNode) {
                throw new TrustyUriException("Graph is blank node");
            }
            if (graphUri != null && !c.equals(graphUri)) {
                throw new TrustyUriException("Multiple graphs");
            }
            graphUri = (IRI)c;
            graph.add(st);
        }
        if (graph.size() == 0) {
            throw new TrustyUriException("Graph not found");
        }
        return RdfHasher.getGraphArtifactCode(RdfHasher.digest(graph));
    }

    public static String makeGraphArtifactCode(List<Statement> statements, IRI baseUri) throws TrustyUriException {
        IRI graphUri = RdfUtils.getTrustyUri(baseUri, " ");
        ArrayList<Statement> graph = new ArrayList<Statement>();
        for (Statement st : statements) {
            Resource c = st.getContext();
            if (c == null || !c.equals(graphUri)) continue;
            graph.add(st);
        }
        if (graph.size() == 0) {
            throw new TrustyUriException("Graph not found");
        }
        return RdfHasher.getGraphArtifactCode(RdfHasher.digest(graph));
    }

    public static MessageDigest digest(List<Statement> statements) {
        MessageDigest md = RdfHasher.getDigest();
        Collections.sort(statements, new StatementComparator());
        Statement previous = null;
        for (Statement st : statements) {
            if (!st.equals(previous)) {
                RdfHasher.digest(st, md);
            }
            previous = st;
        }
        return md;
    }

    public static String getDigestString(List<Statement> statements) {
        StringBuilder sb = new StringBuilder();
        Collections.sort(statements, new StatementComparator());
        Statement previous = null;
        for (Statement st : statements) {
            if (!st.equals(previous)) {
                sb.append(RdfHasher.getDigestString(st));
            }
            previous = st;
        }
        return sb.toString();
    }

    public static MessageDigest getDigest() {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
        return md;
    }

    public static String getArtifactCode(MessageDigest md) {
        return "RA" + TrustyUriUtils.getBase64(md.digest());
    }

    public static String getGraphArtifactCode(MessageDigest md) {
        return "RB" + TrustyUriUtils.getBase64(md.digest());
    }

    public static void digest(Statement st, MessageDigest md) {
        md.update(RdfHasher.valueToString(st.getContext()).getBytes());
        md.update(RdfHasher.valueToString(st.getSubject()).getBytes());
        md.update(RdfHasher.valueToString(st.getPredicate()).getBytes());
        md.update(RdfHasher.valueToString(st.getObject()).getBytes());
    }

    public static String getDigestString(Statement st) {
        String s = "";
        s = s + RdfHasher.valueToString(st.getContext());
        s = s + RdfHasher.valueToString(st.getSubject());
        s = s + RdfHasher.valueToString(st.getPredicate());
        s = s + RdfHasher.valueToString(st.getObject());
        return s;
    }

    private static String valueToString(Value v) {
        if (v instanceof IRI) {
            return ((IRI)v).toString() + "\n";
        }
        if (v instanceof Literal) {
            Literal l = (Literal)v;
            if (l.getLanguage().isPresent()) {
                return "@" + l.getLanguage().get().toLowerCase() + " " + RdfHasher.escapeString(l.stringValue()) + "\n";
            }
            IRI dataType = l.getDatatype();
            if (dataType == null) {
                dataType = XMLSchema.STRING;
            }
            return "^" + dataType.stringValue() + " " + RdfHasher.escapeString(l.stringValue()) + "\n";
        }
        if (v instanceof BNode) {
            throw new RuntimeException("Unexpected blank node encountered");
        }
        if (v == null) {
            return "\n";
        }
        throw new RuntimeException("Unknown element");
    }

    private static final String escapeString(String s) {
        return s.replace("\\", "\\\\").replace("\n", "\\n");
    }
}

