/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.config;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.query.QueryResults;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.eclipse.rdf4j.repository.config.RepositoryConfig;
import org.eclipse.rdf4j.repository.config.RepositoryConfigException;
import org.eclipse.rdf4j.repository.config.RepositoryConfigSchema;

public class RepositoryConfigUtil {
    public static RepositoryConfig getRepositoryConfig(Model model, String repositoryID) {
        Statement idStatement = RepositoryConfigUtil.getIDStatement(model, repositoryID);
        if (idStatement == null) {
            return null;
        }
        Resource repositoryNode = idStatement.getSubject();
        Resource context = idStatement.getContext();
        Model contextGraph = model.filter(null, null, null, context);
        return RepositoryConfig.create(contextGraph, repositoryNode);
    }

    public static Model getRepositoryConfigModel(Model model, String repositoryID) {
        Statement idStatement = RepositoryConfigUtil.getIDStatement(model, repositoryID);
        if (idStatement == null) {
            return null;
        }
        return model.filter(null, null, null, idStatement.getContext());
    }

    public static Set<String> getRepositoryIDs(Model model) throws RepositoryException {
        LinkedHashSet<String> idSet = new LinkedHashSet<String>();
        model.filter(null, RepositoryConfigSchema.REPOSITORYID, null, new Resource[0]).forEach(idStatement -> {
            if (idStatement.getObject() instanceof Literal) {
                Literal idLiteral = (Literal)idStatement.getObject();
                idSet.add(idLiteral.getLabel());
            }
        });
        return idSet;
    }

    private static Statement getIDStatement(Model model, String repositoryID) {
        Literal idLiteral = SimpleValueFactory.getInstance().createLiteral(repositoryID);
        Model idStatementList = model.filter(null, RepositoryConfigSchema.REPOSITORYID, (Value)idLiteral, new Resource[0]);
        if (idStatementList.size() == 1) {
            return (Statement)idStatementList.iterator().next();
        }
        if (idStatementList.isEmpty()) {
            return null;
        }
        throw new RepositoryConfigException("Multiple ID-statements for repository ID " + repositoryID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static Set<String> getRepositoryIDs(Repository repository) throws RepositoryException {
        try (RepositoryConnection con = repository.getConnection();){
            LinkedHashSet<String> idSet = new LinkedHashSet<String>();
            try (RepositoryResult<Statement> idStatementIter = con.getStatements(null, RepositoryConfigSchema.REPOSITORYID, null, true, new Resource[0]);){
                while (idStatementIter.hasNext()) {
                    Statement idStatement = idStatementIter.next();
                    if (!(idStatement.getObject() instanceof Literal)) continue;
                    Literal idLiteral = (Literal)idStatement.getObject();
                    idSet.add(idLiteral.getLabel());
                }
            }
            LinkedHashSet<String> linkedHashSet = idSet;
            return linkedHashSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static boolean hasRepositoryConfig(Repository repository, String repositoryID) throws RepositoryException, RepositoryConfigException {
        try (RepositoryConnection con = repository.getConnection();){
            boolean bl = RepositoryConfigUtil.getIDStatement(con, repositoryID) != null;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static RepositoryConfig getRepositoryConfig(Repository repository, String repositoryID) throws RepositoryConfigException, RepositoryException {
        try (RepositoryConnection con = repository.getConnection();){
            Statement idStatement = RepositoryConfigUtil.getIDStatement(con, repositoryID);
            if (idStatement == null) {
                RepositoryConfig repositoryConfig = null;
                return repositoryConfig;
            }
            Resource repositoryNode = idStatement.getSubject();
            Resource context = idStatement.getContext();
            if (context == null) {
                throw new RepositoryException("No configuration context for repository " + repositoryID);
            }
            Model contextGraph = QueryResults.asModel(con.getStatements(null, null, null, true, context));
            RepositoryConfig repositoryConfig = RepositoryConfig.create(contextGraph, repositoryNode);
            return repositoryConfig;
        }
    }

    @Deprecated
    public static void updateRepositoryConfigs(Repository repository, RepositoryConfig ... configs) throws RepositoryException, RepositoryConfigException {
        try (RepositoryConnection con = repository.getConnection();){
            RepositoryConfigUtil.updateRepositoryConfigs(con, configs);
        }
    }

    @Deprecated
    public static void updateRepositoryConfigs(RepositoryConnection con, RepositoryConfig ... configs) throws RepositoryException, RepositoryConfigException {
        ValueFactory vf = con.getRepository().getValueFactory();
        con.begin();
        for (RepositoryConfig config : configs) {
            Resource context = RepositoryConfigUtil.getContext(con, config.getID());
            if (context != null) {
                con.clear(context);
            } else {
                context = vf.createBNode();
            }
            con.add(context, RDF.TYPE, (Value)RepositoryConfigSchema.REPOSITORY_CONTEXT, new Resource[0]);
            LinkedHashModel graph = new LinkedHashModel();
            config.export(graph);
            con.add(graph, context);
        }
        con.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static boolean removeRepositoryConfigs(Repository repository, String ... repositoryIDs) throws RepositoryException, RepositoryConfigException {
        boolean changed = false;
        try (RepositoryConnection con = repository.getConnection();){
            con.begin();
            for (String id : repositoryIDs) {
                Resource context = RepositoryConfigUtil.getContext(con, id);
                if (context == null) continue;
                con.clear(context);
                con.remove(context, RDF.TYPE, (Value)RepositoryConfigSchema.REPOSITORY_CONTEXT, new Resource[0]);
                changed = true;
            }
            con.commit();
        }
        return changed;
    }

    @Deprecated
    public static Resource getContext(RepositoryConnection con, String repositoryID) throws RepositoryException, RepositoryConfigException {
        Resource context = null;
        Statement idStatement = RepositoryConfigUtil.getIDStatement(con, repositoryID);
        if (idStatement != null) {
            context = idStatement.getContext();
        }
        return context;
    }

    private static Statement getIDStatement(RepositoryConnection con, String repositoryID) throws RepositoryException, RepositoryConfigException {
        Literal idLiteral = con.getRepository().getValueFactory().createLiteral(repositoryID);
        List idStatementList = Iterations.asList(con.getStatements(null, RepositoryConfigSchema.REPOSITORYID, (Value)idLiteral, true, new Resource[0]));
        if (idStatementList.size() == 1) {
            return (Statement)idStatementList.get(0);
        }
        if (idStatementList.isEmpty()) {
            return null;
        }
        throw new RepositoryConfigException("Multiple ID-statements for repository ID " + repositoryID);
    }
}

