/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.rdf4j.rio.RioSetting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RioConfig
implements Serializable {
    private static final long serialVersionUID = 2714L;
    protected final ConcurrentMap<RioSetting<Object>, Object> settings = new ConcurrentHashMap<RioSetting<Object>, Object>();
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    public <T> T get(RioSetting<T> setting) {
        Object result = this.settings.get(setting);
        if (result == null) {
            return setting.getDefaultValue();
        }
        return (T)result;
    }

    public <T> RioConfig set(RioSetting<T> setting, T value) {
        if (value == null) {
            this.settings.remove(setting);
        } else {
            Object putIfAbsent = this.settings.putIfAbsent(setting, value);
            if (putIfAbsent != null) {
                this.settings.put(setting, value);
            }
        }
        return this;
    }

    public <T> boolean isSet(RioSetting<T> setting) {
        return this.settings.containsKey(setting);
    }

    public RioConfig useDefaults() {
        this.settings.clear();
        return this;
    }
}

