/*
 * Decompiled with CFR 0.152.
 */
package org.nanopub;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Set;
import org.apache.commons.io.output.NullOutputStream;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.rio.trig.TriGWriter;
import org.eclipse.rdf4j.rio.turtle.TurtleUtil;

public class CustomTrigWriter
extends TriGWriter {
    private Set<String> usedPrefixes;

    public CustomTrigWriter(OutputStream out) {
        super(out);
    }

    public CustomTrigWriter(Writer writer) {
        super(writer);
    }

    public CustomTrigWriter(OutputStream out, Set<String> usedPrefixes) {
        super(out);
        this.usedPrefixes = usedPrefixes;
    }

    public CustomTrigWriter(Writer writer, Set<String> usedPrefixes) {
        super(writer);
        this.usedPrefixes = usedPrefixes;
    }

    public CustomTrigWriter(Set<String> usedPrefixes) {
        super(NullOutputStream.NULL_OUTPUT_STREAM);
        this.usedPrefixes = usedPrefixes;
    }

    @Override
    protected void writeURI(IRI uri) throws IOException {
        String namespace;
        String p;
        String namespace2;
        String p2;
        String namespace3;
        String p3;
        String uriString = uri.toString();
        String prefix = (String)this.namespaceTable.get(uriString);
        if (prefix != null) {
            this.writer.write(prefix);
            this.writer.write(":");
            if (this.usedPrefixes != null) {
                this.usedPrefixes.add(prefix);
            }
            return;
        }
        prefix = null;
        int splitIdx = TurtleUtil.findURISplitIndex(uriString);
        if (!TurtleUtil.isNameEndChar(uriString.charAt(uriString.length() - 1))) {
            splitIdx = -1;
        }
        if (splitIdx > 0) {
            String namespace4 = uriString.substring(0, splitIdx);
            prefix = (String)this.namespaceTable.get(namespace4);
        }
        int splitIdxDot = uriString.lastIndexOf(".") + 1;
        if (uriString.length() == splitIdxDot) {
            splitIdxDot = -1;
        }
        if (splitIdx > 0 && splitIdxDot > splitIdx && (p3 = (String)this.namespaceTable.get(namespace3 = uriString.substring(0, splitIdxDot))) != null) {
            splitIdx = splitIdxDot;
            prefix = p3;
        }
        int splitIdxColon = uriString.lastIndexOf(":") + 1;
        if (uriString.length() == splitIdxColon) {
            splitIdxColon = -1;
        }
        if (splitIdx > 0 && splitIdxColon > splitIdx && (p2 = (String)this.namespaceTable.get(namespace2 = uriString.substring(0, splitIdxColon))) != null) {
            splitIdx = splitIdxColon;
            prefix = p2;
        }
        int splitIdxUnderscore = uriString.lastIndexOf("_") + 1;
        if (uriString.length() == splitIdxUnderscore) {
            splitIdxUnderscore = -1;
        }
        if (splitIdx > 0 && splitIdxUnderscore > splitIdx && (p = (String)this.namespaceTable.get(namespace = uriString.substring(0, splitIdxUnderscore))) != null) {
            splitIdx = splitIdxUnderscore;
            prefix = p;
        }
        int splitIdxHashsign = uriString.lastIndexOf("#");
        if (splitIdx > 0 && splitIdxHashsign > splitIdx - 2) {
            String namespace5 = uriString.substring(0, splitIdxHashsign);
            String p4 = (String)this.namespaceTable.get(namespace5);
            String postHashPrefix = (String)this.namespaceTable.get(namespace5 + "#");
            if (p4 != null && postHashPrefix == null) {
                splitIdx = splitIdxHashsign;
                prefix = p4;
            }
        }
        if (uriString.endsWith(".")) {
            prefix = null;
        }
        if (prefix != null) {
            this.writer.write(prefix);
            this.writer.write(":");
            this.writer.write(uriString.substring(splitIdx).replaceFirst("^#", "\\\\#"));
            if (this.usedPrefixes != null) {
                this.usedPrefixes.add(prefix);
            }
        } else {
            this.writer.write("<");
            this.writer.write(TurtleUtil.encodeURIString(uriString));
            this.writer.write(">");
        }
    }
}

