/*
 * Decompiled with CFR 0.152.
 */
package org.nanopub;

import com.google.common.collect.ImmutableSet;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.activation.MimetypesFileTypeMap;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.HttpClientBuilder;
import org.eclipse.rdf4j.RDF4JException;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.RDFParserFactory;
import org.eclipse.rdf4j.rio.RDFParserRegistry;
import org.eclipse.rdf4j.rio.RDFWriterFactory;
import org.eclipse.rdf4j.rio.RDFWriterRegistry;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.helpers.AbstractRDFHandler;
import org.nanopub.CustomTrigWriterFactory;
import org.nanopub.MalformedNanopubException;
import org.nanopub.Nanopub;
import org.nanopub.NanopubUtils;
import org.nanopub.NanopubWithNs;
import org.nanopub.SimpleCreatorPattern;
import org.nanopub.SimpleTimestampPattern;

public class NanopubImpl
implements NanopubWithNs,
Serializable {
    private static final long serialVersionUID = -1514452524339132128L;
    private static final MimetypesFileTypeMap mimeMap;
    private IRI nanopubUri;
    private IRI headUri;
    private IRI assertionUri;
    private IRI provenanceUri;
    private IRI pubinfoUri;
    private Set<IRI> graphUris;
    private Set<Statement> head;
    private Set<Statement> assertion;
    private Set<Statement> provenance;
    private Set<Statement> pubinfo;
    private List<Statement> statements = new ArrayList<Statement>();
    private List<String> nsPrefixes = new ArrayList<String>();
    private Map<String, String> ns = new HashMap<String, String>();
    private boolean unusedPrefixesRemoved = false;
    private int tripleCount;
    private long byteCount;
    private static final String nanopubViaSPARQLQuery = "prefix np: <http://www.nanopub.org/nschema#> prefix rdfg: <http://www.w3.org/2004/03/trix/rdfg-1/> prefix this: <@> select ?G ?S ?P ?O where {   {     graph ?G { this: a np:Nanopublication }   } union {     graph ?H { this: a np:Nanopublication } .     graph ?H { { this: np:hasAssertion ?G } union { this: np:hasProvenance ?G }         union { this: np:hasPublicationInfo ?G } }   }   graph ?G { ?S ?P ?O } }";

    private static void tryToLoadParserFactory(String className) {
        try {
            RDFParserFactory pf = (RDFParserFactory)Class.forName(className).newInstance();
            RDFParserRegistry.getInstance().add(pf);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static void tryToLoadWriterFactory(String className) {
        try {
            RDFWriterFactory wf = (RDFWriterFactory)Class.forName(className).newInstance();
            RDFWriterRegistry.getInstance().add(wf);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void ensureLoaded() {
    }

    public NanopubImpl(Collection<Statement> statements, List<String> nsPrefixes, Map<String, String> ns) throws MalformedNanopubException {
        this.statements.addAll(statements);
        this.nsPrefixes.addAll(nsPrefixes);
        this.ns.putAll(ns);
        this.init();
    }

    public NanopubImpl(Collection<Statement> statements, List<Pair<String, String>> namespaces) throws MalformedNanopubException {
        this.statements.addAll(statements);
        for (Pair<String, String> p : namespaces) {
            this.nsPrefixes.add(p.getLeft());
            this.ns.put(p.getLeft(), p.getRight());
        }
        this.init();
    }

    public NanopubImpl(Collection<Statement> statements) throws MalformedNanopubException {
        this.statements.addAll(statements);
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NanopubImpl(Repository repo, IRI nanopubUri, List<String> nsPrefixes, Map<String, String> ns) throws MalformedNanopubException, RepositoryException {
        if (nsPrefixes != null) {
            this.nsPrefixes.addAll(nsPrefixes);
        }
        if (ns != null) {
            this.ns.putAll(ns);
        }
        try (RepositoryConnection connection = repo.getConnection();){
            String q = nanopubViaSPARQLQuery.replaceAll("@", nanopubUri.toString());
            TupleQuery tupleQuery = connection.prepareTupleQuery(QueryLanguage.SPARQL, q);
            try (TupleQueryResult result = tupleQuery.evaluate();){
                while (result.hasNext()) {
                    BindingSet bs = (BindingSet)result.next();
                    Resource g = (Resource)bs.getBinding("G").getValue();
                    Resource s = (Resource)bs.getBinding("S").getValue();
                    IRI p = (IRI)bs.getBinding("P").getValue();
                    Value o = bs.getBinding("O").getValue();
                    Statement st = SimpleValueFactory.getInstance().createStatement(s, p, o, g);
                    this.statements.add(st);
                }
            }
        }
        catch (MalformedQueryException ex) {
            ex.printStackTrace();
        }
        catch (QueryEvaluationException ex) {
            ex.printStackTrace();
        }
        this.init();
    }

    public NanopubImpl(Repository repo, IRI nanopubUri) throws MalformedNanopubException, RepositoryException {
        this(repo, nanopubUri, null, null);
    }

    public NanopubImpl(File file, RDFFormat format) throws MalformedNanopubException, RDF4JException, IOException {
        this.readStatements(new FileInputStream(file), format, "");
        this.init();
    }

    public NanopubImpl(File file) throws MalformedNanopubException, RDF4JException, IOException {
        RDFFormat f;
        String n = file.getName();
        Optional<RDFFormat> format = Rio.getParserFormatForMIMEType(mimeMap.getContentType(n));
        if (!format.isPresent() || !format.get().supportsContexts()) {
            format = Rio.getParserFormatForFileName(n);
        }
        if (!(f = format.get()).supportsContexts()) {
            f = RDFFormat.TRIG;
        }
        this.readStatements(new FileInputStream(file), f, "");
        this.init();
    }

    public NanopubImpl(URL url, RDFFormat format) throws MalformedNanopubException, RDF4JException, IOException {
        HttpResponse response = this.getNanopub(url);
        this.readStatements(response.getEntity().getContent(), format, "");
        this.init();
    }

    public NanopubImpl(URL url) throws MalformedNanopubException, RDF4JException, IOException {
        RDFFormat f;
        HttpResponse response = this.getNanopub(url);
        Header contentTypeHeader = response.getFirstHeader("Content-Type");
        Optional<RDFFormat> format = null;
        if (contentTypeHeader != null) {
            format = Rio.getParserFormatForMIMEType(contentTypeHeader.getValue());
        }
        if (format == null || !format.isPresent() || !format.get().supportsContexts()) {
            format = Rio.getParserFormatForFileName(url.toString());
        }
        if (!(f = format.get()).supportsContexts()) {
            f = RDFFormat.TRIG;
        }
        this.readStatements(response.getEntity().getContent(), f, "");
        this.init();
    }

    private HttpResponse getNanopub(URL url) throws IOException {
        HttpGet get = new HttpGet(url.toString());
        get.setHeader("Accept", "application/trig; q=1, application/x-trig; q=1, text/x-nquads; q=0.1, application/trix; q=0.1");
        CloseableHttpResponse response = HttpClientBuilder.create().build().execute(get);
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode == 404 || statusCode == 410) {
            throw new FileNotFoundException(response.getStatusLine().getReasonPhrase());
        }
        if (statusCode < 200 || statusCode > 299) {
            throw new IOException("HTTP error " + statusCode + ": " + response.getStatusLine().getReasonPhrase());
        }
        return response;
    }

    public NanopubImpl(InputStream in, RDFFormat format, String baseUri) throws MalformedNanopubException, RDF4JException, IOException {
        this.readStatements(in, format, baseUri);
        this.init();
    }

    public NanopubImpl(InputStream in, RDFFormat format) throws MalformedNanopubException, RDF4JException, IOException {
        this(in, format, "");
    }

    public NanopubImpl(String utf8, RDFFormat format, String baseUri) throws MalformedNanopubException, RDF4JException {
        try {
            this.readStatements(new ByteArrayInputStream(utf8.getBytes("UTF-8")), format, baseUri);
        }
        catch (IOException ex) {
            throw new RuntimeException("Unexptected IOException", ex);
        }
        this.init();
    }

    public NanopubImpl(String utf8, RDFFormat format) throws MalformedNanopubException, RDF4JException {
        this(utf8, format, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readStatements(InputStream in, RDFFormat format, String baseUri) throws MalformedNanopubException, RDF4JException, IOException {
        try {
            RDFParser p = NanopubUtils.getParser(format);
            p.setRDFHandler(new AbstractRDFHandler(){

                @Override
                public void handleNamespace(String prefix, String uri) throws RDFHandlerException {
                    NanopubImpl.this.nsPrefixes.add(prefix);
                    NanopubImpl.this.ns.put(prefix, uri);
                }

                @Override
                public void handleStatement(Statement st) throws RDFHandlerException {
                    NanopubImpl.this.statements.add(st);
                }
            });
            p.parse(new InputStreamReader(in, Charset.forName("UTF-8")), baseUri);
        }
        finally {
            in.close();
        }
    }

    private void init() throws MalformedNanopubException {
        if (this.statements.isEmpty()) {
            throw new MalformedNanopubException("No content received for nanopub");
        }
        this.collectNanopubUri(this.statements);
        if (this.nanopubUri == null || this.headUri == null) {
            throw new MalformedNanopubException("No nanopub URI found");
        }
        this.collectGraphs(this.statements);
        this.collectStatements(this.statements);
        this.checkAssertion();
        this.checkProvenance();
        this.checkPubinfo();
    }

    private void collectNanopubUri(Collection<Statement> statements) throws MalformedNanopubException {
        for (Statement st : statements) {
            if (st.getContext() == null) {
                throw new MalformedNanopubException("Null value for context URI found.");
            }
            if (!st.getPredicate().equals(RDF.TYPE) || !st.getObject().equals(Nanopub.NANOPUB_TYPE_URI)) continue;
            if (this.nanopubUri != null) {
                throw new MalformedNanopubException("Two nanopub URIs found");
            }
            this.nanopubUri = (IRI)st.getSubject();
            this.headUri = (IRI)st.getContext();
        }
    }

    private void collectGraphs(Collection<Statement> statements) throws MalformedNanopubException {
        for (Statement st : statements) {
            if (!st.getContext().equals(this.headUri)) continue;
            Resource s = st.getSubject();
            IRI p = st.getPredicate();
            if (s.equals(this.nanopubUri) && p.equals(Nanopub.HAS_ASSERTION_URI)) {
                if (this.assertionUri != null) {
                    throw new MalformedNanopubException("Two assertion URIs found: " + this.assertionUri + " and " + st.getObject());
                }
                this.assertionUri = (IRI)st.getObject();
                continue;
            }
            if (s.equals(this.nanopubUri) && p.equals(Nanopub.HAS_PROVENANCE_URI)) {
                if (this.provenanceUri != null) {
                    throw new MalformedNanopubException("Two provenance URIs found: " + this.provenanceUri + " and " + st.getObject());
                }
                this.provenanceUri = (IRI)st.getObject();
                continue;
            }
            if (!s.equals(this.nanopubUri) || !p.equals(Nanopub.HAS_PUBINFO_URI)) continue;
            if (this.pubinfoUri != null) {
                throw new MalformedNanopubException("Two publication info URIs found: " + this.pubinfoUri + " and " + st.getObject());
            }
            this.pubinfoUri = (IRI)st.getObject();
        }
        if (this.assertionUri == null) {
            throw new MalformedNanopubException("No assertion URI found for " + this.nanopubUri);
        }
        if (this.provenanceUri == null) {
            throw new MalformedNanopubException("No provenance URI found for " + this.nanopubUri);
        }
        if (this.pubinfoUri == null) {
            throw new MalformedNanopubException("No publication info URI found for " + this.nanopubUri);
        }
        this.graphUris = new HashSet<IRI>();
        this.addGraphUri(this.headUri);
        this.addGraphUri(this.assertionUri);
        this.addGraphUri(this.provenanceUri);
        this.addGraphUri(this.pubinfoUri);
        if (this.graphUris.contains(this.nanopubUri)) {
            throw new MalformedNanopubException("Nanopub URI cannot be identical to one of the graph URIs: " + this.nanopubUri);
        }
        this.graphUris = ImmutableSet.copyOf(this.graphUris);
    }

    private void addGraphUri(IRI uri) throws MalformedNanopubException {
        if (this.graphUris.contains(uri)) {
            throw new MalformedNanopubException("Each graph needs a unique URI: " + uri);
        }
        this.graphUris.add(uri);
    }

    private void collectStatements(Collection<Statement> statements) throws MalformedNanopubException {
        this.tripleCount = 0;
        this.byteCount = 0L;
        LinkedHashSet<Statement> head = new LinkedHashSet<Statement>();
        LinkedHashSet<Statement> assertion = new LinkedHashSet<Statement>();
        LinkedHashSet<Statement> provenance = new LinkedHashSet<Statement>();
        LinkedHashSet<Statement> pubinfo = new LinkedHashSet<Statement>();
        for (Statement st : statements) {
            this.checkStatement(st);
            Resource g = st.getContext();
            if (g.equals(this.headUri)) {
                head.add(st);
            } else if (g.equals(this.assertionUri)) {
                assertion.add(st);
            } else if (g.equals(this.provenanceUri)) {
                provenance.add(st);
            } else if (g.equals(this.pubinfoUri)) {
                pubinfo.add(st);
            } else {
                throw new MalformedNanopubException("Disconnected graph: " + g);
            }
            ++this.tripleCount;
            this.byteCount += (long)st.getContext().stringValue().length();
            this.byteCount += (long)st.getSubject().stringValue().length();
            this.byteCount += (long)st.getPredicate().stringValue().length();
            this.byteCount += (long)st.getObject().stringValue().length();
            if (this.tripleCount < 0) {
                this.tripleCount = Integer.MAX_VALUE;
            }
            if (this.byteCount >= 0L) continue;
            this.byteCount = Long.MAX_VALUE;
        }
        this.head = ImmutableSet.copyOf(head);
        this.assertion = ImmutableSet.copyOf(assertion);
        this.provenance = ImmutableSet.copyOf(provenance);
        this.pubinfo = ImmutableSet.copyOf(pubinfo);
    }

    private void checkStatement(Statement st) throws MalformedNanopubException {
        String uriString = null;
        try {
            uriString = st.getContext().stringValue();
            new URI(uriString);
            uriString = st.getSubject().stringValue();
            new URI(uriString);
            uriString = st.getPredicate().stringValue();
            new URI(uriString);
            if (st.getObject() instanceof IRI) {
                uriString = st.getObject().stringValue();
                new URI(uriString);
            }
        }
        catch (URISyntaxException ex) {
            throw new MalformedNanopubException("Malformed URI: " + uriString);
        }
    }

    private void checkAssertion() throws MalformedNanopubException {
        if (this.assertion.isEmpty()) {
            throw new MalformedNanopubException("Empty assertion graph: " + this.assertionUri);
        }
    }

    private void checkProvenance() throws MalformedNanopubException {
        if (this.provenance.isEmpty()) {
            throw new MalformedNanopubException("Empty provenance graph: " + this.provenanceUri);
        }
        for (Statement st : this.provenance) {
            if (this.assertionUri.equals(st.getSubject())) {
                return;
            }
            if (!this.assertionUri.equals(st.getObject())) continue;
            return;
        }
        throw new MalformedNanopubException("Provenance does not refer to assertion: " + this.provenanceUri);
    }

    private void checkPubinfo() throws MalformedNanopubException {
        if (this.pubinfo.isEmpty()) {
            throw new MalformedNanopubException("Empty publication info graph: " + this.pubinfoUri);
        }
        for (Statement st : this.pubinfo) {
            if (this.nanopubUri.equals(st.getSubject())) {
                return;
            }
            if (!this.nanopubUri.equals(st.getObject())) continue;
            return;
        }
        throw new MalformedNanopubException("Publication info does not refer to nanopublication URI: " + this.pubinfoUri);
    }

    @Override
    public IRI getUri() {
        return this.nanopubUri;
    }

    @Override
    public IRI getHeadUri() {
        return this.headUri;
    }

    @Override
    public Set<Statement> getHead() {
        return this.head;
    }

    @Override
    public IRI getAssertionUri() {
        return this.assertionUri;
    }

    @Override
    public Set<Statement> getAssertion() {
        return this.assertion;
    }

    @Override
    public IRI getProvenanceUri() {
        return this.provenanceUri;
    }

    @Override
    public Set<Statement> getProvenance() {
        return this.provenance;
    }

    @Override
    public IRI getPubinfoUri() {
        return this.pubinfoUri;
    }

    @Override
    public Set<Statement> getPubinfo() {
        return this.pubinfo;
    }

    @Override
    public Set<IRI> getGraphUris() {
        return this.graphUris;
    }

    @Override
    public Calendar getCreationTime() {
        return SimpleTimestampPattern.getCreationTime(this);
    }

    @Override
    public Set<IRI> getAuthors() {
        return SimpleCreatorPattern.getAuthors(this);
    }

    @Override
    public Set<IRI> getCreators() {
        return SimpleCreatorPattern.getCreators(this);
    }

    @Override
    public List<String> getNsPrefixes() {
        return new ArrayList<String>(this.nsPrefixes);
    }

    @Override
    public String getNamespace(String prefix) {
        return this.ns.get(prefix);
    }

    @Override
    public void removeUnusedPrefixes() {
        if (this.unusedPrefixesRemoved) {
            return;
        }
        Set<String> usedPrefixes = NanopubUtils.getUsedPrefixes(this);
        for (String prefix : new ArrayList<String>(this.nsPrefixes)) {
            if (usedPrefixes.contains(prefix)) continue;
            this.nsPrefixes.remove(prefix);
            this.ns.remove(prefix);
        }
        this.unusedPrefixesRemoved = true;
    }

    @Override
    public int getTripleCount() {
        return this.tripleCount;
    }

    @Override
    public long getByteCount() {
        return this.byteCount;
    }

    static {
        NanopubImpl.tryToLoadParserFactory("org.eclipse.rdf4j.rio.trig.TriGParserFactory");
        RDFWriterRegistry.getInstance().add(new CustomTrigWriterFactory());
        NanopubImpl.tryToLoadParserFactory("org.eclipse.rdf4j.rio.nquads.NQuadsParserFactory");
        NanopubImpl.tryToLoadWriterFactory("org.eclipse.rdf4j.rio.nquads.NQuadsWriterFactory");
        NanopubImpl.tryToLoadParserFactory("org.eclipse.rdf4j.rio.trix.TriXParserFactory");
        NanopubImpl.tryToLoadWriterFactory("org.eclipse.rdf4j.rio.trix.TriXWriterFactory");
        NanopubImpl.tryToLoadParserFactory("org.eclipse.rdf4j.rio.jsonld.JSONLDParserFactory");
        NanopubImpl.tryToLoadWriterFactory("org.eclipse.rdf4j.rio.jsonld.JSONLDWriterFactory");
        mimeMap = new MimetypesFileTypeMap();
    }
}

