/*
 * Decompiled with CFR 0.152.
 */
package org.nanopub;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.helpers.AbstractRDFHandler;
import org.nanopub.MalformedNanopubException;
import org.nanopub.Nanopub;
import org.nanopub.NanopubImpl;

public class NanopubRdfHandler
extends AbstractRDFHandler {
    private List<Statement> statements = new ArrayList<Statement>();
    private List<String> nsPrefixes = new ArrayList<String>();
    private Map<String, String> ns = new HashMap<String, String>();
    private boolean finished = false;

    @Override
    public void endRDF() throws RDFHandlerException {
        this.finished = true;
    }

    @Override
    public void handleNamespace(String prefix, String uri) throws RDFHandlerException {
        this.nsPrefixes.add(prefix);
        this.ns.put(prefix, uri);
    }

    @Override
    public void handleStatement(Statement st) throws RDFHandlerException {
        this.statements.add(st);
    }

    public Nanopub getNanopub() throws MalformedNanopubException {
        if (!this.finished) {
            throw new RuntimeException("No complete RDF document received");
        }
        return new NanopubImpl(this.statements, this.nsPrefixes, this.ns);
    }
}

