/*
 * Decompiled with CFR 0.152.
 */
package org.nanopub.extra.index;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.vocabulary.DC;
import org.eclipse.rdf4j.model.vocabulary.DCTERMS;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.nanopub.MalformedNanopubException;
import org.nanopub.Nanopub;
import org.nanopub.NanopubWithNs;
import org.nanopub.extra.index.IndexUtils;
import org.nanopub.extra.index.NanopubIndex;

public class NanopubIndexImpl
implements NanopubIndex,
NanopubWithNs {
    private final Nanopub np;
    private final Set<IRI> elementSet;
    private final Set<IRI> subIndexSet;
    private final IRI appendedIndex;
    private boolean isIncompleteIndex = false;

    protected NanopubIndexImpl(Nanopub npIndex) throws MalformedNanopubException {
        this.np = npIndex;
        if (!IndexUtils.isIndex(this.np)) {
            throw new MalformedNanopubException("Nanopub is not a nanopub index");
        }
        IRI appendedIndex = null;
        HashSet<IRI> elementSet = new HashSet<IRI>();
        HashSet<IRI> subIndexSet = new HashSet<IRI>();
        for (Statement st : this.np.getAssertion()) {
            if (!st.getSubject().equals(this.np.getUri())) continue;
            if (st.getPredicate().equals(NanopubIndex.APPENDS_INDEX_URI)) {
                if (appendedIndex != null) {
                    throw new MalformedNanopubException("Multiple appends-statements found for index");
                }
                if (!(st.getObject() instanceof IRI)) {
                    throw new MalformedNanopubException("URI expected for object of appends-statement");
                }
                appendedIndex = (IRI)st.getObject();
                continue;
            }
            if (st.getPredicate().equals(NanopubIndex.INCLUDES_ELEMENT_URI)) {
                if (!(st.getObject() instanceof IRI)) {
                    throw new MalformedNanopubException("Element has to be a URI");
                }
                elementSet.add((IRI)st.getObject());
                continue;
            }
            if (!st.getPredicate().equals(NanopubIndex.INCLUDES_SUBINDEX_URI)) continue;
            if (!(st.getObject() instanceof IRI)) {
                throw new MalformedNanopubException("Sub-index has to be a URI");
            }
            subIndexSet.add((IRI)st.getObject());
        }
        for (Statement st : this.np.getPubinfo()) {
            if (!st.getSubject().equals(this.np.getUri()) || !st.getPredicate().equals(RDF.TYPE) || !st.getObject().equals(NanopubIndex.INCOMPLETE_INDEX_URI)) continue;
            this.isIncompleteIndex = true;
        }
        this.appendedIndex = appendedIndex;
        if (elementSet.size() + subIndexSet.size() > 1000) {
            throw new MalformedNanopubException("Nanopub index exceeds maximum size");
        }
        this.elementSet = ImmutableSet.copyOf(elementSet);
        this.subIndexSet = ImmutableSet.copyOf(subIndexSet);
    }

    @Override
    public IRI getUri() {
        return this.np.getUri();
    }

    @Override
    public IRI getHeadUri() {
        return this.np.getHeadUri();
    }

    @Override
    public Set<Statement> getHead() {
        return this.np.getHead();
    }

    @Override
    public IRI getAssertionUri() {
        return this.np.getAssertionUri();
    }

    @Override
    public Set<Statement> getAssertion() {
        return this.np.getAssertion();
    }

    @Override
    public IRI getProvenanceUri() {
        return this.np.getProvenanceUri();
    }

    @Override
    public Set<Statement> getProvenance() {
        return this.np.getProvenance();
    }

    @Override
    public IRI getPubinfoUri() {
        return this.np.getPubinfoUri();
    }

    @Override
    public Set<Statement> getPubinfo() {
        return this.np.getPubinfo();
    }

    @Override
    public Set<IRI> getGraphUris() {
        return this.np.getGraphUris();
    }

    @Override
    public Calendar getCreationTime() {
        return this.np.getCreationTime();
    }

    @Override
    public Set<IRI> getAuthors() {
        return this.np.getAuthors();
    }

    @Override
    public Set<IRI> getCreators() {
        return this.np.getCreators();
    }

    @Override
    public int getTripleCount() {
        return this.np.getTripleCount();
    }

    @Override
    public long getByteCount() {
        return this.np.getByteCount();
    }

    @Override
    public Set<IRI> getElements() {
        return this.elementSet;
    }

    @Override
    public Set<IRI> getSubIndexes() {
        return this.subIndexSet;
    }

    @Override
    public IRI getAppendedIndex() {
        return this.appendedIndex;
    }

    @Override
    public boolean isIncomplete() {
        return this.isIncompleteIndex;
    }

    @Override
    public List<String> getNsPrefixes() {
        if (this.np instanceof NanopubWithNs) {
            return ((NanopubWithNs)this.np).getNsPrefixes();
        }
        return ImmutableList.of();
    }

    @Override
    public String getNamespace(String prefix) {
        if (this.np instanceof NanopubWithNs) {
            return ((NanopubWithNs)this.np).getNamespace(prefix);
        }
        return null;
    }

    @Override
    public String getName() {
        for (Statement st : this.np.getPubinfo()) {
            if (!st.getSubject().equals(this.np.getUri()) || !st.getPredicate().equals(DC.TITLE) || st.getPredicate().equals(DCTERMS.TITLE) || !(st.getObject() instanceof Literal)) continue;
            return ((Literal)st.getObject()).getLabel();
        }
        return null;
    }

    @Override
    public String getDescription() {
        for (Statement st : this.np.getPubinfo()) {
            if (!st.getSubject().equals(this.np.getUri()) || !st.getPredicate().equals(DC.DESCRIPTION) || st.getPredicate().equals(DCTERMS.DESCRIPTION) || !(st.getObject() instanceof Literal)) continue;
            return ((Literal)st.getObject()).getLabel();
        }
        return null;
    }

    @Override
    public Set<IRI> getSeeAlsoUris() {
        HashSet<IRI> seeAlsoUris = new HashSet<IRI>();
        for (Statement st : this.getPubinfo()) {
            if (!st.getSubject().equals(this.getUri()) || !st.getPredicate().equals(RDFS.SEEALSO) || !(st.getObject() instanceof IRI)) continue;
            seeAlsoUris.add((IRI)st.getObject());
        }
        return seeAlsoUris;
    }

    @Override
    public void removeUnusedPrefixes() {
        if (this.np instanceof NanopubWithNs) {
            ((NanopubWithNs)this.np).removeUnusedPrefixes();
        }
    }
}

