/*
 * Decompiled with CFR 0.152.
 */
package org.nanopub.extra.security;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import javax.xml.bind.DatatypeConverter;
import net.trustyuri.TrustyUriException;
import net.trustyuri.TrustyUriResource;
import org.apache.commons.io.IOUtils;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.Rio;
import org.nanopub.MalformedNanopubException;
import org.nanopub.MultiNanopubRdfHandler;
import org.nanopub.Nanopub;
import org.nanopub.NanopubImpl;
import org.nanopub.NanopubUtils;
import org.nanopub.NanopubWithNs;
import org.nanopub.extra.security.SignatureAlgorithm;
import org.nanopub.extra.security.SignatureUtils;

public class SignNanopub {
    @Parameter(description="input-nanopub-files", required=true)
    private List<File> inputNanopubFiles = new ArrayList<File>();
    @Parameter(names={"-o"}, description="Output file")
    private File singleOutputFile;
    @Parameter(names={"-k"}, description="Path and file name of key files")
    private String keyFilename;
    @Parameter(names={"-a"}, description="Signature algorithm: either RSA or DSA")
    private SignatureAlgorithm algorithm;
    @Parameter(names={"-v"}, description="Verbose")
    private boolean verbose = false;
    private KeyPair key;

    public static void main(String[] args) throws IOException {
        NanopubImpl.ensureLoaded();
        SignNanopub obj = new SignNanopub();
        JCommander jc = new JCommander(obj);
        try {
            jc.parse(args);
        }
        catch (ParameterException ex) {
            jc.usage();
            System.exit(1);
        }
        try {
            obj.run();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }

    private SignNanopub() {
    }

    private void run() throws Exception {
        if (this.algorithm == null) {
            if (this.keyFilename == null) {
                this.keyFilename = "~/.nanopub/id_rsa";
                this.algorithm = SignatureAlgorithm.RSA;
            } else {
                this.algorithm = this.keyFilename.endsWith("_rsa") ? SignatureAlgorithm.RSA : (this.keyFilename.endsWith("_dsa") ? SignatureAlgorithm.DSA : SignatureAlgorithm.RSA);
            }
        } else if (this.keyFilename == null) {
            this.keyFilename = "~/.nanopub/id_" + this.algorithm.name().toLowerCase();
        }
        this.key = SignNanopub.loadKey(this.keyFilename, this.algorithm);
        OutputStream singleOut = this.singleOutputFile != null ? (this.singleOutputFile.getName().matches(".*\\.(gz|gzip)") ? new GZIPOutputStream(new FileOutputStream(this.singleOutputFile)) : new FileOutputStream(this.singleOutputFile)) : null;
        for (File inputFile : this.inputNanopubFiles) {
            OutputStream out;
            File outputFile;
            if (this.singleOutputFile == null) {
                outputFile = new File(inputFile.getParent(), "signed." + inputFile.getName());
                out = inputFile.getName().matches(".*\\.(gz|gzip)") ? new GZIPOutputStream(new FileOutputStream(outputFile)) : new FileOutputStream(outputFile);
            } else {
                outputFile = this.singleOutputFile;
                out = singleOut;
            }
            RDFFormat inFormat = new TrustyUriResource(inputFile).getFormat(RDFFormat.TRIG);
            final RDFFormat outFormat = new TrustyUriResource(outputFile).getFormat(RDFFormat.TRIG);
            MultiNanopubRdfHandler.process(inFormat, inputFile, new MultiNanopubRdfHandler.NanopubHandler(){

                @Override
                public void handleNanopub(Nanopub np) {
                    try {
                        np = SignNanopub.writeAsSignedTrustyNanopub(np, outFormat, SignNanopub.this.algorithm, SignNanopub.this.key, out);
                        if (SignNanopub.this.verbose) {
                            System.out.println("Nanopub URI: " + np.getUri());
                        }
                    }
                    catch (RDFHandlerException ex) {
                        ex.printStackTrace();
                        throw new RuntimeException(ex);
                    }
                    catch (TrustyUriException ex) {
                        ex.printStackTrace();
                        throw new RuntimeException(ex);
                    }
                    catch (InvalidKeyException ex) {
                        ex.printStackTrace();
                        throw new RuntimeException(ex);
                    }
                    catch (SignatureException ex) {
                        ex.printStackTrace();
                        throw new RuntimeException(ex);
                    }
                }
            });
            out.close();
        }
    }

    public static Nanopub signAndTransform(Nanopub nanopub, SignatureAlgorithm algorithm, KeyPair key) throws TrustyUriException, InvalidKeyException, SignatureException {
        return SignNanopub.signAndTransform(nanopub, algorithm, key, null);
    }

    public static Nanopub signAndTransform(Nanopub nanopub, SignatureAlgorithm algorithm, KeyPair key, IRI signer) throws TrustyUriException, InvalidKeyException, SignatureException {
        if (SignatureUtils.seemsToHaveSignature(nanopub)) {
            throw new SignatureException("Seems to have signature before signing: " + nanopub.getUri());
        }
        if (nanopub instanceof NanopubWithNs) {
            ((NanopubWithNs)nanopub).removeUnusedPrefixes();
        }
        try {
            return SignatureUtils.createSignedNanopub(nanopub, algorithm, key, signer);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }

    public static void signAndTransformMultiNanopub(RDFFormat format, File file, SignatureAlgorithm algorithm, KeyPair key, OutputStream out) throws IOException, RDFParseException, RDFHandlerException, MalformedNanopubException {
        FileInputStream in = new FileInputStream(file);
        SignNanopub.signAndTransformMultiNanopub(format, in, algorithm, key, out);
    }

    public static void signAndTransformMultiNanopub(final RDFFormat format, InputStream in, final SignatureAlgorithm algorithm, final KeyPair key, final OutputStream out) throws IOException, RDFParseException, RDFHandlerException, MalformedNanopubException {
        MultiNanopubRdfHandler.process(format, in, new MultiNanopubRdfHandler.NanopubHandler(){

            @Override
            public void handleNanopub(Nanopub np) {
                try {
                    SignNanopub.writeAsSignedTrustyNanopub(np, format, algorithm, key, out);
                }
                catch (RDFHandlerException ex) {
                    ex.printStackTrace();
                    throw new RuntimeException(ex);
                }
                catch (TrustyUriException ex) {
                    ex.printStackTrace();
                    throw new RuntimeException(ex);
                }
                catch (InvalidKeyException ex) {
                    ex.printStackTrace();
                    throw new RuntimeException(ex);
                }
                catch (SignatureException ex) {
                    ex.printStackTrace();
                    throw new RuntimeException(ex);
                }
            }
        });
        out.close();
    }

    public static Nanopub writeAsSignedTrustyNanopub(Nanopub np, RDFFormat format, SignatureAlgorithm algorithm, KeyPair key, OutputStream out) throws RDFHandlerException, TrustyUriException, InvalidKeyException, SignatureException {
        np = SignNanopub.signAndTransform(np, algorithm, key);
        RDFWriter w = Rio.createWriter(format, new OutputStreamWriter(out, Charset.forName("UTF-8")));
        NanopubUtils.propagateToHandler(np, w);
        return np;
    }

    public static KeyPair loadKey(String keyFilename, SignatureAlgorithm algorithm) throws NoSuchAlgorithmException, IOException, InvalidKeySpecException {
        keyFilename = SignatureUtils.getFullFilePath(keyFilename);
        KeyFactory kf = KeyFactory.getInstance(algorithm.name());
        byte[] privateKeyBytes = DatatypeConverter.parseBase64Binary(IOUtils.toString((InputStream)new FileInputStream(keyFilename), "UTF-8"));
        PKCS8EncodedKeySpec privateSpec = new PKCS8EncodedKeySpec(privateKeyBytes);
        PrivateKey privateKey = kf.generatePrivate(privateSpec);
        byte[] publicKeyBytes = DatatypeConverter.parseBase64Binary(IOUtils.toString((InputStream)new FileInputStream(keyFilename + ".pub"), "UTF-8"));
        X509EncodedKeySpec publicSpec = new X509EncodedKeySpec(publicKeyBytes);
        PublicKey publicKey = kf.generatePublic(publicSpec);
        return new KeyPair(publicKey, privateKey);
    }
}

