/*
 * Decompiled with CFR 0.152.
 */
package org.nanopub.extra.server;

import java.io.OutputStream;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.nanopub.MalformedNanopubException;
import org.nanopub.Nanopub;
import org.nanopub.NanopubUtils;
import org.nanopub.extra.index.IndexUtils;
import org.nanopub.extra.index.NanopubIndex;
import org.nanopub.extra.server.FetchIndex;
import org.nanopub.extra.server.GetNanopub;
import org.nanopub.extra.server.NanopubDb;

public class FetchIndexFromDb
extends FetchIndex {
    public static final int maxParallelRequestsPerServer = 5;
    private String indexUri;
    private NanopubDb db;
    private OutputStream out;
    private RDFFormat format;
    private boolean writeIndex;
    private boolean writeContent;
    private int nanopubCount;
    private FetchIndex.Listener listener;

    public FetchIndexFromDb(String indexUri, NanopubDb db, OutputStream out, RDFFormat format, boolean writeIndex, boolean writeContent) {
        this.indexUri = indexUri;
        this.db = db;
        this.out = out;
        this.format = format;
        this.writeIndex = writeIndex;
        this.writeContent = writeContent;
        this.nanopubCount = 0;
    }

    @Override
    public void run() {
        try {
            this.getIndex(this.indexUri);
        }
        catch (RDFHandlerException | MalformedNanopubException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void getIndex(String indexUri) throws RDFHandlerException, MalformedNanopubException {
        NanopubIndex npi = FetchIndexFromDb.getIndex(indexUri, this.db);
        while (npi != null) {
            if (this.writeIndex) {
                this.writeNanopub(npi);
            }
            if (this.writeContent) {
                for (IRI elementUri : npi.getElements()) {
                    this.writeNanopub(GetNanopub.get(elementUri.toString(), this.db));
                }
            }
            for (IRI subIndexUri : npi.getSubIndexes()) {
                this.getIndex(subIndexUri.toString());
            }
            if (npi.getAppendedIndex() != null) {
                npi = FetchIndexFromDb.getIndex(npi.getAppendedIndex().toString(), this.db);
                continue;
            }
            npi = null;
        }
    }

    private static NanopubIndex getIndex(String indexUri, NanopubDb db) throws MalformedNanopubException {
        Nanopub np = GetNanopub.get(indexUri, db);
        if (!IndexUtils.isIndex(np)) {
            throw new RuntimeException("NOT AN INDEX: " + np.getUri());
        }
        return IndexUtils.castToIndex(np);
    }

    private void writeNanopub(Nanopub np) throws RDFHandlerException {
        ++this.nanopubCount;
        if (this.listener != null && this.nanopubCount % 100 == 0) {
            this.listener.progress(this.nanopubCount);
        }
        NanopubUtils.writeToStream(np, this.out, this.format);
    }

    @Override
    public int getNanopubCount() {
        return this.nanopubCount;
    }

    @Override
    public void setProgressListener(FetchIndex.Listener l) {
        this.listener = l;
    }
}

