/*
 * Decompiled with CFR 0.152.
 */
package org.nanopub.extra.server;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import net.trustyuri.TrustyUriUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.eclipse.rdf4j.RDF4JException;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.Rio;
import org.nanopub.MalformedNanopubException;
import org.nanopub.Nanopub;
import org.nanopub.NanopubImpl;
import org.nanopub.NanopubUtils;
import org.nanopub.extra.server.FetchIndex;
import org.nanopub.extra.server.FetchIndexFromDb;
import org.nanopub.extra.server.NanopubDb;
import org.nanopub.extra.server.ServerInfo;
import org.nanopub.extra.server.ServerIterator;
import org.nanopub.extra.server.UnreliableInputStream;
import org.nanopub.trusty.TrustyNanopubUtils;

public class GetNanopub {
    @Parameter(description="nanopub-uris-or-artifact-codes", required=true)
    private List<String> nanopubIds;
    @Parameter(names={"-f"}, description="Format of the nanopub: trig, nq, trix, trig.gz, ...")
    private String format;
    @Parameter(names={"-o"}, description="Output file")
    private File outputFile;
    @Parameter(names={"-e"}, description="Write error messages from fetching nanopubs into this file (ignored otherwise)")
    private File errorFile;
    @Parameter(names={"-i"}, description="Retrieve the index for the given index nanopub")
    private boolean getIndex;
    @Parameter(names={"-c"}, description="Retrieve the content of the given index")
    private boolean getIndexContent;
    @Parameter(names={"--mongodb-host"}, description="Directly contact single MongoDB instance instead of the network (e.g. 'localhost')")
    private String mongoDbHost;
    @Parameter(names={"--mongodb-port"}, description="MongoDB port")
    private int mongoDbPort = 27017;
    @Parameter(names={"--mongodb-dbname"}, description="MongoDB database name")
    private String mongoDbName = "nanopub-server";
    @Parameter(names={"--mongodb-user"}, description="MongoDB user name")
    private String mongoDbUsername;
    @Parameter(names={"--mongodb-pw"}, description="MongoDB password")
    private String mongoDbPassword;
    @Parameter(names={"-r"}, description="Show a report in the end")
    private boolean showReport;
    @Parameter(names={"-l"}, description="Use a local server, e.g. http://localhost:7880/")
    private String localServer;
    @Parameter(names={"--simulate-unreliable-connection"}, description="Simulate an unreliable connection for testing purposes")
    private boolean simUnrelConn;
    private static boolean simulateUnreliableConnection = false;
    private OutputStream outputStream = System.out;
    private PrintStream errorStream = null;
    private int count;
    private List<Exception> exceptions;
    private NanopubDb db = null;
    private RDFFormat rdfFormat;

    public static void main(String[] args) {
        NanopubImpl.ensureLoaded();
        GetNanopub obj = new GetNanopub();
        JCommander jc = new JCommander(obj);
        try {
            jc.parse(args);
        }
        catch (ParameterException ex) {
            jc.usage();
            System.exit(1);
        }
        simulateUnreliableConnection = obj.simUnrelConn;
        try {
            obj.run();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }

    public static Nanopub get(String uriOrArtifactCode) {
        ServerIterator serverIterator = new ServerIterator();
        String ac = GetNanopub.getArtifactCode(uriOrArtifactCode);
        if (!ac.startsWith("RA")) {
            throw new IllegalArgumentException("Not a trusty URI of type RA");
        }
        while (serverIterator.hasNext()) {
            ServerInfo serverInfo = serverIterator.next();
            try {
                Nanopub np = GetNanopub.get(ac, serverInfo);
                if (np == null) continue;
                return np;
            }
            catch (IOException iOException) {
            }
            catch (RDF4JException rDF4JException) {
            }
            catch (MalformedNanopubException malformedNanopubException) {
            }
        }
        return null;
    }

    public static Nanopub get(String uriOrArtifactCode, NanopubDb db) {
        String ac = GetNanopub.getArtifactCode(uriOrArtifactCode);
        if (!ac.startsWith("RA")) {
            throw new IllegalArgumentException("Not a trusty URI of type RA");
        }
        return db.getNanopub(ac);
    }

    public static Nanopub get(String artifactCode, ServerInfo serverInfo) throws IOException, RDF4JException, MalformedNanopubException {
        return GetNanopub.get(artifactCode, serverInfo.getPublicUrl());
    }

    public static Nanopub get(String artifactCode, String serverUrl) throws IOException, RDF4JException, MalformedNanopubException {
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(1000).setConnectionRequestTimeout(100).setSocketTimeout(1000).build();
        CloseableHttpClient c = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).build();
        return GetNanopub.get(artifactCode, serverUrl, c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Nanopub get(String artifactCode, String serverUrl, HttpClient httpClient) throws IOException, RDF4JException, MalformedNanopubException {
        HttpGet get = new HttpGet(serverUrl + artifactCode);
        get.setHeader("Accept", "application/trig");
        try (InputStream in = null;){
            NanopubImpl nanopub;
            HttpResponse resp = httpClient.execute(get);
            if (!GetNanopub.wasSuccessful(resp)) {
                EntityUtils.consumeQuietly(resp.getEntity());
                throw new IOException(resp.getStatusLine().toString());
            }
            in = resp.getEntity().getContent();
            if (simulateUnreliableConnection) {
                in = new UnreliableInputStream(in);
            }
            if (!TrustyNanopubUtils.isValidTrustyNanopub(nanopub = new NanopubImpl(in, RDFFormat.TRIG))) {
                throw new MalformedNanopubException("Nanopub is not trusty");
            }
            NanopubImpl nanopubImpl = nanopub;
            return nanopubImpl;
        }
    }

    public static String getArtifactCode(String uriOrArtifactCode) {
        if (uriOrArtifactCode.indexOf(":") > 0) {
            IRI uri = SimpleValueFactory.getInstance().createIRI(uriOrArtifactCode);
            if (!TrustyUriUtils.isPotentialTrustyUri(uri)) {
                throw new IllegalArgumentException("Not a well-formed trusty URI");
            }
            return TrustyUriUtils.getArtifactCode(uri.toString());
        }
        if (!TrustyUriUtils.isPotentialArtifactCode(uriOrArtifactCode)) {
            throw new IllegalArgumentException("Not a well-formed artifact code");
        }
        return uriOrArtifactCode;
    }

    private void run() throws IOException, RDFHandlerException, MalformedNanopubException {
        if (this.showReport) {
            this.exceptions = new ArrayList<Exception>();
        }
        if (this.outputFile == null) {
            if (this.format == null) {
                this.format = "trig";
            }
            this.rdfFormat = Rio.getParserFormatForFileName("file." + this.format).orElse(RDFFormat.TRIG);
        } else {
            this.rdfFormat = Rio.getParserFormatForFileName(this.outputFile.getName()).orElse(RDFFormat.TRIG);
            this.outputStream = this.outputFile.getName().endsWith(".gz") ? new GZIPOutputStream(new FileOutputStream(this.outputFile)) : new FileOutputStream(this.outputFile);
        }
        if (this.errorFile != null) {
            this.errorStream = new PrintStream(this.errorFile);
        }
        if (this.mongoDbHost != null) {
            this.db = new NanopubDb(this.mongoDbHost, this.mongoDbPort, this.mongoDbName, this.mongoDbUsername, this.mongoDbPassword);
        }
        FetchIndex fetchIndex = null;
        for (String nanopubId : this.nanopubIds) {
            if (this.getIndex || this.getIndexContent) {
                fetchIndex = this.db == null ? new FetchIndex(nanopubId, this.outputStream, this.rdfFormat, this.getIndex, this.getIndexContent, this.localServer) : new FetchIndexFromDb(nanopubId, this.db, this.outputStream, this.rdfFormat, this.getIndex, this.getIndexContent);
                fetchIndex.setProgressListener(new FetchIndex.Listener(){

                    @Override
                    public void progress(int count) {
                        System.err.print(count + " nanopubs...\r");
                    }

                    @Override
                    public void exceptionHappened(Exception ex, String serverUrl, String artifactCode) {
                        if (GetNanopub.this.showReport) {
                            GetNanopub.this.exceptions.add(ex);
                        }
                        if (GetNanopub.this.errorStream != null) {
                            String exString = ex.toString().replaceAll("\\n", "\\\\n");
                            GetNanopub.this.errorStream.println(serverUrl + " " + artifactCode + " " + exString);
                        }
                    }
                });
                fetchIndex.run();
                this.count = fetchIndex.getNanopubCount();
                continue;
            }
            Nanopub np = this.db == null ? GetNanopub.get(nanopubId) : GetNanopub.get(nanopubId, this.db);
            this.outputNanopub(nanopubId, np);
        }
        if (this.outputStream != System.out) {
            this.outputStream.close();
            System.err.println(this.count + " nanopubs retrieved and saved in " + this.outputFile);
        }
        if (this.errorStream != null) {
            this.errorStream.close();
        }
        if (this.showReport && fetchIndex != null) {
            System.err.println("Number of retries: " + this.exceptions.size());
            System.err.println("Used servers:");
            List<ServerInfo> usedServers = fetchIndex.getServers();
            final FetchIndex fi = fetchIndex;
            Collections.sort(usedServers, new Comparator<ServerInfo>(){

                @Override
                public int compare(ServerInfo o1, ServerInfo o2) {
                    return fi.getServerUsage(o2) - fi.getServerUsage(o1);
                }
            });
            int usedServerCount = 0;
            for (ServerInfo si : usedServers) {
                if (fetchIndex.getServerUsage(si) > 0) {
                    ++usedServerCount;
                }
                System.err.format("%8d %s%n", fetchIndex.getServerUsage(si), si.getPublicUrl());
            }
            System.err.format("Number of servers used: " + usedServerCount, new Object[0]);
        }
    }

    private void outputNanopub(String nanopubId, Nanopub np) throws IOException, RDFHandlerException {
        if (np == null) {
            System.err.println("NOT FOUND: " + nanopubId);
            return;
        }
        ++this.count;
        if (this.outputStream == System.out) {
            NanopubUtils.writeToStream(np, System.out, this.rdfFormat);
            System.out.print("\n\n");
        } else {
            NanopubUtils.writeToStream(np, this.outputStream, this.rdfFormat);
            if (this.count % 100 == 0) {
                System.err.print(this.count + " nanopubs...\r");
            }
        }
    }

    private static boolean wasSuccessful(HttpResponse resp) {
        int c = resp.getStatusLine().getStatusCode();
        return c >= 200 && c < 300;
    }
}

