/*
 * Decompiled with CFR 0.152.
 */
package org.nanopub.extra.server;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoCredential;
import com.mongodb.MongoException;
import com.mongodb.ServerAddress;
import java.util.ArrayList;
import org.eclipse.rdf4j.RDF4JException;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.nanopub.MalformedNanopubException;
import org.nanopub.Nanopub;
import org.nanopub.NanopubImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NanopubDb {
    private static RDFFormat internalFormat = RDFFormat.TRIG;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private MongoClient mongo;
    private DB db;
    private static DBObject pingCommand = new BasicDBObject("ping", "1");

    public NanopubDb(String mongoDbHost, int mongoDbPort, String mongoDbName, String mongoDbUsername, String mongoDbPw) {
        this.logger.info("Initialize new DB object");
        ServerAddress serverAddress = new ServerAddress(mongoDbHost, mongoDbPort);
        ArrayList<MongoCredential> credentials = new ArrayList<MongoCredential>();
        if (mongoDbUsername != null) {
            credentials.add(MongoCredential.createMongoCRCredential(mongoDbUsername, mongoDbName, mongoDbPw.toCharArray()));
        }
        this.mongo = new MongoClient(serverAddress, credentials);
        this.db = this.mongo.getDB(mongoDbName);
    }

    public MongoClient getMongoClient() {
        return this.mongo;
    }

    public boolean isAccessible() {
        try {
            this.db.command(pingCommand);
        }
        catch (MongoException ex) {
            return false;
        }
        return true;
    }

    private DBCollection getNanopubCollection() {
        return this.db.getCollection("nanopubs");
    }

    public Nanopub getNanopub(String artifactCode) {
        BasicDBObject query = new BasicDBObject("_id", artifactCode);
        DBCursor cursor = this.getNanopubCollection().find(query);
        if (!cursor.hasNext()) {
            return null;
        }
        String nanopubString = cursor.next().get("nanopub").toString();
        NanopubImpl np = null;
        try {
            np = new NanopubImpl(nanopubString, internalFormat);
        }
        catch (MalformedNanopubException ex) {
            throw new RuntimeException("Stored nanopub is not wellformed (this shouldn't happen)", ex);
        }
        catch (RDF4JException ex) {
            throw new RuntimeException("Stored nanopub is corrupted (this shouldn't happen)", ex);
        }
        return np;
    }

    public boolean hasNanopub(String artifactCode) {
        BasicDBObject query = new BasicDBObject("_id", artifactCode);
        return this.getNanopubCollection().find(query).hasNext();
    }
}

