/*
 * Decompiled with CFR 0.152.
 */
package org.nanopub.extra.server;

import net.trustyuri.TrustyUriUtils;
import org.nanopub.extra.server.ServerInfo;

public class NanopubSurfacePattern {
    private final String[] uriPattern;
    private final String[] hashPattern;

    public NanopubSurfacePattern(String uriPattern, String hashPattern) {
        this.uriPattern = uriPattern == null || uriPattern.isEmpty() ? null : uriPattern.split(" ");
        this.hashPattern = hashPattern == null || hashPattern.isEmpty() ? null : hashPattern.split(" ");
    }

    public NanopubSurfacePattern(ServerInfo serverInfo) {
        this(serverInfo.getUriPattern(), serverInfo.getHashPattern());
    }

    public boolean matchesUri(String uri) {
        if (!this.matchesHash(TrustyUriUtils.getArtifactCode(uri))) {
            return false;
        }
        if (this.uriPattern == null) {
            return true;
        }
        boolean match = false;
        for (String p : this.uriPattern) {
            if (!uri.startsWith(p)) continue;
            match = true;
            break;
        }
        return match;
    }

    public boolean matchesHash(String artifactCode) {
        if (this.hashPattern == null) {
            return true;
        }
        boolean match = false;
        String hash = TrustyUriUtils.getDataPart(artifactCode);
        for (String p : this.hashPattern) {
            if (!hash.startsWith(p)) continue;
            match = true;
            break;
        }
        return match;
    }

    public boolean overlapsWith(NanopubSurfacePattern other) {
        boolean overlapEncountered;
        if (this.uriPattern != null && other.uriPattern != null) {
            overlapEncountered = false;
            for (String p1 : this.uriPattern) {
                for (String p2 : other.uriPattern) {
                    if (!p1.startsWith(p2) && !p2.startsWith(p1)) continue;
                    overlapEncountered = true;
                    break;
                }
                if (overlapEncountered) break;
            }
            if (!overlapEncountered) {
                return false;
            }
        }
        if (this.hashPattern != null && other.hashPattern != null) {
            overlapEncountered = false;
            for (String p1 : this.hashPattern) {
                for (String p2 : other.hashPattern) {
                    if (!p1.startsWith(p2) && !p2.startsWith(p1)) continue;
                    overlapEncountered = true;
                    break;
                }
                if (overlapEncountered) break;
            }
            if (!overlapEncountered) {
                return false;
            }
        }
        return true;
    }

    public static boolean matchesUri(String uri, String uriPattern, String hashPattern) {
        return new NanopubSurfacePattern(uriPattern, hashPattern).matchesUri(uri);
    }

    public static boolean matchesUri(String uri, ServerInfo serverInfo) {
        return new NanopubSurfacePattern(serverInfo).matchesUri(uri);
    }

    public static boolean matchesHash(String artifactCode, String uriPattern, String hashPattern) {
        return new NanopubSurfacePattern(uriPattern, hashPattern).matchesHash(artifactCode);
    }

    public static boolean matchesHash(String artifactCode, ServerInfo serverInfo) {
        return new NanopubSurfacePattern(serverInfo).matchesHash(artifactCode);
    }
}

