/*
 * Decompiled with CFR 0.152.
 */
package org.nanopub.extra.server;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.trustyuri.TrustyUriUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.eclipse.rdf4j.RDF4JException;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.sparql.SPARQLRepository;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.nanopub.MalformedNanopubException;
import org.nanopub.MultiNanopubRdfHandler;
import org.nanopub.Nanopub;
import org.nanopub.NanopubImpl;
import org.nanopub.NanopubUtils;
import org.nanopub.extra.server.NanopubServerUtils;
import org.nanopub.extra.server.ServerInfo;
import org.nanopub.extra.server.ServerIterator;

public class PublishNanopub {
    @Parameter(description="nanopubs", required=true)
    private List<String> nanopubs = new ArrayList<String>();
    @Parameter(names={"-v"}, description="Verbose")
    private boolean verbose = false;
    @Parameter(names={"-u"}, description="Use the given nanopub server URLs")
    private List<String> serverUrls;
    @Parameter(names={"-s"}, description="Get nanopubs to be published from given SPARQL endpoint")
    private String sparqlEndpointUrl;
    private ServerIterator serverIterator = null;
    private ServerInfo serverInfo = null;
    private Map<String, Integer> usedServers = new HashMap<String, Integer>();
    private int count;
    private boolean failed;
    private SPARQLRepository sparqlRepo;
    private String artifactCode;

    public static void main(String[] args) {
        NanopubImpl.ensureLoaded();
        PublishNanopub obj = new PublishNanopub();
        JCommander jc = new JCommander(obj);
        try {
            jc.parse(args);
        }
        catch (ParameterException ex) {
            jc.usage();
            System.exit(1);
        }
        try {
            obj.run();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }

    public static void publish(Nanopub nanopub) throws IOException {
        new PublishNanopub().publishNanopub(nanopub);
    }

    private void run() throws IOException {
        this.failed = false;
        for (String s : this.nanopubs) {
            block13: {
                this.count = 0;
                try {
                    if (this.sparqlEndpointUrl != null) {
                        if (this.sparqlRepo == null) {
                            this.sparqlRepo = new SPARQLRepository(this.sparqlEndpointUrl);
                            this.sparqlRepo.initialize();
                        }
                        this.processNanopub(new NanopubImpl(this.sparqlRepo, SimpleValueFactory.getInstance().createIRI(s)));
                    } else {
                        if (this.verbose) {
                            System.out.println("Reading file: " + s);
                        }
                        MultiNanopubRdfHandler.process(new File(s), new MultiNanopubRdfHandler.NanopubHandler(){

                            @Override
                            public void handleNanopub(Nanopub np) {
                                if (PublishNanopub.this.failed) {
                                    return;
                                }
                                PublishNanopub.this.processNanopub(np);
                            }
                        });
                        if (this.count == 0) {
                            System.out.println("NO NANOPUB FOUND: " + s);
                        }
                    }
                    break block13;
                }
                catch (RDF4JException ex) {
                    System.out.println("RDF ERROR: " + s);
                    ex.printStackTrace(System.err);
                }
                catch (MalformedNanopubException ex) {
                    System.out.println("INVALID NANOPUB: " + s);
                    ex.printStackTrace(System.err);
                }
                break;
            }
            if (!this.failed) continue;
            System.out.println("FAILED TO PUBLISH NANOPUBS");
            break;
        }
        for (String s : this.usedServers.keySet()) {
            int c = this.usedServers.get(s);
            System.out.println(c + " nanopub" + (c == 1 ? "" : "s") + " published at " + s);
        }
        if (this.sparqlRepo != null) {
            try {
                this.sparqlRepo.shutDown();
            }
            catch (RepositoryException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void processNanopub(Nanopub nanopub) {
        ++this.count;
        if (this.count % 100 == 0) {
            System.err.print(this.count + " nanopubs...\r");
        }
        try {
            this.publishNanopub(nanopub);
        }
        catch (IOException ex) {
            if (this.verbose) {
                System.err.println(ex.getClass().getName() + ": " + ex.getMessage());
                System.err.println("---");
            }
            this.failed = true;
        }
    }

    public void publishNanopub(Nanopub nanopub) throws IOException {
        if (this.serverInfo == null) {
            this.serverIterator = this.serverUrls == null || this.serverUrls.isEmpty() ? new ServerIterator() : new ServerIterator(this.serverUrls);
            this.serverInfo = this.serverIterator.next();
        }
        this.artifactCode = TrustyUriUtils.getArtifactCode(nanopub.getUri().toString());
        if (this.verbose) {
            System.out.println("---");
            System.out.println("Trying to publish nanopub: " + this.artifactCode);
        }
        if (NanopubServerUtils.isProtectedNanopub(nanopub)) {
            throw new RuntimeException("Can't publish protected nanopublication: " + this.artifactCode);
        }
        while (this.serverInfo != null) {
            block18: {
                String serverUrl;
                block17: {
                    serverUrl = this.serverInfo.getPublicUrl();
                    try {
                        if (!ServerInfo.load(serverUrl).isPostNanopubsEnabled()) {
                            this.serverInfo = this.serverIterator.next();
                        }
                        break block17;
                    }
                    catch (ServerInfo.ServerInfoException ex) {
                        this.serverInfo = this.serverIterator.next();
                    }
                    continue;
                }
                if (!this.serverInfo.getNanopubSurfacePattern().matchesUri(nanopub.getUri().stringValue())) continue;
                if (this.verbose) {
                    System.out.println("Trying server: " + serverUrl);
                }
                try {
                    HttpPost post = new HttpPost(serverUrl);
                    String nanopubString = NanopubUtils.writeToString(nanopub, RDFFormat.TRIG);
                    post.setEntity(new StringEntity(nanopubString, "UTF-8"));
                    post.setHeader("Content-Type", RDFFormat.TRIG.getDefaultMIMEType());
                    CloseableHttpResponse response = HttpClientBuilder.create().build().execute(post);
                    int code = response.getStatusLine().getStatusCode();
                    if (code >= 200 && code < 300) {
                        if (this.usedServers.containsKey(serverUrl)) {
                            this.usedServers.put(serverUrl, this.usedServers.get(serverUrl) + 1);
                        } else {
                            this.usedServers.put(serverUrl, 1);
                        }
                        if (this.verbose) {
                            System.out.println("Published: " + this.artifactCode);
                        }
                        return;
                    }
                    if (this.verbose) {
                        System.out.println("Response: " + code + " " + response.getStatusLine().getReasonPhrase());
                    }
                }
                catch (IOException ex) {
                    if (this.verbose) {
                        System.out.println(ex.getClass().getName() + ": " + ex.getMessage());
                    }
                }
                catch (RDF4JException ex) {
                    if (!this.verbose) break block18;
                    System.out.println(ex.getClass().getName() + ": " + ex.getMessage());
                }
            }
            this.serverInfo = this.serverIterator.next();
        }
        this.serverInfo = null;
        throw new RuntimeException("Failed to publish the nanopub");
    }

    public ServerInfo getUsedServer() {
        return this.serverInfo;
    }

    public String getPublishedNanopubUrl() {
        if (this.serverInfo == null || this.artifactCode == null) {
            return null;
        }
        return this.serverInfo.getPublicUrl() + this.artifactCode;
    }
}

