/*
 * Decompiled with CFR 0.152.
 */
package org.nanopub.op;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPOutputStream;
import net.trustyuri.TrustyUriException;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.Rio;
import org.nanopub.MalformedNanopubException;
import org.nanopub.MultiNanopubRdfHandler;
import org.nanopub.Nanopub;
import org.nanopub.NanopubImpl;

public class Aggregate {
    @Parameter(description="input-nanopubs")
    private List<File> inputNanopubs = new ArrayList<File>();
    @Parameter(names={"-h"}, description="Output file for aggregation of head graph")
    private File headOutputFile;
    @Parameter(names={"-a"}, description="Output file for aggregation of assertion graph")
    private File assertionOutputFile;
    @Parameter(names={"-p"}, description="Output file for aggregation of provenance graph")
    private File provOutputFile;
    @Parameter(names={"-i"}, description="Output file for aggregation of pubinfo graph")
    private File pubinfoOutputFile;
    @Parameter(names={"--in-format"}, description="Format of the input nanopubs: trig, nq, trix, trig.gz, ...")
    private String inFormat;
    private RDFFormat rdfInFormat;
    private Map<Statement, Integer> headCounts;
    private Map<Statement, Integer> assertionCounts;
    private Map<Statement, Integer> provCounts;
    private Map<Statement, Integer> pubinfoCounts;
    private static ValueFactory vf = SimpleValueFactory.getInstance();
    private static final IRI thisNanopub = vf.createIRI("http://example.org/npop-dummy-uri/this_nanopub");
    private static final IRI thisHead = vf.createIRI("http://example.org/npop-dummy-uri/this_head");
    private static final IRI thisAssertion = vf.createIRI("http://example.org/npop-dummy-uri/this_assertion");
    private static final IRI thisProvenance = vf.createIRI("thttp://example.org/npop-dummy-uri/his_provenance");
    private static final IRI thisPubinfo = vf.createIRI("http://example.org/npop-dummy-uri/this_pubinfo");

    public static void main(String[] args) {
        NanopubImpl.ensureLoaded();
        Aggregate obj = new Aggregate();
        JCommander jc = new JCommander(obj);
        try {
            jc.parse(args);
        }
        catch (ParameterException ex) {
            jc.usage();
            System.exit(1);
        }
        obj.init();
        try {
            obj.run();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }

    public static Aggregate getInstance(String args) throws ParameterException {
        NanopubImpl.ensureLoaded();
        if (args == null) {
            args = "";
        }
        Aggregate obj = new Aggregate();
        JCommander jc = new JCommander(obj);
        jc.parse(args.trim().split(" "));
        obj.init();
        return obj;
    }

    private void init() {
    }

    public void run() throws IOException, RDFParseException, RDFHandlerException, MalformedNanopubException, TrustyUriException {
        if (this.inputNanopubs == null || this.inputNanopubs.isEmpty()) {
            throw new ParameterException("No input files given");
        }
        if (this.headOutputFile != null) {
            this.headCounts = new HashMap<Statement, Integer>();
        }
        if (this.assertionOutputFile != null) {
            this.assertionCounts = new HashMap<Statement, Integer>();
        }
        if (this.provOutputFile != null) {
            this.provCounts = new HashMap<Statement, Integer>();
        }
        if (this.pubinfoOutputFile != null) {
            this.pubinfoCounts = new HashMap<Statement, Integer>();
        }
        for (File inputFile : this.inputNanopubs) {
            this.rdfInFormat = this.inFormat != null ? (RDFFormat)Rio.getParserFormatForFileName("file." + this.inFormat).orElse(null) : (RDFFormat)Rio.getParserFormatForFileName(inputFile.toString()).orElse(null);
            MultiNanopubRdfHandler.process(this.rdfInFormat, inputFile, new MultiNanopubRdfHandler.NanopubHandler(){

                @Override
                public void handleNanopub(Nanopub np) {
                    try {
                        Aggregate.this.process(np);
                    }
                    catch (RDFHandlerException ex) {
                        throw new RuntimeException(ex);
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                }
            });
        }
        this.writeStatementCounts(this.headCounts, this.headOutputFile);
        this.writeStatementCounts(this.assertionCounts, this.assertionOutputFile);
        this.writeStatementCounts(this.provCounts, this.provOutputFile);
        this.writeStatementCounts(this.pubinfoCounts, this.pubinfoOutputFile);
    }

    public void process(Nanopub np) throws RDFHandlerException, IOException {
        this.aggregate(np.getHead(), np, this.headCounts);
        this.aggregate(np.getAssertion(), np, this.assertionCounts);
        this.aggregate(np.getProvenance(), np, this.provCounts);
        this.aggregate(np.getPubinfo(), np, this.pubinfoCounts);
    }

    private void aggregate(Set<Statement> statements, Nanopub np, Map<Statement, Integer> statementCounts) throws IOException {
        if (statementCounts == null) {
            return;
        }
        for (Statement st : statements) {
            Statement pst = this.preprocessStatement(st, np);
            if (!statementCounts.containsKey(pst)) {
                statementCounts.put(pst, 1);
                continue;
            }
            statementCounts.put(pst, statementCounts.get(pst) + 1);
        }
    }

    private Statement preprocessStatement(Statement st, Nanopub np) {
        Resource subject = st.getSubject();
        IRI predicate = st.getPredicate();
        Value object = st.getObject();
        subject = (Resource)this.preprocessValue(subject, np);
        predicate = (IRI)this.preprocessValue(predicate, np);
        object = this.preprocessValue(object, np);
        return vf.createStatement(subject, predicate, object);
    }

    private Value preprocessValue(Value v, Nanopub np) {
        if (np.getUri().equals(v)) {
            return thisNanopub;
        }
        if (np.getHeadUri().equals(v)) {
            return thisHead;
        }
        if (np.getAssertionUri().equals(v)) {
            return thisAssertion;
        }
        if (np.getProvenanceUri().equals(v)) {
            return thisProvenance;
        }
        if (np.getPubinfoUri().equals(v)) {
            return thisPubinfo;
        }
        return v;
    }

    private void writeStatementCounts(final Map<Statement, Integer> statementCounts, File outputFile) throws IOException {
        if (statementCounts == null) {
            return;
        }
        BufferedWriter w = this.makeWriter(outputFile);
        ArrayList<Statement> statementList = new ArrayList<Statement>(statementCounts.keySet());
        Collections.sort(statementList, new Comparator<Statement>(){

            @Override
            public int compare(Statement st1, Statement st2) {
                return -((Integer)statementCounts.get(st1)).compareTo((Integer)statementCounts.get(st2));
            }
        });
        for (Statement st : statementList) {
            w.write(statementCounts.get(st) + " " + st.toString().replaceAll("http://example.org/npop-dummy-uri/", "") + "\n");
        }
        w.flush();
        w.close();
    }

    private BufferedWriter makeWriter(File f) throws IOException {
        if (f == null) {
            return null;
        }
        OutputStream stream = null;
        stream = f.getName().endsWith(".gz") ? new GZIPOutputStream(new FileOutputStream(f)) : new FileOutputStream(f);
        return new BufferedWriter(new OutputStreamWriter(stream));
    }
}

