/*
 * Decompiled with CFR 0.152.
 */
package org.nanopub.op;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import net.trustyuri.TrustyUriException;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.Rio;
import org.nanopub.MalformedNanopubException;
import org.nanopub.MultiNanopubRdfHandler;
import org.nanopub.Nanopub;
import org.nanopub.NanopubImpl;

public class ExportJson {
    @Parameter(description="input-nanopubs", required=true)
    private List<File> inputNanopubs = new ArrayList<File>();
    @Parameter(names={"-o"}, description="Output file")
    private File outputFile;
    @Parameter(names={"--in-format"}, description="Format of the input nanopubs: trig, nq, trix, trig.gz, ...")
    private String inFormat;
    private RDFFormat rdfInFormat;
    private OutputStream outputStream = System.out;
    private BufferedWriter writer;
    private boolean isFirstNp;
    private boolean isFirstSt;

    public static void main(String[] args) {
        NanopubImpl.ensureLoaded();
        ExportJson obj = new ExportJson();
        JCommander jc = new JCommander(obj);
        try {
            jc.parse(args);
        }
        catch (ParameterException ex) {
            jc.usage();
            System.exit(1);
        }
        try {
            obj.run();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }

    private void run() throws IOException, RDFParseException, RDFHandlerException, MalformedNanopubException, TrustyUriException {
        for (File inputFile : this.inputNanopubs) {
            this.rdfInFormat = this.inFormat != null ? (RDFFormat)Rio.getParserFormatForFileName("file." + this.inFormat).orElse(null) : (RDFFormat)Rio.getParserFormatForFileName(inputFile.toString()).orElse(null);
            if (this.outputFile != null) {
                this.outputStream = this.outputFile.getName().endsWith(".gz") ? new GZIPOutputStream(new FileOutputStream(this.outputFile)) : new FileOutputStream(this.outputFile);
            }
            this.writer = new BufferedWriter(new OutputStreamWriter(this.outputStream));
            this.writer.write("[\n");
            this.isFirstNp = true;
            MultiNanopubRdfHandler.process(this.rdfInFormat, inputFile, new MultiNanopubRdfHandler.NanopubHandler(){

                @Override
                public void handleNanopub(Nanopub np) {
                    try {
                        ExportJson.this.process(np);
                    }
                    catch (RDFHandlerException ex) {
                        throw new RuntimeException(ex);
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                }
            });
            this.writer.write("\n]\n");
            this.writer.flush();
            if (this.outputStream == System.out) continue;
            this.writer.close();
        }
    }

    private void process(Nanopub np) throws RDFHandlerException, IOException {
        IRI npUri = np.getUri();
        if (!this.isFirstNp) {
            this.writer.write(",\n");
        }
        this.isFirstNp = false;
        this.writer.write(" [\n");
        this.isFirstSt = true;
        for (Statement st : np.getAssertion()) {
            this.writeStatement(st, "npa", np.getAssertionUri(), npUri);
        }
        for (Statement st : np.getProvenance()) {
            this.writeStatement(st, "npp", np.getProvenanceUri(), npUri);
        }
        for (Statement st : np.getPubinfo()) {
            this.writeStatement(st, "npi", np.getPubinfoUri(), npUri);
        }
        this.writer.write("\n ]");
    }

    private void writeStatement(Statement st, String type, IRI graphUri, IRI npUri) throws RDFHandlerException, IOException {
        if (!this.isFirstSt) {
            this.writer.write(",\n");
        }
        this.isFirstSt = false;
        this.writer.write("  {\n");
        this.writer.write("  \"type\": \"" + type + "\",\n");
        this.writer.write("  \"s\": \"" + this.escape(st.getSubject()) + "\",\n");
        this.writer.write("  \"p\": \"" + this.escape(st.getPredicate()) + "\",\n");
        this.writer.write("  \"o\": \"" + this.escape(st.getObject()) + "\",\n");
        if (st.getObject() instanceof Literal) {
            Literal l = (Literal)st.getObject();
            if (l.getLanguage() != null) {
                this.writer.write("  \"dt\": \"" + this.escape(l.getDatatype()) + "\",\n");
            } else {
                this.writer.write("  \"l\": \"" + l.getLanguage() + "\",\n");
            }
        }
        this.writer.write("  \"g\": \"" + graphUri + "\",\n");
        this.writer.write("  \"np\": \"" + npUri + "\"\n");
        this.writer.write("  }");
    }

    private String escape(Value v) {
        return v.stringValue().replace("\\", "\\\\").replace("\"", "\\\"");
    }
}

