/*
 * Decompiled with CFR 0.152.
 */
package org.nanopub.op;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.trustyuri.TrustyUriException;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.Rio;
import org.nanopub.MalformedNanopubException;
import org.nanopub.MultiNanopubRdfHandler;
import org.nanopub.Nanopub;
import org.nanopub.NanopubImpl;
import org.nanopub.NanopubUtils;

public class Filter {
    @Parameter(description="input-nanopubs", required=true)
    private List<File> inputNanopubs = new ArrayList<File>();
    @Parameter(names={"-f"}, description="Filter by URI or literal")
    private String filter = null;
    @Parameter(names={"-F"}, description="Filter by URI or literal read from file")
    private File filterFile = null;
    @Parameter(names={"--split"}, description="Treat blanks in filter string as OR connectives")
    private boolean splitFilter = false;
    @Parameter(names={"-o"}, description="Output file")
    private File outputFile;
    @Parameter(names={"--no-examples"}, description="Do not output example nanopublications")
    private boolean noExamples = false;
    @Parameter(names={"--only-examples"}, description="Output only example nanopublications")
    private boolean onlyExamples = false;
    @Parameter(names={"--in-format"}, description="Format of the input nanopubs: trig, nq, trix, trig.gz, ...")
    private String inFormat;
    @Parameter(names={"--out-format"}, description="Format of the output nanopubs: trig, nq, trix, trig.gz, ...")
    private String outFormat;
    private RDFFormat rdfInFormat;
    private RDFFormat rdfOutFormat;
    private OutputStream outputStream = System.out;
    private Map<String, Boolean> filterComponents = new HashMap<String, Boolean>();
    public static IRI exampleNanopubType = SimpleValueFactory.getInstance().createIRI("http://purl.org/nanopub/x/ExampleNanopub");

    public static void main(String[] args) {
        NanopubImpl.ensureLoaded();
        Filter obj = new Filter();
        JCommander jc = new JCommander(obj);
        try {
            jc.parse(args);
        }
        catch (ParameterException ex) {
            jc.usage();
            System.exit(1);
        }
        try {
            obj.run();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() throws IOException, RDFParseException, RDFHandlerException, MalformedNanopubException, TrustyUriException {
        if (this.splitFilter) {
            for (String s : this.filter.split(" ")) {
                this.filterComponents.put(s, true);
            }
        } else {
            this.filterComponents.put(this.filter, true);
        }
        if (this.filterFile != null) {
            try (BufferedReader br = null;){
                String line;
                br = this.filterFile.getName().endsWith(".gz") ? new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(this.filterFile)))) : new BufferedReader(new FileReader(this.filterFile));
                while ((line = br.readLine()) != null) {
                    if ((line = line.trim()).isEmpty()) continue;
                    this.filterComponents.put(line, true);
                }
            }
        }
        if (this.filter == null && this.filterFile == null) {
            this.filterComponents = null;
        }
        for (File inputFile : this.inputNanopubs) {
            this.rdfInFormat = this.inFormat != null ? (RDFFormat)Rio.getParserFormatForFileName("file." + this.inFormat).orElse(null) : (RDFFormat)Rio.getParserFormatForFileName(inputFile.toString()).orElse(null);
            if (this.outputFile == null) {
                if (this.outFormat == null) {
                    this.outFormat = "trig";
                }
                this.rdfOutFormat = Rio.getParserFormatForFileName("file." + this.outFormat).orElse(null);
            } else {
                this.rdfOutFormat = Rio.getParserFormatForFileName(this.outputFile.getName()).orElse(null);
                this.outputStream = this.outputFile.getName().endsWith(".gz") ? new GZIPOutputStream(new FileOutputStream(this.outputFile)) : new FileOutputStream(this.outputFile);
            }
            MultiNanopubRdfHandler.process(this.rdfInFormat, inputFile, new MultiNanopubRdfHandler.NanopubHandler(){

                @Override
                public void handleNanopub(Nanopub np) {
                    try {
                        Filter.this.process(np);
                    }
                    catch (RDFHandlerException ex) {
                        throw new RuntimeException(ex);
                    }
                }
            });
            this.outputStream.flush();
            if (this.outputStream == System.out) continue;
            this.outputStream.close();
        }
    }

    private void process(Nanopub np) throws RDFHandlerException {
        if (this.matchesFilter(np)) {
            NanopubUtils.writeToStream(np, this.outputStream, this.rdfOutFormat);
        }
    }

    private boolean matchesFilter(Nanopub np) {
        if (this.noExamples && Filter.isExampleNanopub(np)) {
            return false;
        }
        if (this.onlyExamples && !Filter.isExampleNanopub(np)) {
            return false;
        }
        if (this.filterComponents == null) {
            return true;
        }
        for (Statement st : NanopubUtils.getStatements(np)) {
            if (this.filterComponents.containsKey(st.getSubject().stringValue())) {
                return true;
            }
            if (this.filterComponents.containsKey(st.getPredicate().stringValue())) {
                return true;
            }
            if (this.filterComponents.containsKey(st.getObject().stringValue())) {
                return true;
            }
            if (!this.filterComponents.containsKey(st.getContext().stringValue())) continue;
            return true;
        }
        return false;
    }

    public static boolean isExampleNanopub(Nanopub np) {
        if (np.getPubinfo().contains(SimpleValueFactory.getInstance().createStatement((Resource)np.getUri(), RDF.TYPE, (Value)exampleNanopubType))) {
            return true;
        }
        for (Statement st : NanopubUtils.getStatements(np)) {
            if (Filter.isExampleUri(st.getSubject())) {
                return true;
            }
            if (Filter.isExampleUri(st.getPredicate())) {
                return true;
            }
            if (!Filter.isExampleUri(st.getObject())) continue;
            return true;
        }
        return false;
    }

    public static boolean isExampleUri(Value v) {
        if (!(v instanceof IRI)) {
            return false;
        }
        if (v.stringValue().startsWith("http://example.org/")) {
            return true;
        }
        if (v.stringValue().startsWith("https://example.org/")) {
            return true;
        }
        if (v.stringValue().startsWith("http://example.com/")) {
            return true;
        }
        return v.stringValue().startsWith("https://example.com/");
    }
}

