/*
 * Decompiled with CFR 0.152.
 */
package org.nanopub.op;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.GZIPOutputStream;
import net.trustyuri.TrustyUriException;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.Rio;
import org.nanopub.MalformedNanopubException;
import org.nanopub.MultiNanopubRdfHandler;
import org.nanopub.Nanopub;
import org.nanopub.NanopubImpl;

public class Namespaces {
    @Parameter(description="input-nanopubs")
    private List<File> inputNanopubs = new ArrayList<File>();
    @Parameter(names={"-h"}, description="Output file for namespaces used in head graph")
    private File headOutputFile;
    @Parameter(names={"-a"}, description="Output file for namespaces used in assertion graph")
    private File assertionOutputFile;
    @Parameter(names={"-p"}, description="Output file for namespaces used in provenance graph")
    private File provOutputFile;
    @Parameter(names={"-i"}, description="Output file for namespaces used in pub info graph")
    private File pubinfoOutputFile;
    @Parameter(names={"--subj"}, description="Include subject URIs")
    private boolean includeSubject;
    @Parameter(names={"--pred"}, description="Include predicate URIs")
    private boolean includePredicate;
    @Parameter(names={"--obj"}, description="Include object URIs")
    private boolean includeObject;
    @Parameter(names={"--in-format"}, description="Format of the input nanopubs: trig, nq, trix, trig.gz, ...")
    private String inFormat;
    private RDFFormat rdfInFormat;
    private BufferedWriter headWriter;
    private BufferedWriter assertionWriter;
    private BufferedWriter provWriter;
    private BufferedWriter pubinfoWriter;

    public static void main(String[] args) {
        NanopubImpl.ensureLoaded();
        Namespaces obj = new Namespaces();
        JCommander jc = new JCommander(obj);
        try {
            jc.parse(args);
        }
        catch (ParameterException ex) {
            jc.usage();
            System.exit(1);
        }
        obj.init();
        try {
            obj.run();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }

    public static Namespaces getInstance(String args) throws ParameterException {
        NanopubImpl.ensureLoaded();
        if (args == null) {
            args = "";
        }
        Namespaces obj = new Namespaces();
        JCommander jc = new JCommander(obj);
        jc.parse(args.trim().split(" "));
        obj.init();
        return obj;
    }

    private void init() {
        if (!(this.includeSubject || this.includePredicate || this.includeObject)) {
            this.includeSubject = true;
            this.includePredicate = true;
            this.includeObject = true;
        }
    }

    public void run() throws IOException, RDFParseException, RDFHandlerException, MalformedNanopubException, TrustyUriException {
        if (this.inputNanopubs == null || this.inputNanopubs.isEmpty()) {
            throw new ParameterException("No input files given");
        }
        this.headWriter = this.makeWriter(this.headOutputFile);
        this.assertionWriter = this.makeWriter(this.assertionOutputFile);
        this.provWriter = this.makeWriter(this.provOutputFile);
        this.pubinfoWriter = this.makeWriter(this.pubinfoOutputFile);
        for (File inputFile : this.inputNanopubs) {
            this.rdfInFormat = this.inFormat != null ? (RDFFormat)Rio.getParserFormatForFileName("file." + this.inFormat).orElse(null) : (RDFFormat)Rio.getParserFormatForFileName(inputFile.toString()).orElse(null);
            MultiNanopubRdfHandler.process(this.rdfInFormat, inputFile, new MultiNanopubRdfHandler.NanopubHandler(){

                @Override
                public void handleNanopub(Nanopub np) {
                    try {
                        Namespaces.this.process(np);
                    }
                    catch (RDFHandlerException ex) {
                        throw new RuntimeException(ex);
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                }
            });
        }
        this.closeWriter(this.headWriter);
        this.closeWriter(this.assertionWriter);
        this.closeWriter(this.provWriter);
        this.closeWriter(this.pubinfoWriter);
    }

    public void process(Nanopub np) throws RDFHandlerException, IOException {
        this.writeNamespaces(np.getHead(), this.headWriter);
        this.writeNamespaces(np.getAssertion(), this.assertionWriter);
        this.writeNamespaces(np.getProvenance(), this.provWriter);
        this.writeNamespaces(np.getPubinfo(), this.pubinfoWriter);
    }

    private void writeNamespaces(Set<Statement> statements, BufferedWriter w) throws IOException {
        if (w == null) {
            return;
        }
        HashSet<String> namespaces = new HashSet<String>();
        for (Statement st : statements) {
            if (this.includeSubject && st.getSubject() instanceof IRI) {
                namespaces.add(this.getNamespace((IRI)st.getSubject()));
            }
            if (this.includePredicate) {
                namespaces.add(this.getNamespace(st.getPredicate()));
            }
            if (!this.includeObject || !(st.getObject() instanceof IRI)) continue;
            namespaces.add(this.getNamespace((IRI)st.getObject()));
        }
        for (String n : namespaces) {
            w.write(n + "\n");
        }
    }

    private String getNamespace(IRI uri) {
        return uri.toString().replaceFirst("[A-Za-z0-9_.-]*.$", "");
    }

    private BufferedWriter makeWriter(File f) throws IOException {
        if (f == null) {
            return null;
        }
        OutputStream stream = null;
        stream = f.getName().endsWith(".gz") ? new GZIPOutputStream(new FileOutputStream(f)) : new FileOutputStream(f);
        return new BufferedWriter(new OutputStreamWriter(stream));
    }

    private void closeWriter(Writer w) throws IOException {
        if (w == null) {
            return;
        }
        w.flush();
        w.close();
    }
}

