/*
 * Decompiled with CFR 0.152.
 */
package org.nanopub.op;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.trustyuri.TrustyUriException;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.Rio;
import org.nanopub.MalformedNanopubException;
import org.nanopub.MultiNanopubRdfHandler;
import org.nanopub.Nanopub;
import org.nanopub.NanopubImpl;
import org.nanopub.NanopubRdfHandler;
import org.nanopub.NanopubUtils;
import org.nanopub.op.Fingerprint;
import org.nanopub.op.Topic;
import org.nanopub.trusty.FixTrustyNanopub;

public class Reuse {
    @Parameter(description="input-nanopubs", required=true)
    private List<File> inputNanopubs = new ArrayList<File>();
    @Parameter(names={"-x"}, description="Nanopubs to be reused (if not given, an initial dataset is created)")
    private File reuseNanopubFile;
    @Parameter(names={"-n"}, description="Output new nanopubs")
    private boolean outputNew = false;
    @Parameter(names={"-o"}, description="Output file (requires option -n to be set)")
    private File outputFile;
    @Parameter(names={"-a"}, description="Output file of all nanopublications (-x file needs to be a full nanopub file)")
    private File allOutputFile;
    @Parameter(names={"-c"}, description="Output cache file, which can afterwards be used for argument -x or to create an index)")
    private File cacheFile;
    @Parameter(names={"-r"}, description="Append line to this table file")
    private File tableFile;
    @Parameter(names={"--in-format"}, description="Format of the input nanopubs: trig, nq, trix, trig.gz, ...")
    private String inFormat;
    @Parameter(names={"--reuse-format"}, description="Format of the nanopubs to be reused: trig, nq, trix, trig.gz, ...")
    private String reuseFormat;
    @Parameter(names={"--out-format"}, description="Format of the output nanopubs: trig, nq, trix, trig.gz, ...")
    private String outFormat;
    @Parameter(names={"-f"}, description="Fingerprinting options")
    private String fingerprintOptions;
    @Parameter(names={"-s"}, description="Add npx:supersedes backlinks for changed nanopublications")
    private boolean addSupersedesBacklinks = false;
    @Parameter(names={"-t"}, description="Topic options")
    private String topicOptions;
    private static final String multipleNanopubs = "MULTI";
    private static final String matchedNanopub = "MATCHED";
    private RDFFormat rdfInFormat;
    private RDFFormat rdfReuseFormat;
    private RDFFormat rdfOutFormat;
    private PrintStream outputStream = System.out;
    private PrintStream allOutputStream;
    private PrintStream cacheStream;
    private Map<String, String> reusableNanopubs = new HashMap<String, String>();
    private Map<String, String> existingTopics = new HashMap<String, String>();
    private Map<String, String> reuseNanopubMap = new HashMap<String, String>();
    private int reusableCount;
    private int uniqueReusableCount;
    private int inputCount;
    private int reuseCount;
    private int inTopicDuplCount;
    private int outTopicDuplCount;
    private int topicMatchErrors;
    private int topicMatchCount;
    private Fingerprint fingerprint;
    private Topic topic;

    public static void main(String[] args) {
        NanopubImpl.ensureLoaded();
        Reuse obj = new Reuse();
        JCommander jc = new JCommander(obj);
        try {
            jc.parse(args);
        }
        catch (ParameterException ex) {
            jc.usage();
            System.exit(1);
        }
        obj.init();
        try {
            obj.run();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }

    private void init() {
        try {
            this.fingerprint = Fingerprint.getInstance(this.fingerprintOptions);
        }
        catch (ParameterException ex) {
            System.err.println(ex);
        }
        try {
            this.topic = Topic.getInstance(this.topicOptions);
        }
        catch (ParameterException ex) {
            System.err.println(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() throws IOException, RDFParseException, RDFHandlerException, MalformedNanopubException, TrustyUriException {
        this.reusableCount = 0;
        this.uniqueReusableCount = 0;
        this.inputCount = 0;
        this.reuseCount = 0;
        this.inTopicDuplCount = 0;
        this.topicMatchCount = 0;
        this.topicMatchErrors = 0;
        if (this.outputFile == null) {
            if (this.outFormat == null) {
                this.outFormat = "trig";
            }
            this.rdfOutFormat = Rio.getParserFormatForFileName("file." + this.outFormat).orElse(null);
        } else {
            this.rdfOutFormat = Rio.getParserFormatForFileName(this.outputFile.getName()).orElse(null);
        }
        if (this.reuseNanopubFile != null) {
            if (this.reuseNanopubFile.getName().endsWith(".txt") || this.reuseNanopubFile.getName().endsWith(".txt.gz")) {
                if (this.allOutputFile != null) {
                    throw new RuntimeException("-x needs to specify a full nanopub file if -a is specified");
                }
                try (BufferedReader br = null;){
                    String line;
                    br = this.reuseNanopubFile.getName().endsWith(".gz") ? new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(this.reuseNanopubFile)))) : new BufferedReader(new FileReader(this.reuseNanopubFile));
                    while ((line = br.readLine()) != null) {
                        if ((line = line.trim()).isEmpty()) continue;
                        String[] columns = line.split(" ");
                        String uri = columns[0];
                        String fingerprint = columns[1];
                        this.reusableNanopubs.put(fingerprint, uri);
                        ++this.reusableCount;
                        if (!this.addSupersedesBacklinks) continue;
                        String topic = columns[2];
                        this.recordTopic(topic, uri);
                    }
                }
            } else {
                this.rdfReuseFormat = this.reuseFormat != null ? (RDFFormat)Rio.getParserFormatForFileName("file." + this.reuseFormat).orElse(null) : (RDFFormat)Rio.getParserFormatForFileName(this.reuseNanopubFile.toString()).orElse(null);
                MultiNanopubRdfHandler.process(this.rdfReuseFormat, this.reuseNanopubFile, new MultiNanopubRdfHandler.NanopubHandler(){

                    @Override
                    public void handleNanopub(Nanopub np) {
                        try {
                            String fp = Reuse.this.fingerprint.getFingerprint(np);
                            String uri = np.getUri().toString();
                            Reuse.this.reusableNanopubs.put(fp, uri);
                            Reuse.this.reusableCount++;
                            if (Reuse.this.addSupersedesBacklinks) {
                                Reuse.this.recordTopic(Reuse.this.topic.getTopic(np), uri);
                            }
                            if (Reuse.this.allOutputFile != null) {
                                Reuse.this.reuseNanopubMap.put(fp, NanopubUtils.writeToString(np, Reuse.this.rdfOutFormat));
                            }
                        }
                        catch (IOException ex) {
                            throw new RuntimeException(ex);
                        }
                        catch (RDFHandlerException ex) {
                            throw new RuntimeException(ex);
                        }
                    }
                });
            }
        }
        this.uniqueReusableCount = this.reusableNanopubs.size();
        if (this.cacheFile != null) {
            this.cacheStream = this.cacheFile.getName().endsWith(".gz") ? new PrintStream(new GZIPOutputStream(new FileOutputStream(this.cacheFile))) : new PrintStream(new FileOutputStream(this.cacheFile));
        }
        for (File inputFile : this.inputNanopubs) {
            this.rdfInFormat = this.inFormat != null ? (RDFFormat)Rio.getParserFormatForFileName("file." + this.inFormat).orElse(null) : (RDFFormat)Rio.getParserFormatForFileName(inputFile.toString()).orElse(null);
            if (this.outputFile != null) {
                this.outputStream = this.outputFile.getName().endsWith(".gz") ? new PrintStream(new GZIPOutputStream(new FileOutputStream(this.outputFile))) : new PrintStream(new FileOutputStream(this.outputFile));
            }
            if (this.allOutputFile != null) {
                this.allOutputStream = this.allOutputFile.getName().endsWith(".gz") ? new PrintStream(new GZIPOutputStream(new FileOutputStream(this.allOutputFile))) : new PrintStream(new FileOutputStream(this.allOutputFile));
            }
            MultiNanopubRdfHandler.process(this.rdfInFormat, inputFile, new MultiNanopubRdfHandler.NanopubHandler(){

                @Override
                public void handleNanopub(Nanopub np) {
                    try {
                        Reuse.this.process(np);
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                }
            });
            this.outputStream.flush();
            if (this.outputStream != System.out) {
                this.outputStream.close();
            }
            if (this.allOutputStream != null) {
                this.allOutputStream.flush();
                this.allOutputStream.close();
            }
            if (this.cacheStream != null) {
                this.cacheStream.flush();
                this.cacheStream.close();
            }
            if (this.tableFile != null) {
                PrintStream st = new PrintStream(new FileOutputStream(this.tableFile, true));
                if (this.addSupersedesBacklinks) {
                    st.println(inputFile.getName() + "," + this.reusableCount + "," + this.inputCount + "," + this.reuseCount + "," + this.topicMatchCount + "," + this.inTopicDuplCount + "," + this.outTopicDuplCount + "," + this.topicMatchErrors);
                } else {
                    st.println(inputFile.getName() + "," + this.reusableCount + "," + this.inputCount + "," + this.reuseCount);
                }
                st.close();
            }
            System.err.println("Older dataset count (unique): " + this.reusableCount + " (" + this.uniqueReusableCount + ")");
            System.err.println("Newer dataset count: " + this.inputCount);
            System.err.println("Reuse count: " + this.reuseCount);
            if (!this.addSupersedesBacklinks) continue;
            System.err.println("Topic match count: " + this.topicMatchCount);
            System.err.println("Duplicate topics in older dataset: " + this.inTopicDuplCount);
            System.err.println("Duplicate topics in newer dataset: " + this.outTopicDuplCount);
            System.err.println("Total topic matching errors: " + this.topicMatchErrors);
        }
    }

    private void recordTopic(String topic, String uri) {
        if (this.existingTopics.containsKey(topic)) {
            this.existingTopics.put(topic, multipleNanopubs);
            ++this.inTopicDuplCount;
            ++this.topicMatchErrors;
        } else {
            this.existingTopics.put(topic, uri);
        }
    }

    private void process(Nanopub np) throws IOException, RDFHandlerException, MalformedNanopubException, TrustyUriException {
        ++this.inputCount;
        String fp = this.fingerprint.getFingerprint(np);
        String t = null;
        if (this.addSupersedesBacklinks) {
            t = this.topic.getTopic(np);
        }
        String uri = np.getUri().toString();
        if (this.reusableNanopubs.containsKey(fp)) {
            ++this.reuseCount;
            uri = this.reusableNanopubs.get(fp);
            if (this.addSupersedesBacklinks) {
                String et = this.existingTopics.get(t);
                if (et == multipleNanopubs || et == matchedNanopub) {
                    ++this.topicMatchErrors;
                }
                this.existingTopics.put(t, matchedNanopub);
            }
            if (this.allOutputStream != null) {
                this.allOutputStream.println(this.reuseNanopubMap.get(fp));
            }
        } else {
            if (this.addSupersedesBacklinks && this.existingTopics.containsKey(t)) {
                String et = this.existingTopics.get(t);
                if (et == multipleNanopubs) {
                    ++this.topicMatchErrors;
                } else if (et == matchedNanopub) {
                    ++this.topicMatchErrors;
                    ++this.outTopicDuplCount;
                } else {
                    ++this.topicMatchCount;
                    String oldNpUri = this.existingTopics.get(t);
                    this.existingTopics.put(t, matchedNanopub);
                    np = this.addSupersedesBacklink(np, SimpleValueFactory.getInstance().createIRI(oldNpUri));
                    uri = np.getUri().toString();
                }
            }
            if (this.outputNew) {
                NanopubUtils.writeToStream(np, this.outputStream, this.rdfOutFormat);
            }
            if (this.allOutputStream != null) {
                NanopubUtils.writeToStream(np, this.allOutputStream, this.rdfOutFormat);
            }
        }
        if (this.cacheStream != null) {
            if (this.addSupersedesBacklinks) {
                this.cacheStream.println(uri + " " + fp + " " + t);
            } else {
                this.cacheStream.println(uri + " " + fp);
            }
        }
    }

    private Nanopub addSupersedesBacklink(Nanopub newNp, IRI oldUri) throws RDFHandlerException, MalformedNanopubException, TrustyUriException {
        SupersedesLinkAdder linkAdder = new SupersedesLinkAdder(oldUri, newNp);
        NanopubUtils.propagateToHandler(newNp, linkAdder);
        return FixTrustyNanopub.fix(linkAdder.getNanopub());
    }

    private class SupersedesLinkAdder
    extends NanopubRdfHandler {
        private IRI oldUri;
        private Nanopub newNp;

        public SupersedesLinkAdder(IRI oldUri, Nanopub newNp) {
            this.oldUri = oldUri;
            this.newNp = newNp;
        }

        @Override
        public void handleStatement(Statement st) throws RDFHandlerException {
            if (st.getSubject().equals(this.newNp.getUri()) && st.getPredicate().equals(Nanopub.SUPERSEDES)) {
                return;
            }
            super.handleStatement(st);
        }

        @Override
        public void endRDF() throws RDFHandlerException {
            super.handleStatement(SimpleValueFactory.getInstance().createStatement((Resource)this.newNp.getUri(), Nanopub.SUPERSEDES, (Value)this.oldUri, (Resource)this.newNp.getPubinfoUri()));
            super.endRDF();
        }
    }
}

